/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions.userfilter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.table.TableColumnModel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.CheckableNode;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class TransformResultWindow
extends TopComponent
implements ExplorerManager.Provider {
    private OutlineView _outline;
    private final ExplorerManager _explorer = new ExplorerManager();
    private ActionListener _continueListener;
    private JButton _acceptButton;
    private JCheckBox _deleteUnselected;
    private JPanel _right;
    private JButton _selectAll;
    private JButton _selectNone;
    private JSplitPane _split;

    public TransformResultWindow() {
        this("User Filter", "The following results were returned");
    }

    public TransformResultWindow(String displayName, String col1Heading) {
        this.initComponents();
        this.setDisplayName(displayName);
        this.setIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/automation/resources/Robot.png"));
        this._outline = new OutlineView(col1Heading);
        this._outline.setPropertyColumns(new String[]{"maltego.fixed.type", "Type"});
        this._outline.getOutline().setAutoResizeMode(4);
        TableColumnModel columns = this._outline.getOutline().getColumnModel();
        columns.getColumn(0).setPreferredWidth(150);
        columns.getColumn(1).setPreferredWidth(50);
        this._outline.getOutline().setRootVisible(false);
        this._split.setTopComponent((Component)this._outline);
    }

    protected void componentShowing() {
        super.componentShowing();
        int right = (int)this._right.getMinimumSize().getWidth();
        int total = this.getWidth();
        int position = 200;
        this._split.setDividerLocation(position);
    }

    public void open() {
        Mode mode = WindowManager.getDefault().findMode("output");
        if (mode != null) {
            mode.dockInto((TopComponent)this);
        }
        super.open();
    }

    public int getPersistenceType() {
        return 2;
    }

    public boolean deleteUnselected() {
        return this._deleteUnselected.isSelected();
    }

    private void initComponents() {
        this._split = new JSplitPane();
        this._right = new JPanel();
        this._acceptButton = new JButton();
        this._deleteUnselected = new JCheckBox();
        this._selectAll = new JButton();
        this._selectNone = new JButton();
        this.setLayout(new BorderLayout());
        this._right.setMaximumSize(new Dimension(190, 1000));
        this._right.setMinimumSize(new Dimension(190, 116));
        this._acceptButton.setText(NbBundle.getMessage(TransformResultWindow.class, (String)"TransformResultWindow._acceptButton.text"));
        this._acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TransformResultWindow.this._acceptButtonActionPerformed(evt);
            }
        });
        this._deleteUnselected.setSelected(true);
        this._deleteUnselected.setText(NbBundle.getMessage(TransformResultWindow.class, (String)"TransformResultWindow._deleteUnselected.text"));
        this._deleteUnselected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TransformResultWindow.this._deleteUnselectedActionPerformed(evt);
            }
        });
        this._selectAll.setText(NbBundle.getMessage(TransformResultWindow.class, (String)"TransformResultWindow._selectAll.text"));
        this._selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TransformResultWindow.this._selectAllActionPerformed(evt);
            }
        });
        this._selectNone.setText(NbBundle.getMessage(TransformResultWindow.class, (String)"TransformResultWindow._selectNone.text"));
        this._selectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TransformResultWindow.this._selectNoneActionPerformed(evt);
            }
        });
        GroupLayout _rightLayout = new GroupLayout(this._right);
        this._right.setLayout(_rightLayout);
        _rightLayout.setHorizontalGroup(_rightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(_rightLayout.createSequentialGroup().addContainerGap().addGroup(_rightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._deleteUnselected).addComponent(this._acceptButton).addGroup(_rightLayout.createSequentialGroup().addComponent(this._selectAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._selectNone))).addContainerGap(53, Short.MAX_VALUE)));
        _rightLayout.setVerticalGroup(_rightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(_rightLayout.createSequentialGroup().addContainerGap().addComponent(this._acceptButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this._deleteUnselected).addGap(18, 18, 18).addGroup(_rightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._selectAll).addComponent(this._selectNone)).addContainerGap(29, Short.MAX_VALUE)));
        this._split.setRightComponent(this._right);
        this.add(this._split, "Center");
    }

    private void _acceptButtonActionPerformed(ActionEvent evt) {
        this.close();
        if (this._continueListener != null) {
            this._continueListener.actionPerformed(evt);
        }
    }

    private void _deleteUnselectedActionPerformed(ActionEvent evt) {
    }

    private void _selectAllActionPerformed(ActionEvent evt) {
        this.selectAll();
    }

    private void _selectNoneActionPerformed(ActionEvent evt) {
        this.selectNone();
    }

    public ExplorerManager getExplorerManager() {
        return this._explorer;
    }

    private void selectAll() {
        this.applySelection(true);
    }

    private void selectNone() {
        this.applySelection(false);
    }

    private void applySelection(boolean value) {
        Node[] nodes;
        for (Node node : nodes = this.getExplorerManager().getRootContext().getChildren().getNodes(true)) {
            CheckableNode checkable = (CheckableNode)node.getLookup().lookup(CheckableNode.class);
            if (checkable == null) continue;
            checkable.setSelected(Boolean.valueOf(value));
        }
    }

    public void setContinueListener(ActionListener listener) {
        this._continueListener = listener;
    }

    public ActionListener getContinueListener() {
        return this._continueListener;
    }
}

