/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.tx3.java.api.discovery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.maltego.tx3.java.api.discovery.TransformDiscoveryIO;
import com.maltego.tx3.java.api.discovery.TransformSetting;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TransformDefinition {
    private final String id;
    private final String name;
    private final TransformDiscoveryIO input;
    private final TransformDiscoveryIO output;
    private final List<TransformSetting> transformSettings;
    private final List<String> transformCapabilities;
    private final String displayName;
    private final String description;
    private final String author;
    private final String owner;
    private final String disclaimer;
    private final String version;
    private final int maxEntityInputCount;
    private final int maxEntityOutputCount;
    private final List<String> sets;
    private final Map<String, String> metadata;
    private final String authenticator;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public TransformDefinition(@JsonProperty(value="id") String id, @JsonProperty(value="name", required=true) String name, @JsonProperty(value="input") TransformDiscoveryIO input, @JsonProperty(value="output") TransformDiscoveryIO output, @JsonProperty(value="transformSettings") List<TransformSetting> transformSettings, @JsonProperty(value="transformCapabilities") List<String> transformCapabilities, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="description") String description, @JsonProperty(value="author") String author, @JsonProperty(value="owner") String owner, @JsonProperty(value="disclaimer") String disclaimer, @JsonProperty(value="version", required=true) String version, @JsonProperty(value="maxEntityInputCount") int maxEntityInputCount, @JsonProperty(value="maxEntityOutputCount") int maxEntityOutputCount, @JsonProperty(value="sets") List<String> sets, @JsonProperty(value="metadata") Map<String, String> metadata, @JsonProperty(value="authenticator") String authenticator) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.transformSettings = transformSettings;
        this.transformCapabilities = transformCapabilities;
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.author = author;
        this.owner = owner;
        this.disclaimer = disclaimer;
        this.version = version;
        this.maxEntityInputCount = maxEntityInputCount;
        this.maxEntityOutputCount = maxEntityOutputCount;
        this.sets = sets;
        this.metadata = metadata;
        this.authenticator = authenticator;
    }

    public String getId() {
        return this.id;
    }

    public TransformDiscoveryIO getInput() {
        return this.input;
    }

    public TransformDiscoveryIO getOutput() {
        return this.output;
    }

    public List<TransformSetting> getTransformSettings() {
        return this.transformSettings;
    }

    public List<String> getTransformCapabilities() {
        return this.transformCapabilities;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getDisclaimer() {
        return this.disclaimer;
    }

    public String getVersion() {
        return this.version;
    }

    public int getMaxEntityInputCount() {
        return this.maxEntityInputCount;
    }

    public int getMaxEntityOutputCount() {
        return this.maxEntityOutputCount;
    }

    public List<String> getSets() {
        return this.sets;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getAuthenticator() {
        return this.authenticator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformDefinition that = (TransformDefinition)o;
        return this.maxEntityInputCount == that.maxEntityInputCount && this.maxEntityOutputCount == that.maxEntityOutputCount && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.input, that.input) && Objects.equals(this.output, that.output) && Objects.equals(this.transformSettings, that.transformSettings) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.description, that.description) && Objects.equals(this.author, that.author) && Objects.equals(this.owner, that.owner) && Objects.equals(this.disclaimer, that.disclaimer) && Objects.equals(this.version, that.version) && Objects.equals(this.sets, that.sets) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.authenticator, that.authenticator);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.input, this.output, this.transformSettings, this.displayName, this.description, this.author, this.owner, this.disclaimer, this.version, this.maxEntityInputCount, this.maxEntityOutputCount, this.sets, this.metadata, this.authenticator);
    }

    public String toString() {
        return "TransformDefinition{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", input=" + this.input + ", output=" + this.output + ", transformSettings=" + this.transformSettings + ", displayName='" + this.displayName + '\'' + ", description='" + this.description + '\'' + ", author='" + this.author + '\'' + ", owner='" + this.owner + '\'' + ", disclaimer='" + this.disclaimer + '\'' + ", version='" + this.version + '\'' + ", maxEntityInputCount=" + this.maxEntityInputCount + ", maxEntityOutputCount=" + this.maxEntityOutputCount + ", sets=" + this.sets + ", metadata=" + this.metadata + ", authenticator='" + this.authenticator + '\'' + '}';
    }
}

