/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.convert;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.graph.table.PropertyToColumnMap;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.graph.table.io.TabularGraphIterator;
import com.paterva.maltego.graph.table.io.convert.LightWeightLink;
import com.paterva.maltego.graph.table.io.convert.PartCache;
import com.paterva.maltego.graph.table.io.convert.TabularGraphImportOptions;
import com.paterva.maltego.graph.table.io.convert.TabularGraphTranslateResult;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.util.StringUtilities;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TabularTranslator {
    private final EntityFactory _entityFactory;
    private final LinkFactory _linkFactory;
    private final Map<Integer, MaltegoLink> _templateLinks = new HashMap<Integer, MaltegoLink>();

    public TabularTranslator() {
        this(EntityFactory.getDefault(), LinkFactory.getDefault());
    }

    public TabularTranslator(EntityFactory entityFactory, LinkFactory linkFactory) {
        this._entityFactory = entityFactory;
        this._linkFactory = linkFactory;
    }

    public TabularGraphTranslateResult translate(TabularGraphIterator rowIterator, Map<Integer, TypeDescriptor> entityDesiredColumnTypes, Map<Integer, TypeDescriptor> linkDesiredColumnTypes, List<TabularGraphEntity> tableEntities, List<TabularGraphLink> tableLinks, PartCache partCache) throws IOException {
        TabularGraphTranslateResult translateResult = new TabularGraphTranslateResult();
        List<Object> entityRow = rowIterator.getRow(entityDesiredColumnTypes);
        try {
            translateResult.setEntities(this.translateEntities(tableEntities, entityRow, partCache));
        }
        catch (Exception ex) {
            translateResult.setError(ex.getMessage() + ": " + entityRow);
        }
        if (translateResult.getError() == null) {
            List<Object> linkRow = rowIterator.getRow(linkDesiredColumnTypes);
            try {
                translateResult.setLinks(this.translateLinks(tableLinks, linkRow));
            }
            catch (Exception ex) {
                translateResult.setError(ex.getMessage() + ": " + linkRow);
            }
        }
        return translateResult;
    }

    public Map<TabularGraphEntity, MaltegoEntity> translateEntities(List<TabularGraphEntity> tableEntities, List<Object> rowValues, PartCache partCache) throws TypeInstantiationException, RowImportException {
        HashMap<TabularGraphEntity, MaltegoEntity> entities = new HashMap<TabularGraphEntity, MaltegoEntity>(tableEntities.size());
        for (TabularGraphEntity tableEntity : tableEntities) {
            MaltegoEntity entity = partCache.getEntityFromCache(tableEntity, rowValues);
            if (entity == null) {
                entity = this.translate(tableEntity, rowValues);
                partCache.addEntity(tableEntity, rowValues, entity);
            }
            if (entity == null) continue;
            entities.put(tableEntity, entity);
        }
        return entities;
    }

    public MaltegoEntity translate(TabularGraphEntity tableEntity, List<Object> rowValues) throws TypeInstantiationException, RowImportException {
        MaltegoEntity entity = (MaltegoEntity)this._entityFactory.createInstance(tableEntity.getEntitySpecName(), false, true);
        if (this.translateProperties((PropertyToColumnMap)tableEntity, (MaltegoPart)entity, rowValues)) {
            return entity;
        }
        return null;
    }

    public Map<TabularGraphLink, MaltegoLink> translateLinks(List<TabularGraphLink> tableLinks, List<Object> rowValues) throws TypeInstantiationException, RowImportException {
        HashMap<TabularGraphLink, MaltegoLink> links = new HashMap<TabularGraphLink, MaltegoLink>(tableLinks.size());
        for (TabularGraphLink tableLink : tableLinks) {
            MaltegoLink link = this.translate(tableLink, rowValues);
            if (link == null) continue;
            links.put(tableLink, link);
        }
        return links;
    }

    public MaltegoLink translate(TabularGraphLink tableLink, List<Object> rowValues) throws RowImportException {
        MaltegoLink templateLink = this.getTemplateLink(tableLink);
        LightWeightLink maltegoLink = new LightWeightLink(templateLink);
        this.translateProperties((PropertyToColumnMap)tableLink, (MaltegoPart)maltegoLink, rowValues);
        return maltegoLink;
    }

    private MaltegoLink getTemplateLink(TabularGraphLink tableLink) throws RowImportException {
        MaltegoLink templateLink = this._templateLinks.get(tableLink.getIndex());
        if (templateLink == null) {
            templateLink = this._linkFactory.createInstance(MaltegoLinkSpec.getManualSpec(), true);
            for (int column : tableLink.getColumns()) {
                PropertyDescriptor pd = this.getProperty((PropertyToColumnMap)tableLink, column);
                if (templateLink.getProperties().contains(pd)) continue;
                templateLink.getProperties().add(pd);
            }
            this._templateLinks.put(tableLink.getIndex(), templateLink);
        }
        return templateLink;
    }

    private boolean translateProperties(PropertyToColumnMap map, MaltegoPart maltegoPart, List<Object> rowValues) throws RowImportException {
        boolean allPropertiesNull = true;
        for (int column : map.getColumns()) {
            PropertyDescriptor pd = this.getProperty(map, column);
            Object value = this.getValue(column, rowValues, pd);
            if (value == null) continue;
            allPropertiesNull = false;
            try {
                this.setProperty(maltegoPart, pd, value);
            }
            catch (IllegalArgumentException ex) {
                throw new RowImportException(ex.getMessage());
            }
        }
        return map.getColumns().length <= 0 || !allPropertiesNull;
    }

    private PropertyDescriptor getProperty(PropertyToColumnMap map, int column) throws RowImportException {
        PropertyDescriptor pd = map.getProperty(column);
        if (pd == null) {
            throw new RowImportException("No property set for mapped column: " + column);
        }
        return pd;
    }

    private Object getValue(int column, List<Object> rowValues, PropertyDescriptor pd) {
        Object value = null;
        if (column < rowValues.size()) {
            value = rowValues.get(column);
        }
        if (TabularGraphImportOptions.isTrimValues() && value instanceof String) {
            value = StringUtilities.trim((String)((String)value));
        }
        if (StringUtilities.isNullString((Object)value)) {
            value = null;
        }
        if (value == null && !TabularGraphImportOptions.isBlankCellsIgnored()) {
            value = TypeRegistry.getDefault().getType(pd.getType()).getDefaultValue();
        }
        return value;
    }

    private void setProperty(MaltegoPart part, PropertyDescriptor pd, Object value) {
        if (!part.getProperties().contains(pd)) {
            part.getProperties().add(pd);
        }
        part.setValue(pd, value);
    }

    public static class RowImportException
    extends Exception {
        public RowImportException(String message) {
            super(message);
        }
    }
}

