/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui.hub;

import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeedTag;
import com.paterva.maltego.seeds.api.HubSeeds;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.seeds.api.test.TestHubJson;
import com.paterva.maltego.seeds.api.test.TestHubXml;
import com.paterva.maltego.seeds.ui.DisplayFilterToolbar;
import com.paterva.maltego.seeds.ui.HubFilterManager;
import com.paterva.maltego.seeds.ui.HubItemDescriptor;
import com.paterva.maltego.seeds.ui.HubItemProvider;
import com.paterva.maltego.seeds.ui.HubSeedsHomePanel;
import com.paterva.maltego.seeds.ui.SortToolbar;
import com.paterva.maltego.seeds.ui.hub.HubFilterPanel;
import com.paterva.maltego.seeds.ui.hub.HubInternalPanel;
import com.paterva.maltego.seeds.ui.hub.HubPartnersPanel;
import com.paterva.maltego.seeds.ui.hub.SeedItemDescriptor;
import com.paterva.maltego.transform.gen.TransformSource;
import com.paterva.maltego.transform.gen.TransformSourceRegistry;
import com.paterva.maltego.transform.gen.TransformSourceRegistryListener;
import com.paterva.maltego.util.repository.RepositoryEvent;
import com.paterva.maltego.util.ui.BusySpinnerPanel;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class HubSeedManager
extends JPanel {
    private static final String PROGRESS_VIEW = "progress";
    private static final String SEEDS_VIEW = "seeds";
    private static final String OFFLINE_VIEW = "offline";
    private final CardLayout _layout = new CardLayout();
    private final HubFilterPanel _hubFilterPanel;
    private final HubPartnersPanel _partnersPanel = new HubPartnersPanel();
    private final HubInternalPanel _internalPanel = new HubInternalPanel();
    private final JScrollPane _scrollPane;
    private boolean _isRefreshing = false;
    private PropertyChangeListener _hubSeedRegistryListener;
    private TransformSourceRegistryListener _datasourceRegistryListener;
    private PropertyChangeListener _filterListener;
    private String _filterText = "";
    private DisplayFilterToolbar.DisplayFilter _displayFilter = DisplayFilterToolbar.DisplayFilter.ALL;
    private SortToolbar.Sort _sort = SortToolbar.Sort.DEFAULT;

    public HubSeedManager(HubSeedsHomePanel hubSeedsHomePanel) {
        UIDefaults laf = MaltegoLAF.getLookAndFeelDefaults();
        this.setBackground(laf.getColor("home-main-bg"));
        this.setMinimumSize(new Dimension(935, 100));
        this.setPreferredSize(new Dimension(935, 500));
        this.setLayout(this._layout);
        JLabel label = new JLabel("<Unable to download list of Seeds>");
        label.setForeground(laf.getColor("7-description-foreground"));
        label.setHorizontalAlignment(0);
        BusySpinnerPanel progressPanel = new BusySpinnerPanel();
        ScrollableSeedsPanel seedsPanel = new ScrollableSeedsPanel();
        this._scrollPane = new JScrollPane(seedsPanel);
        seedsPanel.setLayout(new BorderLayout());
        this._hubFilterPanel = new HubFilterPanel(hubSeedsHomePanel, this, this._scrollPane.getVerticalScrollBar());
        seedsPanel.add((Component)this._hubFilterPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)this._partnersPanel, "North");
        centerPanel.add((Component)this._internalPanel, "Center");
        seedsPanel.add((Component)centerPanel, "Center");
        this._scrollPane.setVerticalScrollBarPolicy(20);
        this._scrollPane.setHorizontalScrollBarPolicy(31);
        this._scrollPane.getViewport().setBackground(laf.getColor("hub-internal-bg"));
        this.add((Component)progressPanel, PROGRESS_VIEW);
        this.add((Component)this._scrollPane, SEEDS_VIEW);
        this.add((Component)label, OFFLINE_VIEW);
        this.refresh(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._hubSeedRegistryListener = new HubSeedRegistryListener();
        HubSeedRegistry.getDefault().addPropertyChangeListener(this._hubSeedRegistryListener);
        this._datasourceRegistryListener = new DatasourceListener();
        TransformSourceRegistry.getInstance().addTransformSourceRegistryListener(this._datasourceRegistryListener);
        this._filterListener = new FilterChangeListener();
        HubFilterManager.getInstance().addChangeListener(this._filterListener);
        this.refresh(TestHubXml.isEnabled() || TestHubJson.isEnabled());
        SwingUtilities.invokeLater(() -> {
            JScrollBar bar = this._scrollPane.getVerticalScrollBar();
            if (bar != null) {
                bar.setValue(0);
            }
        });
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        TransformSourceRegistry.getInstance().removeTransformSourceRegistryListener(this._datasourceRegistryListener);
        this._datasourceRegistryListener = null;
        HubSeedRegistry.getDefault().removePropertyChangeListener(this._hubSeedRegistryListener);
        this._hubSeedRegistryListener = null;
        HubFilterManager.getInstance().removeChangeListener(this._filterListener);
        this._filterListener = null;
    }

    public final void refresh(boolean redownload) {
        if (!this._isRefreshing) {
            this._isRefreshing = true;
            if (redownload) {
                this._layout.show(this, PROGRESS_VIEW);
            }
            Thread thread = new Thread((Runnable)new SeedRefresherASync(redownload), "Refresh Seeds");
            thread.start();
        }
    }

    public void setFilterText(String filterText) {
        if (!this._isRefreshing) {
            this._filterText = filterText;
        }
    }

    public void setDipslayFilter(DisplayFilterToolbar.DisplayFilter displayFilter) {
        if (!this._isRefreshing) {
            this._displayFilter = displayFilter;
        }
    }

    public void setSort(SortToolbar.Sort sort) {
        if (!this._isRefreshing) {
            this._sort = sort;
        }
    }

    private void setSeeds(HubSeeds seeds) {
        if (seeds != null) {
            List<HubItemDescriptor> resetCountItems = this.getResetCountItems(seeds);
            int partnersResetCount = this._partnersPanel.getResetCount(resetCountItems);
            int internalResetCount = this._internalPanel.getResetCount(resetCountItems);
            ArrayList<HubItemDescriptor> items = new ArrayList<HubItemDescriptor>();
            items.addAll(seeds.getSeeds().stream().filter(descriptor -> this.descriptorMatchesFilter((HubSeedDescriptor)descriptor)).map(SeedItemDescriptor::new).collect(Collectors.toList()));
            items.sort((d1, d2) -> this.sort((HubItemDescriptor)d1, (HubItemDescriptor)d2));
            Lookup.getDefault().lookupAll(HubItemProvider.class).forEach(hubItemProvider -> items.addAll(hubItemProvider.getItems()));
            this._hubFilterPanel.setHubSeeds(seeds);
            this._partnersPanel.setItems(items, partnersResetCount);
            this._internalPanel.setItems(items, internalResetCount);
            this._layout.show(this, SEEDS_VIEW);
        } else {
            this._layout.show(this, OFFLINE_VIEW);
        }
        this._isRefreshing = false;
    }

    private List<HubItemDescriptor> getResetCountItems(HubSeeds seeds) {
        ArrayList<HubItemDescriptor> resetCountItems = new ArrayList<HubItemDescriptor>();
        resetCountItems.addAll(seeds.getSeeds().stream().map(SeedItemDescriptor::new).collect(Collectors.toList()));
        return resetCountItems;
    }

    private boolean descriptorMatchesFilter(HubSeedDescriptor descriptor) {
        boolean matches = this.textMatchesFilter(descriptor.getDisplayName()) || this.textMatchesFilter(descriptor.getDescription()) || this.textMatchesFilter(descriptor.getDetails()) || descriptor.getProvider() != null && this.textMatchesFilter(descriptor.getProvider().getName());
        List tags = descriptor.getTags();
        if (tags != null) {
            for (HubSeedTag tag : tags) {
                if (!this.textMatchesFilter(tag.getValue())) continue;
                matches = true;
                break;
            }
        }
        switch (this._displayFilter) {
            case INSTALLED: {
                matches = matches && HubSeedSettings.getDefault().isInstalled(descriptor);
                break;
            }
            case NOT_INSTALLED: {
                matches = matches && !HubSeedSettings.getDefault().isInstalled(descriptor);
                break;
            }
        }
        return matches;
    }

    private int sort(HubItemDescriptor d1, HubItemDescriptor d2) {
        if (d1 instanceof SeedItemDescriptor && d2 instanceof SeedItemDescriptor) {
            HubSeedDescriptor hsd1 = ((SeedItemDescriptor)d1).getSeed();
            HubSeedDescriptor hsd2 = ((SeedItemDescriptor)d2).getSeed();
            switch (this._sort) {
                case NAME: {
                    return hsd1.getDisplayName().compareToIgnoreCase(hsd2.getDisplayName());
                }
                case NEWEST: {
                    return hsd2.getModified().compareTo(hsd1.getModified());
                }
            }
        }
        return 0;
    }

    private boolean textMatchesFilter(String text) {
        return text != null && text.toLowerCase().contains(this._filterText);
    }

    private void refreshLater() {
        SwingUtilities.invokeLater(() -> this.refresh(false));
    }

    private class ScrollableSeedsPanel
    extends JPanel
    implements Scrollable {
        private ScrollableSeedsPanel() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 16;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return (orientation == 1 ? visibleRect.height : visibleRect.width) - 10;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private class FilterChangeListener
    implements PropertyChangeListener {
        private FilterChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SwingUtilities.invokeLater(() -> HubSeedManager.this.setSeeds(HubSeedRegistry.getDefault().getSeeds(false)));
        }
    }

    private class DatasourceListener
    implements TransformSourceRegistryListener {
        private DatasourceListener() {
        }

        public void onItemAdded(RepositoryEvent<TransformSource> evt) {
            HubSeedManager.this.refreshLater();
        }

        public void onItemChanged(RepositoryEvent<TransformSource> evt) {
            HubSeedManager.this.refreshLater();
        }

        public void onItemRemoved(RepositoryEvent<TransformSource> evt) {
            HubSeedManager.this.refreshLater();
        }
    }

    private class HubSeedRegistryListener
    implements PropertyChangeListener {
        private HubSeedRegistryListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("seedsChanged".equals(evt.getPropertyName())) {
                HubSeedManager.this.refreshLater();
            }
        }
    }

    private class SeedRefreshCallback
    implements Runnable {
        private final HubSeeds _seeds;

        public SeedRefreshCallback(HubSeeds seeds) {
            this._seeds = seeds;
        }

        @Override
        public void run() {
            HubSeedManager.this.setSeeds(this._seeds);
        }
    }

    private class SeedRefresherASync
    implements Runnable {
        private final boolean _redownload;

        private SeedRefresherASync(boolean redownload) {
            this._redownload = redownload;
        }

        @Override
        public void run() {
            HubSeeds result = null;
            try {
                result = HubSeedRegistry.getDefault().getSeeds(this._redownload);
            }
            catch (Throwable t) {
                Exceptions.printStackTrace((Throwable)t);
            }
            HubSeeds seeds = result;
            SwingUtilities.invokeLater(new SeedRefreshCallback(seeds));
        }
    }
}

