/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph.state;

import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.graph.state.ConnectionController;
import com.paterva.maltego.collab.graph.state.StateConnecting;
import com.paterva.maltego.collab.session.SessionID;

public class StateWaitSessionID
extends StateConnecting.Timeout {
    private StateConnecting _nextState;
    private boolean _sessionCreated;
    private SessionID _sessionId;

    StateWaitSessionID(StateConnecting nextState, boolean sessionCreated, SessionID sessionId) {
        this._nextState = nextState;
        this._sessionCreated = sessionCreated;
        this._sessionId = sessionId;
    }

    @Override
    protected void onRun() {
        this.progress(LogMessageLevel.Info, "Waiting for session information", 25);
        this.debug("waiting for session ID");
        if (this._sessionId != null) {
            this.sessionIDChanged(this._sessionId);
        }
    }

    @Override
    protected long getTimeout() {
        return this.sessionInfo().getMessageTimeout();
    }

    @Override
    protected void onTimeout() {
        String msg = "Timeout waiting for session ID";
        this.handleError("", (Exception)((Object)new CollaborationException(msg, false)));
    }

    @Override
    void sessionIDChanged(SessionID id) {
        boolean acceptIDChange = true;
        if (this.isReconnect() && !this._sessionCreated) {
            SessionID localID = ((ConnectionController)this.getStateMachine()).getSessionID();
            this.debug(String.format("Reconnect with local session ID %s and remote ID %s", localID, id));
            acceptIDChange = id.equals(localID);
        }
        if (acceptIDChange) {
            this.debug("setting session ID to " + id);
            ((ConnectionController)this.getStateMachine()).setSessionID(id);
            this.setNextState(this._nextState);
        } else {
            this.handleError("Incompatible session IDs", (Exception)((Object)new CollaborationException("This graph is part of an older session that used to be hosted in the same chat room. Please connect with a new graph.", false)));
        }
    }
}

