/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.api;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.LinkDecorator;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import java.util.ArrayList;
import java.util.List;
import org.openide.util.Lookup;

public class ExtensibleLinkFactory
extends LinkFactory.Registry {
    private static final List<LinkDecorator> _decorators = new ArrayList<LinkDecorator>(Lookup.getDefault().lookupAll(LinkDecorator.class));
    private final GraphID _graphID;

    public ExtensibleLinkFactory(LinkRegistry registry, GraphID graphID) {
        super(registry);
        this._graphID = graphID;
    }

    @Override
    public MaltegoLink createInstance(String typeName, boolean sampleInstance, boolean decorate) throws TypeInstantiationException {
        MaltegoLink link = super.createInstance(typeName, sampleInstance, decorate);
        link = this.decorate(link, decorate);
        return link;
    }

    @Override
    public MaltegoLink createInstance(MaltegoLinkSpec descriptor, boolean sampleInstance, boolean decorate) throws TypeInstantiationException {
        MaltegoLink link = super.createInstance(descriptor, sampleInstance, decorate);
        link = this.decorate(link, decorate);
        return link;
    }

    @Override
    public MaltegoLink createInstance(String type, boolean decorate) {
        MaltegoLink link = super.createInstance(type, decorate);
        link = this.decorate(link, decorate);
        return link;
    }

    @Override
    public MaltegoLink createInstance(String type, LinkID id, boolean decorate) {
        MaltegoLink link = super.createInstance(type, id, decorate);
        link = this.decorate(link, decorate);
        return link;
    }

    @Override
    public MaltegoLink createInstance(MaltegoLinkSpec descriptor, boolean decorate) {
        MaltegoLink link = super.createInstance(descriptor, decorate);
        link = this.decorate(link, decorate);
        return link;
    }

    @Override
    public MaltegoLink createInstance(MaltegoLinkSpec descriptor, LinkID id, boolean decorate) {
        MaltegoLink link = super.createInstance(descriptor, id, decorate);
        link = this.decorate(link, decorate);
        return link;
    }

    private MaltegoLink decorate(MaltegoLink link, boolean decorate) {
        if (decorate && this._graphID != null) {
            for (LinkDecorator decorator : _decorators) {
                link = decorator.decorate(this._graphID, link);
            }
        }
        return link;
    }
}

