/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.wizard.licensed;

import com.paterva.maltego.licensing.D;
import com.paterva.maltego.licensing.LicensingException;
import com.paterva.maltego.licensing.rest.A;
import com.paterva.maltego.licensing.serialize.F;
import com.paterva.maltego.licensing.serialize.H;
import com.paterva.maltego.licensing.serialize.I;
import com.paterva.maltego.licensing.ui.wizard.LicenseWizard;
import com.paterva.maltego.licensing.ui.wizard.licensed.FailurePanel;
import com.paterva.maltego.licensing.ui.wizard.licensed.LicenseRequestSuccessPanel;
import com.paterva.maltego.util.ui.dialog.PassFailProgressController;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.WizardDescriptor;

public class RequestLicenseController
extends PassFailProgressController<H, LicenseRequestSuccessPanel, FailurePanel> {
    private static final Logger LOG = Logger.getLogger(RequestLicenseController.class.getName());
    private D license = null;

    public RequestLicenseController() {
        this.setName("Request License");
        this.setDescription("A summary of the activation process is shown below.");
        this.setImage(LicenseWizard.getDescriptionImage());
    }

    protected H doProcessing(WizardDescriptor descriptor, ProgressHandle handle) throws LicensingException {
        H blobAndEula = null;
        try {
            boolean offlineActivation = Boolean.TRUE.equals(descriptor.getProperty("licensing.activation.offline"));
            if (offlineActivation) {
                LOG.log(Level.INFO, "License wizard: License Key - requesting offline activation");
                String licenseFile = (String)descriptor.getProperty("licensing.file");
                String response = new String(Files.readAllBytes(Paths.get(licenseFile, new String[0])), StandardCharsets.UTF_8);
                blobAndEula = A.D((String)response);
            } else {
                LOG.log(Level.INFO, "License wizard: License Key - requesting online activation");
                handle.progress("Requesting license from server...");
                String licenseKey = (String)descriptor.getProperty("licensing.key");
                blobAndEula = A.F((String)licenseKey);
            }
            if (blobAndEula != null && blobAndEula.B() != null) {
                this.license = blobAndEula.B().A(true);
            }
        }
        catch (Exception ex) {
            throw new LicensingException("Click back to try again", ex, false);
        }
        return blobAndEula;
    }

    protected void storeSettings(WizardDescriptor settings) {
    }

    protected LicenseRequestSuccessPanel createPassComponent() {
        return new LicenseRequestSuccessPanel();
    }

    protected FailurePanel createFailComponent() {
        return new FailurePanel();
    }

    protected void pass(WizardDescriptor descriptor, LicenseRequestSuccessPanel component, H blobAndEula) {
        F licenseBlob = blobAndEula.B();
        I eula = blobAndEula.A().orElse(null);
        descriptor.putProperty("licensing.blob", (Object)licenseBlob);
        descriptor.putProperty("licensing.eula", (Object)eula);
        descriptor.putProperty("licensing.license", (Object)this.license);
    }

    protected void fail(FailurePanel component, Exception e) {
        Throwable t;
        Throwable throwable = t = e != null ? e.getCause() : null;
        if (t == null) {
            component.setError(null);
        } else if (t.getMessage() == null) {
            component.setError(t.toString());
        } else {
            component.setError(t.getMessage());
        }
        if (t instanceof LicensingException && ((LicensingException)t).isCommunicationError()) {
            component.setOptionsVisible(true);
            component.setTitle("Could not retrieve license from server!");
            component.setDescription("This usually means that you have no internet connection or that your proxy settings are incorrect.\n\nTo change your proxy settings click on the options button below. Use the \"Back\" button to retry the activation process");
        } else {
            component.setOptionsVisible(false);
            component.setTitle("License request failed!");
            component.setDescription("This usually means that your license key is invalid or you have exceeded the maximum number of activations.\n\nPlease contact the Maltego help desk at support@maltego.com.");
        }
    }
}

