/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.imex;

import com.paterva.maltego.customicons.imex.IconDescriptor;
import com.paterva.maltego.customicons.imex.IconMetadata;
import com.paterva.maltego.customicons.imex.SelectableCategory;
import com.paterva.maltego.customicons.imex.SelectableIcon;
import com.paterva.maltego.imgfactory.icons.IconLayerRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.IconSize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openide.filesystems.FileObject;

class Util {
    Util() {
    }

    public static List<SelectableCategory> createSelectables(List<IconDescriptor> icons, List<IconMetadata> metadatas) {
        Args.notNull(icons, (String)"icons");
        Args.notNull(metadatas, (String)"metadatas");
        HashMap<String, SelectableCategory> categories = new HashMap<String, SelectableCategory>();
        for (IconDescriptor iconDescriptor : icons) {
            String category = iconDescriptor.getCategory();
            String iconName = iconDescriptor.getIconName();
            SelectableCategory selectableCategory = (SelectableCategory)categories.get(category);
            if (selectableCategory == null) {
                selectableCategory = new SelectableCategory(category, true);
                categories.put(category, selectableCategory);
            }
            List<SelectableIcon> selectableIcons = selectableCategory.getIcons();
            SelectableIcon selectableIcon = null;
            for (SelectableIcon icon : selectableIcons) {
                if (!iconName.equals(icon.getIconName())) continue;
                selectableIcon = icon;
                break;
            }
            if (selectableIcon == null) {
                selectableIcon = new SelectableIcon(category, iconName, true);
                selectableIcons.add(selectableIcon);
            }
            selectableIcon.getIcons().add(iconDescriptor);
            Util.getIconMetadata(metadatas, category, iconName).ifPresent(selectableIcon::setMetadata);
        }
        ArrayList<SelectableCategory> sortedCategories = new ArrayList<SelectableCategory>(categories.values());
        Collections.sort(sortedCategories);
        for (SelectableCategory selectableCategory : sortedCategories) {
            Collections.sort(selectableCategory.getIcons());
        }
        return sortedCategories;
    }

    public static String getCategory(String parentFolder, String folders) {
        String category = folders.length() > parentFolder.length() + 1 ? folders.substring(parentFolder.length() + 1) : "Custom";
        return category;
    }

    public static List<IconDescriptor> createDescriptors(IconLayerRegistry iconRegistry) {
        return iconRegistry.getIcons().stream().flatMap(icon -> Stream.of(IconSize.values()).map(size -> Util.createDescriptor(iconRegistry, icon, size)).filter(Objects::nonNull)).collect(Collectors.toList());
    }

    public static List<IconMetadata> getIconMetadatas(IconLayerRegistry iconRegistry) {
        Args.notNull((Object)iconRegistry, (String)"iconRegistry");
        return iconRegistry.getIcons().stream().map(IconMetadata::new).collect(Collectors.toList());
    }

    public static Optional<IconMetadata> getIconMetadata(List<IconMetadata> metadatas, RegistryIcon icon) {
        Args.notNull(metadatas, (String)"metadatas");
        Args.notNull((Object)icon, (String)"icon");
        return Util.getIconMetadata(metadatas, icon.getCategory(), icon.getName());
    }

    public static Optional<IconMetadata> getIconMetadata(List<IconMetadata> metadatas, String category, String iconName) {
        Args.notNull(metadatas, (String)"metadatas");
        Args.notNullOrBlank((String)category, (String)"category");
        Args.notNullOrBlank((String)iconName, (String)"iconName");
        return metadatas.stream().filter(meta -> meta.getCategory().equals(category)).filter(meta -> meta.getIconName().equals(iconName)).findAny();
    }

    private static IconDescriptor createDescriptor(IconLayerRegistry iconRegistry, RegistryIcon icon, IconSize size) {
        FileObject fileObject = iconRegistry.getFileObject(icon, size);
        if (fileObject == null) {
            return null;
        }
        return new IconDescriptor(fileObject, icon.getCategory(), icon.getName(), size);
    }
}

