/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ui;

import com.sun.source.util.JavacTask;
import com.sun.tools.javac.api.ClientCodeWrapper;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.jvm.ClassReader;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.netbeans.modules.java.source.ElementUtils;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.CachingFileManager;
import org.netbeans.modules.java.source.ui.JavaSymbolDescriptorBase;
import org.netbeans.modules.java.source.ui.JavaSymbolProvider;
import org.netbeans.modules.java.source.ui.ResolvedJavaSymbolDescriptor;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.jumpto.support.AsyncDescriptor;
import org.netbeans.spi.jumpto.support.DescriptorChangeEvent;
import org.netbeans.spi.jumpto.support.DescriptorChangeListener;
import org.netbeans.spi.jumpto.symbol.SymbolDescriptor;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

final class AsyncJavaSymbolDescriptor
extends JavaSymbolDescriptorBase
implements AsyncDescriptor<SymbolDescriptor> {
    private static final RequestProcessor WORKER = new RequestProcessor(AsyncJavaSymbolDescriptor.class);
    private static final String INIT = "<init>";
    private static final Logger LOG = Logger.getLogger(AsyncJavaSymbolDescriptor.class.getName());
    private static volatile boolean pkgROELogged = false;
    private static volatile boolean clzROELogged = false;
    private static Reference<JavacTaskImpl> javacRef;
    private final String ident;
    private final boolean caseSensitive;
    private final List<DescriptorChangeListener<SymbolDescriptor>> listeners;
    private final AtomicBoolean initialized;

    AsyncJavaSymbolDescriptor(@NullAllowed ProjectInformation projectInformation, @NonNull org.openide.filesystems.FileObject root, @NonNull ClassIndexImpl ci, @NonNull ElementHandle<TypeElement> owner, @NonNull String ident, boolean caseSensitive) {
        super(owner, projectInformation, root, ci);
        assert (ident != null);
        this.ident = ident;
        this.listeners = new CopyOnWriteArrayList<DescriptorChangeListener<SymbolDescriptor>>();
        this.initialized = new AtomicBoolean();
        this.caseSensitive = caseSensitive;
    }

    public Icon getIcon() {
        this.initialize();
        return null;
    }

    public String getSymbolName() {
        this.initialize();
        return this.ident;
    }

    public String getSimpleName() {
        return this.ident;
    }

    public void open() {
        Collection<? extends SymbolDescriptor> symbols = this.resolve();
        if (!symbols.isEmpty()) {
            symbols.iterator().next().open();
        }
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = hashCode * 31 + this.ident.hashCode();
        hashCode = hashCode * 31 + this.getRoot().hashCode();
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AsyncJavaSymbolDescriptor)) {
            return false;
        }
        AsyncJavaSymbolDescriptor other = (AsyncJavaSymbolDescriptor)((Object)obj);
        return this.caseSensitive == other.caseSensitive && this.ident.equals(other.ident) && this.getOwner().equals(other.getOwner()) && this.getRoot().equals(other.getRoot());
    }

    private void initialize() {
        if (this.initialized.compareAndSet(false, true)) {
            Runnable action = () -> {
                Collection<? extends SymbolDescriptor> symbols = this.resolve();
                this.fireDescriptorChange(symbols);
            };
            WORKER.execute(action);
        }
    }

    public void addDescriptorChangeListener(@NonNull DescriptorChangeListener<SymbolDescriptor> listener) {
        Parameters.notNull((CharSequence)"listener", listener);
        this.listeners.add(listener);
    }

    public void removeDescriptorChangeListener(@NonNull DescriptorChangeListener<SymbolDescriptor> listener) {
        Parameters.notNull((CharSequence)"listener", listener);
        this.listeners.remove(listener);
    }

    public boolean hasCorrectCase() {
        return this.caseSensitive;
    }

    private void fireDescriptorChange(Collection<? extends SymbolDescriptor> replacement) {
        DescriptorChangeEvent event = new DescriptorChangeEvent((Object)this, replacement);
        for (DescriptorChangeListener<SymbolDescriptor> l : this.listeners) {
            l.descriptorChanged(event);
        }
    }

    @NonNull
    private Collection<? extends SymbolDescriptor> resolve() {
        try {
            ArrayList<ResolvedJavaSymbolDescriptor> symbols = new ArrayList<ResolvedJavaSymbolDescriptor>();
            JavacTaskImpl jt = AsyncJavaSymbolDescriptor.getJavac(this.getRoot());
            Symtab syms = Symtab.instance(jt.getContext());
            HashSet pkgs = new HashSet(this.getPackages(syms).keySet());
            HashSet clzs = new HashSet(this.getClasses(syms).keySet());
            jt.getElements().getTypeElement("java.lang.Object");
            TypeElement te = ElementUtils.getTypeElementByBinaryName((JavacTask)jt, (String)ElementHandleAccessor.getInstance().getJVMSignature(this.getOwner())[0]);
            if (te != null) {
                if (this.ident.equals(AsyncJavaSymbolDescriptor.getSimpleName(te, null, this.caseSensitive))) {
                    String simpleName = te.getSimpleName().toString();
                    String string = null;
                    ElementKind kind = te.getKind();
                    Set<Modifier> modifiers = te.getModifiers();
                    ElementHandle me = ElementHandle.create((Element)te);
                    symbols.add(new ResolvedJavaSymbolDescriptor(this, simpleName, string, te.getQualifiedName().toString(), kind, modifiers, me));
                }
                for (Element element : te.getEnclosedElements()) {
                    if (!this.ident.equals(AsyncJavaSymbolDescriptor.getSimpleName(element, te, this.caseSensitive))) continue;
                    Pair<String, String> name = JavaSymbolProvider.getDisplayName(element, te);
                    String simpleName = (String)name.first();
                    String simpleNameSuffix = (String)name.second();
                    ElementKind kind = element.getKind();
                    Set<Modifier> modifiers = element.getModifiers();
                    ElementHandle me = ElementHandle.create((Element)element);
                    symbols.add(new ResolvedJavaSymbolDescriptor(this, simpleName, simpleNameSuffix, te.getQualifiedName().toString(), kind, modifiers, me));
                }
            }
            this.getClasses(syms).keySet().retainAll(clzs);
            this.getPackages(syms).keySet().retainAll(pkgs);
            return symbols;
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
            return Collections.emptyList();
        }
    }

    @NonNull
    private Map<?, ?> getPackages(Symtab cr) {
        Map res;
        block3: {
            res = Collections.emptyMap();
            try {
                Field fld = ClassReader.class.getDeclaredField("packages");
                fld.setAccessible(true);
                Map pkgs = (Map)fld.get(cr);
                if (pkgs != null) {
                    res = pkgs;
                }
            }
            catch (ReflectiveOperationException e) {
                if (pkgROELogged) break block3;
                LOG.warning(e.getMessage());
                pkgROELogged = true;
            }
        }
        return res;
    }

    @NonNull
    private Map<?, ?> getClasses(Symtab cr) {
        Map res;
        block3: {
            res = Collections.emptyMap();
            try {
                Field fld = ClassReader.class.getDeclaredField("classes");
                fld.setAccessible(true);
                Map clzs = (Map)fld.get(cr);
                if (clzs != null) {
                    res = clzs;
                }
            }
            catch (ReflectiveOperationException e) {
                if (clzROELogged) break block3;
                LOG.warning(e.getMessage());
                clzROELogged = true;
            }
        }
        return res;
    }

    private static JavacTaskImpl getJavac(org.openide.filesystems.FileObject root) throws IOException {
        JavacTaskImpl javac;
        Reference<JavacTaskImpl> ref = javacRef;
        if (ref == null || (javac = ref.get()) == null) {
            String sourceLevel = SourceLevelQuery.getSourceLevel((org.openide.filesystems.FileObject)root);
            javac = (JavacTaskImpl)JavacTool.create().getTask((Writer)null, (JavaFileManager)new RootChange(root), (DiagnosticListener)new Listener(), sourceLevel != null ? Arrays.asList("-source", sourceLevel) : Collections.emptySet(), (Iterable)Collections.emptySet(), (Iterable)Collections.emptySet());
            javacRef = new WeakReference<JavacTaskImpl>(javac);
        }
        JavaFileManager fm = javac.getContext().get(JavaFileManager.class);
        ((RootChange)fm).setRoot(root);
        return javac;
    }

    @NonNull
    private static String getSimpleName(@NonNull Element element, @NullAllowed Element enclosingElement, boolean caseSensitive) {
        String result = element.getSimpleName().toString();
        if (enclosingElement != null && INIT.equals(result)) {
            result = enclosingElement.getSimpleName().toString();
        }
        if (!caseSensitive) {
            result = result.toLowerCase();
        }
        return result;
    }

    private static final class Listener
    implements DiagnosticListener<JavaFileObject> {
        private Listener() {
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
        }
    }

    @ClientCodeWrapper.Trusted
    private static final class RootChange
    implements JavaFileManager {
        private org.openide.filesystems.FileObject currentRoot;
        private JavaFileManager delegate;

        RootChange(@NonNull org.openide.filesystems.FileObject root) throws IOException {
            this.setRoot(root);
        }

        void setRoot(@NonNull org.openide.filesystems.FileObject root) throws IOException {
            if (root != this.currentRoot) {
                File classes = JavaIndex.getClassFolder((URL)root.toURL());
                CachingFileManager fm = new CachingFileManager(CachingArchiveProvider.getDefault(), ClassPathSupport.createClassPath((URL[])new URL[]{BaseUtilities.toURI((File)classes).toURL()}), null, false, true);
                this.delegate = fm;
                this.currentRoot = root;
            }
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return this.delegate.getClassLoader(location);
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            return this.delegate.list(location, packageName, kinds, recurse);
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
            return this.delegate.inferBinaryName(location, file);
        }

        @Override
        public boolean isSameFile(FileObject a, FileObject b) {
            return this.delegate.isSameFile(a, b);
        }

        @Override
        public boolean handleOption(String current, Iterator<String> remaining) {
            return this.delegate.handleOption(current, remaining);
        }

        @Override
        public boolean hasLocation(JavaFileManager.Location location) {
            return location == StandardLocation.CLASS_PATH || location == StandardLocation.PLATFORM_CLASS_PATH;
        }

        @Override
        public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
            return this.delegate.getJavaFileForInput(location, className, kind);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            return this.delegate.getJavaFileForOutput(location, className, kind, sibling);
        }

        @Override
        public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
            return this.delegate.getFileForInput(location, packageName, relativeName);
        }

        @Override
        public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
            return this.delegate.getFileForOutput(location, packageName, relativeName, sibling);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public int isSupportedOption(String option) {
            return this.delegate.isSupportedOption(option);
        }

        @Override
        public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
            return Collections.emptyList();
        }
    }
}

