/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.wizard;

import com.paterva.maltego.graph.table.MappingRegistry;
import com.paterva.maltego.graph.table.io.links.ConnectivityOptions;
import com.paterva.maltego.graph.table.ui.wizard.DefaultConnectivityOptionsController;
import com.paterva.maltego.graph.table.ui.wizard.ImportFileLoadMappingController;
import com.paterva.maltego.graph.table.ui.wizard.ImportProgressController;
import com.paterva.maltego.graph.table.ui.wizard.ImportTutorialController;
import com.paterva.maltego.graph.table.ui.wizard.MappingConfigurationController;
import com.paterva.maltego.graph.table.ui.wizard.SamplingController;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.util.ui.dialog.ArrayWizardIterator;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.io.File;
import java.text.MessageFormat;
import java.util.prefs.Preferences;
import org.openide.WizardDescriptor;
import org.openide.util.NbPreferences;

public class ImportWizard {
    private static final String PREF_PREVIOUSE_FILE = "maltego.tabular.import.previous.file";
    private static final String PREF_PREVIOUSE_DIR = "maltego.tabular.import.previous.dir";

    public static WizardDescriptor create() {
        String previousFile = ImportWizard.getPreviousFile();
        return ImportWizard.create(previousFile == null ? null : new File(previousFile));
    }

    public static WizardDescriptor create(File file) {
        WizardDescriptor.Panel[] panels;
        MappingRegistry.getDefault().refreshProperties();
        String WIZARD_TITLE = "Graph Import Wizard";
        MappingConfigurationController mcController = new MappingConfigurationController();
        int counter = 0;
        boolean showTutorial = NbPreferences.forModule(ImportTutorialController.class).getBoolean("showImportTutorial", true);
        if (showTutorial) {
            panels = new WizardDescriptor.Panel[6];
            panels[counter++] = new ImportTutorialController();
        } else {
            panels = new WizardDescriptor.Panel[5];
        }
        panels[counter++] = new ImportFileLoadMappingController();
        panels[counter++] = new DefaultConnectivityOptionsController();
        panels[counter++] = mcController;
        panels[counter++] = new SamplingController();
        panels[counter++] = new ImportProgressController();
        WizardUtilities.updatePanels((WizardDescriptor.Panel[])panels);
        WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)new ArrayWizardIterator(panels));
        wizardDescriptor.setTitleFormat(new MessageFormat("Graph Import Wizard - {0}"));
        wizardDescriptor.setTitle("Graph Import Wizard");
        wizardDescriptor.putProperty("WizardPanel_helpDisplayed", (Object)Boolean.FALSE);
        wizardDescriptor.putProperty("mcTabbedPane", (Object)mcController.getMappingConfigurationTabbedPane());
        wizardDescriptor.putProperty("defaultConnectivityOptions", (Object)ConnectivityOptions.SEQUENTIAL);
        if (file != null) {
            wizardDescriptor.putProperty("selectedFile", (Object)file);
        } else {
            String previousDir = ImportWizard.getPreviousDir();
            if (previousDir == null) {
                previousDir = NbPreferences.root().get("browseDir", "");
            }
            wizardDescriptor.putProperty("browseDir", (Object)previousDir);
        }
        wizardDescriptor.putProperty("newGraph", (Object)Boolean.TRUE);
        boolean hasTopGraph = GraphEditorRegistry.getDefault().getTopmost() != null;
        wizardDescriptor.putProperty("showMergeGraphOption", (Object)hasTopGraph);
        return wizardDescriptor;
    }

    public static String getPreviousFile() {
        return ImportWizard.getPrefs().get(PREF_PREVIOUSE_FILE, null);
    }

    public static void setPreviousFile(File previousFile) {
        if (previousFile != null) {
            ImportWizard.getPrefs().put(PREF_PREVIOUSE_FILE, previousFile.getPath());
        }
    }

    public static String getPreviousDir() {
        return ImportWizard.getPrefs().get(PREF_PREVIOUSE_DIR, null);
    }

    public static void setPreviousDir(String previousDir) {
        if (previousDir != null) {
            ImportWizard.getPrefs().put(PREF_PREVIOUSE_DIR, previousDir);
        }
    }

    private static Preferences getPrefs() {
        return NbPreferences.forModule(ImportWizard.class);
    }
}

