/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.EmptyNodeSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NodeSetExpression;
import com.icl.saxon.expr.UnionEnumeration;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;

class UnionExpression
extends NodeSetExpression {
    protected Expression p1;
    protected Expression p2;

    public UnionExpression(Expression expression, Expression expression2) {
        this.p1 = expression;
        this.p2 = expression2;
    }

    public Expression simplify() throws XPathException {
        this.p1 = this.p1.simplify();
        this.p2 = this.p2.simplify();
        if (this.p1 instanceof EmptyNodeSet) {
            return this.p2;
        }
        if (this.p2 instanceof EmptyNodeSet) {
            return this.p1;
        }
        return this;
    }

    public NodeEnumeration enumerate(Context context, boolean bl) throws XPathException {
        return new UnionEnumeration(this.p1.enumerate(context, true), this.p2.enumerate(context, true), context.getController());
    }

    public int getDependencies() {
        return this.p1.getDependencies() | this.p2.getDependencies();
    }

    public boolean isContextDocumentNodeSet() {
        return this.p1.isContextDocumentNodeSet() && this.p2.isContextDocumentNodeSet();
    }

    public Expression reduce(int n, Context context) throws XPathException {
        if ((this.getDependencies() & n) != 0) {
            UnionExpression unionExpression = new UnionExpression(this.p1.reduce(n, context), this.p2.reduce(n, context));
            unionExpression.setStaticContext(this.getStaticContext());
            return unionExpression;
        }
        return this;
    }

    public void display(int n) {
        System.err.println(Expression.indent(n) + "union");
        this.p1.display(n + 1);
        this.p2.display(n + 1);
    }
}

