/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.util.S9apiUtils;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import org.json.JSONException;
import org.json.JSONStringer;

public class XMLtoJSON {
    private static final int ROOT = 0;
    private static final int OBJECT = 1;
    private static final int ARRAY = 2;
    private static QName _type = new QName("", "type");
    private static QName _name = new QName("", "name");
    private static final QName c_body = new QName("c", "http://www.w3.org/ns/xproc-step", "body");

    public static String convert(XdmNode xdmNode) {
        JSONStringer jSONStringer = new JSONStringer();
        if (c_body.equals((Object)(xdmNode = S9apiUtils.getDocumentElement(xdmNode)).getNodeName())) {
            XdmNode xdmNode2 = null;
            XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
            while (xdmSequenceIterator.hasNext()) {
                XdmNode xdmNode3;
                XdmItem xdmItem = xdmSequenceIterator.next();
                if (!(xdmItem instanceof XdmNode) || (xdmNode3 = (XdmNode)xdmItem).getNodeKind() != XdmNodeKind.ELEMENT) continue;
                if (xdmNode2 != null) {
                    throw new XProcException("Found c:body containing more than one JSON element?");
                }
                xdmNode2 = xdmNode3;
            }
            xdmNode = xdmNode2;
        }
        try {
            XMLtoJSON.build(xdmNode, jSONStringer, 0);
        }
        catch (JSONException jSONException) {
            throw new XProcException(jSONException);
        }
        return jSONStringer.toString();
    }

    private static void build(XdmNode xdmNode, JSONStringer jSONStringer, int n) throws JSONException {
        String string;
        String string2 = null;
        string2 = "http://www.ibm.com/xmlns/prod/2009/jsonx".equals(xdmNode.getNodeName().getNamespaceURI()) || "http://www.xmlsh.org/jxml".equals(xdmNode.getNodeName().getNamespaceURI()) ? xdmNode.getNodeName().getLocalName() : xdmNode.getAttributeValue(_type);
        String string3 = null;
        if ("http://marklogic.com/json".equals(xdmNode.getNodeName().getNamespaceURI())) {
            string3 = xdmNode.getNodeName().getLocalName();
            if (string3.contains("_")) {
                if ("_".equals(string3)) {
                    string3 = "";
                } else {
                    string = "";
                    int n2 = string3.indexOf("_");
                    while (n2 >= 0) {
                        string = string + string3.substring(0, n2);
                        String string4 = string3.substring(n2 + 1, n2 + 5);
                        int n3 = Integer.parseInt(string4, 16);
                        string = string + Character.toString((char)n3);
                        string3 = string3.substring(n2 + 5);
                        n2 = string3.indexOf("_");
                    }
                    string3 = string + string3;
                }
            }
        } else {
            string3 = xdmNode.getAttributeValue(_name);
        }
        if (n == 1 && string3 != null) {
            jSONStringer.key(string3);
        }
        if ("object".equals(string2)) {
            jSONStringer.object();
            XMLtoJSON.processChildren(xdmNode, jSONStringer, 1);
            jSONStringer.endObject();
        } else if ("array".equals(string2)) {
            jSONStringer.array();
            XMLtoJSON.processChildren(xdmNode, jSONStringer, 2);
            jSONStringer.endArray();
        } else if ("member".equals(string2)) {
            XMLtoJSON.processChildren(xdmNode, jSONStringer, 1);
        } else if ("null".equals(string2)) {
            jSONStringer.value(null);
        } else if ("number".equals(string2)) {
            string = xdmNode.getStringValue();
            if (string.contains(".")) {
                Double d = Double.parseDouble(string);
                jSONStringer.value(d);
            } else {
                long l = Long.parseLong(string);
                jSONStringer.value(l);
            }
        } else if ("boolean".equals(string2)) {
            jSONStringer.value("true".equals(xdmNode.getStringValue()));
        } else {
            jSONStringer.value(xdmNode.getStringValue());
        }
    }

    private static void processChildren(XdmNode xdmNode, JSONStringer jSONStringer, int n) throws JSONException {
        XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
        while (xdmSequenceIterator.hasNext()) {
            XdmNode xdmNode2;
            XdmItem xdmItem = xdmSequenceIterator.next();
            if (!(xdmItem instanceof XdmNode) || (xdmNode2 = (XdmNode)xdmItem).getNodeKind() != XdmNodeKind.ELEMENT) continue;
            XMLtoJSON.build(xdmNode2, jSONStringer, n);
        }
    }
}

