/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.io.Serializable;
import java.util.StringTokenizer;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeSetPattern;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public final class IDPattern
extends NodeSetPattern {
    public IDPattern(Expression id, Configuration config) {
        super(id, config);
    }

    public Pattern analyze(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.expression = visitor.typeCheck(this.expression, contextItemType);
        RoleLocator role = new RoleLocator(0, (Serializable)((Object)"id"), 1);
        this.expression = TypeChecker.staticTypeCheck(this.expression, SequenceType.ATOMIC_SEQUENCE, false, role, visitor);
        return this;
    }

    public boolean matches(NodeInfo e, XPathContext context) throws XPathException {
        if (e.getNodeKind() != 1) {
            return false;
        }
        DocumentInfo doc = e.getDocumentRoot();
        if (doc == null) {
            return false;
        }
        AtomicValue idValue = (AtomicValue)this.expression.evaluateItem(context);
        if (idValue == null) {
            return false;
        }
        String ids = idValue.getStringValue();
        if (Whitespace.containsWhitespace(ids)) {
            NodeInfo element = doc.selectID(ids, false);
            return element != null && element.isSameNodeInfo(e);
        }
        StringTokenizer tokenizer = new StringTokenizer(ids, " \t\n\r", false);
        while (tokenizer.hasMoreElements()) {
            String id = (String)tokenizer.nextElement();
            NodeInfo element = doc.selectID(id, false);
            if (element == null || !e.isSameNodeInfo(element)) continue;
            return true;
        }
        return false;
    }

    public int getNodeKind() {
        return 1;
    }

    public NodeTest getNodeTest() {
        return NodeKindTest.ELEMENT;
    }
}

