/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

#pragma once

#include <quic/observer/SocketObserverContainer.h>

namespace quic {

/**
 * Helper class for writing an observer that monitors a single socket.
 *
 * Designed to support use cases where the observer implementation is driven
 * entirely by observer events generated by the monitored socket or by events
 * dispatched by the socket's event base.
 *
 * ManagedObserver tracks the folly::ObserverContainer it is in (if any). If the
 * observer's destructor is triggered while it is in an container, it will be
 * removed from the container during the destruction process.
 */
using ManagedObserver = SocketObserverContainer::ManagedObserver;

/**
 * Legacy observer for implementations prior to folly::ObserverContainer.
 *
 * TODO(bschlinker): Complete depreciation.
 */
using LegacyObserver = SocketObserverContainer::LegacyObserver;

} // namespace quic
