We are excited to announce the release of godog v0.12.0.

Here follows a summary of Notable Changes, the Non Backward Compatible Changes and Deprecation Notices. The full change
log is available [here](https://github.com/cucumber/godog/blob/master/CHANGELOG.md).


Notable Changes
---------------

### Output with multiple formatters

Now `godog` is able to use multiple formatters simultaneously with comma-separated formatters.

`--format pretty,junit:report.xml,cucumber:report.json` will write `pretty` format to stdout, `junit` to report.xml
and `cucumber` to report.json.

### Extensible formatters

Standard formatters are now exported with type aliases so that a custom formatter can be built on top of it.
Please check [an example](../_examples/custom-formatter).

### Contextualized hooks

Scenario and Step hooks are now passing context to allow custom state communication. Returned context should generally
be based or equal to received context. Context is also passed to steps that have it in declaration and is read from
steps that return it.

Hooks can now return error, if non nil error is returned test is failed. This enables additional flow control, for
example to check expectations after the scenario.

Scenario hooks are now named `Before` and `After`.

```go
// BeforeScenarioHook defines a hook before scenario.
type BeforeScenarioHook func (ctx context.Context, sc *Scenario) (context.Context, error)

// AfterScenarioHook defines a hook after scenario.
type AfterScenarioHook func (ctx context.Context, sc *Scenario, err error) (context.Context, error)
```

Step hooks are now also named `Before` and `After`, but they are available with `ScenarioContext.StepContext()`.

```go
// BeforeStepHook defines a hook before step.
type BeforeStepHook func (ctx context.Context, st *Step) (context.Context, error)

// AfterStepHook defines a hook after step.
type AfterStepHook func (ctx context.Context, st *Step, status StepResultStatus, err error) (context.Context, error)
```

### Step definition improvements

Now `godog` can use additional ways to declare step definition. These declarations are optional and do not break
backwards compatibility.

Error result may be omitted if the step does not fail.

```go
func iEat(arg1 int) {
    // Eat arg1.
}
```

You can have `context.Context` as first argument, test runner will pass current context to the step.

```go
func iEat(ctx context.Context, arg1 int) {
    if v, ok := ctx.Value(eatKey{}).int; ok {
        // Eat v from context.
    }
    // Eat arg1.
}
```

You can have `context.Context` in return, test runner will use returned context to pass to next hooks and steps.

```go
func iEat(ctx context.Context, arg1 int) context.Context {
    if v, ok := ctx.Value(eatKey{}).int; ok {
        // Eat v from context.
    }
    // Eat arg1.
    
    return context.WithValue(ctx, eatKey{}, 0)
}
```

If error is also needed in return, context have to be first.

```go
func iEat(ctx context.Context, arg1 int) (context.Context, error) {
    if v, ok := ctx.Value(eatKey{}).int; ok {
        // Eat v from context.
    }
    // Eat arg1.

    if arg1 == 0 {
        return errors.New("can't eat nothing")
    }
    
    return context.WithValue(ctx, eatKey{}, 0), nil
}
```

You can now use `string` instead of `*godog.DocString` in declaration.

### Getting features of test suite

`godog.TestSuite` now can `RetrieveFeatures() ([]*models.Feature, error)` to expose parsed features to the user.

### Added official support for go1.16 and go1.17

With the introduction of go1.17, go1.17 and go1.16 are now officially supported.

### Running scenarios as subtests of *testing.T

You can now assign an instance of `*testing.T` to `godog.Options.TestingT` so that scenarios will be invoked with 
`t.Run` allowing granular control with standard Go tools. 

[More info](https://github.com/cucumber/godog#running-godog-with-go-test).

Non Backward Compatible Changes
-------------------------------

### Messages library updated

Messages library is changed from `github.com/cucumber/messages-go/v10` to `github.com/cucumber/messages-go/v16`.

Deprecation Notices
-------------------

### Hooks

Scenario and step hooks were upgraded with new API to support context and errors, previous methods are now deprecated.

- `ScenarioContext.BeforeScenario`, use `ScenarioContext.Before`
- `ScenarioContext.AfterScenario`, use `ScenarioContext.After`
- `ScenarioContext.BeforeStep`, use `ScenarioContext.StepContext().Before`
- `ScenarioContext.AfterStep`, use `ScenarioContext.StepContext().After`

Full change log
---------------

See [CHANGELOG.md](https://github.com/cucumber/godog/blob/master/CHANGELOG.md).
