We are excited to announce the release of godog v0.11.0.

Here follows a summary of Notable Changes, the Non Backward Compatible Changes and Deprecation Notices.
The full change log is available [here](https://github.com/cucumber/godog/blob/master/CHANGELOG.md#v0110-rc1).


Notable Changes
---------------

### Write test report to file
godog is now able to write the report to a file.

- `--format cucumber` will continue to write the report to `stdout`

- `--format cucumber:report.json` will instead write the report to a file named `report.json`

**Note**, godog still only support the use of one formatter.

### Executing godog from the Command Line
godog is now using [Cobra](https://pkg.go.dev/github.com/spf13/cobra) to run godog from the command line. With this update, godog has received sub-commands: (build, help, run, version)

To run tests with godog, `godog [<feature>]` has been replaced with `godog run [<feature>]`.

To build a test binary, `godog --output g.test [<feature>]`has been replaced with `godog build --output g.test [<feature>]`.

### Upload artifacts to the github release
The releases on github now include prebuilt binaries for:
- Linux for amd64 and arm64
- macOs (Darwin) for amd64

### Restructure of the codebase with internal packages
A lot of the internal code that used to be in the main godog package has been moved to internal packages.

The reason for this is mainly for decoupling to allow for simpler tests and to make the codebase easier to work with in general.

### Added official support for go1.15 and removed support for go1.12 
With the introduction of go1.15, go1.15 is now officially supported and go1.12 has been removed, this is since godog supports the 3 latest versions of golang.

Non Backward Compatible Changes
-------------------------------

### Concurrency Formatter
`ConcurrencyFormatter` is now removed since the deprecation in [v0.10.0](./v0.10.0.md).

### Run and RunWithOptions
`Run` and `RunWithOptions` are now removed since the deprecation in [v0.10.0](./v0.10.0.md).

### Suite and SuiteContext
`Suite` and `SuiteContext` are now removed since the deprecation in [v0.10.0](./v0.10.0.md).

Deprecation Notices
-------------------

### BindFlags
`BindFlags(prefix, flag.CommandLine, &opts)` has been replaced by `BindCommandLineFlags(prefix, &opts)` and will be removed in `v0.12.0`.

Using `BindCommandLineFlags(prefix, &opts)` also requires you to use `"github.com/spf13/pflag"` to parse the flags.
```go
package main

import (
	"fmt"
	"os"
	"testing"

	"github.com/cucumber/godog"
	"github.com/cucumber/godog/colors"
	"github.com/spf13/pflag"
)

var opts = godog.Options{Output: colors.Colored(os.Stdout)}

func init() {
	godog.BindCommandLineFlags("godog.", &opts)
}

func TestMain(m *testing.M) {
	pflag.Parse()
	opts.Paths = pflag.Args()
  
  // ...
```

### Executing the godog CLI
godog has received sub-commands: (build, help, run, version)

To run tests with godog, `godog [<feature>]` has been replaced with `godog run [<feature>]`.

To build a test binary, `godog --output g.test [<feature>]`has been replaced with `godog build --output g.test [<feature>]`.

Full change log
---------------

See [CHANGELOG.md](https://github.com/cucumber/godog/blob/master/CHANGELOG.md#v0110-rc1).
