We are excited to announce the release of godog v0.10.0.

Here follows a summary of Notable Changes, the Non Backward Compatible Changes and Deprecation Notices.
The full change log is available [here](https://github.com/cucumber/godog/blob/master/CHANGELOG.md#v0100).


Notable Changes
---------------

### Context Initializers
The current Suite initializer will be removed and replaced by two new initializers, one for the Test Suite and one for the Scenarios.

The **TestSuiteContext** Initializer will be executed once for the execution of the full TestSuite.
```go
// These are the hooks that can be configured for the TestSuite.
func (ctx *TestSuiteContext) BeforeSuite(fn func())
func (ctx *TestSuiteContext) AfterSuite(fn func())
```

The **ScenarioContext** Initializer will be executed before every Scenario.
```go
// These are the hooks that can be configured for a Scenario.
func (ctx *ScenarioContext) BeforeScenario(fn func(sc *Scenario))
func (ctx *ScenarioContext) AfterScenario(fn func(sc *Scenario, err error))
func (ctx *ScenarioContext) BeforeStep(fn func(st *Step))
func (ctx *ScenarioContext) AfterStep(fn func(st *Step, err error))

// Registers a step definition for a Scenario.
func (ctx *ScenarioContext) Step(expr, stepFunc interface{})
```

### Formatter Concurrency
All builtin formatters now support concurrency.

### Scenario Concurrency
Using the new Initializers, godog will now execute scenarios concurrently instead of features.


Non Backward Compatible Changes
-------------------------------

### Hooks
`BeforeFeature` and `AfterFeature` hooks are now removed since the deprecation in [v0.9.0](./v0.9.0.md).


Deprecation Notices
-------------------

### Run and RunWithOptions
`Run` and `RunWithOptions` are now considered deprecated and will be removed in `v0.11.0`.

`godog.Run(suiteName string, initializer func(*Suite))` will be replaced by:
```go
godog.TestSuite{
	Name: suiteName,
	TestSuiteInitializer: InitializeTestSuite,
	ScenarioInitializer: InitializeScenario,
}.Run()
```

`godog.RunWithOptions(suiteName string, initializer func(*Suite), opts Options)` will be replaced by:
```go
godog.TestSuite{
	Name: suiteName,
	TestSuiteInitializer: InitializeTestSuite,
	ScenarioInitializer: InitializeScenario,
	Options: &opts,
}.Run()
```

### Suite Initializers
The `Suite` is now considered deprecated and will be removed in `v0.11.0`.

Initializers that use `*godog.Suite` like this:
```go
func FeatureContext(s *godog.Suite) {
	s.BeforeSuite(func() { Godogs = 0 })

	s.BeforeScenario(func(*messages.Pickle) {
		Godogs = 0 // clean the state before every scenario
	})

	s.Step(`^there are (\d+) godogs$`, thereAreGodogs)
	s.Step(`^I eat (\d+)$`, iEat)
	s.Step(`^there should be (\d+) remaining$`, thereShouldBeRemaining)
}
```

will be replaced by:
```go
func InitializeTestSuite(ctx *godog.TestSuiteContext) {
	ctx.BeforeSuite(func() { Godogs = 0 })
}

func InitializeScenario(ctx *godog.ScenarioContext) {
	ctx.BeforeScenario(func(*godog.Scenario) {
		Godogs = 0 // clean the state before every scenario
	})

	ctx.Step(`^there are (\d+) godogs$`, thereAreGodogs)
	ctx.Step(`^I eat (\d+)$`, iEat)
	ctx.Step(`^there should be (\d+) remaining$`, thereShouldBeRemaining)
}
```

### SuiteContext
The `SuiteContext` is now considered deprecated and will be removed in `v0.11.0`.

### Concurrency Formatter
The `ConcurrencyFormatter` interface is now considered deprecated and will be removed in `v0.11.0`.

Full change log
---------------

See [CHANGELOG.md](https://github.com/cucumber/godog/blob/master/CHANGELOG.md#v0100).