package tests

import (
	"testing"

	"github.com/ProtonMail/gluon/imap"
	"github.com/ProtonMail/gluon/internal/response"
	"github.com/stretchr/testify/require"
)

func TestIdNilNoData(t *testing.T) {
	runOneToOneTest(t, defaultServerOptions(t), func(c *testConnection, s *testSession) {
		wantResponse := response.ID(imap.NewIMAPIDFromVersionInfo(testServerVersionInfo))
		c.C(`A001 ID NIL`)
		c.S(wantResponse.String())
		c.OK(`A001`)
	})
}

func TestIdContextLookup(t *testing.T) {
	runOneToOneTest(t, defaultServerOptions(t), func(c *testConnection, s *testSession) {
		wantResponse := response.ID(imap.NewIMAPIDFromVersionInfo(testServerVersionInfo))
		// Store new ID
		c.C(`A001 ID ("foo" "bar")`)
		c.S(wantResponse.String())
		c.OK(`A001`)

		c.C("A003 LOGIN user pass").OK("A003")

		// NOTE: We are only recording this with APPEND since it was the easiest command to verify the data has been
		// record properly in the context, as APPEND will always require a communication with the remote connector.
		c.C("A004 APPEND INBOX (\\Seen) {26}")
		c.S("+ Ready")
		c.C("To: 00010203-0405-4607-880").OK("A004")

		s.flush("user")

		wantID := imap.NewIMAPIDFromKeyMap(map[string]string{"foo": "bar"})

		require.Equal(t, wantID, s.conns[s.userIDs["user"]].GetLastRecordedIMAPID())
	})
}
