// Code generated by ent, DO NOT EDIT.

package migrate

import (
	"entgo.io/ent/dialect/sql/schema"
	"entgo.io/ent/schema/field"
)

var (
	// DeletedSubscriptionsColumns holds the columns for the "deleted_subscriptions" table.
	DeletedSubscriptionsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeInt, Increment: true},
		{Name: "name", Type: field.TypeString, Unique: true},
		{Name: "remote_id", Type: field.TypeString, Unique: true},
	}
	// DeletedSubscriptionsTable holds the schema information for the "deleted_subscriptions" table.
	DeletedSubscriptionsTable = &schema.Table{
		Name:       "deleted_subscriptions",
		Columns:    DeletedSubscriptionsColumns,
		PrimaryKey: []*schema.Column{DeletedSubscriptionsColumns[0]},
		Indexes: []*schema.Index{
			{
				Name:    "deletedsubscription_remote_id",
				Unique:  false,
				Columns: []*schema.Column{DeletedSubscriptionsColumns[2]},
			},
			{
				Name:    "deletedsubscription_name",
				Unique:  false,
				Columns: []*schema.Column{DeletedSubscriptionsColumns[1]},
			},
		},
	}
	// MailboxesColumns holds the columns for the "mailboxes" table.
	MailboxesColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUint64, Increment: true},
		{Name: "remote_id", Type: field.TypeString, Unique: true, Nullable: true},
		{Name: "name", Type: field.TypeString, Unique: true},
		{Name: "uid_next", Type: field.TypeUint32, Default: 1},
		{Name: "uid_validity", Type: field.TypeUint32, Default: 1},
		{Name: "subscribed", Type: field.TypeBool, Default: true},
	}
	// MailboxesTable holds the schema information for the "mailboxes" table.
	MailboxesTable = &schema.Table{
		Name:       "mailboxes",
		Columns:    MailboxesColumns,
		PrimaryKey: []*schema.Column{MailboxesColumns[0]},
		Indexes: []*schema.Index{
			{
				Name:    "mailbox_id",
				Unique:  false,
				Columns: []*schema.Column{MailboxesColumns[0]},
			},
			{
				Name:    "mailbox_remote_id",
				Unique:  false,
				Columns: []*schema.Column{MailboxesColumns[1]},
			},
			{
				Name:    "mailbox_name",
				Unique:  false,
				Columns: []*schema.Column{MailboxesColumns[2]},
			},
		},
	}
	// MailboxAttrsColumns holds the columns for the "mailbox_attrs" table.
	MailboxAttrsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeInt, Increment: true},
		{Name: "value", Type: field.TypeString},
		{Name: "mailbox_attributes", Type: field.TypeUint64, Nullable: true},
	}
	// MailboxAttrsTable holds the schema information for the "mailbox_attrs" table.
	MailboxAttrsTable = &schema.Table{
		Name:       "mailbox_attrs",
		Columns:    MailboxAttrsColumns,
		PrimaryKey: []*schema.Column{MailboxAttrsColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "mailbox_attrs_mailboxes_attributes",
				Columns:    []*schema.Column{MailboxAttrsColumns[2]},
				RefColumns: []*schema.Column{MailboxesColumns[0]},
				OnDelete:   schema.Cascade,
			},
		},
	}
	// MailboxFlagsColumns holds the columns for the "mailbox_flags" table.
	MailboxFlagsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeInt, Increment: true},
		{Name: "value", Type: field.TypeString},
		{Name: "mailbox_flags", Type: field.TypeUint64, Nullable: true},
	}
	// MailboxFlagsTable holds the schema information for the "mailbox_flags" table.
	MailboxFlagsTable = &schema.Table{
		Name:       "mailbox_flags",
		Columns:    MailboxFlagsColumns,
		PrimaryKey: []*schema.Column{MailboxFlagsColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "mailbox_flags_mailboxes_flags",
				Columns:    []*schema.Column{MailboxFlagsColumns[2]},
				RefColumns: []*schema.Column{MailboxesColumns[0]},
				OnDelete:   schema.Cascade,
			},
		},
	}
	// MailboxPermFlagsColumns holds the columns for the "mailbox_perm_flags" table.
	MailboxPermFlagsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeInt, Increment: true},
		{Name: "value", Type: field.TypeString},
		{Name: "mailbox_permanent_flags", Type: field.TypeUint64, Nullable: true},
	}
	// MailboxPermFlagsTable holds the schema information for the "mailbox_perm_flags" table.
	MailboxPermFlagsTable = &schema.Table{
		Name:       "mailbox_perm_flags",
		Columns:    MailboxPermFlagsColumns,
		PrimaryKey: []*schema.Column{MailboxPermFlagsColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "mailbox_perm_flags_mailboxes_permanent_flags",
				Columns:    []*schema.Column{MailboxPermFlagsColumns[2]},
				RefColumns: []*schema.Column{MailboxesColumns[0]},
				OnDelete:   schema.Cascade,
			},
		},
	}
	// MessagesColumns holds the columns for the "messages" table.
	MessagesColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID, Unique: true},
		{Name: "remote_id", Type: field.TypeString, Unique: true, Nullable: true},
		{Name: "date", Type: field.TypeTime},
		{Name: "size", Type: field.TypeInt},
		{Name: "body", Type: field.TypeString},
		{Name: "body_structure", Type: field.TypeString},
		{Name: "envelope", Type: field.TypeString},
		{Name: "deleted", Type: field.TypeBool, Default: false},
	}
	// MessagesTable holds the schema information for the "messages" table.
	MessagesTable = &schema.Table{
		Name:       "messages",
		Columns:    MessagesColumns,
		PrimaryKey: []*schema.Column{MessagesColumns[0]},
		Indexes: []*schema.Index{
			{
				Name:    "message_id",
				Unique:  false,
				Columns: []*schema.Column{MessagesColumns[0]},
			},
			{
				Name:    "message_remote_id",
				Unique:  false,
				Columns: []*schema.Column{MessagesColumns[1]},
			},
		},
	}
	// MessageFlagsColumns holds the columns for the "message_flags" table.
	MessageFlagsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeInt, Increment: true},
		{Name: "value", Type: field.TypeString},
		{Name: "message_flags", Type: field.TypeUUID, Nullable: true},
	}
	// MessageFlagsTable holds the schema information for the "message_flags" table.
	MessageFlagsTable = &schema.Table{
		Name:       "message_flags",
		Columns:    MessageFlagsColumns,
		PrimaryKey: []*schema.Column{MessageFlagsColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "message_flags_messages_flags",
				Columns:    []*schema.Column{MessageFlagsColumns[2]},
				RefColumns: []*schema.Column{MessagesColumns[0]},
				OnDelete:   schema.Cascade,
			},
		},
	}
	// UIDsColumns holds the columns for the "ui_ds" table.
	UIDsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeInt, Increment: true},
		{Name: "uid", Type: field.TypeUint32},
		{Name: "deleted", Type: field.TypeBool, Default: false},
		{Name: "recent", Type: field.TypeBool, Default: true},
		{Name: "mailbox_ui_ds", Type: field.TypeUint64, Nullable: true},
		{Name: "uid_message", Type: field.TypeUUID, Nullable: true},
	}
	// UIDsTable holds the schema information for the "ui_ds" table.
	UIDsTable = &schema.Table{
		Name:       "ui_ds",
		Columns:    UIDsColumns,
		PrimaryKey: []*schema.Column{UIDsColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "ui_ds_mailboxes_UIDs",
				Columns:    []*schema.Column{UIDsColumns[4]},
				RefColumns: []*schema.Column{MailboxesColumns[0]},
				OnDelete:   schema.Cascade,
			},
			{
				Symbol:     "ui_ds_messages_message",
				Columns:    []*schema.Column{UIDsColumns[5]},
				RefColumns: []*schema.Column{MessagesColumns[0]},
				OnDelete:   schema.SetNull,
			},
		},
		Indexes: []*schema.Index{
			{
				Name:    "uid_uid_uid_message",
				Unique:  false,
				Columns: []*schema.Column{UIDsColumns[1], UIDsColumns[5]},
			},
		},
	}
	// Tables holds all the tables in the schema.
	Tables = []*schema.Table{
		DeletedSubscriptionsTable,
		MailboxesTable,
		MailboxAttrsTable,
		MailboxFlagsTable,
		MailboxPermFlagsTable,
		MessagesTable,
		MessageFlagsTable,
		UIDsTable,
	}
)

func init() {
	MailboxAttrsTable.ForeignKeys[0].RefTable = MailboxesTable
	MailboxFlagsTable.ForeignKeys[0].RefTable = MailboxesTable
	MailboxPermFlagsTable.ForeignKeys[0].RefTable = MailboxesTable
	MessageFlagsTable.ForeignKeys[0].RefTable = MessagesTable
	UIDsTable.ForeignKeys[0].RefTable = MailboxesTable
	UIDsTable.ForeignKeys[1].RefTable = MessagesTable
}
