// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/ProtonMail/gluon/imap"
	"github.com/ProtonMail/gluon/internal/db/ent/message"
	"github.com/ProtonMail/gluon/internal/db/ent/messageflag"
)

// MessageFlagCreate is the builder for creating a MessageFlag entity.
type MessageFlagCreate struct {
	config
	mutation *MessageFlagMutation
	hooks    []Hook
}

// SetValue sets the "Value" field.
func (mfc *MessageFlagCreate) SetValue(s string) *MessageFlagCreate {
	mfc.mutation.SetValue(s)
	return mfc
}

// SetMessagesID sets the "messages" edge to the Message entity by ID.
func (mfc *MessageFlagCreate) SetMessagesID(id imap.InternalMessageID) *MessageFlagCreate {
	mfc.mutation.SetMessagesID(id)
	return mfc
}

// SetNillableMessagesID sets the "messages" edge to the Message entity by ID if the given value is not nil.
func (mfc *MessageFlagCreate) SetNillableMessagesID(id *imap.InternalMessageID) *MessageFlagCreate {
	if id != nil {
		mfc = mfc.SetMessagesID(*id)
	}
	return mfc
}

// SetMessages sets the "messages" edge to the Message entity.
func (mfc *MessageFlagCreate) SetMessages(m *Message) *MessageFlagCreate {
	return mfc.SetMessagesID(m.ID)
}

// Mutation returns the MessageFlagMutation object of the builder.
func (mfc *MessageFlagCreate) Mutation() *MessageFlagMutation {
	return mfc.mutation
}

// Save creates the MessageFlag in the database.
func (mfc *MessageFlagCreate) Save(ctx context.Context) (*MessageFlag, error) {
	var (
		err  error
		node *MessageFlag
	)
	if len(mfc.hooks) == 0 {
		if err = mfc.check(); err != nil {
			return nil, err
		}
		node, err = mfc.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*MessageFlagMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			if err = mfc.check(); err != nil {
				return nil, err
			}
			mfc.mutation = mutation
			if node, err = mfc.sqlSave(ctx); err != nil {
				return nil, err
			}
			mutation.id = &node.ID
			mutation.done = true
			return node, err
		})
		for i := len(mfc.hooks) - 1; i >= 0; i-- {
			if mfc.hooks[i] == nil {
				return nil, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = mfc.hooks[i](mut)
		}
		v, err := mut.Mutate(ctx, mfc.mutation)
		if err != nil {
			return nil, err
		}
		nv, ok := v.(*MessageFlag)
		if !ok {
			return nil, fmt.Errorf("unexpected node type %T returned from MessageFlagMutation", v)
		}
		node = nv
	}
	return node, err
}

// SaveX calls Save and panics if Save returns an error.
func (mfc *MessageFlagCreate) SaveX(ctx context.Context) *MessageFlag {
	v, err := mfc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (mfc *MessageFlagCreate) Exec(ctx context.Context) error {
	_, err := mfc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (mfc *MessageFlagCreate) ExecX(ctx context.Context) {
	if err := mfc.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (mfc *MessageFlagCreate) check() error {
	if _, ok := mfc.mutation.Value(); !ok {
		return &ValidationError{Name: "Value", err: errors.New(`ent: missing required field "MessageFlag.Value"`)}
	}
	return nil
}

func (mfc *MessageFlagCreate) sqlSave(ctx context.Context) (*MessageFlag, error) {
	_node, _spec := mfc.createSpec()
	if err := sqlgraph.CreateNode(ctx, mfc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	id := _spec.ID.Value.(int64)
	_node.ID = int(id)
	return _node, nil
}

func (mfc *MessageFlagCreate) createSpec() (*MessageFlag, *sqlgraph.CreateSpec) {
	var (
		_node = &MessageFlag{config: mfc.config}
		_spec = &sqlgraph.CreateSpec{
			Table: messageflag.Table,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: messageflag.FieldID,
			},
		}
	)
	if value, ok := mfc.mutation.Value(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: messageflag.FieldValue,
		})
		_node.Value = value
	}
	if nodes := mfc.mutation.MessagesIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   messageflag.MessagesTable,
			Columns: []string{messageflag.MessagesColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeUUID,
					Column: message.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.message_flags = &nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// MessageFlagCreateBulk is the builder for creating many MessageFlag entities in bulk.
type MessageFlagCreateBulk struct {
	config
	builders []*MessageFlagCreate
}

// Save creates the MessageFlag entities in the database.
func (mfcb *MessageFlagCreateBulk) Save(ctx context.Context) ([]*MessageFlag, error) {
	specs := make([]*sqlgraph.CreateSpec, len(mfcb.builders))
	nodes := make([]*MessageFlag, len(mfcb.builders))
	mutators := make([]Mutator, len(mfcb.builders))
	for i := range mfcb.builders {
		func(i int, root context.Context) {
			builder := mfcb.builders[i]
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*MessageFlagMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				nodes[i], specs[i] = builder.createSpec()
				var err error
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, mfcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, mfcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				if specs[i].ID.Value != nil {
					id := specs[i].ID.Value.(int64)
					nodes[i].ID = int(id)
				}
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, mfcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (mfcb *MessageFlagCreateBulk) SaveX(ctx context.Context) []*MessageFlag {
	v, err := mfcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (mfcb *MessageFlagCreateBulk) Exec(ctx context.Context) error {
	_, err := mfcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (mfcb *MessageFlagCreateBulk) ExecX(ctx context.Context) {
	if err := mfcb.Exec(ctx); err != nil {
		panic(err)
	}
}
