// Code generated by ent, DO NOT EDIT.

package ent

import (
	"fmt"
	"strings"

	"entgo.io/ent/dialect/sql"
	"github.com/ProtonMail/gluon/imap"
	"github.com/ProtonMail/gluon/internal/db/ent/message"
	"github.com/ProtonMail/gluon/internal/db/ent/messageflag"
)

// MessageFlag is the model entity for the MessageFlag schema.
type MessageFlag struct {
	config `json:"-"`
	// ID of the ent.
	ID int `json:"id,omitempty"`
	// Value holds the value of the "Value" field.
	Value string `json:"Value,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the MessageFlagQuery when eager-loading is set.
	Edges         MessageFlagEdges `json:"edges"`
	message_flags *imap.InternalMessageID
}

// MessageFlagEdges holds the relations/edges for other nodes in the graph.
type MessageFlagEdges struct {
	// Messages holds the value of the messages edge.
	Messages *Message `json:"messages,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [1]bool
}

// MessagesOrErr returns the Messages value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e MessageFlagEdges) MessagesOrErr() (*Message, error) {
	if e.loadedTypes[0] {
		if e.Messages == nil {
			// Edge was loaded but was not found.
			return nil, &NotFoundError{label: message.Label}
		}
		return e.Messages, nil
	}
	return nil, &NotLoadedError{edge: "messages"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*MessageFlag) scanValues(columns []string) ([]interface{}, error) {
	values := make([]interface{}, len(columns))
	for i := range columns {
		switch columns[i] {
		case messageflag.FieldID:
			values[i] = new(sql.NullInt64)
		case messageflag.FieldValue:
			values[i] = new(sql.NullString)
		case messageflag.ForeignKeys[0]: // message_flags
			values[i] = &sql.NullScanner{S: new(imap.InternalMessageID)}
		default:
			return nil, fmt.Errorf("unexpected column %q for type MessageFlag", columns[i])
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the MessageFlag fields.
func (mf *MessageFlag) assignValues(columns []string, values []interface{}) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case messageflag.FieldID:
			value, ok := values[i].(*sql.NullInt64)
			if !ok {
				return fmt.Errorf("unexpected type %T for field id", value)
			}
			mf.ID = int(value.Int64)
		case messageflag.FieldValue:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field Value", values[i])
			} else if value.Valid {
				mf.Value = value.String
			}
		case messageflag.ForeignKeys[0]:
			if value, ok := values[i].(*sql.NullScanner); !ok {
				return fmt.Errorf("unexpected type %T for field message_flags", values[i])
			} else if value.Valid {
				mf.message_flags = new(imap.InternalMessageID)
				*mf.message_flags = *value.S.(*imap.InternalMessageID)
			}
		}
	}
	return nil
}

// QueryMessages queries the "messages" edge of the MessageFlag entity.
func (mf *MessageFlag) QueryMessages() *MessageQuery {
	return (&MessageFlagClient{config: mf.config}).QueryMessages(mf)
}

// Update returns a builder for updating this MessageFlag.
// Note that you need to call MessageFlag.Unwrap() before calling this method if this MessageFlag
// was returned from a transaction, and the transaction was committed or rolled back.
func (mf *MessageFlag) Update() *MessageFlagUpdateOne {
	return (&MessageFlagClient{config: mf.config}).UpdateOne(mf)
}

// Unwrap unwraps the MessageFlag entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (mf *MessageFlag) Unwrap() *MessageFlag {
	_tx, ok := mf.config.driver.(*txDriver)
	if !ok {
		panic("ent: MessageFlag is not a transactional entity")
	}
	mf.config.driver = _tx.drv
	return mf
}

// String implements the fmt.Stringer.
func (mf *MessageFlag) String() string {
	var builder strings.Builder
	builder.WriteString("MessageFlag(")
	builder.WriteString(fmt.Sprintf("id=%v, ", mf.ID))
	builder.WriteString("Value=")
	builder.WriteString(mf.Value)
	builder.WriteByte(')')
	return builder.String()
}

// MessageFlags is a parsable slice of MessageFlag.
type MessageFlags []*MessageFlag

func (mf MessageFlags) config(cfg config) {
	for _i := range mf {
		mf[_i].config = cfg
	}
}
