// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/ProtonMail/gluon/imap"
	"github.com/ProtonMail/gluon/internal/db/ent/message"
	"github.com/ProtonMail/gluon/internal/db/ent/messageflag"
	"github.com/ProtonMail/gluon/internal/db/ent/predicate"
	"github.com/ProtonMail/gluon/internal/db/ent/uid"
)

// MessageUpdate is the builder for updating Message entities.
type MessageUpdate struct {
	config
	hooks    []Hook
	mutation *MessageMutation
}

// Where appends a list predicates to the MessageUpdate builder.
func (mu *MessageUpdate) Where(ps ...predicate.Message) *MessageUpdate {
	mu.mutation.Where(ps...)
	return mu
}

// SetRemoteID sets the "RemoteID" field.
func (mu *MessageUpdate) SetRemoteID(ii imap.MessageID) *MessageUpdate {
	mu.mutation.SetRemoteID(ii)
	return mu
}

// SetNillableRemoteID sets the "RemoteID" field if the given value is not nil.
func (mu *MessageUpdate) SetNillableRemoteID(ii *imap.MessageID) *MessageUpdate {
	if ii != nil {
		mu.SetRemoteID(*ii)
	}
	return mu
}

// ClearRemoteID clears the value of the "RemoteID" field.
func (mu *MessageUpdate) ClearRemoteID() *MessageUpdate {
	mu.mutation.ClearRemoteID()
	return mu
}

// SetDate sets the "Date" field.
func (mu *MessageUpdate) SetDate(t time.Time) *MessageUpdate {
	mu.mutation.SetDate(t)
	return mu
}

// SetSize sets the "Size" field.
func (mu *MessageUpdate) SetSize(i int) *MessageUpdate {
	mu.mutation.ResetSize()
	mu.mutation.SetSize(i)
	return mu
}

// AddSize adds i to the "Size" field.
func (mu *MessageUpdate) AddSize(i int) *MessageUpdate {
	mu.mutation.AddSize(i)
	return mu
}

// SetBody sets the "Body" field.
func (mu *MessageUpdate) SetBody(s string) *MessageUpdate {
	mu.mutation.SetBody(s)
	return mu
}

// SetBodyStructure sets the "BodyStructure" field.
func (mu *MessageUpdate) SetBodyStructure(s string) *MessageUpdate {
	mu.mutation.SetBodyStructure(s)
	return mu
}

// SetEnvelope sets the "Envelope" field.
func (mu *MessageUpdate) SetEnvelope(s string) *MessageUpdate {
	mu.mutation.SetEnvelope(s)
	return mu
}

// SetDeleted sets the "Deleted" field.
func (mu *MessageUpdate) SetDeleted(b bool) *MessageUpdate {
	mu.mutation.SetDeleted(b)
	return mu
}

// SetNillableDeleted sets the "Deleted" field if the given value is not nil.
func (mu *MessageUpdate) SetNillableDeleted(b *bool) *MessageUpdate {
	if b != nil {
		mu.SetDeleted(*b)
	}
	return mu
}

// AddFlagIDs adds the "flags" edge to the MessageFlag entity by IDs.
func (mu *MessageUpdate) AddFlagIDs(ids ...int) *MessageUpdate {
	mu.mutation.AddFlagIDs(ids...)
	return mu
}

// AddFlags adds the "flags" edges to the MessageFlag entity.
func (mu *MessageUpdate) AddFlags(m ...*MessageFlag) *MessageUpdate {
	ids := make([]int, len(m))
	for i := range m {
		ids[i] = m[i].ID
	}
	return mu.AddFlagIDs(ids...)
}

// AddUIDIDs adds the "UIDs" edge to the UID entity by IDs.
func (mu *MessageUpdate) AddUIDIDs(ids ...int) *MessageUpdate {
	mu.mutation.AddUIDIDs(ids...)
	return mu
}

// AddUIDs adds the "UIDs" edges to the UID entity.
func (mu *MessageUpdate) AddUIDs(u ...*UID) *MessageUpdate {
	ids := make([]int, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return mu.AddUIDIDs(ids...)
}

// Mutation returns the MessageMutation object of the builder.
func (mu *MessageUpdate) Mutation() *MessageMutation {
	return mu.mutation
}

// ClearFlags clears all "flags" edges to the MessageFlag entity.
func (mu *MessageUpdate) ClearFlags() *MessageUpdate {
	mu.mutation.ClearFlags()
	return mu
}

// RemoveFlagIDs removes the "flags" edge to MessageFlag entities by IDs.
func (mu *MessageUpdate) RemoveFlagIDs(ids ...int) *MessageUpdate {
	mu.mutation.RemoveFlagIDs(ids...)
	return mu
}

// RemoveFlags removes "flags" edges to MessageFlag entities.
func (mu *MessageUpdate) RemoveFlags(m ...*MessageFlag) *MessageUpdate {
	ids := make([]int, len(m))
	for i := range m {
		ids[i] = m[i].ID
	}
	return mu.RemoveFlagIDs(ids...)
}

// ClearUIDs clears all "UIDs" edges to the UID entity.
func (mu *MessageUpdate) ClearUIDs() *MessageUpdate {
	mu.mutation.ClearUIDs()
	return mu
}

// RemoveUIDIDs removes the "UIDs" edge to UID entities by IDs.
func (mu *MessageUpdate) RemoveUIDIDs(ids ...int) *MessageUpdate {
	mu.mutation.RemoveUIDIDs(ids...)
	return mu
}

// RemoveUIDs removes "UIDs" edges to UID entities.
func (mu *MessageUpdate) RemoveUIDs(u ...*UID) *MessageUpdate {
	ids := make([]int, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return mu.RemoveUIDIDs(ids...)
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (mu *MessageUpdate) Save(ctx context.Context) (int, error) {
	var (
		err      error
		affected int
	)
	if len(mu.hooks) == 0 {
		affected, err = mu.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*MessageMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			mu.mutation = mutation
			affected, err = mu.sqlSave(ctx)
			mutation.done = true
			return affected, err
		})
		for i := len(mu.hooks) - 1; i >= 0; i-- {
			if mu.hooks[i] == nil {
				return 0, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = mu.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, mu.mutation); err != nil {
			return 0, err
		}
	}
	return affected, err
}

// SaveX is like Save, but panics if an error occurs.
func (mu *MessageUpdate) SaveX(ctx context.Context) int {
	affected, err := mu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (mu *MessageUpdate) Exec(ctx context.Context) error {
	_, err := mu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (mu *MessageUpdate) ExecX(ctx context.Context) {
	if err := mu.Exec(ctx); err != nil {
		panic(err)
	}
}

func (mu *MessageUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := &sqlgraph.UpdateSpec{
		Node: &sqlgraph.NodeSpec{
			Table:   message.Table,
			Columns: message.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeUUID,
				Column: message.FieldID,
			},
		},
	}
	if ps := mu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := mu.mutation.RemoteID(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: message.FieldRemoteID,
		})
	}
	if mu.mutation.RemoteIDCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: message.FieldRemoteID,
		})
	}
	if value, ok := mu.mutation.Date(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: message.FieldDate,
		})
	}
	if value, ok := mu.mutation.Size(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeInt,
			Value:  value,
			Column: message.FieldSize,
		})
	}
	if value, ok := mu.mutation.AddedSize(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeInt,
			Value:  value,
			Column: message.FieldSize,
		})
	}
	if value, ok := mu.mutation.Body(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: message.FieldBody,
		})
	}
	if value, ok := mu.mutation.BodyStructure(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: message.FieldBodyStructure,
		})
	}
	if value, ok := mu.mutation.Envelope(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: message.FieldEnvelope,
		})
	}
	if value, ok := mu.mutation.Deleted(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeBool,
			Value:  value,
			Column: message.FieldDeleted,
		})
	}
	if mu.mutation.FlagsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   message.FlagsTable,
			Columns: []string{message.FlagsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: messageflag.FieldID,
				},
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := mu.mutation.RemovedFlagsIDs(); len(nodes) > 0 && !mu.mutation.FlagsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   message.FlagsTable,
			Columns: []string{message.FlagsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: messageflag.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := mu.mutation.FlagsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   message.FlagsTable,
			Columns: []string{message.FlagsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: messageflag.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if mu.mutation.UIDsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   message.UIDsTable,
			Columns: []string{message.UIDsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: uid.FieldID,
				},
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := mu.mutation.RemovedUIDsIDs(); len(nodes) > 0 && !mu.mutation.UIDsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   message.UIDsTable,
			Columns: []string{message.UIDsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: uid.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := mu.mutation.UIDsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   message.UIDsTable,
			Columns: []string{message.UIDsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: uid.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if n, err = sqlgraph.UpdateNodes(ctx, mu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{message.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	return n, nil
}

// MessageUpdateOne is the builder for updating a single Message entity.
type MessageUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *MessageMutation
}

// SetRemoteID sets the "RemoteID" field.
func (muo *MessageUpdateOne) SetRemoteID(ii imap.MessageID) *MessageUpdateOne {
	muo.mutation.SetRemoteID(ii)
	return muo
}

// SetNillableRemoteID sets the "RemoteID" field if the given value is not nil.
func (muo *MessageUpdateOne) SetNillableRemoteID(ii *imap.MessageID) *MessageUpdateOne {
	if ii != nil {
		muo.SetRemoteID(*ii)
	}
	return muo
}

// ClearRemoteID clears the value of the "RemoteID" field.
func (muo *MessageUpdateOne) ClearRemoteID() *MessageUpdateOne {
	muo.mutation.ClearRemoteID()
	return muo
}

// SetDate sets the "Date" field.
func (muo *MessageUpdateOne) SetDate(t time.Time) *MessageUpdateOne {
	muo.mutation.SetDate(t)
	return muo
}

// SetSize sets the "Size" field.
func (muo *MessageUpdateOne) SetSize(i int) *MessageUpdateOne {
	muo.mutation.ResetSize()
	muo.mutation.SetSize(i)
	return muo
}

// AddSize adds i to the "Size" field.
func (muo *MessageUpdateOne) AddSize(i int) *MessageUpdateOne {
	muo.mutation.AddSize(i)
	return muo
}

// SetBody sets the "Body" field.
func (muo *MessageUpdateOne) SetBody(s string) *MessageUpdateOne {
	muo.mutation.SetBody(s)
	return muo
}

// SetBodyStructure sets the "BodyStructure" field.
func (muo *MessageUpdateOne) SetBodyStructure(s string) *MessageUpdateOne {
	muo.mutation.SetBodyStructure(s)
	return muo
}

// SetEnvelope sets the "Envelope" field.
func (muo *MessageUpdateOne) SetEnvelope(s string) *MessageUpdateOne {
	muo.mutation.SetEnvelope(s)
	return muo
}

// SetDeleted sets the "Deleted" field.
func (muo *MessageUpdateOne) SetDeleted(b bool) *MessageUpdateOne {
	muo.mutation.SetDeleted(b)
	return muo
}

// SetNillableDeleted sets the "Deleted" field if the given value is not nil.
func (muo *MessageUpdateOne) SetNillableDeleted(b *bool) *MessageUpdateOne {
	if b != nil {
		muo.SetDeleted(*b)
	}
	return muo
}

// AddFlagIDs adds the "flags" edge to the MessageFlag entity by IDs.
func (muo *MessageUpdateOne) AddFlagIDs(ids ...int) *MessageUpdateOne {
	muo.mutation.AddFlagIDs(ids...)
	return muo
}

// AddFlags adds the "flags" edges to the MessageFlag entity.
func (muo *MessageUpdateOne) AddFlags(m ...*MessageFlag) *MessageUpdateOne {
	ids := make([]int, len(m))
	for i := range m {
		ids[i] = m[i].ID
	}
	return muo.AddFlagIDs(ids...)
}

// AddUIDIDs adds the "UIDs" edge to the UID entity by IDs.
func (muo *MessageUpdateOne) AddUIDIDs(ids ...int) *MessageUpdateOne {
	muo.mutation.AddUIDIDs(ids...)
	return muo
}

// AddUIDs adds the "UIDs" edges to the UID entity.
func (muo *MessageUpdateOne) AddUIDs(u ...*UID) *MessageUpdateOne {
	ids := make([]int, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return muo.AddUIDIDs(ids...)
}

// Mutation returns the MessageMutation object of the builder.
func (muo *MessageUpdateOne) Mutation() *MessageMutation {
	return muo.mutation
}

// ClearFlags clears all "flags" edges to the MessageFlag entity.
func (muo *MessageUpdateOne) ClearFlags() *MessageUpdateOne {
	muo.mutation.ClearFlags()
	return muo
}

// RemoveFlagIDs removes the "flags" edge to MessageFlag entities by IDs.
func (muo *MessageUpdateOne) RemoveFlagIDs(ids ...int) *MessageUpdateOne {
	muo.mutation.RemoveFlagIDs(ids...)
	return muo
}

// RemoveFlags removes "flags" edges to MessageFlag entities.
func (muo *MessageUpdateOne) RemoveFlags(m ...*MessageFlag) *MessageUpdateOne {
	ids := make([]int, len(m))
	for i := range m {
		ids[i] = m[i].ID
	}
	return muo.RemoveFlagIDs(ids...)
}

// ClearUIDs clears all "UIDs" edges to the UID entity.
func (muo *MessageUpdateOne) ClearUIDs() *MessageUpdateOne {
	muo.mutation.ClearUIDs()
	return muo
}

// RemoveUIDIDs removes the "UIDs" edge to UID entities by IDs.
func (muo *MessageUpdateOne) RemoveUIDIDs(ids ...int) *MessageUpdateOne {
	muo.mutation.RemoveUIDIDs(ids...)
	return muo
}

// RemoveUIDs removes "UIDs" edges to UID entities.
func (muo *MessageUpdateOne) RemoveUIDs(u ...*UID) *MessageUpdateOne {
	ids := make([]int, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return muo.RemoveUIDIDs(ids...)
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (muo *MessageUpdateOne) Select(field string, fields ...string) *MessageUpdateOne {
	muo.fields = append([]string{field}, fields...)
	return muo
}

// Save executes the query and returns the updated Message entity.
func (muo *MessageUpdateOne) Save(ctx context.Context) (*Message, error) {
	var (
		err  error
		node *Message
	)
	if len(muo.hooks) == 0 {
		node, err = muo.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*MessageMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			muo.mutation = mutation
			node, err = muo.sqlSave(ctx)
			mutation.done = true
			return node, err
		})
		for i := len(muo.hooks) - 1; i >= 0; i-- {
			if muo.hooks[i] == nil {
				return nil, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = muo.hooks[i](mut)
		}
		v, err := mut.Mutate(ctx, muo.mutation)
		if err != nil {
			return nil, err
		}
		nv, ok := v.(*Message)
		if !ok {
			return nil, fmt.Errorf("unexpected node type %T returned from MessageMutation", v)
		}
		node = nv
	}
	return node, err
}

// SaveX is like Save, but panics if an error occurs.
func (muo *MessageUpdateOne) SaveX(ctx context.Context) *Message {
	node, err := muo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (muo *MessageUpdateOne) Exec(ctx context.Context) error {
	_, err := muo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (muo *MessageUpdateOne) ExecX(ctx context.Context) {
	if err := muo.Exec(ctx); err != nil {
		panic(err)
	}
}

func (muo *MessageUpdateOne) sqlSave(ctx context.Context) (_node *Message, err error) {
	_spec := &sqlgraph.UpdateSpec{
		Node: &sqlgraph.NodeSpec{
			Table:   message.Table,
			Columns: message.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeUUID,
				Column: message.FieldID,
			},
		},
	}
	id, ok := muo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`ent: missing "Message.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := muo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, message.FieldID)
		for _, f := range fields {
			if !message.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			if f != message.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := muo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := muo.mutation.RemoteID(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: message.FieldRemoteID,
		})
	}
	if muo.mutation.RemoteIDCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: message.FieldRemoteID,
		})
	}
	if value, ok := muo.mutation.Date(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: message.FieldDate,
		})
	}
	if value, ok := muo.mutation.Size(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeInt,
			Value:  value,
			Column: message.FieldSize,
		})
	}
	if value, ok := muo.mutation.AddedSize(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeInt,
			Value:  value,
			Column: message.FieldSize,
		})
	}
	if value, ok := muo.mutation.Body(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: message.FieldBody,
		})
	}
	if value, ok := muo.mutation.BodyStructure(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: message.FieldBodyStructure,
		})
	}
	if value, ok := muo.mutation.Envelope(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: message.FieldEnvelope,
		})
	}
	if value, ok := muo.mutation.Deleted(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeBool,
			Value:  value,
			Column: message.FieldDeleted,
		})
	}
	if muo.mutation.FlagsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   message.FlagsTable,
			Columns: []string{message.FlagsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: messageflag.FieldID,
				},
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := muo.mutation.RemovedFlagsIDs(); len(nodes) > 0 && !muo.mutation.FlagsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   message.FlagsTable,
			Columns: []string{message.FlagsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: messageflag.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := muo.mutation.FlagsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   message.FlagsTable,
			Columns: []string{message.FlagsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: messageflag.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if muo.mutation.UIDsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   message.UIDsTable,
			Columns: []string{message.UIDsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: uid.FieldID,
				},
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := muo.mutation.RemovedUIDsIDs(); len(nodes) > 0 && !muo.mutation.UIDsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   message.UIDsTable,
			Columns: []string{message.UIDsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: uid.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := muo.mutation.UIDsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   message.UIDsTable,
			Columns: []string{message.UIDsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: uid.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_node = &Message{config: muo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, muo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{message.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	return _node, nil
}
