// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"fmt"
	"math"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/ProtonMail/gluon/internal/db/ent/mailboxpermflag"
	"github.com/ProtonMail/gluon/internal/db/ent/predicate"
)

// MailboxPermFlagQuery is the builder for querying MailboxPermFlag entities.
type MailboxPermFlagQuery struct {
	config
	limit      *int
	offset     *int
	unique     *bool
	order      []OrderFunc
	fields     []string
	predicates []predicate.MailboxPermFlag
	withFKs    bool
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Where adds a new predicate for the MailboxPermFlagQuery builder.
func (mpfq *MailboxPermFlagQuery) Where(ps ...predicate.MailboxPermFlag) *MailboxPermFlagQuery {
	mpfq.predicates = append(mpfq.predicates, ps...)
	return mpfq
}

// Limit adds a limit step to the query.
func (mpfq *MailboxPermFlagQuery) Limit(limit int) *MailboxPermFlagQuery {
	mpfq.limit = &limit
	return mpfq
}

// Offset adds an offset step to the query.
func (mpfq *MailboxPermFlagQuery) Offset(offset int) *MailboxPermFlagQuery {
	mpfq.offset = &offset
	return mpfq
}

// Unique configures the query builder to filter duplicate records on query.
// By default, unique is set to true, and can be disabled using this method.
func (mpfq *MailboxPermFlagQuery) Unique(unique bool) *MailboxPermFlagQuery {
	mpfq.unique = &unique
	return mpfq
}

// Order adds an order step to the query.
func (mpfq *MailboxPermFlagQuery) Order(o ...OrderFunc) *MailboxPermFlagQuery {
	mpfq.order = append(mpfq.order, o...)
	return mpfq
}

// First returns the first MailboxPermFlag entity from the query.
// Returns a *NotFoundError when no MailboxPermFlag was found.
func (mpfq *MailboxPermFlagQuery) First(ctx context.Context) (*MailboxPermFlag, error) {
	nodes, err := mpfq.Limit(1).All(ctx)
	if err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nil, &NotFoundError{mailboxpermflag.Label}
	}
	return nodes[0], nil
}

// FirstX is like First, but panics if an error occurs.
func (mpfq *MailboxPermFlagQuery) FirstX(ctx context.Context) *MailboxPermFlag {
	node, err := mpfq.First(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return node
}

// FirstID returns the first MailboxPermFlag ID from the query.
// Returns a *NotFoundError when no MailboxPermFlag ID was found.
func (mpfq *MailboxPermFlagQuery) FirstID(ctx context.Context) (id int, err error) {
	var ids []int
	if ids, err = mpfq.Limit(1).IDs(ctx); err != nil {
		return
	}
	if len(ids) == 0 {
		err = &NotFoundError{mailboxpermflag.Label}
		return
	}
	return ids[0], nil
}

// FirstIDX is like FirstID, but panics if an error occurs.
func (mpfq *MailboxPermFlagQuery) FirstIDX(ctx context.Context) int {
	id, err := mpfq.FirstID(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return id
}

// Only returns a single MailboxPermFlag entity found by the query, ensuring it only returns one.
// Returns a *NotSingularError when more than one MailboxPermFlag entity is found.
// Returns a *NotFoundError when no MailboxPermFlag entities are found.
func (mpfq *MailboxPermFlagQuery) Only(ctx context.Context) (*MailboxPermFlag, error) {
	nodes, err := mpfq.Limit(2).All(ctx)
	if err != nil {
		return nil, err
	}
	switch len(nodes) {
	case 1:
		return nodes[0], nil
	case 0:
		return nil, &NotFoundError{mailboxpermflag.Label}
	default:
		return nil, &NotSingularError{mailboxpermflag.Label}
	}
}

// OnlyX is like Only, but panics if an error occurs.
func (mpfq *MailboxPermFlagQuery) OnlyX(ctx context.Context) *MailboxPermFlag {
	node, err := mpfq.Only(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// OnlyID is like Only, but returns the only MailboxPermFlag ID in the query.
// Returns a *NotSingularError when more than one MailboxPermFlag ID is found.
// Returns a *NotFoundError when no entities are found.
func (mpfq *MailboxPermFlagQuery) OnlyID(ctx context.Context) (id int, err error) {
	var ids []int
	if ids, err = mpfq.Limit(2).IDs(ctx); err != nil {
		return
	}
	switch len(ids) {
	case 1:
		id = ids[0]
	case 0:
		err = &NotFoundError{mailboxpermflag.Label}
	default:
		err = &NotSingularError{mailboxpermflag.Label}
	}
	return
}

// OnlyIDX is like OnlyID, but panics if an error occurs.
func (mpfq *MailboxPermFlagQuery) OnlyIDX(ctx context.Context) int {
	id, err := mpfq.OnlyID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// All executes the query and returns a list of MailboxPermFlags.
func (mpfq *MailboxPermFlagQuery) All(ctx context.Context) ([]*MailboxPermFlag, error) {
	if err := mpfq.prepareQuery(ctx); err != nil {
		return nil, err
	}
	return mpfq.sqlAll(ctx)
}

// AllX is like All, but panics if an error occurs.
func (mpfq *MailboxPermFlagQuery) AllX(ctx context.Context) []*MailboxPermFlag {
	nodes, err := mpfq.All(ctx)
	if err != nil {
		panic(err)
	}
	return nodes
}

// IDs executes the query and returns a list of MailboxPermFlag IDs.
func (mpfq *MailboxPermFlagQuery) IDs(ctx context.Context) ([]int, error) {
	var ids []int
	if err := mpfq.Select(mailboxpermflag.FieldID).Scan(ctx, &ids); err != nil {
		return nil, err
	}
	return ids, nil
}

// IDsX is like IDs, but panics if an error occurs.
func (mpfq *MailboxPermFlagQuery) IDsX(ctx context.Context) []int {
	ids, err := mpfq.IDs(ctx)
	if err != nil {
		panic(err)
	}
	return ids
}

// Count returns the count of the given query.
func (mpfq *MailboxPermFlagQuery) Count(ctx context.Context) (int, error) {
	if err := mpfq.prepareQuery(ctx); err != nil {
		return 0, err
	}
	return mpfq.sqlCount(ctx)
}

// CountX is like Count, but panics if an error occurs.
func (mpfq *MailboxPermFlagQuery) CountX(ctx context.Context) int {
	count, err := mpfq.Count(ctx)
	if err != nil {
		panic(err)
	}
	return count
}

// Exist returns true if the query has elements in the graph.
func (mpfq *MailboxPermFlagQuery) Exist(ctx context.Context) (bool, error) {
	if err := mpfq.prepareQuery(ctx); err != nil {
		return false, err
	}
	return mpfq.sqlExist(ctx)
}

// ExistX is like Exist, but panics if an error occurs.
func (mpfq *MailboxPermFlagQuery) ExistX(ctx context.Context) bool {
	exist, err := mpfq.Exist(ctx)
	if err != nil {
		panic(err)
	}
	return exist
}

// Clone returns a duplicate of the MailboxPermFlagQuery builder, including all associated steps. It can be
// used to prepare common query builders and use them differently after the clone is made.
func (mpfq *MailboxPermFlagQuery) Clone() *MailboxPermFlagQuery {
	if mpfq == nil {
		return nil
	}
	return &MailboxPermFlagQuery{
		config:     mpfq.config,
		limit:      mpfq.limit,
		offset:     mpfq.offset,
		order:      append([]OrderFunc{}, mpfq.order...),
		predicates: append([]predicate.MailboxPermFlag{}, mpfq.predicates...),
		// clone intermediate query.
		sql:    mpfq.sql.Clone(),
		path:   mpfq.path,
		unique: mpfq.unique,
	}
}

// GroupBy is used to group vertices by one or more fields/columns.
// It is often used with aggregate functions, like: count, max, mean, min, sum.
//
// Example:
//
//	var v []struct {
//		Value string `json:"Value,omitempty"`
//		Count int `json:"count,omitempty"`
//	}
//
//	client.MailboxPermFlag.Query().
//		GroupBy(mailboxpermflag.FieldValue).
//		Aggregate(ent.Count()).
//		Scan(ctx, &v)
func (mpfq *MailboxPermFlagQuery) GroupBy(field string, fields ...string) *MailboxPermFlagGroupBy {
	grbuild := &MailboxPermFlagGroupBy{config: mpfq.config}
	grbuild.fields = append([]string{field}, fields...)
	grbuild.path = func(ctx context.Context) (prev *sql.Selector, err error) {
		if err := mpfq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		return mpfq.sqlQuery(ctx), nil
	}
	grbuild.label = mailboxpermflag.Label
	grbuild.flds, grbuild.scan = &grbuild.fields, grbuild.Scan
	return grbuild
}

// Select allows the selection one or more fields/columns for the given query,
// instead of selecting all fields in the entity.
//
// Example:
//
//	var v []struct {
//		Value string `json:"Value,omitempty"`
//	}
//
//	client.MailboxPermFlag.Query().
//		Select(mailboxpermflag.FieldValue).
//		Scan(ctx, &v)
func (mpfq *MailboxPermFlagQuery) Select(fields ...string) *MailboxPermFlagSelect {
	mpfq.fields = append(mpfq.fields, fields...)
	selbuild := &MailboxPermFlagSelect{MailboxPermFlagQuery: mpfq}
	selbuild.label = mailboxpermflag.Label
	selbuild.flds, selbuild.scan = &mpfq.fields, selbuild.Scan
	return selbuild
}

func (mpfq *MailboxPermFlagQuery) prepareQuery(ctx context.Context) error {
	for _, f := range mpfq.fields {
		if !mailboxpermflag.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
		}
	}
	if mpfq.path != nil {
		prev, err := mpfq.path(ctx)
		if err != nil {
			return err
		}
		mpfq.sql = prev
	}
	return nil
}

func (mpfq *MailboxPermFlagQuery) sqlAll(ctx context.Context, hooks ...queryHook) ([]*MailboxPermFlag, error) {
	var (
		nodes   = []*MailboxPermFlag{}
		withFKs = mpfq.withFKs
		_spec   = mpfq.querySpec()
	)
	if withFKs {
		_spec.Node.Columns = append(_spec.Node.Columns, mailboxpermflag.ForeignKeys...)
	}
	_spec.ScanValues = func(columns []string) ([]interface{}, error) {
		return (*MailboxPermFlag).scanValues(nil, columns)
	}
	_spec.Assign = func(columns []string, values []interface{}) error {
		node := &MailboxPermFlag{config: mpfq.config}
		nodes = append(nodes, node)
		return node.assignValues(columns, values)
	}
	for i := range hooks {
		hooks[i](ctx, _spec)
	}
	if err := sqlgraph.QueryNodes(ctx, mpfq.driver, _spec); err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nodes, nil
	}
	return nodes, nil
}

func (mpfq *MailboxPermFlagQuery) sqlCount(ctx context.Context) (int, error) {
	_spec := mpfq.querySpec()
	_spec.Node.Columns = mpfq.fields
	if len(mpfq.fields) > 0 {
		_spec.Unique = mpfq.unique != nil && *mpfq.unique
	}
	return sqlgraph.CountNodes(ctx, mpfq.driver, _spec)
}

func (mpfq *MailboxPermFlagQuery) sqlExist(ctx context.Context) (bool, error) {
	n, err := mpfq.sqlCount(ctx)
	if err != nil {
		return false, fmt.Errorf("ent: check existence: %w", err)
	}
	return n > 0, nil
}

func (mpfq *MailboxPermFlagQuery) querySpec() *sqlgraph.QuerySpec {
	_spec := &sqlgraph.QuerySpec{
		Node: &sqlgraph.NodeSpec{
			Table:   mailboxpermflag.Table,
			Columns: mailboxpermflag.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: mailboxpermflag.FieldID,
			},
		},
		From:   mpfq.sql,
		Unique: true,
	}
	if unique := mpfq.unique; unique != nil {
		_spec.Unique = *unique
	}
	if fields := mpfq.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, mailboxpermflag.FieldID)
		for i := range fields {
			if fields[i] != mailboxpermflag.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, fields[i])
			}
		}
	}
	if ps := mpfq.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if limit := mpfq.limit; limit != nil {
		_spec.Limit = *limit
	}
	if offset := mpfq.offset; offset != nil {
		_spec.Offset = *offset
	}
	if ps := mpfq.order; len(ps) > 0 {
		_spec.Order = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	return _spec
}

func (mpfq *MailboxPermFlagQuery) sqlQuery(ctx context.Context) *sql.Selector {
	builder := sql.Dialect(mpfq.driver.Dialect())
	t1 := builder.Table(mailboxpermflag.Table)
	columns := mpfq.fields
	if len(columns) == 0 {
		columns = mailboxpermflag.Columns
	}
	selector := builder.Select(t1.Columns(columns...)...).From(t1)
	if mpfq.sql != nil {
		selector = mpfq.sql
		selector.Select(selector.Columns(columns...)...)
	}
	if mpfq.unique != nil && *mpfq.unique {
		selector.Distinct()
	}
	for _, p := range mpfq.predicates {
		p(selector)
	}
	for _, p := range mpfq.order {
		p(selector)
	}
	if offset := mpfq.offset; offset != nil {
		// limit is mandatory for offset clause. We start
		// with default value, and override it below if needed.
		selector.Offset(*offset).Limit(math.MaxInt32)
	}
	if limit := mpfq.limit; limit != nil {
		selector.Limit(*limit)
	}
	return selector
}

// MailboxPermFlagGroupBy is the group-by builder for MailboxPermFlag entities.
type MailboxPermFlagGroupBy struct {
	config
	selector
	fields []string
	fns    []AggregateFunc
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Aggregate adds the given aggregation functions to the group-by query.
func (mpfgb *MailboxPermFlagGroupBy) Aggregate(fns ...AggregateFunc) *MailboxPermFlagGroupBy {
	mpfgb.fns = append(mpfgb.fns, fns...)
	return mpfgb
}

// Scan applies the group-by query and scans the result into the given value.
func (mpfgb *MailboxPermFlagGroupBy) Scan(ctx context.Context, v interface{}) error {
	query, err := mpfgb.path(ctx)
	if err != nil {
		return err
	}
	mpfgb.sql = query
	return mpfgb.sqlScan(ctx, v)
}

func (mpfgb *MailboxPermFlagGroupBy) sqlScan(ctx context.Context, v interface{}) error {
	for _, f := range mpfgb.fields {
		if !mailboxpermflag.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("invalid field %q for group-by", f)}
		}
	}
	selector := mpfgb.sqlQuery()
	if err := selector.Err(); err != nil {
		return err
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := mpfgb.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

func (mpfgb *MailboxPermFlagGroupBy) sqlQuery() *sql.Selector {
	selector := mpfgb.sql.Select()
	aggregation := make([]string, 0, len(mpfgb.fns))
	for _, fn := range mpfgb.fns {
		aggregation = append(aggregation, fn(selector))
	}
	// If no columns were selected in a custom aggregation function, the default
	// selection is the fields used for "group-by", and the aggregation functions.
	if len(selector.SelectedColumns()) == 0 {
		columns := make([]string, 0, len(mpfgb.fields)+len(mpfgb.fns))
		for _, f := range mpfgb.fields {
			columns = append(columns, selector.C(f))
		}
		columns = append(columns, aggregation...)
		selector.Select(columns...)
	}
	return selector.GroupBy(selector.Columns(mpfgb.fields...)...)
}

// MailboxPermFlagSelect is the builder for selecting fields of MailboxPermFlag entities.
type MailboxPermFlagSelect struct {
	*MailboxPermFlagQuery
	selector
	// intermediate query (i.e. traversal path).
	sql *sql.Selector
}

// Scan applies the selector query and scans the result into the given value.
func (mpfs *MailboxPermFlagSelect) Scan(ctx context.Context, v interface{}) error {
	if err := mpfs.prepareQuery(ctx); err != nil {
		return err
	}
	mpfs.sql = mpfs.MailboxPermFlagQuery.sqlQuery(ctx)
	return mpfs.sqlScan(ctx, v)
}

func (mpfs *MailboxPermFlagSelect) sqlScan(ctx context.Context, v interface{}) error {
	rows := &sql.Rows{}
	query, args := mpfs.sql.Query()
	if err := mpfs.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}
