// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/ProtonMail/gluon/internal/db/ent/mailboxpermflag"
)

// MailboxPermFlagCreate is the builder for creating a MailboxPermFlag entity.
type MailboxPermFlagCreate struct {
	config
	mutation *MailboxPermFlagMutation
	hooks    []Hook
}

// SetValue sets the "Value" field.
func (mpfc *MailboxPermFlagCreate) SetValue(s string) *MailboxPermFlagCreate {
	mpfc.mutation.SetValue(s)
	return mpfc
}

// Mutation returns the MailboxPermFlagMutation object of the builder.
func (mpfc *MailboxPermFlagCreate) Mutation() *MailboxPermFlagMutation {
	return mpfc.mutation
}

// Save creates the MailboxPermFlag in the database.
func (mpfc *MailboxPermFlagCreate) Save(ctx context.Context) (*MailboxPermFlag, error) {
	var (
		err  error
		node *MailboxPermFlag
	)
	if len(mpfc.hooks) == 0 {
		if err = mpfc.check(); err != nil {
			return nil, err
		}
		node, err = mpfc.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*MailboxPermFlagMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			if err = mpfc.check(); err != nil {
				return nil, err
			}
			mpfc.mutation = mutation
			if node, err = mpfc.sqlSave(ctx); err != nil {
				return nil, err
			}
			mutation.id = &node.ID
			mutation.done = true
			return node, err
		})
		for i := len(mpfc.hooks) - 1; i >= 0; i-- {
			if mpfc.hooks[i] == nil {
				return nil, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = mpfc.hooks[i](mut)
		}
		v, err := mut.Mutate(ctx, mpfc.mutation)
		if err != nil {
			return nil, err
		}
		nv, ok := v.(*MailboxPermFlag)
		if !ok {
			return nil, fmt.Errorf("unexpected node type %T returned from MailboxPermFlagMutation", v)
		}
		node = nv
	}
	return node, err
}

// SaveX calls Save and panics if Save returns an error.
func (mpfc *MailboxPermFlagCreate) SaveX(ctx context.Context) *MailboxPermFlag {
	v, err := mpfc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (mpfc *MailboxPermFlagCreate) Exec(ctx context.Context) error {
	_, err := mpfc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (mpfc *MailboxPermFlagCreate) ExecX(ctx context.Context) {
	if err := mpfc.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (mpfc *MailboxPermFlagCreate) check() error {
	if _, ok := mpfc.mutation.Value(); !ok {
		return &ValidationError{Name: "Value", err: errors.New(`ent: missing required field "MailboxPermFlag.Value"`)}
	}
	return nil
}

func (mpfc *MailboxPermFlagCreate) sqlSave(ctx context.Context) (*MailboxPermFlag, error) {
	_node, _spec := mpfc.createSpec()
	if err := sqlgraph.CreateNode(ctx, mpfc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	id := _spec.ID.Value.(int64)
	_node.ID = int(id)
	return _node, nil
}

func (mpfc *MailboxPermFlagCreate) createSpec() (*MailboxPermFlag, *sqlgraph.CreateSpec) {
	var (
		_node = &MailboxPermFlag{config: mpfc.config}
		_spec = &sqlgraph.CreateSpec{
			Table: mailboxpermflag.Table,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: mailboxpermflag.FieldID,
			},
		}
	)
	if value, ok := mpfc.mutation.Value(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: mailboxpermflag.FieldValue,
		})
		_node.Value = value
	}
	return _node, _spec
}

// MailboxPermFlagCreateBulk is the builder for creating many MailboxPermFlag entities in bulk.
type MailboxPermFlagCreateBulk struct {
	config
	builders []*MailboxPermFlagCreate
}

// Save creates the MailboxPermFlag entities in the database.
func (mpfcb *MailboxPermFlagCreateBulk) Save(ctx context.Context) ([]*MailboxPermFlag, error) {
	specs := make([]*sqlgraph.CreateSpec, len(mpfcb.builders))
	nodes := make([]*MailboxPermFlag, len(mpfcb.builders))
	mutators := make([]Mutator, len(mpfcb.builders))
	for i := range mpfcb.builders {
		func(i int, root context.Context) {
			builder := mpfcb.builders[i]
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*MailboxPermFlagMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				nodes[i], specs[i] = builder.createSpec()
				var err error
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, mpfcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, mpfcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				if specs[i].ID.Value != nil {
					id := specs[i].ID.Value.(int64)
					nodes[i].ID = int(id)
				}
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, mpfcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (mpfcb *MailboxPermFlagCreateBulk) SaveX(ctx context.Context) []*MailboxPermFlag {
	v, err := mpfcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (mpfcb *MailboxPermFlagCreateBulk) Exec(ctx context.Context) error {
	_, err := mpfcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (mpfcb *MailboxPermFlagCreateBulk) ExecX(ctx context.Context) {
	if err := mpfcb.Exec(ctx); err != nil {
		panic(err)
	}
}
