// Code generated by ent, DO NOT EDIT.

package ent

import (
	"fmt"
	"strings"

	"entgo.io/ent/dialect/sql"
	"github.com/ProtonMail/gluon/imap"
	"github.com/ProtonMail/gluon/internal/db/ent/mailboxpermflag"
)

// MailboxPermFlag is the model entity for the MailboxPermFlag schema.
type MailboxPermFlag struct {
	config `json:"-"`
	// ID of the ent.
	ID int `json:"id,omitempty"`
	// Value holds the value of the "Value" field.
	Value                   string `json:"Value,omitempty"`
	mailbox_permanent_flags *imap.InternalMailboxID
}

// scanValues returns the types for scanning values from sql.Rows.
func (*MailboxPermFlag) scanValues(columns []string) ([]interface{}, error) {
	values := make([]interface{}, len(columns))
	for i := range columns {
		switch columns[i] {
		case mailboxpermflag.FieldID:
			values[i] = new(sql.NullInt64)
		case mailboxpermflag.FieldValue:
			values[i] = new(sql.NullString)
		case mailboxpermflag.ForeignKeys[0]: // mailbox_permanent_flags
			values[i] = new(sql.NullInt64)
		default:
			return nil, fmt.Errorf("unexpected column %q for type MailboxPermFlag", columns[i])
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the MailboxPermFlag fields.
func (mpf *MailboxPermFlag) assignValues(columns []string, values []interface{}) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case mailboxpermflag.FieldID:
			value, ok := values[i].(*sql.NullInt64)
			if !ok {
				return fmt.Errorf("unexpected type %T for field id", value)
			}
			mpf.ID = int(value.Int64)
		case mailboxpermflag.FieldValue:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field Value", values[i])
			} else if value.Valid {
				mpf.Value = value.String
			}
		case mailboxpermflag.ForeignKeys[0]:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field mailbox_permanent_flags", values[i])
			} else if value.Valid {
				mpf.mailbox_permanent_flags = new(imap.InternalMailboxID)
				*mpf.mailbox_permanent_flags = imap.InternalMailboxID(value.Int64)
			}
		}
	}
	return nil
}

// Update returns a builder for updating this MailboxPermFlag.
// Note that you need to call MailboxPermFlag.Unwrap() before calling this method if this MailboxPermFlag
// was returned from a transaction, and the transaction was committed or rolled back.
func (mpf *MailboxPermFlag) Update() *MailboxPermFlagUpdateOne {
	return (&MailboxPermFlagClient{config: mpf.config}).UpdateOne(mpf)
}

// Unwrap unwraps the MailboxPermFlag entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (mpf *MailboxPermFlag) Unwrap() *MailboxPermFlag {
	_tx, ok := mpf.config.driver.(*txDriver)
	if !ok {
		panic("ent: MailboxPermFlag is not a transactional entity")
	}
	mpf.config.driver = _tx.drv
	return mpf
}

// String implements the fmt.Stringer.
func (mpf *MailboxPermFlag) String() string {
	var builder strings.Builder
	builder.WriteString("MailboxPermFlag(")
	builder.WriteString(fmt.Sprintf("id=%v, ", mpf.ID))
	builder.WriteString("Value=")
	builder.WriteString(mpf.Value)
	builder.WriteByte(')')
	return builder.String()
}

// MailboxPermFlags is a parsable slice of MailboxPermFlag.
type MailboxPermFlags []*MailboxPermFlag

func (mpf MailboxPermFlags) config(cfg config) {
	for _i := range mpf {
		mpf[_i].config = cfg
	}
}
