// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"fmt"
	"math"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/ProtonMail/gluon/internal/db/ent/mailboxflag"
	"github.com/ProtonMail/gluon/internal/db/ent/predicate"
)

// MailboxFlagQuery is the builder for querying MailboxFlag entities.
type MailboxFlagQuery struct {
	config
	limit      *int
	offset     *int
	unique     *bool
	order      []OrderFunc
	fields     []string
	predicates []predicate.MailboxFlag
	withFKs    bool
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Where adds a new predicate for the MailboxFlagQuery builder.
func (mfq *MailboxFlagQuery) Where(ps ...predicate.MailboxFlag) *MailboxFlagQuery {
	mfq.predicates = append(mfq.predicates, ps...)
	return mfq
}

// Limit adds a limit step to the query.
func (mfq *MailboxFlagQuery) Limit(limit int) *MailboxFlagQuery {
	mfq.limit = &limit
	return mfq
}

// Offset adds an offset step to the query.
func (mfq *MailboxFlagQuery) Offset(offset int) *MailboxFlagQuery {
	mfq.offset = &offset
	return mfq
}

// Unique configures the query builder to filter duplicate records on query.
// By default, unique is set to true, and can be disabled using this method.
func (mfq *MailboxFlagQuery) Unique(unique bool) *MailboxFlagQuery {
	mfq.unique = &unique
	return mfq
}

// Order adds an order step to the query.
func (mfq *MailboxFlagQuery) Order(o ...OrderFunc) *MailboxFlagQuery {
	mfq.order = append(mfq.order, o...)
	return mfq
}

// First returns the first MailboxFlag entity from the query.
// Returns a *NotFoundError when no MailboxFlag was found.
func (mfq *MailboxFlagQuery) First(ctx context.Context) (*MailboxFlag, error) {
	nodes, err := mfq.Limit(1).All(ctx)
	if err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nil, &NotFoundError{mailboxflag.Label}
	}
	return nodes[0], nil
}

// FirstX is like First, but panics if an error occurs.
func (mfq *MailboxFlagQuery) FirstX(ctx context.Context) *MailboxFlag {
	node, err := mfq.First(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return node
}

// FirstID returns the first MailboxFlag ID from the query.
// Returns a *NotFoundError when no MailboxFlag ID was found.
func (mfq *MailboxFlagQuery) FirstID(ctx context.Context) (id int, err error) {
	var ids []int
	if ids, err = mfq.Limit(1).IDs(ctx); err != nil {
		return
	}
	if len(ids) == 0 {
		err = &NotFoundError{mailboxflag.Label}
		return
	}
	return ids[0], nil
}

// FirstIDX is like FirstID, but panics if an error occurs.
func (mfq *MailboxFlagQuery) FirstIDX(ctx context.Context) int {
	id, err := mfq.FirstID(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return id
}

// Only returns a single MailboxFlag entity found by the query, ensuring it only returns one.
// Returns a *NotSingularError when more than one MailboxFlag entity is found.
// Returns a *NotFoundError when no MailboxFlag entities are found.
func (mfq *MailboxFlagQuery) Only(ctx context.Context) (*MailboxFlag, error) {
	nodes, err := mfq.Limit(2).All(ctx)
	if err != nil {
		return nil, err
	}
	switch len(nodes) {
	case 1:
		return nodes[0], nil
	case 0:
		return nil, &NotFoundError{mailboxflag.Label}
	default:
		return nil, &NotSingularError{mailboxflag.Label}
	}
}

// OnlyX is like Only, but panics if an error occurs.
func (mfq *MailboxFlagQuery) OnlyX(ctx context.Context) *MailboxFlag {
	node, err := mfq.Only(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// OnlyID is like Only, but returns the only MailboxFlag ID in the query.
// Returns a *NotSingularError when more than one MailboxFlag ID is found.
// Returns a *NotFoundError when no entities are found.
func (mfq *MailboxFlagQuery) OnlyID(ctx context.Context) (id int, err error) {
	var ids []int
	if ids, err = mfq.Limit(2).IDs(ctx); err != nil {
		return
	}
	switch len(ids) {
	case 1:
		id = ids[0]
	case 0:
		err = &NotFoundError{mailboxflag.Label}
	default:
		err = &NotSingularError{mailboxflag.Label}
	}
	return
}

// OnlyIDX is like OnlyID, but panics if an error occurs.
func (mfq *MailboxFlagQuery) OnlyIDX(ctx context.Context) int {
	id, err := mfq.OnlyID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// All executes the query and returns a list of MailboxFlags.
func (mfq *MailboxFlagQuery) All(ctx context.Context) ([]*MailboxFlag, error) {
	if err := mfq.prepareQuery(ctx); err != nil {
		return nil, err
	}
	return mfq.sqlAll(ctx)
}

// AllX is like All, but panics if an error occurs.
func (mfq *MailboxFlagQuery) AllX(ctx context.Context) []*MailboxFlag {
	nodes, err := mfq.All(ctx)
	if err != nil {
		panic(err)
	}
	return nodes
}

// IDs executes the query and returns a list of MailboxFlag IDs.
func (mfq *MailboxFlagQuery) IDs(ctx context.Context) ([]int, error) {
	var ids []int
	if err := mfq.Select(mailboxflag.FieldID).Scan(ctx, &ids); err != nil {
		return nil, err
	}
	return ids, nil
}

// IDsX is like IDs, but panics if an error occurs.
func (mfq *MailboxFlagQuery) IDsX(ctx context.Context) []int {
	ids, err := mfq.IDs(ctx)
	if err != nil {
		panic(err)
	}
	return ids
}

// Count returns the count of the given query.
func (mfq *MailboxFlagQuery) Count(ctx context.Context) (int, error) {
	if err := mfq.prepareQuery(ctx); err != nil {
		return 0, err
	}
	return mfq.sqlCount(ctx)
}

// CountX is like Count, but panics if an error occurs.
func (mfq *MailboxFlagQuery) CountX(ctx context.Context) int {
	count, err := mfq.Count(ctx)
	if err != nil {
		panic(err)
	}
	return count
}

// Exist returns true if the query has elements in the graph.
func (mfq *MailboxFlagQuery) Exist(ctx context.Context) (bool, error) {
	if err := mfq.prepareQuery(ctx); err != nil {
		return false, err
	}
	return mfq.sqlExist(ctx)
}

// ExistX is like Exist, but panics if an error occurs.
func (mfq *MailboxFlagQuery) ExistX(ctx context.Context) bool {
	exist, err := mfq.Exist(ctx)
	if err != nil {
		panic(err)
	}
	return exist
}

// Clone returns a duplicate of the MailboxFlagQuery builder, including all associated steps. It can be
// used to prepare common query builders and use them differently after the clone is made.
func (mfq *MailboxFlagQuery) Clone() *MailboxFlagQuery {
	if mfq == nil {
		return nil
	}
	return &MailboxFlagQuery{
		config:     mfq.config,
		limit:      mfq.limit,
		offset:     mfq.offset,
		order:      append([]OrderFunc{}, mfq.order...),
		predicates: append([]predicate.MailboxFlag{}, mfq.predicates...),
		// clone intermediate query.
		sql:    mfq.sql.Clone(),
		path:   mfq.path,
		unique: mfq.unique,
	}
}

// GroupBy is used to group vertices by one or more fields/columns.
// It is often used with aggregate functions, like: count, max, mean, min, sum.
//
// Example:
//
//	var v []struct {
//		Value string `json:"Value,omitempty"`
//		Count int `json:"count,omitempty"`
//	}
//
//	client.MailboxFlag.Query().
//		GroupBy(mailboxflag.FieldValue).
//		Aggregate(ent.Count()).
//		Scan(ctx, &v)
func (mfq *MailboxFlagQuery) GroupBy(field string, fields ...string) *MailboxFlagGroupBy {
	grbuild := &MailboxFlagGroupBy{config: mfq.config}
	grbuild.fields = append([]string{field}, fields...)
	grbuild.path = func(ctx context.Context) (prev *sql.Selector, err error) {
		if err := mfq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		return mfq.sqlQuery(ctx), nil
	}
	grbuild.label = mailboxflag.Label
	grbuild.flds, grbuild.scan = &grbuild.fields, grbuild.Scan
	return grbuild
}

// Select allows the selection one or more fields/columns for the given query,
// instead of selecting all fields in the entity.
//
// Example:
//
//	var v []struct {
//		Value string `json:"Value,omitempty"`
//	}
//
//	client.MailboxFlag.Query().
//		Select(mailboxflag.FieldValue).
//		Scan(ctx, &v)
func (mfq *MailboxFlagQuery) Select(fields ...string) *MailboxFlagSelect {
	mfq.fields = append(mfq.fields, fields...)
	selbuild := &MailboxFlagSelect{MailboxFlagQuery: mfq}
	selbuild.label = mailboxflag.Label
	selbuild.flds, selbuild.scan = &mfq.fields, selbuild.Scan
	return selbuild
}

func (mfq *MailboxFlagQuery) prepareQuery(ctx context.Context) error {
	for _, f := range mfq.fields {
		if !mailboxflag.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
		}
	}
	if mfq.path != nil {
		prev, err := mfq.path(ctx)
		if err != nil {
			return err
		}
		mfq.sql = prev
	}
	return nil
}

func (mfq *MailboxFlagQuery) sqlAll(ctx context.Context, hooks ...queryHook) ([]*MailboxFlag, error) {
	var (
		nodes   = []*MailboxFlag{}
		withFKs = mfq.withFKs
		_spec   = mfq.querySpec()
	)
	if withFKs {
		_spec.Node.Columns = append(_spec.Node.Columns, mailboxflag.ForeignKeys...)
	}
	_spec.ScanValues = func(columns []string) ([]interface{}, error) {
		return (*MailboxFlag).scanValues(nil, columns)
	}
	_spec.Assign = func(columns []string, values []interface{}) error {
		node := &MailboxFlag{config: mfq.config}
		nodes = append(nodes, node)
		return node.assignValues(columns, values)
	}
	for i := range hooks {
		hooks[i](ctx, _spec)
	}
	if err := sqlgraph.QueryNodes(ctx, mfq.driver, _spec); err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nodes, nil
	}
	return nodes, nil
}

func (mfq *MailboxFlagQuery) sqlCount(ctx context.Context) (int, error) {
	_spec := mfq.querySpec()
	_spec.Node.Columns = mfq.fields
	if len(mfq.fields) > 0 {
		_spec.Unique = mfq.unique != nil && *mfq.unique
	}
	return sqlgraph.CountNodes(ctx, mfq.driver, _spec)
}

func (mfq *MailboxFlagQuery) sqlExist(ctx context.Context) (bool, error) {
	n, err := mfq.sqlCount(ctx)
	if err != nil {
		return false, fmt.Errorf("ent: check existence: %w", err)
	}
	return n > 0, nil
}

func (mfq *MailboxFlagQuery) querySpec() *sqlgraph.QuerySpec {
	_spec := &sqlgraph.QuerySpec{
		Node: &sqlgraph.NodeSpec{
			Table:   mailboxflag.Table,
			Columns: mailboxflag.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: mailboxflag.FieldID,
			},
		},
		From:   mfq.sql,
		Unique: true,
	}
	if unique := mfq.unique; unique != nil {
		_spec.Unique = *unique
	}
	if fields := mfq.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, mailboxflag.FieldID)
		for i := range fields {
			if fields[i] != mailboxflag.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, fields[i])
			}
		}
	}
	if ps := mfq.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if limit := mfq.limit; limit != nil {
		_spec.Limit = *limit
	}
	if offset := mfq.offset; offset != nil {
		_spec.Offset = *offset
	}
	if ps := mfq.order; len(ps) > 0 {
		_spec.Order = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	return _spec
}

func (mfq *MailboxFlagQuery) sqlQuery(ctx context.Context) *sql.Selector {
	builder := sql.Dialect(mfq.driver.Dialect())
	t1 := builder.Table(mailboxflag.Table)
	columns := mfq.fields
	if len(columns) == 0 {
		columns = mailboxflag.Columns
	}
	selector := builder.Select(t1.Columns(columns...)...).From(t1)
	if mfq.sql != nil {
		selector = mfq.sql
		selector.Select(selector.Columns(columns...)...)
	}
	if mfq.unique != nil && *mfq.unique {
		selector.Distinct()
	}
	for _, p := range mfq.predicates {
		p(selector)
	}
	for _, p := range mfq.order {
		p(selector)
	}
	if offset := mfq.offset; offset != nil {
		// limit is mandatory for offset clause. We start
		// with default value, and override it below if needed.
		selector.Offset(*offset).Limit(math.MaxInt32)
	}
	if limit := mfq.limit; limit != nil {
		selector.Limit(*limit)
	}
	return selector
}

// MailboxFlagGroupBy is the group-by builder for MailboxFlag entities.
type MailboxFlagGroupBy struct {
	config
	selector
	fields []string
	fns    []AggregateFunc
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Aggregate adds the given aggregation functions to the group-by query.
func (mfgb *MailboxFlagGroupBy) Aggregate(fns ...AggregateFunc) *MailboxFlagGroupBy {
	mfgb.fns = append(mfgb.fns, fns...)
	return mfgb
}

// Scan applies the group-by query and scans the result into the given value.
func (mfgb *MailboxFlagGroupBy) Scan(ctx context.Context, v interface{}) error {
	query, err := mfgb.path(ctx)
	if err != nil {
		return err
	}
	mfgb.sql = query
	return mfgb.sqlScan(ctx, v)
}

func (mfgb *MailboxFlagGroupBy) sqlScan(ctx context.Context, v interface{}) error {
	for _, f := range mfgb.fields {
		if !mailboxflag.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("invalid field %q for group-by", f)}
		}
	}
	selector := mfgb.sqlQuery()
	if err := selector.Err(); err != nil {
		return err
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := mfgb.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

func (mfgb *MailboxFlagGroupBy) sqlQuery() *sql.Selector {
	selector := mfgb.sql.Select()
	aggregation := make([]string, 0, len(mfgb.fns))
	for _, fn := range mfgb.fns {
		aggregation = append(aggregation, fn(selector))
	}
	// If no columns were selected in a custom aggregation function, the default
	// selection is the fields used for "group-by", and the aggregation functions.
	if len(selector.SelectedColumns()) == 0 {
		columns := make([]string, 0, len(mfgb.fields)+len(mfgb.fns))
		for _, f := range mfgb.fields {
			columns = append(columns, selector.C(f))
		}
		columns = append(columns, aggregation...)
		selector.Select(columns...)
	}
	return selector.GroupBy(selector.Columns(mfgb.fields...)...)
}

// MailboxFlagSelect is the builder for selecting fields of MailboxFlag entities.
type MailboxFlagSelect struct {
	*MailboxFlagQuery
	selector
	// intermediate query (i.e. traversal path).
	sql *sql.Selector
}

// Scan applies the selector query and scans the result into the given value.
func (mfs *MailboxFlagSelect) Scan(ctx context.Context, v interface{}) error {
	if err := mfs.prepareQuery(ctx); err != nil {
		return err
	}
	mfs.sql = mfs.MailboxFlagQuery.sqlQuery(ctx)
	return mfs.sqlScan(ctx, v)
}

func (mfs *MailboxFlagSelect) sqlScan(ctx context.Context, v interface{}) error {
	rows := &sql.Rows{}
	query, args := mfs.sql.Query()
	if err := mfs.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}
