// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"fmt"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/ProtonMail/gluon/internal/db/ent/mailboxflag"
	"github.com/ProtonMail/gluon/internal/db/ent/predicate"
)

// MailboxFlagDelete is the builder for deleting a MailboxFlag entity.
type MailboxFlagDelete struct {
	config
	hooks    []Hook
	mutation *MailboxFlagMutation
}

// Where appends a list predicates to the MailboxFlagDelete builder.
func (mfd *MailboxFlagDelete) Where(ps ...predicate.MailboxFlag) *MailboxFlagDelete {
	mfd.mutation.Where(ps...)
	return mfd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (mfd *MailboxFlagDelete) Exec(ctx context.Context) (int, error) {
	var (
		err      error
		affected int
	)
	if len(mfd.hooks) == 0 {
		affected, err = mfd.sqlExec(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*MailboxFlagMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			mfd.mutation = mutation
			affected, err = mfd.sqlExec(ctx)
			mutation.done = true
			return affected, err
		})
		for i := len(mfd.hooks) - 1; i >= 0; i-- {
			if mfd.hooks[i] == nil {
				return 0, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = mfd.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, mfd.mutation); err != nil {
			return 0, err
		}
	}
	return affected, err
}

// ExecX is like Exec, but panics if an error occurs.
func (mfd *MailboxFlagDelete) ExecX(ctx context.Context) int {
	n, err := mfd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (mfd *MailboxFlagDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := &sqlgraph.DeleteSpec{
		Node: &sqlgraph.NodeSpec{
			Table: mailboxflag.Table,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: mailboxflag.FieldID,
			},
		},
	}
	if ps := mfd.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, mfd.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	return affected, err
}

// MailboxFlagDeleteOne is the builder for deleting a single MailboxFlag entity.
type MailboxFlagDeleteOne struct {
	mfd *MailboxFlagDelete
}

// Exec executes the deletion query.
func (mfdo *MailboxFlagDeleteOne) Exec(ctx context.Context) error {
	n, err := mfdo.mfd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{mailboxflag.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (mfdo *MailboxFlagDeleteOne) ExecX(ctx context.Context) {
	mfdo.mfd.ExecX(ctx)
}
