// Code generated by ent, DO NOT EDIT.

package ent

import (
	"fmt"
	"strings"

	"entgo.io/ent/dialect/sql"
	"github.com/ProtonMail/gluon/imap"
	"github.com/ProtonMail/gluon/internal/db/ent/mailboxattr"
)

// MailboxAttr is the model entity for the MailboxAttr schema.
type MailboxAttr struct {
	config `json:"-"`
	// ID of the ent.
	ID int `json:"id,omitempty"`
	// Value holds the value of the "Value" field.
	Value              string `json:"Value,omitempty"`
	mailbox_attributes *imap.InternalMailboxID
}

// scanValues returns the types for scanning values from sql.Rows.
func (*MailboxAttr) scanValues(columns []string) ([]interface{}, error) {
	values := make([]interface{}, len(columns))
	for i := range columns {
		switch columns[i] {
		case mailboxattr.FieldID:
			values[i] = new(sql.NullInt64)
		case mailboxattr.FieldValue:
			values[i] = new(sql.NullString)
		case mailboxattr.ForeignKeys[0]: // mailbox_attributes
			values[i] = new(sql.NullInt64)
		default:
			return nil, fmt.Errorf("unexpected column %q for type MailboxAttr", columns[i])
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the MailboxAttr fields.
func (ma *MailboxAttr) assignValues(columns []string, values []interface{}) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case mailboxattr.FieldID:
			value, ok := values[i].(*sql.NullInt64)
			if !ok {
				return fmt.Errorf("unexpected type %T for field id", value)
			}
			ma.ID = int(value.Int64)
		case mailboxattr.FieldValue:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field Value", values[i])
			} else if value.Valid {
				ma.Value = value.String
			}
		case mailboxattr.ForeignKeys[0]:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field mailbox_attributes", values[i])
			} else if value.Valid {
				ma.mailbox_attributes = new(imap.InternalMailboxID)
				*ma.mailbox_attributes = imap.InternalMailboxID(value.Int64)
			}
		}
	}
	return nil
}

// Update returns a builder for updating this MailboxAttr.
// Note that you need to call MailboxAttr.Unwrap() before calling this method if this MailboxAttr
// was returned from a transaction, and the transaction was committed or rolled back.
func (ma *MailboxAttr) Update() *MailboxAttrUpdateOne {
	return (&MailboxAttrClient{config: ma.config}).UpdateOne(ma)
}

// Unwrap unwraps the MailboxAttr entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (ma *MailboxAttr) Unwrap() *MailboxAttr {
	_tx, ok := ma.config.driver.(*txDriver)
	if !ok {
		panic("ent: MailboxAttr is not a transactional entity")
	}
	ma.config.driver = _tx.drv
	return ma
}

// String implements the fmt.Stringer.
func (ma *MailboxAttr) String() string {
	var builder strings.Builder
	builder.WriteString("MailboxAttr(")
	builder.WriteString(fmt.Sprintf("id=%v, ", ma.ID))
	builder.WriteString("Value=")
	builder.WriteString(ma.Value)
	builder.WriteByte(')')
	return builder.String()
}

// MailboxAttrs is a parsable slice of MailboxAttr.
type MailboxAttrs []*MailboxAttr

func (ma MailboxAttrs) config(cfg config) {
	for _i := range ma {
		ma[_i].config = cfg
	}
}
