// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"database/sql/driver"
	"fmt"
	"math"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/ProtonMail/gluon/imap"
	"github.com/ProtonMail/gluon/internal/db/ent/mailbox"
	"github.com/ProtonMail/gluon/internal/db/ent/mailboxattr"
	"github.com/ProtonMail/gluon/internal/db/ent/mailboxflag"
	"github.com/ProtonMail/gluon/internal/db/ent/mailboxpermflag"
	"github.com/ProtonMail/gluon/internal/db/ent/predicate"
	"github.com/ProtonMail/gluon/internal/db/ent/uid"
)

// MailboxQuery is the builder for querying Mailbox entities.
type MailboxQuery struct {
	config
	limit              *int
	offset             *int
	unique             *bool
	order              []OrderFunc
	fields             []string
	predicates         []predicate.Mailbox
	withUIDs           *UIDQuery
	withFlags          *MailboxFlagQuery
	withPermanentFlags *MailboxPermFlagQuery
	withAttributes     *MailboxAttrQuery
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Where adds a new predicate for the MailboxQuery builder.
func (mq *MailboxQuery) Where(ps ...predicate.Mailbox) *MailboxQuery {
	mq.predicates = append(mq.predicates, ps...)
	return mq
}

// Limit adds a limit step to the query.
func (mq *MailboxQuery) Limit(limit int) *MailboxQuery {
	mq.limit = &limit
	return mq
}

// Offset adds an offset step to the query.
func (mq *MailboxQuery) Offset(offset int) *MailboxQuery {
	mq.offset = &offset
	return mq
}

// Unique configures the query builder to filter duplicate records on query.
// By default, unique is set to true, and can be disabled using this method.
func (mq *MailboxQuery) Unique(unique bool) *MailboxQuery {
	mq.unique = &unique
	return mq
}

// Order adds an order step to the query.
func (mq *MailboxQuery) Order(o ...OrderFunc) *MailboxQuery {
	mq.order = append(mq.order, o...)
	return mq
}

// QueryUIDs chains the current query on the "UIDs" edge.
func (mq *MailboxQuery) QueryUIDs() *UIDQuery {
	query := &UIDQuery{config: mq.config}
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := mq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := mq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(mailbox.Table, mailbox.FieldID, selector),
			sqlgraph.To(uid.Table, uid.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, mailbox.UIDsTable, mailbox.UIDsColumn),
		)
		fromU = sqlgraph.SetNeighbors(mq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// QueryFlags chains the current query on the "flags" edge.
func (mq *MailboxQuery) QueryFlags() *MailboxFlagQuery {
	query := &MailboxFlagQuery{config: mq.config}
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := mq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := mq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(mailbox.Table, mailbox.FieldID, selector),
			sqlgraph.To(mailboxflag.Table, mailboxflag.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, mailbox.FlagsTable, mailbox.FlagsColumn),
		)
		fromU = sqlgraph.SetNeighbors(mq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// QueryPermanentFlags chains the current query on the "permanent_flags" edge.
func (mq *MailboxQuery) QueryPermanentFlags() *MailboxPermFlagQuery {
	query := &MailboxPermFlagQuery{config: mq.config}
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := mq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := mq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(mailbox.Table, mailbox.FieldID, selector),
			sqlgraph.To(mailboxpermflag.Table, mailboxpermflag.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, mailbox.PermanentFlagsTable, mailbox.PermanentFlagsColumn),
		)
		fromU = sqlgraph.SetNeighbors(mq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// QueryAttributes chains the current query on the "attributes" edge.
func (mq *MailboxQuery) QueryAttributes() *MailboxAttrQuery {
	query := &MailboxAttrQuery{config: mq.config}
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := mq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := mq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(mailbox.Table, mailbox.FieldID, selector),
			sqlgraph.To(mailboxattr.Table, mailboxattr.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, mailbox.AttributesTable, mailbox.AttributesColumn),
		)
		fromU = sqlgraph.SetNeighbors(mq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// First returns the first Mailbox entity from the query.
// Returns a *NotFoundError when no Mailbox was found.
func (mq *MailboxQuery) First(ctx context.Context) (*Mailbox, error) {
	nodes, err := mq.Limit(1).All(ctx)
	if err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nil, &NotFoundError{mailbox.Label}
	}
	return nodes[0], nil
}

// FirstX is like First, but panics if an error occurs.
func (mq *MailboxQuery) FirstX(ctx context.Context) *Mailbox {
	node, err := mq.First(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return node
}

// FirstID returns the first Mailbox ID from the query.
// Returns a *NotFoundError when no Mailbox ID was found.
func (mq *MailboxQuery) FirstID(ctx context.Context) (id imap.InternalMailboxID, err error) {
	var ids []imap.InternalMailboxID
	if ids, err = mq.Limit(1).IDs(ctx); err != nil {
		return
	}
	if len(ids) == 0 {
		err = &NotFoundError{mailbox.Label}
		return
	}
	return ids[0], nil
}

// FirstIDX is like FirstID, but panics if an error occurs.
func (mq *MailboxQuery) FirstIDX(ctx context.Context) imap.InternalMailboxID {
	id, err := mq.FirstID(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return id
}

// Only returns a single Mailbox entity found by the query, ensuring it only returns one.
// Returns a *NotSingularError when more than one Mailbox entity is found.
// Returns a *NotFoundError when no Mailbox entities are found.
func (mq *MailboxQuery) Only(ctx context.Context) (*Mailbox, error) {
	nodes, err := mq.Limit(2).All(ctx)
	if err != nil {
		return nil, err
	}
	switch len(nodes) {
	case 1:
		return nodes[0], nil
	case 0:
		return nil, &NotFoundError{mailbox.Label}
	default:
		return nil, &NotSingularError{mailbox.Label}
	}
}

// OnlyX is like Only, but panics if an error occurs.
func (mq *MailboxQuery) OnlyX(ctx context.Context) *Mailbox {
	node, err := mq.Only(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// OnlyID is like Only, but returns the only Mailbox ID in the query.
// Returns a *NotSingularError when more than one Mailbox ID is found.
// Returns a *NotFoundError when no entities are found.
func (mq *MailboxQuery) OnlyID(ctx context.Context) (id imap.InternalMailboxID, err error) {
	var ids []imap.InternalMailboxID
	if ids, err = mq.Limit(2).IDs(ctx); err != nil {
		return
	}
	switch len(ids) {
	case 1:
		id = ids[0]
	case 0:
		err = &NotFoundError{mailbox.Label}
	default:
		err = &NotSingularError{mailbox.Label}
	}
	return
}

// OnlyIDX is like OnlyID, but panics if an error occurs.
func (mq *MailboxQuery) OnlyIDX(ctx context.Context) imap.InternalMailboxID {
	id, err := mq.OnlyID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// All executes the query and returns a list of Mailboxes.
func (mq *MailboxQuery) All(ctx context.Context) ([]*Mailbox, error) {
	if err := mq.prepareQuery(ctx); err != nil {
		return nil, err
	}
	return mq.sqlAll(ctx)
}

// AllX is like All, but panics if an error occurs.
func (mq *MailboxQuery) AllX(ctx context.Context) []*Mailbox {
	nodes, err := mq.All(ctx)
	if err != nil {
		panic(err)
	}
	return nodes
}

// IDs executes the query and returns a list of Mailbox IDs.
func (mq *MailboxQuery) IDs(ctx context.Context) ([]imap.InternalMailboxID, error) {
	var ids []imap.InternalMailboxID
	if err := mq.Select(mailbox.FieldID).Scan(ctx, &ids); err != nil {
		return nil, err
	}
	return ids, nil
}

// IDsX is like IDs, but panics if an error occurs.
func (mq *MailboxQuery) IDsX(ctx context.Context) []imap.InternalMailboxID {
	ids, err := mq.IDs(ctx)
	if err != nil {
		panic(err)
	}
	return ids
}

// Count returns the count of the given query.
func (mq *MailboxQuery) Count(ctx context.Context) (int, error) {
	if err := mq.prepareQuery(ctx); err != nil {
		return 0, err
	}
	return mq.sqlCount(ctx)
}

// CountX is like Count, but panics if an error occurs.
func (mq *MailboxQuery) CountX(ctx context.Context) int {
	count, err := mq.Count(ctx)
	if err != nil {
		panic(err)
	}
	return count
}

// Exist returns true if the query has elements in the graph.
func (mq *MailboxQuery) Exist(ctx context.Context) (bool, error) {
	if err := mq.prepareQuery(ctx); err != nil {
		return false, err
	}
	return mq.sqlExist(ctx)
}

// ExistX is like Exist, but panics if an error occurs.
func (mq *MailboxQuery) ExistX(ctx context.Context) bool {
	exist, err := mq.Exist(ctx)
	if err != nil {
		panic(err)
	}
	return exist
}

// Clone returns a duplicate of the MailboxQuery builder, including all associated steps. It can be
// used to prepare common query builders and use them differently after the clone is made.
func (mq *MailboxQuery) Clone() *MailboxQuery {
	if mq == nil {
		return nil
	}
	return &MailboxQuery{
		config:             mq.config,
		limit:              mq.limit,
		offset:             mq.offset,
		order:              append([]OrderFunc{}, mq.order...),
		predicates:         append([]predicate.Mailbox{}, mq.predicates...),
		withUIDs:           mq.withUIDs.Clone(),
		withFlags:          mq.withFlags.Clone(),
		withPermanentFlags: mq.withPermanentFlags.Clone(),
		withAttributes:     mq.withAttributes.Clone(),
		// clone intermediate query.
		sql:    mq.sql.Clone(),
		path:   mq.path,
		unique: mq.unique,
	}
}

// WithUIDs tells the query-builder to eager-load the nodes that are connected to
// the "UIDs" edge. The optional arguments are used to configure the query builder of the edge.
func (mq *MailboxQuery) WithUIDs(opts ...func(*UIDQuery)) *MailboxQuery {
	query := &UIDQuery{config: mq.config}
	for _, opt := range opts {
		opt(query)
	}
	mq.withUIDs = query
	return mq
}

// WithFlags tells the query-builder to eager-load the nodes that are connected to
// the "flags" edge. The optional arguments are used to configure the query builder of the edge.
func (mq *MailboxQuery) WithFlags(opts ...func(*MailboxFlagQuery)) *MailboxQuery {
	query := &MailboxFlagQuery{config: mq.config}
	for _, opt := range opts {
		opt(query)
	}
	mq.withFlags = query
	return mq
}

// WithPermanentFlags tells the query-builder to eager-load the nodes that are connected to
// the "permanent_flags" edge. The optional arguments are used to configure the query builder of the edge.
func (mq *MailboxQuery) WithPermanentFlags(opts ...func(*MailboxPermFlagQuery)) *MailboxQuery {
	query := &MailboxPermFlagQuery{config: mq.config}
	for _, opt := range opts {
		opt(query)
	}
	mq.withPermanentFlags = query
	return mq
}

// WithAttributes tells the query-builder to eager-load the nodes that are connected to
// the "attributes" edge. The optional arguments are used to configure the query builder of the edge.
func (mq *MailboxQuery) WithAttributes(opts ...func(*MailboxAttrQuery)) *MailboxQuery {
	query := &MailboxAttrQuery{config: mq.config}
	for _, opt := range opts {
		opt(query)
	}
	mq.withAttributes = query
	return mq
}

// GroupBy is used to group vertices by one or more fields/columns.
// It is often used with aggregate functions, like: count, max, mean, min, sum.
//
// Example:
//
//	var v []struct {
//		RemoteID imap.MailboxID `json:"RemoteID,omitempty"`
//		Count int `json:"count,omitempty"`
//	}
//
//	client.Mailbox.Query().
//		GroupBy(mailbox.FieldRemoteID).
//		Aggregate(ent.Count()).
//		Scan(ctx, &v)
func (mq *MailboxQuery) GroupBy(field string, fields ...string) *MailboxGroupBy {
	grbuild := &MailboxGroupBy{config: mq.config}
	grbuild.fields = append([]string{field}, fields...)
	grbuild.path = func(ctx context.Context) (prev *sql.Selector, err error) {
		if err := mq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		return mq.sqlQuery(ctx), nil
	}
	grbuild.label = mailbox.Label
	grbuild.flds, grbuild.scan = &grbuild.fields, grbuild.Scan
	return grbuild
}

// Select allows the selection one or more fields/columns for the given query,
// instead of selecting all fields in the entity.
//
// Example:
//
//	var v []struct {
//		RemoteID imap.MailboxID `json:"RemoteID,omitempty"`
//	}
//
//	client.Mailbox.Query().
//		Select(mailbox.FieldRemoteID).
//		Scan(ctx, &v)
func (mq *MailboxQuery) Select(fields ...string) *MailboxSelect {
	mq.fields = append(mq.fields, fields...)
	selbuild := &MailboxSelect{MailboxQuery: mq}
	selbuild.label = mailbox.Label
	selbuild.flds, selbuild.scan = &mq.fields, selbuild.Scan
	return selbuild
}

func (mq *MailboxQuery) prepareQuery(ctx context.Context) error {
	for _, f := range mq.fields {
		if !mailbox.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
		}
	}
	if mq.path != nil {
		prev, err := mq.path(ctx)
		if err != nil {
			return err
		}
		mq.sql = prev
	}
	return nil
}

func (mq *MailboxQuery) sqlAll(ctx context.Context, hooks ...queryHook) ([]*Mailbox, error) {
	var (
		nodes       = []*Mailbox{}
		_spec       = mq.querySpec()
		loadedTypes = [4]bool{
			mq.withUIDs != nil,
			mq.withFlags != nil,
			mq.withPermanentFlags != nil,
			mq.withAttributes != nil,
		}
	)
	_spec.ScanValues = func(columns []string) ([]interface{}, error) {
		return (*Mailbox).scanValues(nil, columns)
	}
	_spec.Assign = func(columns []string, values []interface{}) error {
		node := &Mailbox{config: mq.config}
		nodes = append(nodes, node)
		node.Edges.loadedTypes = loadedTypes
		return node.assignValues(columns, values)
	}
	for i := range hooks {
		hooks[i](ctx, _spec)
	}
	if err := sqlgraph.QueryNodes(ctx, mq.driver, _spec); err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nodes, nil
	}
	if query := mq.withUIDs; query != nil {
		if err := mq.loadUIDs(ctx, query, nodes,
			func(n *Mailbox) { n.Edges.UIDs = []*UID{} },
			func(n *Mailbox, e *UID) { n.Edges.UIDs = append(n.Edges.UIDs, e) }); err != nil {
			return nil, err
		}
	}
	if query := mq.withFlags; query != nil {
		if err := mq.loadFlags(ctx, query, nodes,
			func(n *Mailbox) { n.Edges.Flags = []*MailboxFlag{} },
			func(n *Mailbox, e *MailboxFlag) { n.Edges.Flags = append(n.Edges.Flags, e) }); err != nil {
			return nil, err
		}
	}
	if query := mq.withPermanentFlags; query != nil {
		if err := mq.loadPermanentFlags(ctx, query, nodes,
			func(n *Mailbox) { n.Edges.PermanentFlags = []*MailboxPermFlag{} },
			func(n *Mailbox, e *MailboxPermFlag) { n.Edges.PermanentFlags = append(n.Edges.PermanentFlags, e) }); err != nil {
			return nil, err
		}
	}
	if query := mq.withAttributes; query != nil {
		if err := mq.loadAttributes(ctx, query, nodes,
			func(n *Mailbox) { n.Edges.Attributes = []*MailboxAttr{} },
			func(n *Mailbox, e *MailboxAttr) { n.Edges.Attributes = append(n.Edges.Attributes, e) }); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

func (mq *MailboxQuery) loadUIDs(ctx context.Context, query *UIDQuery, nodes []*Mailbox, init func(*Mailbox), assign func(*Mailbox, *UID)) error {
	fks := make([]driver.Value, 0, len(nodes))
	nodeids := make(map[imap.InternalMailboxID]*Mailbox)
	for i := range nodes {
		fks = append(fks, nodes[i].ID)
		nodeids[nodes[i].ID] = nodes[i]
		if init != nil {
			init(nodes[i])
		}
	}
	query.withFKs = true
	query.Where(predicate.UID(func(s *sql.Selector) {
		s.Where(sql.InValues(mailbox.UIDsColumn, fks...))
	}))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		fk := n.mailbox_ui_ds
		if fk == nil {
			return fmt.Errorf(`foreign-key "mailbox_ui_ds" is nil for node %v`, n.ID)
		}
		node, ok := nodeids[*fk]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "mailbox_ui_ds" returned %v for node %v`, *fk, n.ID)
		}
		assign(node, n)
	}
	return nil
}
func (mq *MailboxQuery) loadFlags(ctx context.Context, query *MailboxFlagQuery, nodes []*Mailbox, init func(*Mailbox), assign func(*Mailbox, *MailboxFlag)) error {
	fks := make([]driver.Value, 0, len(nodes))
	nodeids := make(map[imap.InternalMailboxID]*Mailbox)
	for i := range nodes {
		fks = append(fks, nodes[i].ID)
		nodeids[nodes[i].ID] = nodes[i]
		if init != nil {
			init(nodes[i])
		}
	}
	query.withFKs = true
	query.Where(predicate.MailboxFlag(func(s *sql.Selector) {
		s.Where(sql.InValues(mailbox.FlagsColumn, fks...))
	}))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		fk := n.mailbox_flags
		if fk == nil {
			return fmt.Errorf(`foreign-key "mailbox_flags" is nil for node %v`, n.ID)
		}
		node, ok := nodeids[*fk]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "mailbox_flags" returned %v for node %v`, *fk, n.ID)
		}
		assign(node, n)
	}
	return nil
}
func (mq *MailboxQuery) loadPermanentFlags(ctx context.Context, query *MailboxPermFlagQuery, nodes []*Mailbox, init func(*Mailbox), assign func(*Mailbox, *MailboxPermFlag)) error {
	fks := make([]driver.Value, 0, len(nodes))
	nodeids := make(map[imap.InternalMailboxID]*Mailbox)
	for i := range nodes {
		fks = append(fks, nodes[i].ID)
		nodeids[nodes[i].ID] = nodes[i]
		if init != nil {
			init(nodes[i])
		}
	}
	query.withFKs = true
	query.Where(predicate.MailboxPermFlag(func(s *sql.Selector) {
		s.Where(sql.InValues(mailbox.PermanentFlagsColumn, fks...))
	}))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		fk := n.mailbox_permanent_flags
		if fk == nil {
			return fmt.Errorf(`foreign-key "mailbox_permanent_flags" is nil for node %v`, n.ID)
		}
		node, ok := nodeids[*fk]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "mailbox_permanent_flags" returned %v for node %v`, *fk, n.ID)
		}
		assign(node, n)
	}
	return nil
}
func (mq *MailboxQuery) loadAttributes(ctx context.Context, query *MailboxAttrQuery, nodes []*Mailbox, init func(*Mailbox), assign func(*Mailbox, *MailboxAttr)) error {
	fks := make([]driver.Value, 0, len(nodes))
	nodeids := make(map[imap.InternalMailboxID]*Mailbox)
	for i := range nodes {
		fks = append(fks, nodes[i].ID)
		nodeids[nodes[i].ID] = nodes[i]
		if init != nil {
			init(nodes[i])
		}
	}
	query.withFKs = true
	query.Where(predicate.MailboxAttr(func(s *sql.Selector) {
		s.Where(sql.InValues(mailbox.AttributesColumn, fks...))
	}))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		fk := n.mailbox_attributes
		if fk == nil {
			return fmt.Errorf(`foreign-key "mailbox_attributes" is nil for node %v`, n.ID)
		}
		node, ok := nodeids[*fk]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "mailbox_attributes" returned %v for node %v`, *fk, n.ID)
		}
		assign(node, n)
	}
	return nil
}

func (mq *MailboxQuery) sqlCount(ctx context.Context) (int, error) {
	_spec := mq.querySpec()
	_spec.Node.Columns = mq.fields
	if len(mq.fields) > 0 {
		_spec.Unique = mq.unique != nil && *mq.unique
	}
	return sqlgraph.CountNodes(ctx, mq.driver, _spec)
}

func (mq *MailboxQuery) sqlExist(ctx context.Context) (bool, error) {
	n, err := mq.sqlCount(ctx)
	if err != nil {
		return false, fmt.Errorf("ent: check existence: %w", err)
	}
	return n > 0, nil
}

func (mq *MailboxQuery) querySpec() *sqlgraph.QuerySpec {
	_spec := &sqlgraph.QuerySpec{
		Node: &sqlgraph.NodeSpec{
			Table:   mailbox.Table,
			Columns: mailbox.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeUint64,
				Column: mailbox.FieldID,
			},
		},
		From:   mq.sql,
		Unique: true,
	}
	if unique := mq.unique; unique != nil {
		_spec.Unique = *unique
	}
	if fields := mq.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, mailbox.FieldID)
		for i := range fields {
			if fields[i] != mailbox.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, fields[i])
			}
		}
	}
	if ps := mq.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if limit := mq.limit; limit != nil {
		_spec.Limit = *limit
	}
	if offset := mq.offset; offset != nil {
		_spec.Offset = *offset
	}
	if ps := mq.order; len(ps) > 0 {
		_spec.Order = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	return _spec
}

func (mq *MailboxQuery) sqlQuery(ctx context.Context) *sql.Selector {
	builder := sql.Dialect(mq.driver.Dialect())
	t1 := builder.Table(mailbox.Table)
	columns := mq.fields
	if len(columns) == 0 {
		columns = mailbox.Columns
	}
	selector := builder.Select(t1.Columns(columns...)...).From(t1)
	if mq.sql != nil {
		selector = mq.sql
		selector.Select(selector.Columns(columns...)...)
	}
	if mq.unique != nil && *mq.unique {
		selector.Distinct()
	}
	for _, p := range mq.predicates {
		p(selector)
	}
	for _, p := range mq.order {
		p(selector)
	}
	if offset := mq.offset; offset != nil {
		// limit is mandatory for offset clause. We start
		// with default value, and override it below if needed.
		selector.Offset(*offset).Limit(math.MaxInt32)
	}
	if limit := mq.limit; limit != nil {
		selector.Limit(*limit)
	}
	return selector
}

// MailboxGroupBy is the group-by builder for Mailbox entities.
type MailboxGroupBy struct {
	config
	selector
	fields []string
	fns    []AggregateFunc
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Aggregate adds the given aggregation functions to the group-by query.
func (mgb *MailboxGroupBy) Aggregate(fns ...AggregateFunc) *MailboxGroupBy {
	mgb.fns = append(mgb.fns, fns...)
	return mgb
}

// Scan applies the group-by query and scans the result into the given value.
func (mgb *MailboxGroupBy) Scan(ctx context.Context, v interface{}) error {
	query, err := mgb.path(ctx)
	if err != nil {
		return err
	}
	mgb.sql = query
	return mgb.sqlScan(ctx, v)
}

func (mgb *MailboxGroupBy) sqlScan(ctx context.Context, v interface{}) error {
	for _, f := range mgb.fields {
		if !mailbox.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("invalid field %q for group-by", f)}
		}
	}
	selector := mgb.sqlQuery()
	if err := selector.Err(); err != nil {
		return err
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := mgb.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

func (mgb *MailboxGroupBy) sqlQuery() *sql.Selector {
	selector := mgb.sql.Select()
	aggregation := make([]string, 0, len(mgb.fns))
	for _, fn := range mgb.fns {
		aggregation = append(aggregation, fn(selector))
	}
	// If no columns were selected in a custom aggregation function, the default
	// selection is the fields used for "group-by", and the aggregation functions.
	if len(selector.SelectedColumns()) == 0 {
		columns := make([]string, 0, len(mgb.fields)+len(mgb.fns))
		for _, f := range mgb.fields {
			columns = append(columns, selector.C(f))
		}
		columns = append(columns, aggregation...)
		selector.Select(columns...)
	}
	return selector.GroupBy(selector.Columns(mgb.fields...)...)
}

// MailboxSelect is the builder for selecting fields of Mailbox entities.
type MailboxSelect struct {
	*MailboxQuery
	selector
	// intermediate query (i.e. traversal path).
	sql *sql.Selector
}

// Scan applies the selector query and scans the result into the given value.
func (ms *MailboxSelect) Scan(ctx context.Context, v interface{}) error {
	if err := ms.prepareQuery(ctx); err != nil {
		return err
	}
	ms.sql = ms.MailboxQuery.sqlQuery(ctx)
	return ms.sqlScan(ctx, v)
}

func (ms *MailboxSelect) sqlScan(ctx context.Context, v interface{}) error {
	rows := &sql.Rows{}
	query, args := ms.sql.Query()
	if err := ms.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}
