// Code generated by ent, DO NOT EDIT.

package mailbox

import (
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"github.com/ProtonMail/gluon/imap"
	"github.com/ProtonMail/gluon/internal/db/ent/predicate"
)

// ID filters vertices based on their ID field.
func ID(id imap.InternalMailboxID) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldID), id))
	})
}

// IDEQ applies the EQ predicate on the ID field.
func IDEQ(id imap.InternalMailboxID) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldID), id))
	})
}

// IDNEQ applies the NEQ predicate on the ID field.
func IDNEQ(id imap.InternalMailboxID) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldID), id))
	})
}

// IDIn applies the In predicate on the ID field.
func IDIn(ids ...imap.InternalMailboxID) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		v := make([]interface{}, len(ids))
		for i := range v {
			v[i] = ids[i]
		}
		s.Where(sql.In(s.C(FieldID), v...))
	})
}

// IDNotIn applies the NotIn predicate on the ID field.
func IDNotIn(ids ...imap.InternalMailboxID) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		v := make([]interface{}, len(ids))
		for i := range v {
			v[i] = ids[i]
		}
		s.Where(sql.NotIn(s.C(FieldID), v...))
	})
}

// IDGT applies the GT predicate on the ID field.
func IDGT(id imap.InternalMailboxID) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldID), id))
	})
}

// IDGTE applies the GTE predicate on the ID field.
func IDGTE(id imap.InternalMailboxID) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldID), id))
	})
}

// IDLT applies the LT predicate on the ID field.
func IDLT(id imap.InternalMailboxID) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldID), id))
	})
}

// IDLTE applies the LTE predicate on the ID field.
func IDLTE(id imap.InternalMailboxID) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldID), id))
	})
}

// RemoteID applies equality check predicate on the "RemoteID" field. It's identical to RemoteIDEQ.
func RemoteID(v imap.MailboxID) predicate.Mailbox {
	vc := string(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldRemoteID), vc))
	})
}

// Name applies equality check predicate on the "Name" field. It's identical to NameEQ.
func Name(v string) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldName), v))
	})
}

// UIDNext applies equality check predicate on the "UIDNext" field. It's identical to UIDNextEQ.
func UIDNext(v imap.UID) predicate.Mailbox {
	vc := uint32(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldUIDNext), vc))
	})
}

// UIDValidity applies equality check predicate on the "UIDValidity" field. It's identical to UIDValidityEQ.
func UIDValidity(v imap.UID) predicate.Mailbox {
	vc := uint32(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldUIDValidity), vc))
	})
}

// Subscribed applies equality check predicate on the "Subscribed" field. It's identical to SubscribedEQ.
func Subscribed(v bool) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldSubscribed), v))
	})
}

// RemoteIDEQ applies the EQ predicate on the "RemoteID" field.
func RemoteIDEQ(v imap.MailboxID) predicate.Mailbox {
	vc := string(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldRemoteID), vc))
	})
}

// RemoteIDNEQ applies the NEQ predicate on the "RemoteID" field.
func RemoteIDNEQ(v imap.MailboxID) predicate.Mailbox {
	vc := string(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldRemoteID), vc))
	})
}

// RemoteIDIn applies the In predicate on the "RemoteID" field.
func RemoteIDIn(vs ...imap.MailboxID) predicate.Mailbox {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldRemoteID), v...))
	})
}

// RemoteIDNotIn applies the NotIn predicate on the "RemoteID" field.
func RemoteIDNotIn(vs ...imap.MailboxID) predicate.Mailbox {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldRemoteID), v...))
	})
}

// RemoteIDGT applies the GT predicate on the "RemoteID" field.
func RemoteIDGT(v imap.MailboxID) predicate.Mailbox {
	vc := string(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldRemoteID), vc))
	})
}

// RemoteIDGTE applies the GTE predicate on the "RemoteID" field.
func RemoteIDGTE(v imap.MailboxID) predicate.Mailbox {
	vc := string(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldRemoteID), vc))
	})
}

// RemoteIDLT applies the LT predicate on the "RemoteID" field.
func RemoteIDLT(v imap.MailboxID) predicate.Mailbox {
	vc := string(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldRemoteID), vc))
	})
}

// RemoteIDLTE applies the LTE predicate on the "RemoteID" field.
func RemoteIDLTE(v imap.MailboxID) predicate.Mailbox {
	vc := string(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldRemoteID), vc))
	})
}

// RemoteIDContains applies the Contains predicate on the "RemoteID" field.
func RemoteIDContains(v imap.MailboxID) predicate.Mailbox {
	vc := string(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldRemoteID), vc))
	})
}

// RemoteIDHasPrefix applies the HasPrefix predicate on the "RemoteID" field.
func RemoteIDHasPrefix(v imap.MailboxID) predicate.Mailbox {
	vc := string(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldRemoteID), vc))
	})
}

// RemoteIDHasSuffix applies the HasSuffix predicate on the "RemoteID" field.
func RemoteIDHasSuffix(v imap.MailboxID) predicate.Mailbox {
	vc := string(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldRemoteID), vc))
	})
}

// RemoteIDIsNil applies the IsNil predicate on the "RemoteID" field.
func RemoteIDIsNil() predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldRemoteID)))
	})
}

// RemoteIDNotNil applies the NotNil predicate on the "RemoteID" field.
func RemoteIDNotNil() predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldRemoteID)))
	})
}

// RemoteIDEqualFold applies the EqualFold predicate on the "RemoteID" field.
func RemoteIDEqualFold(v imap.MailboxID) predicate.Mailbox {
	vc := string(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldRemoteID), vc))
	})
}

// RemoteIDContainsFold applies the ContainsFold predicate on the "RemoteID" field.
func RemoteIDContainsFold(v imap.MailboxID) predicate.Mailbox {
	vc := string(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldRemoteID), vc))
	})
}

// NameEQ applies the EQ predicate on the "Name" field.
func NameEQ(v string) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldName), v))
	})
}

// NameNEQ applies the NEQ predicate on the "Name" field.
func NameNEQ(v string) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldName), v))
	})
}

// NameIn applies the In predicate on the "Name" field.
func NameIn(vs ...string) predicate.Mailbox {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldName), v...))
	})
}

// NameNotIn applies the NotIn predicate on the "Name" field.
func NameNotIn(vs ...string) predicate.Mailbox {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldName), v...))
	})
}

// NameGT applies the GT predicate on the "Name" field.
func NameGT(v string) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldName), v))
	})
}

// NameGTE applies the GTE predicate on the "Name" field.
func NameGTE(v string) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldName), v))
	})
}

// NameLT applies the LT predicate on the "Name" field.
func NameLT(v string) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldName), v))
	})
}

// NameLTE applies the LTE predicate on the "Name" field.
func NameLTE(v string) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldName), v))
	})
}

// NameContains applies the Contains predicate on the "Name" field.
func NameContains(v string) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldName), v))
	})
}

// NameHasPrefix applies the HasPrefix predicate on the "Name" field.
func NameHasPrefix(v string) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldName), v))
	})
}

// NameHasSuffix applies the HasSuffix predicate on the "Name" field.
func NameHasSuffix(v string) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldName), v))
	})
}

// NameEqualFold applies the EqualFold predicate on the "Name" field.
func NameEqualFold(v string) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldName), v))
	})
}

// NameContainsFold applies the ContainsFold predicate on the "Name" field.
func NameContainsFold(v string) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldName), v))
	})
}

// UIDNextEQ applies the EQ predicate on the "UIDNext" field.
func UIDNextEQ(v imap.UID) predicate.Mailbox {
	vc := uint32(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldUIDNext), vc))
	})
}

// UIDNextNEQ applies the NEQ predicate on the "UIDNext" field.
func UIDNextNEQ(v imap.UID) predicate.Mailbox {
	vc := uint32(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldUIDNext), vc))
	})
}

// UIDNextIn applies the In predicate on the "UIDNext" field.
func UIDNextIn(vs ...imap.UID) predicate.Mailbox {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = uint32(vs[i])
	}
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldUIDNext), v...))
	})
}

// UIDNextNotIn applies the NotIn predicate on the "UIDNext" field.
func UIDNextNotIn(vs ...imap.UID) predicate.Mailbox {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = uint32(vs[i])
	}
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldUIDNext), v...))
	})
}

// UIDNextGT applies the GT predicate on the "UIDNext" field.
func UIDNextGT(v imap.UID) predicate.Mailbox {
	vc := uint32(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldUIDNext), vc))
	})
}

// UIDNextGTE applies the GTE predicate on the "UIDNext" field.
func UIDNextGTE(v imap.UID) predicate.Mailbox {
	vc := uint32(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldUIDNext), vc))
	})
}

// UIDNextLT applies the LT predicate on the "UIDNext" field.
func UIDNextLT(v imap.UID) predicate.Mailbox {
	vc := uint32(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldUIDNext), vc))
	})
}

// UIDNextLTE applies the LTE predicate on the "UIDNext" field.
func UIDNextLTE(v imap.UID) predicate.Mailbox {
	vc := uint32(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldUIDNext), vc))
	})
}

// UIDValidityEQ applies the EQ predicate on the "UIDValidity" field.
func UIDValidityEQ(v imap.UID) predicate.Mailbox {
	vc := uint32(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldUIDValidity), vc))
	})
}

// UIDValidityNEQ applies the NEQ predicate on the "UIDValidity" field.
func UIDValidityNEQ(v imap.UID) predicate.Mailbox {
	vc := uint32(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldUIDValidity), vc))
	})
}

// UIDValidityIn applies the In predicate on the "UIDValidity" field.
func UIDValidityIn(vs ...imap.UID) predicate.Mailbox {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = uint32(vs[i])
	}
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldUIDValidity), v...))
	})
}

// UIDValidityNotIn applies the NotIn predicate on the "UIDValidity" field.
func UIDValidityNotIn(vs ...imap.UID) predicate.Mailbox {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = uint32(vs[i])
	}
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldUIDValidity), v...))
	})
}

// UIDValidityGT applies the GT predicate on the "UIDValidity" field.
func UIDValidityGT(v imap.UID) predicate.Mailbox {
	vc := uint32(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldUIDValidity), vc))
	})
}

// UIDValidityGTE applies the GTE predicate on the "UIDValidity" field.
func UIDValidityGTE(v imap.UID) predicate.Mailbox {
	vc := uint32(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldUIDValidity), vc))
	})
}

// UIDValidityLT applies the LT predicate on the "UIDValidity" field.
func UIDValidityLT(v imap.UID) predicate.Mailbox {
	vc := uint32(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldUIDValidity), vc))
	})
}

// UIDValidityLTE applies the LTE predicate on the "UIDValidity" field.
func UIDValidityLTE(v imap.UID) predicate.Mailbox {
	vc := uint32(v)
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldUIDValidity), vc))
	})
}

// SubscribedEQ applies the EQ predicate on the "Subscribed" field.
func SubscribedEQ(v bool) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldSubscribed), v))
	})
}

// SubscribedNEQ applies the NEQ predicate on the "Subscribed" field.
func SubscribedNEQ(v bool) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldSubscribed), v))
	})
}

// HasUIDs applies the HasEdge predicate on the "UIDs" edge.
func HasUIDs() predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.To(UIDsTable, FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, UIDsTable, UIDsColumn),
		)
		sqlgraph.HasNeighbors(s, step)
	})
}

// HasUIDsWith applies the HasEdge predicate on the "UIDs" edge with a given conditions (other predicates).
func HasUIDsWith(preds ...predicate.UID) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.To(UIDsInverseTable, FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, UIDsTable, UIDsColumn),
		)
		sqlgraph.HasNeighborsWith(s, step, func(s *sql.Selector) {
			for _, p := range preds {
				p(s)
			}
		})
	})
}

// HasFlags applies the HasEdge predicate on the "flags" edge.
func HasFlags() predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.To(FlagsTable, FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, FlagsTable, FlagsColumn),
		)
		sqlgraph.HasNeighbors(s, step)
	})
}

// HasFlagsWith applies the HasEdge predicate on the "flags" edge with a given conditions (other predicates).
func HasFlagsWith(preds ...predicate.MailboxFlag) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.To(FlagsInverseTable, FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, FlagsTable, FlagsColumn),
		)
		sqlgraph.HasNeighborsWith(s, step, func(s *sql.Selector) {
			for _, p := range preds {
				p(s)
			}
		})
	})
}

// HasPermanentFlags applies the HasEdge predicate on the "permanent_flags" edge.
func HasPermanentFlags() predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.To(PermanentFlagsTable, FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, PermanentFlagsTable, PermanentFlagsColumn),
		)
		sqlgraph.HasNeighbors(s, step)
	})
}

// HasPermanentFlagsWith applies the HasEdge predicate on the "permanent_flags" edge with a given conditions (other predicates).
func HasPermanentFlagsWith(preds ...predicate.MailboxPermFlag) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.To(PermanentFlagsInverseTable, FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, PermanentFlagsTable, PermanentFlagsColumn),
		)
		sqlgraph.HasNeighborsWith(s, step, func(s *sql.Selector) {
			for _, p := range preds {
				p(s)
			}
		})
	})
}

// HasAttributes applies the HasEdge predicate on the "attributes" edge.
func HasAttributes() predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.To(AttributesTable, FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, AttributesTable, AttributesColumn),
		)
		sqlgraph.HasNeighbors(s, step)
	})
}

// HasAttributesWith applies the HasEdge predicate on the "attributes" edge with a given conditions (other predicates).
func HasAttributesWith(preds ...predicate.MailboxAttr) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.To(AttributesInverseTable, FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, AttributesTable, AttributesColumn),
		)
		sqlgraph.HasNeighborsWith(s, step, func(s *sql.Selector) {
			for _, p := range preds {
				p(s)
			}
		})
	})
}

// And groups predicates with the AND operator between them.
func And(predicates ...predicate.Mailbox) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s1 := s.Clone().SetP(nil)
		for _, p := range predicates {
			p(s1)
		}
		s.Where(s1.P())
	})
}

// Or groups predicates with the OR operator between them.
func Or(predicates ...predicate.Mailbox) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		s1 := s.Clone().SetP(nil)
		for i, p := range predicates {
			if i > 0 {
				s1.Or()
			}
			p(s1)
		}
		s.Where(s1.P())
	})
}

// Not applies the not operator on the given predicate.
func Not(p predicate.Mailbox) predicate.Mailbox {
	return predicate.Mailbox(func(s *sql.Selector) {
		p(s.Not())
	})
}
