// Code generated by ent, DO NOT EDIT.

package ent

import (
	"fmt"
	"strings"

	"entgo.io/ent/dialect/sql"
	"github.com/ProtonMail/gluon/imap"
	"github.com/ProtonMail/gluon/internal/db/ent/mailbox"
)

// Mailbox is the model entity for the Mailbox schema.
type Mailbox struct {
	config `json:"-"`
	// ID of the ent.
	ID imap.InternalMailboxID `json:"id,omitempty"`
	// RemoteID holds the value of the "RemoteID" field.
	RemoteID imap.MailboxID `json:"RemoteID,omitempty"`
	// Name holds the value of the "Name" field.
	Name string `json:"Name,omitempty"`
	// UIDNext holds the value of the "UIDNext" field.
	UIDNext imap.UID `json:"UIDNext,omitempty"`
	// UIDValidity holds the value of the "UIDValidity" field.
	UIDValidity imap.UID `json:"UIDValidity,omitempty"`
	// Subscribed holds the value of the "Subscribed" field.
	Subscribed bool `json:"Subscribed,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the MailboxQuery when eager-loading is set.
	Edges MailboxEdges `json:"edges"`
}

// MailboxEdges holds the relations/edges for other nodes in the graph.
type MailboxEdges struct {
	// UIDs holds the value of the UIDs edge.
	UIDs []*UID `json:"UIDs,omitempty"`
	// Flags holds the value of the flags edge.
	Flags []*MailboxFlag `json:"flags,omitempty"`
	// PermanentFlags holds the value of the permanent_flags edge.
	PermanentFlags []*MailboxPermFlag `json:"permanent_flags,omitempty"`
	// Attributes holds the value of the attributes edge.
	Attributes []*MailboxAttr `json:"attributes,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [4]bool
}

// UIDsOrErr returns the UIDs value or an error if the edge
// was not loaded in eager-loading.
func (e MailboxEdges) UIDsOrErr() ([]*UID, error) {
	if e.loadedTypes[0] {
		return e.UIDs, nil
	}
	return nil, &NotLoadedError{edge: "UIDs"}
}

// FlagsOrErr returns the Flags value or an error if the edge
// was not loaded in eager-loading.
func (e MailboxEdges) FlagsOrErr() ([]*MailboxFlag, error) {
	if e.loadedTypes[1] {
		return e.Flags, nil
	}
	return nil, &NotLoadedError{edge: "flags"}
}

// PermanentFlagsOrErr returns the PermanentFlags value or an error if the edge
// was not loaded in eager-loading.
func (e MailboxEdges) PermanentFlagsOrErr() ([]*MailboxPermFlag, error) {
	if e.loadedTypes[2] {
		return e.PermanentFlags, nil
	}
	return nil, &NotLoadedError{edge: "permanent_flags"}
}

// AttributesOrErr returns the Attributes value or an error if the edge
// was not loaded in eager-loading.
func (e MailboxEdges) AttributesOrErr() ([]*MailboxAttr, error) {
	if e.loadedTypes[3] {
		return e.Attributes, nil
	}
	return nil, &NotLoadedError{edge: "attributes"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*Mailbox) scanValues(columns []string) ([]interface{}, error) {
	values := make([]interface{}, len(columns))
	for i := range columns {
		switch columns[i] {
		case mailbox.FieldSubscribed:
			values[i] = new(sql.NullBool)
		case mailbox.FieldID, mailbox.FieldUIDNext, mailbox.FieldUIDValidity:
			values[i] = new(sql.NullInt64)
		case mailbox.FieldRemoteID, mailbox.FieldName:
			values[i] = new(sql.NullString)
		default:
			return nil, fmt.Errorf("unexpected column %q for type Mailbox", columns[i])
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the Mailbox fields.
func (m *Mailbox) assignValues(columns []string, values []interface{}) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case mailbox.FieldID:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value.Valid {
				m.ID = imap.InternalMailboxID(value.Int64)
			}
		case mailbox.FieldRemoteID:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field RemoteID", values[i])
			} else if value.Valid {
				m.RemoteID = imap.MailboxID(value.String)
			}
		case mailbox.FieldName:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field Name", values[i])
			} else if value.Valid {
				m.Name = value.String
			}
		case mailbox.FieldUIDNext:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field UIDNext", values[i])
			} else if value.Valid {
				m.UIDNext = imap.UID(value.Int64)
			}
		case mailbox.FieldUIDValidity:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field UIDValidity", values[i])
			} else if value.Valid {
				m.UIDValidity = imap.UID(value.Int64)
			}
		case mailbox.FieldSubscribed:
			if value, ok := values[i].(*sql.NullBool); !ok {
				return fmt.Errorf("unexpected type %T for field Subscribed", values[i])
			} else if value.Valid {
				m.Subscribed = value.Bool
			}
		}
	}
	return nil
}

// QueryUIDs queries the "UIDs" edge of the Mailbox entity.
func (m *Mailbox) QueryUIDs() *UIDQuery {
	return (&MailboxClient{config: m.config}).QueryUIDs(m)
}

// QueryFlags queries the "flags" edge of the Mailbox entity.
func (m *Mailbox) QueryFlags() *MailboxFlagQuery {
	return (&MailboxClient{config: m.config}).QueryFlags(m)
}

// QueryPermanentFlags queries the "permanent_flags" edge of the Mailbox entity.
func (m *Mailbox) QueryPermanentFlags() *MailboxPermFlagQuery {
	return (&MailboxClient{config: m.config}).QueryPermanentFlags(m)
}

// QueryAttributes queries the "attributes" edge of the Mailbox entity.
func (m *Mailbox) QueryAttributes() *MailboxAttrQuery {
	return (&MailboxClient{config: m.config}).QueryAttributes(m)
}

// Update returns a builder for updating this Mailbox.
// Note that you need to call Mailbox.Unwrap() before calling this method if this Mailbox
// was returned from a transaction, and the transaction was committed or rolled back.
func (m *Mailbox) Update() *MailboxUpdateOne {
	return (&MailboxClient{config: m.config}).UpdateOne(m)
}

// Unwrap unwraps the Mailbox entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (m *Mailbox) Unwrap() *Mailbox {
	_tx, ok := m.config.driver.(*txDriver)
	if !ok {
		panic("ent: Mailbox is not a transactional entity")
	}
	m.config.driver = _tx.drv
	return m
}

// String implements the fmt.Stringer.
func (m *Mailbox) String() string {
	var builder strings.Builder
	builder.WriteString("Mailbox(")
	builder.WriteString(fmt.Sprintf("id=%v, ", m.ID))
	builder.WriteString("RemoteID=")
	builder.WriteString(fmt.Sprintf("%v", m.RemoteID))
	builder.WriteString(", ")
	builder.WriteString("Name=")
	builder.WriteString(m.Name)
	builder.WriteString(", ")
	builder.WriteString("UIDNext=")
	builder.WriteString(fmt.Sprintf("%v", m.UIDNext))
	builder.WriteString(", ")
	builder.WriteString("UIDValidity=")
	builder.WriteString(fmt.Sprintf("%v", m.UIDValidity))
	builder.WriteString(", ")
	builder.WriteString("Subscribed=")
	builder.WriteString(fmt.Sprintf("%v", m.Subscribed))
	builder.WriteByte(')')
	return builder.String()
}

// Mailboxes is a parsable slice of Mailbox.
type Mailboxes []*Mailbox

func (m Mailboxes) config(cfg config) {
	for _i := range m {
		m[_i].config = cfg
	}
}
