// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/ProtonMail/gluon/imap"
	"github.com/ProtonMail/gluon/internal/db/ent/deletedsubscription"
	"github.com/ProtonMail/gluon/internal/db/ent/predicate"
)

// DeletedSubscriptionUpdate is the builder for updating DeletedSubscription entities.
type DeletedSubscriptionUpdate struct {
	config
	hooks    []Hook
	mutation *DeletedSubscriptionMutation
}

// Where appends a list predicates to the DeletedSubscriptionUpdate builder.
func (dsu *DeletedSubscriptionUpdate) Where(ps ...predicate.DeletedSubscription) *DeletedSubscriptionUpdate {
	dsu.mutation.Where(ps...)
	return dsu
}

// SetName sets the "Name" field.
func (dsu *DeletedSubscriptionUpdate) SetName(s string) *DeletedSubscriptionUpdate {
	dsu.mutation.SetName(s)
	return dsu
}

// SetRemoteID sets the "RemoteID" field.
func (dsu *DeletedSubscriptionUpdate) SetRemoteID(ii imap.MailboxID) *DeletedSubscriptionUpdate {
	dsu.mutation.SetRemoteID(ii)
	return dsu
}

// Mutation returns the DeletedSubscriptionMutation object of the builder.
func (dsu *DeletedSubscriptionUpdate) Mutation() *DeletedSubscriptionMutation {
	return dsu.mutation
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (dsu *DeletedSubscriptionUpdate) Save(ctx context.Context) (int, error) {
	var (
		err      error
		affected int
	)
	if len(dsu.hooks) == 0 {
		affected, err = dsu.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*DeletedSubscriptionMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			dsu.mutation = mutation
			affected, err = dsu.sqlSave(ctx)
			mutation.done = true
			return affected, err
		})
		for i := len(dsu.hooks) - 1; i >= 0; i-- {
			if dsu.hooks[i] == nil {
				return 0, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = dsu.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, dsu.mutation); err != nil {
			return 0, err
		}
	}
	return affected, err
}

// SaveX is like Save, but panics if an error occurs.
func (dsu *DeletedSubscriptionUpdate) SaveX(ctx context.Context) int {
	affected, err := dsu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (dsu *DeletedSubscriptionUpdate) Exec(ctx context.Context) error {
	_, err := dsu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (dsu *DeletedSubscriptionUpdate) ExecX(ctx context.Context) {
	if err := dsu.Exec(ctx); err != nil {
		panic(err)
	}
}

func (dsu *DeletedSubscriptionUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := &sqlgraph.UpdateSpec{
		Node: &sqlgraph.NodeSpec{
			Table:   deletedsubscription.Table,
			Columns: deletedsubscription.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: deletedsubscription.FieldID,
			},
		},
	}
	if ps := dsu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := dsu.mutation.Name(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: deletedsubscription.FieldName,
		})
	}
	if value, ok := dsu.mutation.RemoteID(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: deletedsubscription.FieldRemoteID,
		})
	}
	if n, err = sqlgraph.UpdateNodes(ctx, dsu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{deletedsubscription.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	return n, nil
}

// DeletedSubscriptionUpdateOne is the builder for updating a single DeletedSubscription entity.
type DeletedSubscriptionUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *DeletedSubscriptionMutation
}

// SetName sets the "Name" field.
func (dsuo *DeletedSubscriptionUpdateOne) SetName(s string) *DeletedSubscriptionUpdateOne {
	dsuo.mutation.SetName(s)
	return dsuo
}

// SetRemoteID sets the "RemoteID" field.
func (dsuo *DeletedSubscriptionUpdateOne) SetRemoteID(ii imap.MailboxID) *DeletedSubscriptionUpdateOne {
	dsuo.mutation.SetRemoteID(ii)
	return dsuo
}

// Mutation returns the DeletedSubscriptionMutation object of the builder.
func (dsuo *DeletedSubscriptionUpdateOne) Mutation() *DeletedSubscriptionMutation {
	return dsuo.mutation
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (dsuo *DeletedSubscriptionUpdateOne) Select(field string, fields ...string) *DeletedSubscriptionUpdateOne {
	dsuo.fields = append([]string{field}, fields...)
	return dsuo
}

// Save executes the query and returns the updated DeletedSubscription entity.
func (dsuo *DeletedSubscriptionUpdateOne) Save(ctx context.Context) (*DeletedSubscription, error) {
	var (
		err  error
		node *DeletedSubscription
	)
	if len(dsuo.hooks) == 0 {
		node, err = dsuo.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*DeletedSubscriptionMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			dsuo.mutation = mutation
			node, err = dsuo.sqlSave(ctx)
			mutation.done = true
			return node, err
		})
		for i := len(dsuo.hooks) - 1; i >= 0; i-- {
			if dsuo.hooks[i] == nil {
				return nil, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = dsuo.hooks[i](mut)
		}
		v, err := mut.Mutate(ctx, dsuo.mutation)
		if err != nil {
			return nil, err
		}
		nv, ok := v.(*DeletedSubscription)
		if !ok {
			return nil, fmt.Errorf("unexpected node type %T returned from DeletedSubscriptionMutation", v)
		}
		node = nv
	}
	return node, err
}

// SaveX is like Save, but panics if an error occurs.
func (dsuo *DeletedSubscriptionUpdateOne) SaveX(ctx context.Context) *DeletedSubscription {
	node, err := dsuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (dsuo *DeletedSubscriptionUpdateOne) Exec(ctx context.Context) error {
	_, err := dsuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (dsuo *DeletedSubscriptionUpdateOne) ExecX(ctx context.Context) {
	if err := dsuo.Exec(ctx); err != nil {
		panic(err)
	}
}

func (dsuo *DeletedSubscriptionUpdateOne) sqlSave(ctx context.Context) (_node *DeletedSubscription, err error) {
	_spec := &sqlgraph.UpdateSpec{
		Node: &sqlgraph.NodeSpec{
			Table:   deletedsubscription.Table,
			Columns: deletedsubscription.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: deletedsubscription.FieldID,
			},
		},
	}
	id, ok := dsuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`ent: missing "DeletedSubscription.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := dsuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, deletedsubscription.FieldID)
		for _, f := range fields {
			if !deletedsubscription.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			if f != deletedsubscription.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := dsuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := dsuo.mutation.Name(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: deletedsubscription.FieldName,
		})
	}
	if value, ok := dsuo.mutation.RemoteID(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: deletedsubscription.FieldRemoteID,
		})
	}
	_node = &DeletedSubscription{config: dsuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, dsuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{deletedsubscription.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	return _node, nil
}
