// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/ProtonMail/gluon/imap"
	"github.com/ProtonMail/gluon/internal/db/ent/deletedsubscription"
)

// DeletedSubscriptionCreate is the builder for creating a DeletedSubscription entity.
type DeletedSubscriptionCreate struct {
	config
	mutation *DeletedSubscriptionMutation
	hooks    []Hook
}

// SetName sets the "Name" field.
func (dsc *DeletedSubscriptionCreate) SetName(s string) *DeletedSubscriptionCreate {
	dsc.mutation.SetName(s)
	return dsc
}

// SetRemoteID sets the "RemoteID" field.
func (dsc *DeletedSubscriptionCreate) SetRemoteID(ii imap.MailboxID) *DeletedSubscriptionCreate {
	dsc.mutation.SetRemoteID(ii)
	return dsc
}

// Mutation returns the DeletedSubscriptionMutation object of the builder.
func (dsc *DeletedSubscriptionCreate) Mutation() *DeletedSubscriptionMutation {
	return dsc.mutation
}

// Save creates the DeletedSubscription in the database.
func (dsc *DeletedSubscriptionCreate) Save(ctx context.Context) (*DeletedSubscription, error) {
	var (
		err  error
		node *DeletedSubscription
	)
	if len(dsc.hooks) == 0 {
		if err = dsc.check(); err != nil {
			return nil, err
		}
		node, err = dsc.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*DeletedSubscriptionMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			if err = dsc.check(); err != nil {
				return nil, err
			}
			dsc.mutation = mutation
			if node, err = dsc.sqlSave(ctx); err != nil {
				return nil, err
			}
			mutation.id = &node.ID
			mutation.done = true
			return node, err
		})
		for i := len(dsc.hooks) - 1; i >= 0; i-- {
			if dsc.hooks[i] == nil {
				return nil, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = dsc.hooks[i](mut)
		}
		v, err := mut.Mutate(ctx, dsc.mutation)
		if err != nil {
			return nil, err
		}
		nv, ok := v.(*DeletedSubscription)
		if !ok {
			return nil, fmt.Errorf("unexpected node type %T returned from DeletedSubscriptionMutation", v)
		}
		node = nv
	}
	return node, err
}

// SaveX calls Save and panics if Save returns an error.
func (dsc *DeletedSubscriptionCreate) SaveX(ctx context.Context) *DeletedSubscription {
	v, err := dsc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (dsc *DeletedSubscriptionCreate) Exec(ctx context.Context) error {
	_, err := dsc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (dsc *DeletedSubscriptionCreate) ExecX(ctx context.Context) {
	if err := dsc.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (dsc *DeletedSubscriptionCreate) check() error {
	if _, ok := dsc.mutation.Name(); !ok {
		return &ValidationError{Name: "Name", err: errors.New(`ent: missing required field "DeletedSubscription.Name"`)}
	}
	if _, ok := dsc.mutation.RemoteID(); !ok {
		return &ValidationError{Name: "RemoteID", err: errors.New(`ent: missing required field "DeletedSubscription.RemoteID"`)}
	}
	return nil
}

func (dsc *DeletedSubscriptionCreate) sqlSave(ctx context.Context) (*DeletedSubscription, error) {
	_node, _spec := dsc.createSpec()
	if err := sqlgraph.CreateNode(ctx, dsc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	id := _spec.ID.Value.(int64)
	_node.ID = int(id)
	return _node, nil
}

func (dsc *DeletedSubscriptionCreate) createSpec() (*DeletedSubscription, *sqlgraph.CreateSpec) {
	var (
		_node = &DeletedSubscription{config: dsc.config}
		_spec = &sqlgraph.CreateSpec{
			Table: deletedsubscription.Table,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: deletedsubscription.FieldID,
			},
		}
	)
	if value, ok := dsc.mutation.Name(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: deletedsubscription.FieldName,
		})
		_node.Name = value
	}
	if value, ok := dsc.mutation.RemoteID(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: deletedsubscription.FieldRemoteID,
		})
		_node.RemoteID = value
	}
	return _node, _spec
}

// DeletedSubscriptionCreateBulk is the builder for creating many DeletedSubscription entities in bulk.
type DeletedSubscriptionCreateBulk struct {
	config
	builders []*DeletedSubscriptionCreate
}

// Save creates the DeletedSubscription entities in the database.
func (dscb *DeletedSubscriptionCreateBulk) Save(ctx context.Context) ([]*DeletedSubscription, error) {
	specs := make([]*sqlgraph.CreateSpec, len(dscb.builders))
	nodes := make([]*DeletedSubscription, len(dscb.builders))
	mutators := make([]Mutator, len(dscb.builders))
	for i := range dscb.builders {
		func(i int, root context.Context) {
			builder := dscb.builders[i]
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*DeletedSubscriptionMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				nodes[i], specs[i] = builder.createSpec()
				var err error
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, dscb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, dscb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				if specs[i].ID.Value != nil {
					id := specs[i].ID.Value.(int64)
					nodes[i].ID = int(id)
				}
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, dscb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (dscb *DeletedSubscriptionCreateBulk) SaveX(ctx context.Context) []*DeletedSubscription {
	v, err := dscb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (dscb *DeletedSubscriptionCreateBulk) Exec(ctx context.Context) error {
	_, err := dscb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (dscb *DeletedSubscriptionCreateBulk) ExecX(ctx context.Context) {
	if err := dscb.Exec(ctx); err != nil {
		panic(err)
	}
}
