// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package file

import (
	"entgo.io/ent/dialect/gremlin/graph/dsl"
	"entgo.io/ent/dialect/gremlin/graph/dsl/__"
	"entgo.io/ent/dialect/gremlin/graph/dsl/p"
	"entgo.io/ent/entc/integration/gremlin/ent/predicate"
)

// ID filters vertices based on their ID field.
func ID(id string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.HasID(id)
	})
}

// IDEQ applies the EQ predicate on the ID field.
func IDEQ(id string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.HasID(p.EQ(id))
	})
}

// IDNEQ applies the NEQ predicate on the ID field.
func IDNEQ(id string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.HasID(p.NEQ(id))
	})
}

// IDIn applies the In predicate on the ID field.
func IDIn(ids ...string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		v := make([]interface{}, len(ids))
		for i := range v {
			v[i] = ids[i]
		}
		t.HasID(p.Within(v...))
	})
}

// IDNotIn applies the NotIn predicate on the ID field.
func IDNotIn(ids ...string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		v := make([]interface{}, len(ids))
		for i := range v {
			v[i] = ids[i]
		}
		t.HasID(p.Without(v...))
	})
}

// IDGT applies the GT predicate on the ID field.
func IDGT(id string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.HasID(p.GT(id))
	})
}

// IDGTE applies the GTE predicate on the ID field.
func IDGTE(id string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.HasID(p.GTE(id))
	})
}

// IDLT applies the LT predicate on the ID field.
func IDLT(id string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.HasID(p.LT(id))
	})
}

// IDLTE applies the LTE predicate on the ID field.
func IDLTE(id string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.HasID(p.LTE(id))
	})
}

// Size applies equality check predicate on the "size" field. It's identical to SizeEQ.
func Size(v int) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldSize, p.EQ(v))
	})
}

// Name applies equality check predicate on the "name" field. It's identical to NameEQ.
func Name(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.EQ(v))
	})
}

// User applies equality check predicate on the "user" field. It's identical to UserEQ.
func User(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldUser, p.EQ(v))
	})
}

// Group applies equality check predicate on the "group" field. It's identical to GroupEQ.
func Group(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldGroup, p.EQ(v))
	})
}

// Op applies equality check predicate on the "op" field. It's identical to OpEQ.
func Op(v bool) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldOp, p.EQ(v))
	})
}

// SizeEQ applies the EQ predicate on the "size" field.
func SizeEQ(v int) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldSize, p.EQ(v))
	})
}

// SizeNEQ applies the NEQ predicate on the "size" field.
func SizeNEQ(v int) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldSize, p.NEQ(v))
	})
}

// SizeIn applies the In predicate on the "size" field.
func SizeIn(vs ...int) predicate.File {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldSize, p.Within(v...))
	})
}

// SizeNotIn applies the NotIn predicate on the "size" field.
func SizeNotIn(vs ...int) predicate.File {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldSize, p.Without(v...))
	})
}

// SizeGT applies the GT predicate on the "size" field.
func SizeGT(v int) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldSize, p.GT(v))
	})
}

// SizeGTE applies the GTE predicate on the "size" field.
func SizeGTE(v int) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldSize, p.GTE(v))
	})
}

// SizeLT applies the LT predicate on the "size" field.
func SizeLT(v int) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldSize, p.LT(v))
	})
}

// SizeLTE applies the LTE predicate on the "size" field.
func SizeLTE(v int) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldSize, p.LTE(v))
	})
}

// NameEQ applies the EQ predicate on the "name" field.
func NameEQ(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.EQ(v))
	})
}

// NameNEQ applies the NEQ predicate on the "name" field.
func NameNEQ(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.NEQ(v))
	})
}

// NameIn applies the In predicate on the "name" field.
func NameIn(vs ...string) predicate.File {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.Within(v...))
	})
}

// NameNotIn applies the NotIn predicate on the "name" field.
func NameNotIn(vs ...string) predicate.File {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.Without(v...))
	})
}

// NameGT applies the GT predicate on the "name" field.
func NameGT(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.GT(v))
	})
}

// NameGTE applies the GTE predicate on the "name" field.
func NameGTE(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.GTE(v))
	})
}

// NameLT applies the LT predicate on the "name" field.
func NameLT(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.LT(v))
	})
}

// NameLTE applies the LTE predicate on the "name" field.
func NameLTE(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.LTE(v))
	})
}

// NameContains applies the Contains predicate on the "name" field.
func NameContains(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.Containing(v))
	})
}

// NameHasPrefix applies the HasPrefix predicate on the "name" field.
func NameHasPrefix(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.StartingWith(v))
	})
}

// NameHasSuffix applies the HasSuffix predicate on the "name" field.
func NameHasSuffix(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldName, p.EndingWith(v))
	})
}

// UserEQ applies the EQ predicate on the "user" field.
func UserEQ(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldUser, p.EQ(v))
	})
}

// UserNEQ applies the NEQ predicate on the "user" field.
func UserNEQ(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldUser, p.NEQ(v))
	})
}

// UserIn applies the In predicate on the "user" field.
func UserIn(vs ...string) predicate.File {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldUser, p.Within(v...))
	})
}

// UserNotIn applies the NotIn predicate on the "user" field.
func UserNotIn(vs ...string) predicate.File {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldUser, p.Without(v...))
	})
}

// UserGT applies the GT predicate on the "user" field.
func UserGT(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldUser, p.GT(v))
	})
}

// UserGTE applies the GTE predicate on the "user" field.
func UserGTE(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldUser, p.GTE(v))
	})
}

// UserLT applies the LT predicate on the "user" field.
func UserLT(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldUser, p.LT(v))
	})
}

// UserLTE applies the LTE predicate on the "user" field.
func UserLTE(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldUser, p.LTE(v))
	})
}

// UserContains applies the Contains predicate on the "user" field.
func UserContains(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldUser, p.Containing(v))
	})
}

// UserHasPrefix applies the HasPrefix predicate on the "user" field.
func UserHasPrefix(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldUser, p.StartingWith(v))
	})
}

// UserHasSuffix applies the HasSuffix predicate on the "user" field.
func UserHasSuffix(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldUser, p.EndingWith(v))
	})
}

// UserIsNil applies the IsNil predicate on the "user" field.
func UserIsNil() predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldUser)
	})
}

// UserNotNil applies the NotNil predicate on the "user" field.
func UserNotNil() predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldUser)
	})
}

// GroupEQ applies the EQ predicate on the "group" field.
func GroupEQ(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldGroup, p.EQ(v))
	})
}

// GroupNEQ applies the NEQ predicate on the "group" field.
func GroupNEQ(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldGroup, p.NEQ(v))
	})
}

// GroupIn applies the In predicate on the "group" field.
func GroupIn(vs ...string) predicate.File {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldGroup, p.Within(v...))
	})
}

// GroupNotIn applies the NotIn predicate on the "group" field.
func GroupNotIn(vs ...string) predicate.File {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldGroup, p.Without(v...))
	})
}

// GroupGT applies the GT predicate on the "group" field.
func GroupGT(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldGroup, p.GT(v))
	})
}

// GroupGTE applies the GTE predicate on the "group" field.
func GroupGTE(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldGroup, p.GTE(v))
	})
}

// GroupLT applies the LT predicate on the "group" field.
func GroupLT(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldGroup, p.LT(v))
	})
}

// GroupLTE applies the LTE predicate on the "group" field.
func GroupLTE(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldGroup, p.LTE(v))
	})
}

// GroupContains applies the Contains predicate on the "group" field.
func GroupContains(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldGroup, p.Containing(v))
	})
}

// GroupHasPrefix applies the HasPrefix predicate on the "group" field.
func GroupHasPrefix(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldGroup, p.StartingWith(v))
	})
}

// GroupHasSuffix applies the HasSuffix predicate on the "group" field.
func GroupHasSuffix(v string) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldGroup, p.EndingWith(v))
	})
}

// GroupIsNil applies the IsNil predicate on the "group" field.
func GroupIsNil() predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldGroup)
	})
}

// GroupNotNil applies the NotNil predicate on the "group" field.
func GroupNotNil() predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldGroup)
	})
}

// OpEQ applies the EQ predicate on the "op" field.
func OpEQ(v bool) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldOp, p.EQ(v))
	})
}

// OpNEQ applies the NEQ predicate on the "op" field.
func OpNEQ(v bool) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldOp, p.NEQ(v))
	})
}

// OpIsNil applies the IsNil predicate on the "op" field.
func OpIsNil() predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldOp)
	})
}

// OpNotNil applies the NotNil predicate on the "op" field.
func OpNotNil() predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldOp)
	})
}

// FieldIDEQ applies the EQ predicate on the "field_id" field.
func FieldIDEQ(v int) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldFieldID, p.EQ(v))
	})
}

// FieldIDNEQ applies the NEQ predicate on the "field_id" field.
func FieldIDNEQ(v int) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldFieldID, p.NEQ(v))
	})
}

// FieldIDIn applies the In predicate on the "field_id" field.
func FieldIDIn(vs ...int) predicate.File {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldFieldID, p.Within(v...))
	})
}

// FieldIDNotIn applies the NotIn predicate on the "field_id" field.
func FieldIDNotIn(vs ...int) predicate.File {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldFieldID, p.Without(v...))
	})
}

// FieldIDGT applies the GT predicate on the "field_id" field.
func FieldIDGT(v int) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldFieldID, p.GT(v))
	})
}

// FieldIDGTE applies the GTE predicate on the "field_id" field.
func FieldIDGTE(v int) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldFieldID, p.GTE(v))
	})
}

// FieldIDLT applies the LT predicate on the "field_id" field.
func FieldIDLT(v int) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldFieldID, p.LT(v))
	})
}

// FieldIDLTE applies the LTE predicate on the "field_id" field.
func FieldIDLTE(v int) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.Has(Label, FieldFieldID, p.LTE(v))
	})
}

// FieldIDIsNil applies the IsNil predicate on the "field_id" field.
func FieldIDIsNil() predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldFieldID)
	})
}

// FieldIDNotNil applies the NotNil predicate on the "field_id" field.
func FieldIDNotNil() predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldFieldID)
	})
}

// HasOwner applies the HasEdge predicate on the "owner" edge.
func HasOwner() predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.InE(OwnerInverseLabel).InV()
	})
}

// HasOwnerWith applies the HasEdge predicate on the "owner" edge with a given conditions (other predicates).
func HasOwnerWith(preds ...predicate.User) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		tr := __.OutV()
		for _, p := range preds {
			p(tr)
		}
		t.InE(OwnerInverseLabel).Where(tr).InV()
	})
}

// HasType applies the HasEdge predicate on the "type" edge.
func HasType() predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.InE(TypeInverseLabel).InV()
	})
}

// HasTypeWith applies the HasEdge predicate on the "type" edge with a given conditions (other predicates).
func HasTypeWith(preds ...predicate.FileType) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		tr := __.OutV()
		for _, p := range preds {
			p(tr)
		}
		t.InE(TypeInverseLabel).Where(tr).InV()
	})
}

// HasField applies the HasEdge predicate on the "field" edge.
func HasField() predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		t.OutE(FieldLabel).OutV()
	})
}

// HasFieldWith applies the HasEdge predicate on the "field" edge with a given conditions (other predicates).
func HasFieldWith(preds ...predicate.FieldType) predicate.File {
	return predicate.File(func(t *dsl.Traversal) {
		tr := __.InV()
		for _, p := range preds {
			p(tr)
		}
		t.OutE(FieldLabel).Where(tr).OutV()
	})
}

// And groups predicates with the AND operator between them.
func And(predicates ...predicate.File) predicate.File {
	return predicate.File(func(tr *dsl.Traversal) {
		trs := make([]interface{}, 0, len(predicates))
		for _, p := range predicates {
			t := __.New()
			p(t)
			trs = append(trs, t)
		}
		tr.Where(__.And(trs...))
	})
}

// Or groups predicates with the OR operator between them.
func Or(predicates ...predicate.File) predicate.File {
	return predicate.File(func(tr *dsl.Traversal) {
		trs := make([]interface{}, 0, len(predicates))
		for _, p := range predicates {
			t := __.New()
			p(t)
			trs = append(trs, t)
		}
		tr.Where(__.Or(trs...))
	})
}

// Not applies the not operator on the given predicate.
func Not(p predicate.File) predicate.File {
	return predicate.File(func(tr *dsl.Traversal) {
		t := __.New()
		p(t)
		tr.Where(__.Not(t))
	})
}
