We are excited to announce the release of godog v0.9.0.

Here follows a summary of Notable Changes, the Non Backward Compatible Changes and Deprecation Notices.
The full change log is available [here](https://github.com/cucumber/godog/blob/master/CHANGELOG.md#090).


Notable Changes
---------------

Most importantly, note that the gherkin core is changed to [gherkin-go](https://github.com/cucumber/gherkin-go/releases/tag/v9.2.0).



Non Backward Compatible Changes
-------------------------------

### Install godog
With the change of dependencies for godog, which relies on `go modules`, installing godog now requires go modules to be active.

If you are running `within the $GOPATH`, you would need to install godog like this:
`GO111MODULE=on go get github.com/cucumber/godog/cmd/godog@v0.9.0`
- Adding `GO111MODULE=on` will allow go get and go mod to work together as intended.
- Adding `@v0.9.0` will install v0.9.0 specifically instead of master.

If you are running `outside of the $GOPATH`, you should still specify a version.

I you encounter this error, please try adding `GO111MODULE=on`:
```
/go# go get github.com/cucumber/godog/cmd/godog
package github.com/cucumber/gherkin-go/v19: cannot find package "github.com/cucumber/gherkin-go/v19" in any of:
	/usr/local/go/src/github.com/cucumber/gherkin-go/v19 (from $GOROOT)
	/go/src/github.com/cucumber/gherkin-go/v19 (from $GOPATH)
package github.com/cucumber/messages-go/v10: cannot find package "github.com/cucumber/messages-go/v10" in any of:
	/usr/local/go/src/github.com/cucumber/messages-go/v10 (from $GOROOT)
	/go/src/github.com/cucumber/messages-go/v10 (from $GOPATH)
```


### Gherkin Core
The following types have been switched for [messages-go](https://github.com/cucumber/messages-go).

|           old           |                     new                     |
| ----------------------- | ------------------------------------------- |
| gherkin.Feature         | messages.GherkinDocument                    |
| gherkin.Scenario        | messages.Pickle                             |
| gherkin.ScenarioOutline | messages.Pickle                             |
| gherkin.Step            | messages.Pickle_PickleStep                  |
| gherkin.DocString       | messages.PickleStepArgument_PickleDocString |
| gherkin.DataTable       | messages.PickleStepArgument_PickleTable     |


### Step Defintions
- `StepDef` has been renamed to `StepDefinition`
- Steps that earlier accepted `*gherkin.DocString` or `*gherkin.DataTable` needs to be updated to use `*messages.PickleStepArgument_PickleDocString` resp. `*messages.PickleStepArgument_PickleTable`.
[Example](https://github.com/cucumber/godog/pull/240/files#diff-a5f59d298843b731ff8d2f9c670303ff).


### Hooks
The updated hooks can be found [here](https://github.com/cucumber/godog/blob/b62eb13ee70c9f0f732b694b39bde9670051bac7/suite.go#L251).
- `BeforeFeature` and `AfterFeature` hooks now accept `*messages.GherkinDocument` instead of `*gherkin.Feature`
- `BeforeScenario` and `AfterScenario` hooks now accept `*messages.Pickle` instead of `interface{}`
- `BeforeStep` and `AfterStep` hooks now accept `*messages.Pickle_PickleStep` instead `*gherkin.Step`


### Formatter
The formatter interface have recieved some updates, the updated version can be found [here](https://github.com/cucumber/godog/blob/b62eb13ee70c9f0f732b694b39bde9670051bac7/fmt.go#L100).

- `Feature` now accepts `*messages.GherkinDocument` instead of `*gherkin.Feature`
- `Node` has been renamed to `Pickle` and now accepts `*messages.Pickle` instead of `interface{}`
- `Defined`, `Failed`, `Passed`, `Skipped`, `Undefined`, `Pending` now takes `*messages.Pickle` as the first argument and `*gherkin.Step, *StepDef` have been updated to `*messages.Pickle_PickleStep, *StepDefinition`



Deprecation Notices
-------------------

### Hooks
- `BeforeFeature` and `AfterFeature` hooks are now considered deprecated and will be removed in `v0.10.0`.


Full change log
---------------

See [CHANGELOG.md](https://github.com/cucumber/godog/blob/master/CHANGELOG.md#090).

