lexer grammar RFC2047Lexer;

// Printable (0x20-0x7E)
Exclamation:      '!';      // \u0021
DQuote:           '"';      // \u0022
Hash:             '#';      // \u0023
Dollar:           '$';      // \u0024
Percent:          '%';      // \u0025
Ampersand:        '&';      // \u0026
SQuote:           '\'';     // \u0027
LParens:          '(';      // \u0028
RParens:          ')';      // \u0029
Asterisk:         '*';      // \u002A
Plus:             '+';      // \u002B
Comma:            ',';      // \u002C
Minus:            '-';      // \u002D
Period:           '.';      // \u002E
Slash:            '/';      // \u002F
Digit:            [0-9];    // \u0030 -- \u0039
Colon:            ':';      // \u003A
Semicolon:        ';';      // \u003B
Less:             '<';      // \u003C
Equal:            '=';      // \u003D
Greater:          '>';      // \u003E
Question:         '?';      // \u003F
At:               '@';      // \u0040
LBracket:         '[';      // \u005B
Backslash:        '\\';     // \u005C
RBracket:         ']';      // \u005D
Caret:            '^';      // \u005E
Underscore:       '_';      // \u005F
Backtick:         '`';      // \u0060
LCurly:           '{';      // \u007B
Pipe:             '|';      // \u007C
RCurly:           '}';      // \u007D
Tilde:            '~';      // \u007E

A: 'A'|'a';
B: 'B'|'b';
C: 'C'|'c';
D: 'D'|'d';
E: 'E'|'e';
F: 'F'|'f';
G: 'G'|'g';
H: 'H'|'h';
I: 'I'|'i';
J: 'J'|'j';
K: 'K'|'k';
L: 'L'|'l';
M: 'M'|'m';
N: 'N'|'n';
O: 'O'|'o';
P: 'P'|'p';
Q: 'Q'|'q';
R: 'R'|'r';
S: 'S'|'s';
T: 'T'|'t';
U: 'U'|'u';
V: 'V'|'v';
W: 'W'|'w';
X: 'X'|'x';
Y: 'Y'|'y';
Z: 'Z'|'z';



