// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/ProtonMail/gluon/imap"
	"github.com/ProtonMail/gluon/internal/db/ent/mailbox"
	"github.com/ProtonMail/gluon/internal/db/ent/message"
	"github.com/ProtonMail/gluon/internal/db/ent/uid"
)

// UIDCreate is the builder for creating a UID entity.
type UIDCreate struct {
	config
	mutation *UIDMutation
	hooks    []Hook
}

// SetUID sets the "UID" field.
func (uc *UIDCreate) SetUID(i imap.UID) *UIDCreate {
	uc.mutation.SetUID(i)
	return uc
}

// SetDeleted sets the "Deleted" field.
func (uc *UIDCreate) SetDeleted(b bool) *UIDCreate {
	uc.mutation.SetDeleted(b)
	return uc
}

// SetNillableDeleted sets the "Deleted" field if the given value is not nil.
func (uc *UIDCreate) SetNillableDeleted(b *bool) *UIDCreate {
	if b != nil {
		uc.SetDeleted(*b)
	}
	return uc
}

// SetRecent sets the "Recent" field.
func (uc *UIDCreate) SetRecent(b bool) *UIDCreate {
	uc.mutation.SetRecent(b)
	return uc
}

// SetNillableRecent sets the "Recent" field if the given value is not nil.
func (uc *UIDCreate) SetNillableRecent(b *bool) *UIDCreate {
	if b != nil {
		uc.SetRecent(*b)
	}
	return uc
}

// SetMessageID sets the "message" edge to the Message entity by ID.
func (uc *UIDCreate) SetMessageID(id imap.InternalMessageID) *UIDCreate {
	uc.mutation.SetMessageID(id)
	return uc
}

// SetNillableMessageID sets the "message" edge to the Message entity by ID if the given value is not nil.
func (uc *UIDCreate) SetNillableMessageID(id *imap.InternalMessageID) *UIDCreate {
	if id != nil {
		uc = uc.SetMessageID(*id)
	}
	return uc
}

// SetMessage sets the "message" edge to the Message entity.
func (uc *UIDCreate) SetMessage(m *Message) *UIDCreate {
	return uc.SetMessageID(m.ID)
}

// SetMailboxID sets the "mailbox" edge to the Mailbox entity by ID.
func (uc *UIDCreate) SetMailboxID(id imap.InternalMailboxID) *UIDCreate {
	uc.mutation.SetMailboxID(id)
	return uc
}

// SetNillableMailboxID sets the "mailbox" edge to the Mailbox entity by ID if the given value is not nil.
func (uc *UIDCreate) SetNillableMailboxID(id *imap.InternalMailboxID) *UIDCreate {
	if id != nil {
		uc = uc.SetMailboxID(*id)
	}
	return uc
}

// SetMailbox sets the "mailbox" edge to the Mailbox entity.
func (uc *UIDCreate) SetMailbox(m *Mailbox) *UIDCreate {
	return uc.SetMailboxID(m.ID)
}

// Mutation returns the UIDMutation object of the builder.
func (uc *UIDCreate) Mutation() *UIDMutation {
	return uc.mutation
}

// Save creates the UID in the database.
func (uc *UIDCreate) Save(ctx context.Context) (*UID, error) {
	var (
		err  error
		node *UID
	)
	uc.defaults()
	if len(uc.hooks) == 0 {
		if err = uc.check(); err != nil {
			return nil, err
		}
		node, err = uc.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*UIDMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			if err = uc.check(); err != nil {
				return nil, err
			}
			uc.mutation = mutation
			if node, err = uc.sqlSave(ctx); err != nil {
				return nil, err
			}
			mutation.id = &node.ID
			mutation.done = true
			return node, err
		})
		for i := len(uc.hooks) - 1; i >= 0; i-- {
			if uc.hooks[i] == nil {
				return nil, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = uc.hooks[i](mut)
		}
		v, err := mut.Mutate(ctx, uc.mutation)
		if err != nil {
			return nil, err
		}
		nv, ok := v.(*UID)
		if !ok {
			return nil, fmt.Errorf("unexpected node type %T returned from UIDMutation", v)
		}
		node = nv
	}
	return node, err
}

// SaveX calls Save and panics if Save returns an error.
func (uc *UIDCreate) SaveX(ctx context.Context) *UID {
	v, err := uc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (uc *UIDCreate) Exec(ctx context.Context) error {
	_, err := uc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (uc *UIDCreate) ExecX(ctx context.Context) {
	if err := uc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (uc *UIDCreate) defaults() {
	if _, ok := uc.mutation.Deleted(); !ok {
		v := uid.DefaultDeleted
		uc.mutation.SetDeleted(v)
	}
	if _, ok := uc.mutation.Recent(); !ok {
		v := uid.DefaultRecent
		uc.mutation.SetRecent(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (uc *UIDCreate) check() error {
	if _, ok := uc.mutation.UID(); !ok {
		return &ValidationError{Name: "UID", err: errors.New(`ent: missing required field "UID.UID"`)}
	}
	if _, ok := uc.mutation.Deleted(); !ok {
		return &ValidationError{Name: "Deleted", err: errors.New(`ent: missing required field "UID.Deleted"`)}
	}
	if _, ok := uc.mutation.Recent(); !ok {
		return &ValidationError{Name: "Recent", err: errors.New(`ent: missing required field "UID.Recent"`)}
	}
	return nil
}

func (uc *UIDCreate) sqlSave(ctx context.Context) (*UID, error) {
	_node, _spec := uc.createSpec()
	if err := sqlgraph.CreateNode(ctx, uc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	id := _spec.ID.Value.(int64)
	_node.ID = int(id)
	return _node, nil
}

func (uc *UIDCreate) createSpec() (*UID, *sqlgraph.CreateSpec) {
	var (
		_node = &UID{config: uc.config}
		_spec = &sqlgraph.CreateSpec{
			Table: uid.Table,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: uid.FieldID,
			},
		}
	)
	if value, ok := uc.mutation.UID(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeUint32,
			Value:  value,
			Column: uid.FieldUID,
		})
		_node.UID = value
	}
	if value, ok := uc.mutation.Deleted(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeBool,
			Value:  value,
			Column: uid.FieldDeleted,
		})
		_node.Deleted = value
	}
	if value, ok := uc.mutation.Recent(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeBool,
			Value:  value,
			Column: uid.FieldRecent,
		})
		_node.Recent = value
	}
	if nodes := uc.mutation.MessageIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   uid.MessageTable,
			Columns: []string{uid.MessageColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeUUID,
					Column: message.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.uid_message = &nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := uc.mutation.MailboxIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   uid.MailboxTable,
			Columns: []string{uid.MailboxColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeUint64,
					Column: mailbox.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.mailbox_ui_ds = &nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// UIDCreateBulk is the builder for creating many UID entities in bulk.
type UIDCreateBulk struct {
	config
	builders []*UIDCreate
}

// Save creates the UID entities in the database.
func (ucb *UIDCreateBulk) Save(ctx context.Context) ([]*UID, error) {
	specs := make([]*sqlgraph.CreateSpec, len(ucb.builders))
	nodes := make([]*UID, len(ucb.builders))
	mutators := make([]Mutator, len(ucb.builders))
	for i := range ucb.builders {
		func(i int, root context.Context) {
			builder := ucb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*UIDMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				nodes[i], specs[i] = builder.createSpec()
				var err error
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, ucb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, ucb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				if specs[i].ID.Value != nil {
					id := specs[i].ID.Value.(int64)
					nodes[i].ID = int(id)
				}
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, ucb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (ucb *UIDCreateBulk) SaveX(ctx context.Context) []*UID {
	v, err := ucb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (ucb *UIDCreateBulk) Exec(ctx context.Context) error {
	_, err := ucb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ucb *UIDCreateBulk) ExecX(ctx context.Context) {
	if err := ucb.Exec(ctx); err != nil {
		panic(err)
	}
}
