// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"sync"
	"time"

	"github.com/ProtonMail/gluon/imap"
	"github.com/ProtonMail/gluon/internal/db/ent/deletedsubscription"
	"github.com/ProtonMail/gluon/internal/db/ent/mailbox"
	"github.com/ProtonMail/gluon/internal/db/ent/mailboxattr"
	"github.com/ProtonMail/gluon/internal/db/ent/mailboxflag"
	"github.com/ProtonMail/gluon/internal/db/ent/mailboxpermflag"
	"github.com/ProtonMail/gluon/internal/db/ent/message"
	"github.com/ProtonMail/gluon/internal/db/ent/messageflag"
	"github.com/ProtonMail/gluon/internal/db/ent/predicate"
	"github.com/ProtonMail/gluon/internal/db/ent/uid"

	"entgo.io/ent"
)

const (
	// Operation types.
	OpCreate    = ent.OpCreate
	OpDelete    = ent.OpDelete
	OpDeleteOne = ent.OpDeleteOne
	OpUpdate    = ent.OpUpdate
	OpUpdateOne = ent.OpUpdateOne

	// Node types.
	TypeDeletedSubscription = "DeletedSubscription"
	TypeMailbox             = "Mailbox"
	TypeMailboxAttr         = "MailboxAttr"
	TypeMailboxFlag         = "MailboxFlag"
	TypeMailboxPermFlag     = "MailboxPermFlag"
	TypeMessage             = "Message"
	TypeMessageFlag         = "MessageFlag"
	TypeUID                 = "UID"
)

// DeletedSubscriptionMutation represents an operation that mutates the DeletedSubscription nodes in the graph.
type DeletedSubscriptionMutation struct {
	config
	op            Op
	typ           string
	id            *int
	_Name         *string
	_RemoteID     *imap.MailboxID
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*DeletedSubscription, error)
	predicates    []predicate.DeletedSubscription
}

var _ ent.Mutation = (*DeletedSubscriptionMutation)(nil)

// deletedsubscriptionOption allows management of the mutation configuration using functional options.
type deletedsubscriptionOption func(*DeletedSubscriptionMutation)

// newDeletedSubscriptionMutation creates new mutation for the DeletedSubscription entity.
func newDeletedSubscriptionMutation(c config, op Op, opts ...deletedsubscriptionOption) *DeletedSubscriptionMutation {
	m := &DeletedSubscriptionMutation{
		config:        c,
		op:            op,
		typ:           TypeDeletedSubscription,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withDeletedSubscriptionID sets the ID field of the mutation.
func withDeletedSubscriptionID(id int) deletedsubscriptionOption {
	return func(m *DeletedSubscriptionMutation) {
		var (
			err   error
			once  sync.Once
			value *DeletedSubscription
		)
		m.oldValue = func(ctx context.Context) (*DeletedSubscription, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().DeletedSubscription.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withDeletedSubscription sets the old DeletedSubscription of the mutation.
func withDeletedSubscription(node *DeletedSubscription) deletedsubscriptionOption {
	return func(m *DeletedSubscriptionMutation) {
		m.oldValue = func(context.Context) (*DeletedSubscription, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m DeletedSubscriptionMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m DeletedSubscriptionMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *DeletedSubscriptionMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *DeletedSubscriptionMutation) IDs(ctx context.Context) ([]int, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []int{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().DeletedSubscription.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetName sets the "Name" field.
func (m *DeletedSubscriptionMutation) SetName(s string) {
	m._Name = &s
}

// Name returns the value of the "Name" field in the mutation.
func (m *DeletedSubscriptionMutation) Name() (r string, exists bool) {
	v := m._Name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "Name" field's value of the DeletedSubscription entity.
// If the DeletedSubscription object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DeletedSubscriptionMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "Name" field.
func (m *DeletedSubscriptionMutation) ResetName() {
	m._Name = nil
}

// SetRemoteID sets the "RemoteID" field.
func (m *DeletedSubscriptionMutation) SetRemoteID(ii imap.MailboxID) {
	m._RemoteID = &ii
}

// RemoteID returns the value of the "RemoteID" field in the mutation.
func (m *DeletedSubscriptionMutation) RemoteID() (r imap.MailboxID, exists bool) {
	v := m._RemoteID
	if v == nil {
		return
	}
	return *v, true
}

// OldRemoteID returns the old "RemoteID" field's value of the DeletedSubscription entity.
// If the DeletedSubscription object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DeletedSubscriptionMutation) OldRemoteID(ctx context.Context) (v imap.MailboxID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldRemoteID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldRemoteID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRemoteID: %w", err)
	}
	return oldValue.RemoteID, nil
}

// ResetRemoteID resets all changes to the "RemoteID" field.
func (m *DeletedSubscriptionMutation) ResetRemoteID() {
	m._RemoteID = nil
}

// Where appends a list predicates to the DeletedSubscriptionMutation builder.
func (m *DeletedSubscriptionMutation) Where(ps ...predicate.DeletedSubscription) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *DeletedSubscriptionMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (DeletedSubscription).
func (m *DeletedSubscriptionMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *DeletedSubscriptionMutation) Fields() []string {
	fields := make([]string, 0, 2)
	if m._Name != nil {
		fields = append(fields, deletedsubscription.FieldName)
	}
	if m._RemoteID != nil {
		fields = append(fields, deletedsubscription.FieldRemoteID)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *DeletedSubscriptionMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case deletedsubscription.FieldName:
		return m.Name()
	case deletedsubscription.FieldRemoteID:
		return m.RemoteID()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *DeletedSubscriptionMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case deletedsubscription.FieldName:
		return m.OldName(ctx)
	case deletedsubscription.FieldRemoteID:
		return m.OldRemoteID(ctx)
	}
	return nil, fmt.Errorf("unknown DeletedSubscription field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *DeletedSubscriptionMutation) SetField(name string, value ent.Value) error {
	switch name {
	case deletedsubscription.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case deletedsubscription.FieldRemoteID:
		v, ok := value.(imap.MailboxID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRemoteID(v)
		return nil
	}
	return fmt.Errorf("unknown DeletedSubscription field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *DeletedSubscriptionMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *DeletedSubscriptionMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *DeletedSubscriptionMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown DeletedSubscription numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *DeletedSubscriptionMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *DeletedSubscriptionMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *DeletedSubscriptionMutation) ClearField(name string) error {
	return fmt.Errorf("unknown DeletedSubscription nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *DeletedSubscriptionMutation) ResetField(name string) error {
	switch name {
	case deletedsubscription.FieldName:
		m.ResetName()
		return nil
	case deletedsubscription.FieldRemoteID:
		m.ResetRemoteID()
		return nil
	}
	return fmt.Errorf("unknown DeletedSubscription field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *DeletedSubscriptionMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *DeletedSubscriptionMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *DeletedSubscriptionMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *DeletedSubscriptionMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *DeletedSubscriptionMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *DeletedSubscriptionMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *DeletedSubscriptionMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown DeletedSubscription unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *DeletedSubscriptionMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown DeletedSubscription edge %s", name)
}

// MailboxMutation represents an operation that mutates the Mailbox nodes in the graph.
type MailboxMutation struct {
	config
	op                     Op
	typ                    string
	id                     *imap.InternalMailboxID
	_RemoteID              *imap.MailboxID
	_Name                  *string
	_UIDNext               *imap.UID
	add_UIDNext            *imap.UID
	_UIDValidity           *imap.UID
	add_UIDValidity        *imap.UID
	_Subscribed            *bool
	clearedFields          map[string]struct{}
	_UIDs                  map[int]struct{}
	removed_UIDs           map[int]struct{}
	cleared_UIDs           bool
	flags                  map[int]struct{}
	removedflags           map[int]struct{}
	clearedflags           bool
	permanent_flags        map[int]struct{}
	removedpermanent_flags map[int]struct{}
	clearedpermanent_flags bool
	attributes             map[int]struct{}
	removedattributes      map[int]struct{}
	clearedattributes      bool
	done                   bool
	oldValue               func(context.Context) (*Mailbox, error)
	predicates             []predicate.Mailbox
}

var _ ent.Mutation = (*MailboxMutation)(nil)

// mailboxOption allows management of the mutation configuration using functional options.
type mailboxOption func(*MailboxMutation)

// newMailboxMutation creates new mutation for the Mailbox entity.
func newMailboxMutation(c config, op Op, opts ...mailboxOption) *MailboxMutation {
	m := &MailboxMutation{
		config:        c,
		op:            op,
		typ:           TypeMailbox,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withMailboxID sets the ID field of the mutation.
func withMailboxID(id imap.InternalMailboxID) mailboxOption {
	return func(m *MailboxMutation) {
		var (
			err   error
			once  sync.Once
			value *Mailbox
		)
		m.oldValue = func(ctx context.Context) (*Mailbox, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Mailbox.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withMailbox sets the old Mailbox of the mutation.
func withMailbox(node *Mailbox) mailboxOption {
	return func(m *MailboxMutation) {
		m.oldValue = func(context.Context) (*Mailbox, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m MailboxMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m MailboxMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Mailbox entities.
func (m *MailboxMutation) SetID(id imap.InternalMailboxID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *MailboxMutation) ID() (id imap.InternalMailboxID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *MailboxMutation) IDs(ctx context.Context) ([]imap.InternalMailboxID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []imap.InternalMailboxID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Mailbox.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetRemoteID sets the "RemoteID" field.
func (m *MailboxMutation) SetRemoteID(ii imap.MailboxID) {
	m._RemoteID = &ii
}

// RemoteID returns the value of the "RemoteID" field in the mutation.
func (m *MailboxMutation) RemoteID() (r imap.MailboxID, exists bool) {
	v := m._RemoteID
	if v == nil {
		return
	}
	return *v, true
}

// OldRemoteID returns the old "RemoteID" field's value of the Mailbox entity.
// If the Mailbox object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MailboxMutation) OldRemoteID(ctx context.Context) (v imap.MailboxID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldRemoteID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldRemoteID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRemoteID: %w", err)
	}
	return oldValue.RemoteID, nil
}

// ClearRemoteID clears the value of the "RemoteID" field.
func (m *MailboxMutation) ClearRemoteID() {
	m._RemoteID = nil
	m.clearedFields[mailbox.FieldRemoteID] = struct{}{}
}

// RemoteIDCleared returns if the "RemoteID" field was cleared in this mutation.
func (m *MailboxMutation) RemoteIDCleared() bool {
	_, ok := m.clearedFields[mailbox.FieldRemoteID]
	return ok
}

// ResetRemoteID resets all changes to the "RemoteID" field.
func (m *MailboxMutation) ResetRemoteID() {
	m._RemoteID = nil
	delete(m.clearedFields, mailbox.FieldRemoteID)
}

// SetName sets the "Name" field.
func (m *MailboxMutation) SetName(s string) {
	m._Name = &s
}

// Name returns the value of the "Name" field in the mutation.
func (m *MailboxMutation) Name() (r string, exists bool) {
	v := m._Name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "Name" field's value of the Mailbox entity.
// If the Mailbox object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MailboxMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "Name" field.
func (m *MailboxMutation) ResetName() {
	m._Name = nil
}

// SetUIDNext sets the "UIDNext" field.
func (m *MailboxMutation) SetUIDNext(i imap.UID) {
	m._UIDNext = &i
	m.add_UIDNext = nil
}

// UIDNext returns the value of the "UIDNext" field in the mutation.
func (m *MailboxMutation) UIDNext() (r imap.UID, exists bool) {
	v := m._UIDNext
	if v == nil {
		return
	}
	return *v, true
}

// OldUIDNext returns the old "UIDNext" field's value of the Mailbox entity.
// If the Mailbox object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MailboxMutation) OldUIDNext(ctx context.Context) (v imap.UID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUIDNext is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUIDNext requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUIDNext: %w", err)
	}
	return oldValue.UIDNext, nil
}

// AddUIDNext adds i to the "UIDNext" field.
func (m *MailboxMutation) AddUIDNext(i imap.UID) {
	if m.add_UIDNext != nil {
		*m.add_UIDNext += i
	} else {
		m.add_UIDNext = &i
	}
}

// AddedUIDNext returns the value that was added to the "UIDNext" field in this mutation.
func (m *MailboxMutation) AddedUIDNext() (r imap.UID, exists bool) {
	v := m.add_UIDNext
	if v == nil {
		return
	}
	return *v, true
}

// ResetUIDNext resets all changes to the "UIDNext" field.
func (m *MailboxMutation) ResetUIDNext() {
	m._UIDNext = nil
	m.add_UIDNext = nil
}

// SetUIDValidity sets the "UIDValidity" field.
func (m *MailboxMutation) SetUIDValidity(i imap.UID) {
	m._UIDValidity = &i
	m.add_UIDValidity = nil
}

// UIDValidity returns the value of the "UIDValidity" field in the mutation.
func (m *MailboxMutation) UIDValidity() (r imap.UID, exists bool) {
	v := m._UIDValidity
	if v == nil {
		return
	}
	return *v, true
}

// OldUIDValidity returns the old "UIDValidity" field's value of the Mailbox entity.
// If the Mailbox object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MailboxMutation) OldUIDValidity(ctx context.Context) (v imap.UID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUIDValidity is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUIDValidity requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUIDValidity: %w", err)
	}
	return oldValue.UIDValidity, nil
}

// AddUIDValidity adds i to the "UIDValidity" field.
func (m *MailboxMutation) AddUIDValidity(i imap.UID) {
	if m.add_UIDValidity != nil {
		*m.add_UIDValidity += i
	} else {
		m.add_UIDValidity = &i
	}
}

// AddedUIDValidity returns the value that was added to the "UIDValidity" field in this mutation.
func (m *MailboxMutation) AddedUIDValidity() (r imap.UID, exists bool) {
	v := m.add_UIDValidity
	if v == nil {
		return
	}
	return *v, true
}

// ResetUIDValidity resets all changes to the "UIDValidity" field.
func (m *MailboxMutation) ResetUIDValidity() {
	m._UIDValidity = nil
	m.add_UIDValidity = nil
}

// SetSubscribed sets the "Subscribed" field.
func (m *MailboxMutation) SetSubscribed(b bool) {
	m._Subscribed = &b
}

// Subscribed returns the value of the "Subscribed" field in the mutation.
func (m *MailboxMutation) Subscribed() (r bool, exists bool) {
	v := m._Subscribed
	if v == nil {
		return
	}
	return *v, true
}

// OldSubscribed returns the old "Subscribed" field's value of the Mailbox entity.
// If the Mailbox object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MailboxMutation) OldSubscribed(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSubscribed is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSubscribed requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSubscribed: %w", err)
	}
	return oldValue.Subscribed, nil
}

// ResetSubscribed resets all changes to the "Subscribed" field.
func (m *MailboxMutation) ResetSubscribed() {
	m._Subscribed = nil
}

// AddUIDIDs adds the "UIDs" edge to the UID entity by ids.
func (m *MailboxMutation) AddUIDIDs(ids ...int) {
	if m._UIDs == nil {
		m._UIDs = make(map[int]struct{})
	}
	for i := range ids {
		m._UIDs[ids[i]] = struct{}{}
	}
}

// ClearUIDs clears the "UIDs" edge to the UID entity.
func (m *MailboxMutation) ClearUIDs() {
	m.cleared_UIDs = true
}

// UIDsCleared reports if the "UIDs" edge to the UID entity was cleared.
func (m *MailboxMutation) UIDsCleared() bool {
	return m.cleared_UIDs
}

// RemoveUIDIDs removes the "UIDs" edge to the UID entity by IDs.
func (m *MailboxMutation) RemoveUIDIDs(ids ...int) {
	if m.removed_UIDs == nil {
		m.removed_UIDs = make(map[int]struct{})
	}
	for i := range ids {
		delete(m._UIDs, ids[i])
		m.removed_UIDs[ids[i]] = struct{}{}
	}
}

// RemovedUIDs returns the removed IDs of the "UIDs" edge to the UID entity.
func (m *MailboxMutation) RemovedUIDsIDs() (ids []int) {
	for id := range m.removed_UIDs {
		ids = append(ids, id)
	}
	return
}

// UIDsIDs returns the "UIDs" edge IDs in the mutation.
func (m *MailboxMutation) UIDsIDs() (ids []int) {
	for id := range m._UIDs {
		ids = append(ids, id)
	}
	return
}

// ResetUIDs resets all changes to the "UIDs" edge.
func (m *MailboxMutation) ResetUIDs() {
	m._UIDs = nil
	m.cleared_UIDs = false
	m.removed_UIDs = nil
}

// AddFlagIDs adds the "flags" edge to the MailboxFlag entity by ids.
func (m *MailboxMutation) AddFlagIDs(ids ...int) {
	if m.flags == nil {
		m.flags = make(map[int]struct{})
	}
	for i := range ids {
		m.flags[ids[i]] = struct{}{}
	}
}

// ClearFlags clears the "flags" edge to the MailboxFlag entity.
func (m *MailboxMutation) ClearFlags() {
	m.clearedflags = true
}

// FlagsCleared reports if the "flags" edge to the MailboxFlag entity was cleared.
func (m *MailboxMutation) FlagsCleared() bool {
	return m.clearedflags
}

// RemoveFlagIDs removes the "flags" edge to the MailboxFlag entity by IDs.
func (m *MailboxMutation) RemoveFlagIDs(ids ...int) {
	if m.removedflags == nil {
		m.removedflags = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.flags, ids[i])
		m.removedflags[ids[i]] = struct{}{}
	}
}

// RemovedFlags returns the removed IDs of the "flags" edge to the MailboxFlag entity.
func (m *MailboxMutation) RemovedFlagsIDs() (ids []int) {
	for id := range m.removedflags {
		ids = append(ids, id)
	}
	return
}

// FlagsIDs returns the "flags" edge IDs in the mutation.
func (m *MailboxMutation) FlagsIDs() (ids []int) {
	for id := range m.flags {
		ids = append(ids, id)
	}
	return
}

// ResetFlags resets all changes to the "flags" edge.
func (m *MailboxMutation) ResetFlags() {
	m.flags = nil
	m.clearedflags = false
	m.removedflags = nil
}

// AddPermanentFlagIDs adds the "permanent_flags" edge to the MailboxPermFlag entity by ids.
func (m *MailboxMutation) AddPermanentFlagIDs(ids ...int) {
	if m.permanent_flags == nil {
		m.permanent_flags = make(map[int]struct{})
	}
	for i := range ids {
		m.permanent_flags[ids[i]] = struct{}{}
	}
}

// ClearPermanentFlags clears the "permanent_flags" edge to the MailboxPermFlag entity.
func (m *MailboxMutation) ClearPermanentFlags() {
	m.clearedpermanent_flags = true
}

// PermanentFlagsCleared reports if the "permanent_flags" edge to the MailboxPermFlag entity was cleared.
func (m *MailboxMutation) PermanentFlagsCleared() bool {
	return m.clearedpermanent_flags
}

// RemovePermanentFlagIDs removes the "permanent_flags" edge to the MailboxPermFlag entity by IDs.
func (m *MailboxMutation) RemovePermanentFlagIDs(ids ...int) {
	if m.removedpermanent_flags == nil {
		m.removedpermanent_flags = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.permanent_flags, ids[i])
		m.removedpermanent_flags[ids[i]] = struct{}{}
	}
}

// RemovedPermanentFlags returns the removed IDs of the "permanent_flags" edge to the MailboxPermFlag entity.
func (m *MailboxMutation) RemovedPermanentFlagsIDs() (ids []int) {
	for id := range m.removedpermanent_flags {
		ids = append(ids, id)
	}
	return
}

// PermanentFlagsIDs returns the "permanent_flags" edge IDs in the mutation.
func (m *MailboxMutation) PermanentFlagsIDs() (ids []int) {
	for id := range m.permanent_flags {
		ids = append(ids, id)
	}
	return
}

// ResetPermanentFlags resets all changes to the "permanent_flags" edge.
func (m *MailboxMutation) ResetPermanentFlags() {
	m.permanent_flags = nil
	m.clearedpermanent_flags = false
	m.removedpermanent_flags = nil
}

// AddAttributeIDs adds the "attributes" edge to the MailboxAttr entity by ids.
func (m *MailboxMutation) AddAttributeIDs(ids ...int) {
	if m.attributes == nil {
		m.attributes = make(map[int]struct{})
	}
	for i := range ids {
		m.attributes[ids[i]] = struct{}{}
	}
}

// ClearAttributes clears the "attributes" edge to the MailboxAttr entity.
func (m *MailboxMutation) ClearAttributes() {
	m.clearedattributes = true
}

// AttributesCleared reports if the "attributes" edge to the MailboxAttr entity was cleared.
func (m *MailboxMutation) AttributesCleared() bool {
	return m.clearedattributes
}

// RemoveAttributeIDs removes the "attributes" edge to the MailboxAttr entity by IDs.
func (m *MailboxMutation) RemoveAttributeIDs(ids ...int) {
	if m.removedattributes == nil {
		m.removedattributes = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.attributes, ids[i])
		m.removedattributes[ids[i]] = struct{}{}
	}
}

// RemovedAttributes returns the removed IDs of the "attributes" edge to the MailboxAttr entity.
func (m *MailboxMutation) RemovedAttributesIDs() (ids []int) {
	for id := range m.removedattributes {
		ids = append(ids, id)
	}
	return
}

// AttributesIDs returns the "attributes" edge IDs in the mutation.
func (m *MailboxMutation) AttributesIDs() (ids []int) {
	for id := range m.attributes {
		ids = append(ids, id)
	}
	return
}

// ResetAttributes resets all changes to the "attributes" edge.
func (m *MailboxMutation) ResetAttributes() {
	m.attributes = nil
	m.clearedattributes = false
	m.removedattributes = nil
}

// Where appends a list predicates to the MailboxMutation builder.
func (m *MailboxMutation) Where(ps ...predicate.Mailbox) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *MailboxMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Mailbox).
func (m *MailboxMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *MailboxMutation) Fields() []string {
	fields := make([]string, 0, 5)
	if m._RemoteID != nil {
		fields = append(fields, mailbox.FieldRemoteID)
	}
	if m._Name != nil {
		fields = append(fields, mailbox.FieldName)
	}
	if m._UIDNext != nil {
		fields = append(fields, mailbox.FieldUIDNext)
	}
	if m._UIDValidity != nil {
		fields = append(fields, mailbox.FieldUIDValidity)
	}
	if m._Subscribed != nil {
		fields = append(fields, mailbox.FieldSubscribed)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *MailboxMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case mailbox.FieldRemoteID:
		return m.RemoteID()
	case mailbox.FieldName:
		return m.Name()
	case mailbox.FieldUIDNext:
		return m.UIDNext()
	case mailbox.FieldUIDValidity:
		return m.UIDValidity()
	case mailbox.FieldSubscribed:
		return m.Subscribed()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *MailboxMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case mailbox.FieldRemoteID:
		return m.OldRemoteID(ctx)
	case mailbox.FieldName:
		return m.OldName(ctx)
	case mailbox.FieldUIDNext:
		return m.OldUIDNext(ctx)
	case mailbox.FieldUIDValidity:
		return m.OldUIDValidity(ctx)
	case mailbox.FieldSubscribed:
		return m.OldSubscribed(ctx)
	}
	return nil, fmt.Errorf("unknown Mailbox field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MailboxMutation) SetField(name string, value ent.Value) error {
	switch name {
	case mailbox.FieldRemoteID:
		v, ok := value.(imap.MailboxID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRemoteID(v)
		return nil
	case mailbox.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case mailbox.FieldUIDNext:
		v, ok := value.(imap.UID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUIDNext(v)
		return nil
	case mailbox.FieldUIDValidity:
		v, ok := value.(imap.UID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUIDValidity(v)
		return nil
	case mailbox.FieldSubscribed:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSubscribed(v)
		return nil
	}
	return fmt.Errorf("unknown Mailbox field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *MailboxMutation) AddedFields() []string {
	var fields []string
	if m.add_UIDNext != nil {
		fields = append(fields, mailbox.FieldUIDNext)
	}
	if m.add_UIDValidity != nil {
		fields = append(fields, mailbox.FieldUIDValidity)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *MailboxMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case mailbox.FieldUIDNext:
		return m.AddedUIDNext()
	case mailbox.FieldUIDValidity:
		return m.AddedUIDValidity()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MailboxMutation) AddField(name string, value ent.Value) error {
	switch name {
	case mailbox.FieldUIDNext:
		v, ok := value.(imap.UID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddUIDNext(v)
		return nil
	case mailbox.FieldUIDValidity:
		v, ok := value.(imap.UID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddUIDValidity(v)
		return nil
	}
	return fmt.Errorf("unknown Mailbox numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *MailboxMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(mailbox.FieldRemoteID) {
		fields = append(fields, mailbox.FieldRemoteID)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *MailboxMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *MailboxMutation) ClearField(name string) error {
	switch name {
	case mailbox.FieldRemoteID:
		m.ClearRemoteID()
		return nil
	}
	return fmt.Errorf("unknown Mailbox nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *MailboxMutation) ResetField(name string) error {
	switch name {
	case mailbox.FieldRemoteID:
		m.ResetRemoteID()
		return nil
	case mailbox.FieldName:
		m.ResetName()
		return nil
	case mailbox.FieldUIDNext:
		m.ResetUIDNext()
		return nil
	case mailbox.FieldUIDValidity:
		m.ResetUIDValidity()
		return nil
	case mailbox.FieldSubscribed:
		m.ResetSubscribed()
		return nil
	}
	return fmt.Errorf("unknown Mailbox field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *MailboxMutation) AddedEdges() []string {
	edges := make([]string, 0, 4)
	if m._UIDs != nil {
		edges = append(edges, mailbox.EdgeUIDs)
	}
	if m.flags != nil {
		edges = append(edges, mailbox.EdgeFlags)
	}
	if m.permanent_flags != nil {
		edges = append(edges, mailbox.EdgePermanentFlags)
	}
	if m.attributes != nil {
		edges = append(edges, mailbox.EdgeAttributes)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *MailboxMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case mailbox.EdgeUIDs:
		ids := make([]ent.Value, 0, len(m._UIDs))
		for id := range m._UIDs {
			ids = append(ids, id)
		}
		return ids
	case mailbox.EdgeFlags:
		ids := make([]ent.Value, 0, len(m.flags))
		for id := range m.flags {
			ids = append(ids, id)
		}
		return ids
	case mailbox.EdgePermanentFlags:
		ids := make([]ent.Value, 0, len(m.permanent_flags))
		for id := range m.permanent_flags {
			ids = append(ids, id)
		}
		return ids
	case mailbox.EdgeAttributes:
		ids := make([]ent.Value, 0, len(m.attributes))
		for id := range m.attributes {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *MailboxMutation) RemovedEdges() []string {
	edges := make([]string, 0, 4)
	if m.removed_UIDs != nil {
		edges = append(edges, mailbox.EdgeUIDs)
	}
	if m.removedflags != nil {
		edges = append(edges, mailbox.EdgeFlags)
	}
	if m.removedpermanent_flags != nil {
		edges = append(edges, mailbox.EdgePermanentFlags)
	}
	if m.removedattributes != nil {
		edges = append(edges, mailbox.EdgeAttributes)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *MailboxMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case mailbox.EdgeUIDs:
		ids := make([]ent.Value, 0, len(m.removed_UIDs))
		for id := range m.removed_UIDs {
			ids = append(ids, id)
		}
		return ids
	case mailbox.EdgeFlags:
		ids := make([]ent.Value, 0, len(m.removedflags))
		for id := range m.removedflags {
			ids = append(ids, id)
		}
		return ids
	case mailbox.EdgePermanentFlags:
		ids := make([]ent.Value, 0, len(m.removedpermanent_flags))
		for id := range m.removedpermanent_flags {
			ids = append(ids, id)
		}
		return ids
	case mailbox.EdgeAttributes:
		ids := make([]ent.Value, 0, len(m.removedattributes))
		for id := range m.removedattributes {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *MailboxMutation) ClearedEdges() []string {
	edges := make([]string, 0, 4)
	if m.cleared_UIDs {
		edges = append(edges, mailbox.EdgeUIDs)
	}
	if m.clearedflags {
		edges = append(edges, mailbox.EdgeFlags)
	}
	if m.clearedpermanent_flags {
		edges = append(edges, mailbox.EdgePermanentFlags)
	}
	if m.clearedattributes {
		edges = append(edges, mailbox.EdgeAttributes)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *MailboxMutation) EdgeCleared(name string) bool {
	switch name {
	case mailbox.EdgeUIDs:
		return m.cleared_UIDs
	case mailbox.EdgeFlags:
		return m.clearedflags
	case mailbox.EdgePermanentFlags:
		return m.clearedpermanent_flags
	case mailbox.EdgeAttributes:
		return m.clearedattributes
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *MailboxMutation) ClearEdge(name string) error {
	switch name {
	}
	return fmt.Errorf("unknown Mailbox unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *MailboxMutation) ResetEdge(name string) error {
	switch name {
	case mailbox.EdgeUIDs:
		m.ResetUIDs()
		return nil
	case mailbox.EdgeFlags:
		m.ResetFlags()
		return nil
	case mailbox.EdgePermanentFlags:
		m.ResetPermanentFlags()
		return nil
	case mailbox.EdgeAttributes:
		m.ResetAttributes()
		return nil
	}
	return fmt.Errorf("unknown Mailbox edge %s", name)
}

// MailboxAttrMutation represents an operation that mutates the MailboxAttr nodes in the graph.
type MailboxAttrMutation struct {
	config
	op            Op
	typ           string
	id            *int
	_Value        *string
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*MailboxAttr, error)
	predicates    []predicate.MailboxAttr
}

var _ ent.Mutation = (*MailboxAttrMutation)(nil)

// mailboxattrOption allows management of the mutation configuration using functional options.
type mailboxattrOption func(*MailboxAttrMutation)

// newMailboxAttrMutation creates new mutation for the MailboxAttr entity.
func newMailboxAttrMutation(c config, op Op, opts ...mailboxattrOption) *MailboxAttrMutation {
	m := &MailboxAttrMutation{
		config:        c,
		op:            op,
		typ:           TypeMailboxAttr,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withMailboxAttrID sets the ID field of the mutation.
func withMailboxAttrID(id int) mailboxattrOption {
	return func(m *MailboxAttrMutation) {
		var (
			err   error
			once  sync.Once
			value *MailboxAttr
		)
		m.oldValue = func(ctx context.Context) (*MailboxAttr, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().MailboxAttr.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withMailboxAttr sets the old MailboxAttr of the mutation.
func withMailboxAttr(node *MailboxAttr) mailboxattrOption {
	return func(m *MailboxAttrMutation) {
		m.oldValue = func(context.Context) (*MailboxAttr, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m MailboxAttrMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m MailboxAttrMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *MailboxAttrMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *MailboxAttrMutation) IDs(ctx context.Context) ([]int, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []int{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().MailboxAttr.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetValue sets the "Value" field.
func (m *MailboxAttrMutation) SetValue(s string) {
	m._Value = &s
}

// Value returns the value of the "Value" field in the mutation.
func (m *MailboxAttrMutation) Value() (r string, exists bool) {
	v := m._Value
	if v == nil {
		return
	}
	return *v, true
}

// OldValue returns the old "Value" field's value of the MailboxAttr entity.
// If the MailboxAttr object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MailboxAttrMutation) OldValue(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldValue is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldValue requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldValue: %w", err)
	}
	return oldValue.Value, nil
}

// ResetValue resets all changes to the "Value" field.
func (m *MailboxAttrMutation) ResetValue() {
	m._Value = nil
}

// Where appends a list predicates to the MailboxAttrMutation builder.
func (m *MailboxAttrMutation) Where(ps ...predicate.MailboxAttr) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *MailboxAttrMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (MailboxAttr).
func (m *MailboxAttrMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *MailboxAttrMutation) Fields() []string {
	fields := make([]string, 0, 1)
	if m._Value != nil {
		fields = append(fields, mailboxattr.FieldValue)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *MailboxAttrMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case mailboxattr.FieldValue:
		return m.Value()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *MailboxAttrMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case mailboxattr.FieldValue:
		return m.OldValue(ctx)
	}
	return nil, fmt.Errorf("unknown MailboxAttr field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MailboxAttrMutation) SetField(name string, value ent.Value) error {
	switch name {
	case mailboxattr.FieldValue:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetValue(v)
		return nil
	}
	return fmt.Errorf("unknown MailboxAttr field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *MailboxAttrMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *MailboxAttrMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MailboxAttrMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown MailboxAttr numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *MailboxAttrMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *MailboxAttrMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *MailboxAttrMutation) ClearField(name string) error {
	return fmt.Errorf("unknown MailboxAttr nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *MailboxAttrMutation) ResetField(name string) error {
	switch name {
	case mailboxattr.FieldValue:
		m.ResetValue()
		return nil
	}
	return fmt.Errorf("unknown MailboxAttr field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *MailboxAttrMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *MailboxAttrMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *MailboxAttrMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *MailboxAttrMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *MailboxAttrMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *MailboxAttrMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *MailboxAttrMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown MailboxAttr unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *MailboxAttrMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown MailboxAttr edge %s", name)
}

// MailboxFlagMutation represents an operation that mutates the MailboxFlag nodes in the graph.
type MailboxFlagMutation struct {
	config
	op            Op
	typ           string
	id            *int
	_Value        *string
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*MailboxFlag, error)
	predicates    []predicate.MailboxFlag
}

var _ ent.Mutation = (*MailboxFlagMutation)(nil)

// mailboxflagOption allows management of the mutation configuration using functional options.
type mailboxflagOption func(*MailboxFlagMutation)

// newMailboxFlagMutation creates new mutation for the MailboxFlag entity.
func newMailboxFlagMutation(c config, op Op, opts ...mailboxflagOption) *MailboxFlagMutation {
	m := &MailboxFlagMutation{
		config:        c,
		op:            op,
		typ:           TypeMailboxFlag,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withMailboxFlagID sets the ID field of the mutation.
func withMailboxFlagID(id int) mailboxflagOption {
	return func(m *MailboxFlagMutation) {
		var (
			err   error
			once  sync.Once
			value *MailboxFlag
		)
		m.oldValue = func(ctx context.Context) (*MailboxFlag, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().MailboxFlag.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withMailboxFlag sets the old MailboxFlag of the mutation.
func withMailboxFlag(node *MailboxFlag) mailboxflagOption {
	return func(m *MailboxFlagMutation) {
		m.oldValue = func(context.Context) (*MailboxFlag, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m MailboxFlagMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m MailboxFlagMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *MailboxFlagMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *MailboxFlagMutation) IDs(ctx context.Context) ([]int, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []int{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().MailboxFlag.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetValue sets the "Value" field.
func (m *MailboxFlagMutation) SetValue(s string) {
	m._Value = &s
}

// Value returns the value of the "Value" field in the mutation.
func (m *MailboxFlagMutation) Value() (r string, exists bool) {
	v := m._Value
	if v == nil {
		return
	}
	return *v, true
}

// OldValue returns the old "Value" field's value of the MailboxFlag entity.
// If the MailboxFlag object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MailboxFlagMutation) OldValue(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldValue is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldValue requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldValue: %w", err)
	}
	return oldValue.Value, nil
}

// ResetValue resets all changes to the "Value" field.
func (m *MailboxFlagMutation) ResetValue() {
	m._Value = nil
}

// Where appends a list predicates to the MailboxFlagMutation builder.
func (m *MailboxFlagMutation) Where(ps ...predicate.MailboxFlag) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *MailboxFlagMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (MailboxFlag).
func (m *MailboxFlagMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *MailboxFlagMutation) Fields() []string {
	fields := make([]string, 0, 1)
	if m._Value != nil {
		fields = append(fields, mailboxflag.FieldValue)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *MailboxFlagMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case mailboxflag.FieldValue:
		return m.Value()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *MailboxFlagMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case mailboxflag.FieldValue:
		return m.OldValue(ctx)
	}
	return nil, fmt.Errorf("unknown MailboxFlag field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MailboxFlagMutation) SetField(name string, value ent.Value) error {
	switch name {
	case mailboxflag.FieldValue:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetValue(v)
		return nil
	}
	return fmt.Errorf("unknown MailboxFlag field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *MailboxFlagMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *MailboxFlagMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MailboxFlagMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown MailboxFlag numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *MailboxFlagMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *MailboxFlagMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *MailboxFlagMutation) ClearField(name string) error {
	return fmt.Errorf("unknown MailboxFlag nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *MailboxFlagMutation) ResetField(name string) error {
	switch name {
	case mailboxflag.FieldValue:
		m.ResetValue()
		return nil
	}
	return fmt.Errorf("unknown MailboxFlag field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *MailboxFlagMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *MailboxFlagMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *MailboxFlagMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *MailboxFlagMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *MailboxFlagMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *MailboxFlagMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *MailboxFlagMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown MailboxFlag unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *MailboxFlagMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown MailboxFlag edge %s", name)
}

// MailboxPermFlagMutation represents an operation that mutates the MailboxPermFlag nodes in the graph.
type MailboxPermFlagMutation struct {
	config
	op            Op
	typ           string
	id            *int
	_Value        *string
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*MailboxPermFlag, error)
	predicates    []predicate.MailboxPermFlag
}

var _ ent.Mutation = (*MailboxPermFlagMutation)(nil)

// mailboxpermflagOption allows management of the mutation configuration using functional options.
type mailboxpermflagOption func(*MailboxPermFlagMutation)

// newMailboxPermFlagMutation creates new mutation for the MailboxPermFlag entity.
func newMailboxPermFlagMutation(c config, op Op, opts ...mailboxpermflagOption) *MailboxPermFlagMutation {
	m := &MailboxPermFlagMutation{
		config:        c,
		op:            op,
		typ:           TypeMailboxPermFlag,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withMailboxPermFlagID sets the ID field of the mutation.
func withMailboxPermFlagID(id int) mailboxpermflagOption {
	return func(m *MailboxPermFlagMutation) {
		var (
			err   error
			once  sync.Once
			value *MailboxPermFlag
		)
		m.oldValue = func(ctx context.Context) (*MailboxPermFlag, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().MailboxPermFlag.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withMailboxPermFlag sets the old MailboxPermFlag of the mutation.
func withMailboxPermFlag(node *MailboxPermFlag) mailboxpermflagOption {
	return func(m *MailboxPermFlagMutation) {
		m.oldValue = func(context.Context) (*MailboxPermFlag, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m MailboxPermFlagMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m MailboxPermFlagMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *MailboxPermFlagMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *MailboxPermFlagMutation) IDs(ctx context.Context) ([]int, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []int{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().MailboxPermFlag.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetValue sets the "Value" field.
func (m *MailboxPermFlagMutation) SetValue(s string) {
	m._Value = &s
}

// Value returns the value of the "Value" field in the mutation.
func (m *MailboxPermFlagMutation) Value() (r string, exists bool) {
	v := m._Value
	if v == nil {
		return
	}
	return *v, true
}

// OldValue returns the old "Value" field's value of the MailboxPermFlag entity.
// If the MailboxPermFlag object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MailboxPermFlagMutation) OldValue(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldValue is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldValue requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldValue: %w", err)
	}
	return oldValue.Value, nil
}

// ResetValue resets all changes to the "Value" field.
func (m *MailboxPermFlagMutation) ResetValue() {
	m._Value = nil
}

// Where appends a list predicates to the MailboxPermFlagMutation builder.
func (m *MailboxPermFlagMutation) Where(ps ...predicate.MailboxPermFlag) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *MailboxPermFlagMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (MailboxPermFlag).
func (m *MailboxPermFlagMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *MailboxPermFlagMutation) Fields() []string {
	fields := make([]string, 0, 1)
	if m._Value != nil {
		fields = append(fields, mailboxpermflag.FieldValue)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *MailboxPermFlagMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case mailboxpermflag.FieldValue:
		return m.Value()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *MailboxPermFlagMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case mailboxpermflag.FieldValue:
		return m.OldValue(ctx)
	}
	return nil, fmt.Errorf("unknown MailboxPermFlag field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MailboxPermFlagMutation) SetField(name string, value ent.Value) error {
	switch name {
	case mailboxpermflag.FieldValue:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetValue(v)
		return nil
	}
	return fmt.Errorf("unknown MailboxPermFlag field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *MailboxPermFlagMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *MailboxPermFlagMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MailboxPermFlagMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown MailboxPermFlag numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *MailboxPermFlagMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *MailboxPermFlagMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *MailboxPermFlagMutation) ClearField(name string) error {
	return fmt.Errorf("unknown MailboxPermFlag nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *MailboxPermFlagMutation) ResetField(name string) error {
	switch name {
	case mailboxpermflag.FieldValue:
		m.ResetValue()
		return nil
	}
	return fmt.Errorf("unknown MailboxPermFlag field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *MailboxPermFlagMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *MailboxPermFlagMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *MailboxPermFlagMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *MailboxPermFlagMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *MailboxPermFlagMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *MailboxPermFlagMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *MailboxPermFlagMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown MailboxPermFlag unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *MailboxPermFlagMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown MailboxPermFlag edge %s", name)
}

// MessageMutation represents an operation that mutates the Message nodes in the graph.
type MessageMutation struct {
	config
	op             Op
	typ            string
	id             *imap.InternalMessageID
	_RemoteID      *imap.MessageID
	_Date          *time.Time
	_Size          *int
	add_Size       *int
	_Body          *string
	_BodyStructure *string
	_Envelope      *string
	_Deleted       *bool
	clearedFields  map[string]struct{}
	flags          map[int]struct{}
	removedflags   map[int]struct{}
	clearedflags   bool
	_UIDs          map[int]struct{}
	removed_UIDs   map[int]struct{}
	cleared_UIDs   bool
	done           bool
	oldValue       func(context.Context) (*Message, error)
	predicates     []predicate.Message
}

var _ ent.Mutation = (*MessageMutation)(nil)

// messageOption allows management of the mutation configuration using functional options.
type messageOption func(*MessageMutation)

// newMessageMutation creates new mutation for the Message entity.
func newMessageMutation(c config, op Op, opts ...messageOption) *MessageMutation {
	m := &MessageMutation{
		config:        c,
		op:            op,
		typ:           TypeMessage,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withMessageID sets the ID field of the mutation.
func withMessageID(id imap.InternalMessageID) messageOption {
	return func(m *MessageMutation) {
		var (
			err   error
			once  sync.Once
			value *Message
		)
		m.oldValue = func(ctx context.Context) (*Message, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Message.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withMessage sets the old Message of the mutation.
func withMessage(node *Message) messageOption {
	return func(m *MessageMutation) {
		m.oldValue = func(context.Context) (*Message, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m MessageMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m MessageMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Message entities.
func (m *MessageMutation) SetID(id imap.InternalMessageID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *MessageMutation) ID() (id imap.InternalMessageID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *MessageMutation) IDs(ctx context.Context) ([]imap.InternalMessageID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []imap.InternalMessageID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Message.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetRemoteID sets the "RemoteID" field.
func (m *MessageMutation) SetRemoteID(ii imap.MessageID) {
	m._RemoteID = &ii
}

// RemoteID returns the value of the "RemoteID" field in the mutation.
func (m *MessageMutation) RemoteID() (r imap.MessageID, exists bool) {
	v := m._RemoteID
	if v == nil {
		return
	}
	return *v, true
}

// OldRemoteID returns the old "RemoteID" field's value of the Message entity.
// If the Message object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MessageMutation) OldRemoteID(ctx context.Context) (v imap.MessageID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldRemoteID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldRemoteID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRemoteID: %w", err)
	}
	return oldValue.RemoteID, nil
}

// ClearRemoteID clears the value of the "RemoteID" field.
func (m *MessageMutation) ClearRemoteID() {
	m._RemoteID = nil
	m.clearedFields[message.FieldRemoteID] = struct{}{}
}

// RemoteIDCleared returns if the "RemoteID" field was cleared in this mutation.
func (m *MessageMutation) RemoteIDCleared() bool {
	_, ok := m.clearedFields[message.FieldRemoteID]
	return ok
}

// ResetRemoteID resets all changes to the "RemoteID" field.
func (m *MessageMutation) ResetRemoteID() {
	m._RemoteID = nil
	delete(m.clearedFields, message.FieldRemoteID)
}

// SetDate sets the "Date" field.
func (m *MessageMutation) SetDate(t time.Time) {
	m._Date = &t
}

// Date returns the value of the "Date" field in the mutation.
func (m *MessageMutation) Date() (r time.Time, exists bool) {
	v := m._Date
	if v == nil {
		return
	}
	return *v, true
}

// OldDate returns the old "Date" field's value of the Message entity.
// If the Message object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MessageMutation) OldDate(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldDate is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldDate requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDate: %w", err)
	}
	return oldValue.Date, nil
}

// ResetDate resets all changes to the "Date" field.
func (m *MessageMutation) ResetDate() {
	m._Date = nil
}

// SetSize sets the "Size" field.
func (m *MessageMutation) SetSize(i int) {
	m._Size = &i
	m.add_Size = nil
}

// Size returns the value of the "Size" field in the mutation.
func (m *MessageMutation) Size() (r int, exists bool) {
	v := m._Size
	if v == nil {
		return
	}
	return *v, true
}

// OldSize returns the old "Size" field's value of the Message entity.
// If the Message object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MessageMutation) OldSize(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSize is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSize requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSize: %w", err)
	}
	return oldValue.Size, nil
}

// AddSize adds i to the "Size" field.
func (m *MessageMutation) AddSize(i int) {
	if m.add_Size != nil {
		*m.add_Size += i
	} else {
		m.add_Size = &i
	}
}

// AddedSize returns the value that was added to the "Size" field in this mutation.
func (m *MessageMutation) AddedSize() (r int, exists bool) {
	v := m.add_Size
	if v == nil {
		return
	}
	return *v, true
}

// ResetSize resets all changes to the "Size" field.
func (m *MessageMutation) ResetSize() {
	m._Size = nil
	m.add_Size = nil
}

// SetBody sets the "Body" field.
func (m *MessageMutation) SetBody(s string) {
	m._Body = &s
}

// Body returns the value of the "Body" field in the mutation.
func (m *MessageMutation) Body() (r string, exists bool) {
	v := m._Body
	if v == nil {
		return
	}
	return *v, true
}

// OldBody returns the old "Body" field's value of the Message entity.
// If the Message object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MessageMutation) OldBody(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldBody is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldBody requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldBody: %w", err)
	}
	return oldValue.Body, nil
}

// ResetBody resets all changes to the "Body" field.
func (m *MessageMutation) ResetBody() {
	m._Body = nil
}

// SetBodyStructure sets the "BodyStructure" field.
func (m *MessageMutation) SetBodyStructure(s string) {
	m._BodyStructure = &s
}

// BodyStructure returns the value of the "BodyStructure" field in the mutation.
func (m *MessageMutation) BodyStructure() (r string, exists bool) {
	v := m._BodyStructure
	if v == nil {
		return
	}
	return *v, true
}

// OldBodyStructure returns the old "BodyStructure" field's value of the Message entity.
// If the Message object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MessageMutation) OldBodyStructure(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldBodyStructure is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldBodyStructure requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldBodyStructure: %w", err)
	}
	return oldValue.BodyStructure, nil
}

// ResetBodyStructure resets all changes to the "BodyStructure" field.
func (m *MessageMutation) ResetBodyStructure() {
	m._BodyStructure = nil
}

// SetEnvelope sets the "Envelope" field.
func (m *MessageMutation) SetEnvelope(s string) {
	m._Envelope = &s
}

// Envelope returns the value of the "Envelope" field in the mutation.
func (m *MessageMutation) Envelope() (r string, exists bool) {
	v := m._Envelope
	if v == nil {
		return
	}
	return *v, true
}

// OldEnvelope returns the old "Envelope" field's value of the Message entity.
// If the Message object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MessageMutation) OldEnvelope(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldEnvelope is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldEnvelope requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldEnvelope: %w", err)
	}
	return oldValue.Envelope, nil
}

// ResetEnvelope resets all changes to the "Envelope" field.
func (m *MessageMutation) ResetEnvelope() {
	m._Envelope = nil
}

// SetDeleted sets the "Deleted" field.
func (m *MessageMutation) SetDeleted(b bool) {
	m._Deleted = &b
}

// Deleted returns the value of the "Deleted" field in the mutation.
func (m *MessageMutation) Deleted() (r bool, exists bool) {
	v := m._Deleted
	if v == nil {
		return
	}
	return *v, true
}

// OldDeleted returns the old "Deleted" field's value of the Message entity.
// If the Message object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MessageMutation) OldDeleted(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldDeleted is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldDeleted requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDeleted: %w", err)
	}
	return oldValue.Deleted, nil
}

// ResetDeleted resets all changes to the "Deleted" field.
func (m *MessageMutation) ResetDeleted() {
	m._Deleted = nil
}

// AddFlagIDs adds the "flags" edge to the MessageFlag entity by ids.
func (m *MessageMutation) AddFlagIDs(ids ...int) {
	if m.flags == nil {
		m.flags = make(map[int]struct{})
	}
	for i := range ids {
		m.flags[ids[i]] = struct{}{}
	}
}

// ClearFlags clears the "flags" edge to the MessageFlag entity.
func (m *MessageMutation) ClearFlags() {
	m.clearedflags = true
}

// FlagsCleared reports if the "flags" edge to the MessageFlag entity was cleared.
func (m *MessageMutation) FlagsCleared() bool {
	return m.clearedflags
}

// RemoveFlagIDs removes the "flags" edge to the MessageFlag entity by IDs.
func (m *MessageMutation) RemoveFlagIDs(ids ...int) {
	if m.removedflags == nil {
		m.removedflags = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.flags, ids[i])
		m.removedflags[ids[i]] = struct{}{}
	}
}

// RemovedFlags returns the removed IDs of the "flags" edge to the MessageFlag entity.
func (m *MessageMutation) RemovedFlagsIDs() (ids []int) {
	for id := range m.removedflags {
		ids = append(ids, id)
	}
	return
}

// FlagsIDs returns the "flags" edge IDs in the mutation.
func (m *MessageMutation) FlagsIDs() (ids []int) {
	for id := range m.flags {
		ids = append(ids, id)
	}
	return
}

// ResetFlags resets all changes to the "flags" edge.
func (m *MessageMutation) ResetFlags() {
	m.flags = nil
	m.clearedflags = false
	m.removedflags = nil
}

// AddUIDIDs adds the "UIDs" edge to the UID entity by ids.
func (m *MessageMutation) AddUIDIDs(ids ...int) {
	if m._UIDs == nil {
		m._UIDs = make(map[int]struct{})
	}
	for i := range ids {
		m._UIDs[ids[i]] = struct{}{}
	}
}

// ClearUIDs clears the "UIDs" edge to the UID entity.
func (m *MessageMutation) ClearUIDs() {
	m.cleared_UIDs = true
}

// UIDsCleared reports if the "UIDs" edge to the UID entity was cleared.
func (m *MessageMutation) UIDsCleared() bool {
	return m.cleared_UIDs
}

// RemoveUIDIDs removes the "UIDs" edge to the UID entity by IDs.
func (m *MessageMutation) RemoveUIDIDs(ids ...int) {
	if m.removed_UIDs == nil {
		m.removed_UIDs = make(map[int]struct{})
	}
	for i := range ids {
		delete(m._UIDs, ids[i])
		m.removed_UIDs[ids[i]] = struct{}{}
	}
}

// RemovedUIDs returns the removed IDs of the "UIDs" edge to the UID entity.
func (m *MessageMutation) RemovedUIDsIDs() (ids []int) {
	for id := range m.removed_UIDs {
		ids = append(ids, id)
	}
	return
}

// UIDsIDs returns the "UIDs" edge IDs in the mutation.
func (m *MessageMutation) UIDsIDs() (ids []int) {
	for id := range m._UIDs {
		ids = append(ids, id)
	}
	return
}

// ResetUIDs resets all changes to the "UIDs" edge.
func (m *MessageMutation) ResetUIDs() {
	m._UIDs = nil
	m.cleared_UIDs = false
	m.removed_UIDs = nil
}

// Where appends a list predicates to the MessageMutation builder.
func (m *MessageMutation) Where(ps ...predicate.Message) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *MessageMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Message).
func (m *MessageMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *MessageMutation) Fields() []string {
	fields := make([]string, 0, 7)
	if m._RemoteID != nil {
		fields = append(fields, message.FieldRemoteID)
	}
	if m._Date != nil {
		fields = append(fields, message.FieldDate)
	}
	if m._Size != nil {
		fields = append(fields, message.FieldSize)
	}
	if m._Body != nil {
		fields = append(fields, message.FieldBody)
	}
	if m._BodyStructure != nil {
		fields = append(fields, message.FieldBodyStructure)
	}
	if m._Envelope != nil {
		fields = append(fields, message.FieldEnvelope)
	}
	if m._Deleted != nil {
		fields = append(fields, message.FieldDeleted)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *MessageMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case message.FieldRemoteID:
		return m.RemoteID()
	case message.FieldDate:
		return m.Date()
	case message.FieldSize:
		return m.Size()
	case message.FieldBody:
		return m.Body()
	case message.FieldBodyStructure:
		return m.BodyStructure()
	case message.FieldEnvelope:
		return m.Envelope()
	case message.FieldDeleted:
		return m.Deleted()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *MessageMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case message.FieldRemoteID:
		return m.OldRemoteID(ctx)
	case message.FieldDate:
		return m.OldDate(ctx)
	case message.FieldSize:
		return m.OldSize(ctx)
	case message.FieldBody:
		return m.OldBody(ctx)
	case message.FieldBodyStructure:
		return m.OldBodyStructure(ctx)
	case message.FieldEnvelope:
		return m.OldEnvelope(ctx)
	case message.FieldDeleted:
		return m.OldDeleted(ctx)
	}
	return nil, fmt.Errorf("unknown Message field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MessageMutation) SetField(name string, value ent.Value) error {
	switch name {
	case message.FieldRemoteID:
		v, ok := value.(imap.MessageID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRemoteID(v)
		return nil
	case message.FieldDate:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDate(v)
		return nil
	case message.FieldSize:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSize(v)
		return nil
	case message.FieldBody:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetBody(v)
		return nil
	case message.FieldBodyStructure:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetBodyStructure(v)
		return nil
	case message.FieldEnvelope:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetEnvelope(v)
		return nil
	case message.FieldDeleted:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDeleted(v)
		return nil
	}
	return fmt.Errorf("unknown Message field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *MessageMutation) AddedFields() []string {
	var fields []string
	if m.add_Size != nil {
		fields = append(fields, message.FieldSize)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *MessageMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case message.FieldSize:
		return m.AddedSize()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MessageMutation) AddField(name string, value ent.Value) error {
	switch name {
	case message.FieldSize:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddSize(v)
		return nil
	}
	return fmt.Errorf("unknown Message numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *MessageMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(message.FieldRemoteID) {
		fields = append(fields, message.FieldRemoteID)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *MessageMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *MessageMutation) ClearField(name string) error {
	switch name {
	case message.FieldRemoteID:
		m.ClearRemoteID()
		return nil
	}
	return fmt.Errorf("unknown Message nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *MessageMutation) ResetField(name string) error {
	switch name {
	case message.FieldRemoteID:
		m.ResetRemoteID()
		return nil
	case message.FieldDate:
		m.ResetDate()
		return nil
	case message.FieldSize:
		m.ResetSize()
		return nil
	case message.FieldBody:
		m.ResetBody()
		return nil
	case message.FieldBodyStructure:
		m.ResetBodyStructure()
		return nil
	case message.FieldEnvelope:
		m.ResetEnvelope()
		return nil
	case message.FieldDeleted:
		m.ResetDeleted()
		return nil
	}
	return fmt.Errorf("unknown Message field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *MessageMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.flags != nil {
		edges = append(edges, message.EdgeFlags)
	}
	if m._UIDs != nil {
		edges = append(edges, message.EdgeUIDs)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *MessageMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case message.EdgeFlags:
		ids := make([]ent.Value, 0, len(m.flags))
		for id := range m.flags {
			ids = append(ids, id)
		}
		return ids
	case message.EdgeUIDs:
		ids := make([]ent.Value, 0, len(m._UIDs))
		for id := range m._UIDs {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *MessageMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	if m.removedflags != nil {
		edges = append(edges, message.EdgeFlags)
	}
	if m.removed_UIDs != nil {
		edges = append(edges, message.EdgeUIDs)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *MessageMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case message.EdgeFlags:
		ids := make([]ent.Value, 0, len(m.removedflags))
		for id := range m.removedflags {
			ids = append(ids, id)
		}
		return ids
	case message.EdgeUIDs:
		ids := make([]ent.Value, 0, len(m.removed_UIDs))
		for id := range m.removed_UIDs {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *MessageMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.clearedflags {
		edges = append(edges, message.EdgeFlags)
	}
	if m.cleared_UIDs {
		edges = append(edges, message.EdgeUIDs)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *MessageMutation) EdgeCleared(name string) bool {
	switch name {
	case message.EdgeFlags:
		return m.clearedflags
	case message.EdgeUIDs:
		return m.cleared_UIDs
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *MessageMutation) ClearEdge(name string) error {
	switch name {
	}
	return fmt.Errorf("unknown Message unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *MessageMutation) ResetEdge(name string) error {
	switch name {
	case message.EdgeFlags:
		m.ResetFlags()
		return nil
	case message.EdgeUIDs:
		m.ResetUIDs()
		return nil
	}
	return fmt.Errorf("unknown Message edge %s", name)
}

// MessageFlagMutation represents an operation that mutates the MessageFlag nodes in the graph.
type MessageFlagMutation struct {
	config
	op              Op
	typ             string
	id              *int
	_Value          *string
	clearedFields   map[string]struct{}
	messages        *imap.InternalMessageID
	clearedmessages bool
	done            bool
	oldValue        func(context.Context) (*MessageFlag, error)
	predicates      []predicate.MessageFlag
}

var _ ent.Mutation = (*MessageFlagMutation)(nil)

// messageflagOption allows management of the mutation configuration using functional options.
type messageflagOption func(*MessageFlagMutation)

// newMessageFlagMutation creates new mutation for the MessageFlag entity.
func newMessageFlagMutation(c config, op Op, opts ...messageflagOption) *MessageFlagMutation {
	m := &MessageFlagMutation{
		config:        c,
		op:            op,
		typ:           TypeMessageFlag,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withMessageFlagID sets the ID field of the mutation.
func withMessageFlagID(id int) messageflagOption {
	return func(m *MessageFlagMutation) {
		var (
			err   error
			once  sync.Once
			value *MessageFlag
		)
		m.oldValue = func(ctx context.Context) (*MessageFlag, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().MessageFlag.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withMessageFlag sets the old MessageFlag of the mutation.
func withMessageFlag(node *MessageFlag) messageflagOption {
	return func(m *MessageFlagMutation) {
		m.oldValue = func(context.Context) (*MessageFlag, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m MessageFlagMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m MessageFlagMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *MessageFlagMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *MessageFlagMutation) IDs(ctx context.Context) ([]int, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []int{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().MessageFlag.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetValue sets the "Value" field.
func (m *MessageFlagMutation) SetValue(s string) {
	m._Value = &s
}

// Value returns the value of the "Value" field in the mutation.
func (m *MessageFlagMutation) Value() (r string, exists bool) {
	v := m._Value
	if v == nil {
		return
	}
	return *v, true
}

// OldValue returns the old "Value" field's value of the MessageFlag entity.
// If the MessageFlag object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MessageFlagMutation) OldValue(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldValue is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldValue requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldValue: %w", err)
	}
	return oldValue.Value, nil
}

// ResetValue resets all changes to the "Value" field.
func (m *MessageFlagMutation) ResetValue() {
	m._Value = nil
}

// SetMessagesID sets the "messages" edge to the Message entity by id.
func (m *MessageFlagMutation) SetMessagesID(id imap.InternalMessageID) {
	m.messages = &id
}

// ClearMessages clears the "messages" edge to the Message entity.
func (m *MessageFlagMutation) ClearMessages() {
	m.clearedmessages = true
}

// MessagesCleared reports if the "messages" edge to the Message entity was cleared.
func (m *MessageFlagMutation) MessagesCleared() bool {
	return m.clearedmessages
}

// MessagesID returns the "messages" edge ID in the mutation.
func (m *MessageFlagMutation) MessagesID() (id imap.InternalMessageID, exists bool) {
	if m.messages != nil {
		return *m.messages, true
	}
	return
}

// MessagesIDs returns the "messages" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// MessagesID instead. It exists only for internal usage by the builders.
func (m *MessageFlagMutation) MessagesIDs() (ids []imap.InternalMessageID) {
	if id := m.messages; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetMessages resets all changes to the "messages" edge.
func (m *MessageFlagMutation) ResetMessages() {
	m.messages = nil
	m.clearedmessages = false
}

// Where appends a list predicates to the MessageFlagMutation builder.
func (m *MessageFlagMutation) Where(ps ...predicate.MessageFlag) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *MessageFlagMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (MessageFlag).
func (m *MessageFlagMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *MessageFlagMutation) Fields() []string {
	fields := make([]string, 0, 1)
	if m._Value != nil {
		fields = append(fields, messageflag.FieldValue)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *MessageFlagMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case messageflag.FieldValue:
		return m.Value()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *MessageFlagMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case messageflag.FieldValue:
		return m.OldValue(ctx)
	}
	return nil, fmt.Errorf("unknown MessageFlag field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MessageFlagMutation) SetField(name string, value ent.Value) error {
	switch name {
	case messageflag.FieldValue:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetValue(v)
		return nil
	}
	return fmt.Errorf("unknown MessageFlag field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *MessageFlagMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *MessageFlagMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MessageFlagMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown MessageFlag numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *MessageFlagMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *MessageFlagMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *MessageFlagMutation) ClearField(name string) error {
	return fmt.Errorf("unknown MessageFlag nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *MessageFlagMutation) ResetField(name string) error {
	switch name {
	case messageflag.FieldValue:
		m.ResetValue()
		return nil
	}
	return fmt.Errorf("unknown MessageFlag field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *MessageFlagMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.messages != nil {
		edges = append(edges, messageflag.EdgeMessages)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *MessageFlagMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case messageflag.EdgeMessages:
		if id := m.messages; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *MessageFlagMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *MessageFlagMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *MessageFlagMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedmessages {
		edges = append(edges, messageflag.EdgeMessages)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *MessageFlagMutation) EdgeCleared(name string) bool {
	switch name {
	case messageflag.EdgeMessages:
		return m.clearedmessages
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *MessageFlagMutation) ClearEdge(name string) error {
	switch name {
	case messageflag.EdgeMessages:
		m.ClearMessages()
		return nil
	}
	return fmt.Errorf("unknown MessageFlag unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *MessageFlagMutation) ResetEdge(name string) error {
	switch name {
	case messageflag.EdgeMessages:
		m.ResetMessages()
		return nil
	}
	return fmt.Errorf("unknown MessageFlag edge %s", name)
}

// UIDMutation represents an operation that mutates the UID nodes in the graph.
type UIDMutation struct {
	config
	op             Op
	typ            string
	id             *int
	_UID           *imap.UID
	add_UID        *imap.UID
	_Deleted       *bool
	_Recent        *bool
	clearedFields  map[string]struct{}
	message        *imap.InternalMessageID
	clearedmessage bool
	mailbox        *imap.InternalMailboxID
	clearedmailbox bool
	done           bool
	oldValue       func(context.Context) (*UID, error)
	predicates     []predicate.UID
}

var _ ent.Mutation = (*UIDMutation)(nil)

// uidOption allows management of the mutation configuration using functional options.
type uidOption func(*UIDMutation)

// newUIDMutation creates new mutation for the UID entity.
func newUIDMutation(c config, op Op, opts ...uidOption) *UIDMutation {
	m := &UIDMutation{
		config:        c,
		op:            op,
		typ:           TypeUID,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withUIDID sets the ID field of the mutation.
func withUIDID(id int) uidOption {
	return func(m *UIDMutation) {
		var (
			err   error
			once  sync.Once
			value *UID
		)
		m.oldValue = func(ctx context.Context) (*UID, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().UID.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withUID sets the old UID of the mutation.
func withUID(node *UID) uidOption {
	return func(m *UIDMutation) {
		m.oldValue = func(context.Context) (*UID, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m UIDMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m UIDMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *UIDMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *UIDMutation) IDs(ctx context.Context) ([]int, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []int{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().UID.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetUID sets the "UID" field.
func (m *UIDMutation) SetUID(i imap.UID) {
	m._UID = &i
	m.add_UID = nil
}

// UID returns the value of the "UID" field in the mutation.
func (m *UIDMutation) UID() (r imap.UID, exists bool) {
	v := m._UID
	if v == nil {
		return
	}
	return *v, true
}

// OldUID returns the old "UID" field's value of the UID entity.
// If the UID object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UIDMutation) OldUID(ctx context.Context) (v imap.UID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUID: %w", err)
	}
	return oldValue.UID, nil
}

// AddUID adds i to the "UID" field.
func (m *UIDMutation) AddUID(i imap.UID) {
	if m.add_UID != nil {
		*m.add_UID += i
	} else {
		m.add_UID = &i
	}
}

// AddedUID returns the value that was added to the "UID" field in this mutation.
func (m *UIDMutation) AddedUID() (r imap.UID, exists bool) {
	v := m.add_UID
	if v == nil {
		return
	}
	return *v, true
}

// ResetUID resets all changes to the "UID" field.
func (m *UIDMutation) ResetUID() {
	m._UID = nil
	m.add_UID = nil
}

// SetDeleted sets the "Deleted" field.
func (m *UIDMutation) SetDeleted(b bool) {
	m._Deleted = &b
}

// Deleted returns the value of the "Deleted" field in the mutation.
func (m *UIDMutation) Deleted() (r bool, exists bool) {
	v := m._Deleted
	if v == nil {
		return
	}
	return *v, true
}

// OldDeleted returns the old "Deleted" field's value of the UID entity.
// If the UID object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UIDMutation) OldDeleted(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldDeleted is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldDeleted requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDeleted: %w", err)
	}
	return oldValue.Deleted, nil
}

// ResetDeleted resets all changes to the "Deleted" field.
func (m *UIDMutation) ResetDeleted() {
	m._Deleted = nil
}

// SetRecent sets the "Recent" field.
func (m *UIDMutation) SetRecent(b bool) {
	m._Recent = &b
}

// Recent returns the value of the "Recent" field in the mutation.
func (m *UIDMutation) Recent() (r bool, exists bool) {
	v := m._Recent
	if v == nil {
		return
	}
	return *v, true
}

// OldRecent returns the old "Recent" field's value of the UID entity.
// If the UID object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UIDMutation) OldRecent(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldRecent is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldRecent requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRecent: %w", err)
	}
	return oldValue.Recent, nil
}

// ResetRecent resets all changes to the "Recent" field.
func (m *UIDMutation) ResetRecent() {
	m._Recent = nil
}

// SetMessageID sets the "message" edge to the Message entity by id.
func (m *UIDMutation) SetMessageID(id imap.InternalMessageID) {
	m.message = &id
}

// ClearMessage clears the "message" edge to the Message entity.
func (m *UIDMutation) ClearMessage() {
	m.clearedmessage = true
}

// MessageCleared reports if the "message" edge to the Message entity was cleared.
func (m *UIDMutation) MessageCleared() bool {
	return m.clearedmessage
}

// MessageID returns the "message" edge ID in the mutation.
func (m *UIDMutation) MessageID() (id imap.InternalMessageID, exists bool) {
	if m.message != nil {
		return *m.message, true
	}
	return
}

// MessageIDs returns the "message" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// MessageID instead. It exists only for internal usage by the builders.
func (m *UIDMutation) MessageIDs() (ids []imap.InternalMessageID) {
	if id := m.message; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetMessage resets all changes to the "message" edge.
func (m *UIDMutation) ResetMessage() {
	m.message = nil
	m.clearedmessage = false
}

// SetMailboxID sets the "mailbox" edge to the Mailbox entity by id.
func (m *UIDMutation) SetMailboxID(id imap.InternalMailboxID) {
	m.mailbox = &id
}

// ClearMailbox clears the "mailbox" edge to the Mailbox entity.
func (m *UIDMutation) ClearMailbox() {
	m.clearedmailbox = true
}

// MailboxCleared reports if the "mailbox" edge to the Mailbox entity was cleared.
func (m *UIDMutation) MailboxCleared() bool {
	return m.clearedmailbox
}

// MailboxID returns the "mailbox" edge ID in the mutation.
func (m *UIDMutation) MailboxID() (id imap.InternalMailboxID, exists bool) {
	if m.mailbox != nil {
		return *m.mailbox, true
	}
	return
}

// MailboxIDs returns the "mailbox" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// MailboxID instead. It exists only for internal usage by the builders.
func (m *UIDMutation) MailboxIDs() (ids []imap.InternalMailboxID) {
	if id := m.mailbox; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetMailbox resets all changes to the "mailbox" edge.
func (m *UIDMutation) ResetMailbox() {
	m.mailbox = nil
	m.clearedmailbox = false
}

// Where appends a list predicates to the UIDMutation builder.
func (m *UIDMutation) Where(ps ...predicate.UID) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *UIDMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (UID).
func (m *UIDMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *UIDMutation) Fields() []string {
	fields := make([]string, 0, 3)
	if m._UID != nil {
		fields = append(fields, uid.FieldUID)
	}
	if m._Deleted != nil {
		fields = append(fields, uid.FieldDeleted)
	}
	if m._Recent != nil {
		fields = append(fields, uid.FieldRecent)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *UIDMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case uid.FieldUID:
		return m.UID()
	case uid.FieldDeleted:
		return m.Deleted()
	case uid.FieldRecent:
		return m.Recent()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *UIDMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case uid.FieldUID:
		return m.OldUID(ctx)
	case uid.FieldDeleted:
		return m.OldDeleted(ctx)
	case uid.FieldRecent:
		return m.OldRecent(ctx)
	}
	return nil, fmt.Errorf("unknown UID field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UIDMutation) SetField(name string, value ent.Value) error {
	switch name {
	case uid.FieldUID:
		v, ok := value.(imap.UID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUID(v)
		return nil
	case uid.FieldDeleted:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDeleted(v)
		return nil
	case uid.FieldRecent:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRecent(v)
		return nil
	}
	return fmt.Errorf("unknown UID field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *UIDMutation) AddedFields() []string {
	var fields []string
	if m.add_UID != nil {
		fields = append(fields, uid.FieldUID)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *UIDMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case uid.FieldUID:
		return m.AddedUID()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UIDMutation) AddField(name string, value ent.Value) error {
	switch name {
	case uid.FieldUID:
		v, ok := value.(imap.UID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddUID(v)
		return nil
	}
	return fmt.Errorf("unknown UID numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *UIDMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *UIDMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *UIDMutation) ClearField(name string) error {
	return fmt.Errorf("unknown UID nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *UIDMutation) ResetField(name string) error {
	switch name {
	case uid.FieldUID:
		m.ResetUID()
		return nil
	case uid.FieldDeleted:
		m.ResetDeleted()
		return nil
	case uid.FieldRecent:
		m.ResetRecent()
		return nil
	}
	return fmt.Errorf("unknown UID field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *UIDMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.message != nil {
		edges = append(edges, uid.EdgeMessage)
	}
	if m.mailbox != nil {
		edges = append(edges, uid.EdgeMailbox)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *UIDMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case uid.EdgeMessage:
		if id := m.message; id != nil {
			return []ent.Value{*id}
		}
	case uid.EdgeMailbox:
		if id := m.mailbox; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *UIDMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *UIDMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *UIDMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.clearedmessage {
		edges = append(edges, uid.EdgeMessage)
	}
	if m.clearedmailbox {
		edges = append(edges, uid.EdgeMailbox)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *UIDMutation) EdgeCleared(name string) bool {
	switch name {
	case uid.EdgeMessage:
		return m.clearedmessage
	case uid.EdgeMailbox:
		return m.clearedmailbox
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *UIDMutation) ClearEdge(name string) error {
	switch name {
	case uid.EdgeMessage:
		m.ClearMessage()
		return nil
	case uid.EdgeMailbox:
		m.ClearMailbox()
		return nil
	}
	return fmt.Errorf("unknown UID unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *UIDMutation) ResetEdge(name string) error {
	switch name {
	case uid.EdgeMessage:
		m.ResetMessage()
		return nil
	case uid.EdgeMailbox:
		m.ResetMailbox()
		return nil
	}
	return fmt.Errorf("unknown UID edge %s", name)
}
