// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"fmt"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/ProtonMail/gluon/internal/db/ent/messageflag"
	"github.com/ProtonMail/gluon/internal/db/ent/predicate"
)

// MessageFlagDelete is the builder for deleting a MessageFlag entity.
type MessageFlagDelete struct {
	config
	hooks    []Hook
	mutation *MessageFlagMutation
}

// Where appends a list predicates to the MessageFlagDelete builder.
func (mfd *MessageFlagDelete) Where(ps ...predicate.MessageFlag) *MessageFlagDelete {
	mfd.mutation.Where(ps...)
	return mfd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (mfd *MessageFlagDelete) Exec(ctx context.Context) (int, error) {
	var (
		err      error
		affected int
	)
	if len(mfd.hooks) == 0 {
		affected, err = mfd.sqlExec(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*MessageFlagMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			mfd.mutation = mutation
			affected, err = mfd.sqlExec(ctx)
			mutation.done = true
			return affected, err
		})
		for i := len(mfd.hooks) - 1; i >= 0; i-- {
			if mfd.hooks[i] == nil {
				return 0, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = mfd.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, mfd.mutation); err != nil {
			return 0, err
		}
	}
	return affected, err
}

// ExecX is like Exec, but panics if an error occurs.
func (mfd *MessageFlagDelete) ExecX(ctx context.Context) int {
	n, err := mfd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (mfd *MessageFlagDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := &sqlgraph.DeleteSpec{
		Node: &sqlgraph.NodeSpec{
			Table: messageflag.Table,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: messageflag.FieldID,
			},
		},
	}
	if ps := mfd.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, mfd.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	return affected, err
}

// MessageFlagDeleteOne is the builder for deleting a single MessageFlag entity.
type MessageFlagDeleteOne struct {
	mfd *MessageFlagDelete
}

// Exec executes the deletion query.
func (mfdo *MessageFlagDeleteOne) Exec(ctx context.Context) error {
	n, err := mfdo.mfd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{messageflag.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (mfdo *MessageFlagDeleteOne) ExecX(ctx context.Context) {
	mfdo.mfd.ExecX(ctx)
}
