// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"fmt"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/ProtonMail/gluon/internal/db/ent/mailboxpermflag"
	"github.com/ProtonMail/gluon/internal/db/ent/predicate"
)

// MailboxPermFlagDelete is the builder for deleting a MailboxPermFlag entity.
type MailboxPermFlagDelete struct {
	config
	hooks    []Hook
	mutation *MailboxPermFlagMutation
}

// Where appends a list predicates to the MailboxPermFlagDelete builder.
func (mpfd *MailboxPermFlagDelete) Where(ps ...predicate.MailboxPermFlag) *MailboxPermFlagDelete {
	mpfd.mutation.Where(ps...)
	return mpfd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (mpfd *MailboxPermFlagDelete) Exec(ctx context.Context) (int, error) {
	var (
		err      error
		affected int
	)
	if len(mpfd.hooks) == 0 {
		affected, err = mpfd.sqlExec(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*MailboxPermFlagMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			mpfd.mutation = mutation
			affected, err = mpfd.sqlExec(ctx)
			mutation.done = true
			return affected, err
		})
		for i := len(mpfd.hooks) - 1; i >= 0; i-- {
			if mpfd.hooks[i] == nil {
				return 0, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = mpfd.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, mpfd.mutation); err != nil {
			return 0, err
		}
	}
	return affected, err
}

// ExecX is like Exec, but panics if an error occurs.
func (mpfd *MailboxPermFlagDelete) ExecX(ctx context.Context) int {
	n, err := mpfd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (mpfd *MailboxPermFlagDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := &sqlgraph.DeleteSpec{
		Node: &sqlgraph.NodeSpec{
			Table: mailboxpermflag.Table,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: mailboxpermflag.FieldID,
			},
		},
	}
	if ps := mpfd.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, mpfd.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	return affected, err
}

// MailboxPermFlagDeleteOne is the builder for deleting a single MailboxPermFlag entity.
type MailboxPermFlagDeleteOne struct {
	mpfd *MailboxPermFlagDelete
}

// Exec executes the deletion query.
func (mpfdo *MailboxPermFlagDeleteOne) Exec(ctx context.Context) error {
	n, err := mpfdo.mpfd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{mailboxpermflag.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (mpfdo *MailboxPermFlagDeleteOne) ExecX(ctx context.Context) {
	mpfdo.mpfd.ExecX(ctx)
}
