// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/ProtonMail/gluon/internal/db/ent/mailboxflag"
)

// MailboxFlagCreate is the builder for creating a MailboxFlag entity.
type MailboxFlagCreate struct {
	config
	mutation *MailboxFlagMutation
	hooks    []Hook
}

// SetValue sets the "Value" field.
func (mfc *MailboxFlagCreate) SetValue(s string) *MailboxFlagCreate {
	mfc.mutation.SetValue(s)
	return mfc
}

// Mutation returns the MailboxFlagMutation object of the builder.
func (mfc *MailboxFlagCreate) Mutation() *MailboxFlagMutation {
	return mfc.mutation
}

// Save creates the MailboxFlag in the database.
func (mfc *MailboxFlagCreate) Save(ctx context.Context) (*MailboxFlag, error) {
	var (
		err  error
		node *MailboxFlag
	)
	if len(mfc.hooks) == 0 {
		if err = mfc.check(); err != nil {
			return nil, err
		}
		node, err = mfc.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*MailboxFlagMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			if err = mfc.check(); err != nil {
				return nil, err
			}
			mfc.mutation = mutation
			if node, err = mfc.sqlSave(ctx); err != nil {
				return nil, err
			}
			mutation.id = &node.ID
			mutation.done = true
			return node, err
		})
		for i := len(mfc.hooks) - 1; i >= 0; i-- {
			if mfc.hooks[i] == nil {
				return nil, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = mfc.hooks[i](mut)
		}
		v, err := mut.Mutate(ctx, mfc.mutation)
		if err != nil {
			return nil, err
		}
		nv, ok := v.(*MailboxFlag)
		if !ok {
			return nil, fmt.Errorf("unexpected node type %T returned from MailboxFlagMutation", v)
		}
		node = nv
	}
	return node, err
}

// SaveX calls Save and panics if Save returns an error.
func (mfc *MailboxFlagCreate) SaveX(ctx context.Context) *MailboxFlag {
	v, err := mfc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (mfc *MailboxFlagCreate) Exec(ctx context.Context) error {
	_, err := mfc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (mfc *MailboxFlagCreate) ExecX(ctx context.Context) {
	if err := mfc.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (mfc *MailboxFlagCreate) check() error {
	if _, ok := mfc.mutation.Value(); !ok {
		return &ValidationError{Name: "Value", err: errors.New(`ent: missing required field "MailboxFlag.Value"`)}
	}
	return nil
}

func (mfc *MailboxFlagCreate) sqlSave(ctx context.Context) (*MailboxFlag, error) {
	_node, _spec := mfc.createSpec()
	if err := sqlgraph.CreateNode(ctx, mfc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	id := _spec.ID.Value.(int64)
	_node.ID = int(id)
	return _node, nil
}

func (mfc *MailboxFlagCreate) createSpec() (*MailboxFlag, *sqlgraph.CreateSpec) {
	var (
		_node = &MailboxFlag{config: mfc.config}
		_spec = &sqlgraph.CreateSpec{
			Table: mailboxflag.Table,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: mailboxflag.FieldID,
			},
		}
	)
	if value, ok := mfc.mutation.Value(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: mailboxflag.FieldValue,
		})
		_node.Value = value
	}
	return _node, _spec
}

// MailboxFlagCreateBulk is the builder for creating many MailboxFlag entities in bulk.
type MailboxFlagCreateBulk struct {
	config
	builders []*MailboxFlagCreate
}

// Save creates the MailboxFlag entities in the database.
func (mfcb *MailboxFlagCreateBulk) Save(ctx context.Context) ([]*MailboxFlag, error) {
	specs := make([]*sqlgraph.CreateSpec, len(mfcb.builders))
	nodes := make([]*MailboxFlag, len(mfcb.builders))
	mutators := make([]Mutator, len(mfcb.builders))
	for i := range mfcb.builders {
		func(i int, root context.Context) {
			builder := mfcb.builders[i]
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*MailboxFlagMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				nodes[i], specs[i] = builder.createSpec()
				var err error
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, mfcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, mfcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				if specs[i].ID.Value != nil {
					id := specs[i].ID.Value.(int64)
					nodes[i].ID = int(id)
				}
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, mfcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (mfcb *MailboxFlagCreateBulk) SaveX(ctx context.Context) []*MailboxFlag {
	v, err := mfcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (mfcb *MailboxFlagCreateBulk) Exec(ctx context.Context) error {
	_, err := mfcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (mfcb *MailboxFlagCreateBulk) ExecX(ctx context.Context) {
	if err := mfcb.Exec(ctx); err != nil {
		panic(err)
	}
}
