// Code generated by ent, DO NOT EDIT.

package hook

import (
	"context"
	"fmt"

	"github.com/ProtonMail/gluon/internal/db/ent"
)

// The DeletedSubscriptionFunc type is an adapter to allow the use of ordinary
// function as DeletedSubscription mutator.
type DeletedSubscriptionFunc func(context.Context, *ent.DeletedSubscriptionMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f DeletedSubscriptionFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.DeletedSubscriptionMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.DeletedSubscriptionMutation", m)
	}
	return f(ctx, mv)
}

// The MailboxFunc type is an adapter to allow the use of ordinary
// function as Mailbox mutator.
type MailboxFunc func(context.Context, *ent.MailboxMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f MailboxFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.MailboxMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.MailboxMutation", m)
	}
	return f(ctx, mv)
}

// The MailboxAttrFunc type is an adapter to allow the use of ordinary
// function as MailboxAttr mutator.
type MailboxAttrFunc func(context.Context, *ent.MailboxAttrMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f MailboxAttrFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.MailboxAttrMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.MailboxAttrMutation", m)
	}
	return f(ctx, mv)
}

// The MailboxFlagFunc type is an adapter to allow the use of ordinary
// function as MailboxFlag mutator.
type MailboxFlagFunc func(context.Context, *ent.MailboxFlagMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f MailboxFlagFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.MailboxFlagMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.MailboxFlagMutation", m)
	}
	return f(ctx, mv)
}

// The MailboxPermFlagFunc type is an adapter to allow the use of ordinary
// function as MailboxPermFlag mutator.
type MailboxPermFlagFunc func(context.Context, *ent.MailboxPermFlagMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f MailboxPermFlagFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.MailboxPermFlagMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.MailboxPermFlagMutation", m)
	}
	return f(ctx, mv)
}

// The MessageFunc type is an adapter to allow the use of ordinary
// function as Message mutator.
type MessageFunc func(context.Context, *ent.MessageMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f MessageFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.MessageMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.MessageMutation", m)
	}
	return f(ctx, mv)
}

// The MessageFlagFunc type is an adapter to allow the use of ordinary
// function as MessageFlag mutator.
type MessageFlagFunc func(context.Context, *ent.MessageFlagMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f MessageFlagFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.MessageFlagMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.MessageFlagMutation", m)
	}
	return f(ctx, mv)
}

// The UIDFunc type is an adapter to allow the use of ordinary
// function as UID mutator.
type UIDFunc func(context.Context, *ent.UIDMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f UIDFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.UIDMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.UIDMutation", m)
	}
	return f(ctx, mv)
}

// Condition is a hook condition function.
type Condition func(context.Context, ent.Mutation) bool

// And groups conditions with the AND operator.
func And(first, second Condition, rest ...Condition) Condition {
	return func(ctx context.Context, m ent.Mutation) bool {
		if !first(ctx, m) || !second(ctx, m) {
			return false
		}
		for _, cond := range rest {
			if !cond(ctx, m) {
				return false
			}
		}
		return true
	}
}

// Or groups conditions with the OR operator.
func Or(first, second Condition, rest ...Condition) Condition {
	return func(ctx context.Context, m ent.Mutation) bool {
		if first(ctx, m) || second(ctx, m) {
			return true
		}
		for _, cond := range rest {
			if cond(ctx, m) {
				return true
			}
		}
		return false
	}
}

// Not negates a given condition.
func Not(cond Condition) Condition {
	return func(ctx context.Context, m ent.Mutation) bool {
		return !cond(ctx, m)
	}
}

// HasOp is a condition testing mutation operation.
func HasOp(op ent.Op) Condition {
	return func(_ context.Context, m ent.Mutation) bool {
		return m.Op().Is(op)
	}
}

// HasAddedFields is a condition validating `.AddedField` on fields.
func HasAddedFields(field string, fields ...string) Condition {
	return func(_ context.Context, m ent.Mutation) bool {
		if _, exists := m.AddedField(field); !exists {
			return false
		}
		for _, field := range fields {
			if _, exists := m.AddedField(field); !exists {
				return false
			}
		}
		return true
	}
}

// HasClearedFields is a condition validating `.FieldCleared` on fields.
func HasClearedFields(field string, fields ...string) Condition {
	return func(_ context.Context, m ent.Mutation) bool {
		if exists := m.FieldCleared(field); !exists {
			return false
		}
		for _, field := range fields {
			if exists := m.FieldCleared(field); !exists {
				return false
			}
		}
		return true
	}
}

// HasFields is a condition validating `.Field` on fields.
func HasFields(field string, fields ...string) Condition {
	return func(_ context.Context, m ent.Mutation) bool {
		if _, exists := m.Field(field); !exists {
			return false
		}
		for _, field := range fields {
			if _, exists := m.Field(field); !exists {
				return false
			}
		}
		return true
	}
}

// If executes the given hook under condition.
//
//	hook.If(ComputeAverage, And(HasFields(...), HasAddedFields(...)))
func If(hk ent.Hook, cond Condition) ent.Hook {
	return func(next ent.Mutator) ent.Mutator {
		return ent.MutateFunc(func(ctx context.Context, m ent.Mutation) (ent.Value, error) {
			if cond(ctx, m) {
				return hk(next).Mutate(ctx, m)
			}
			return next.Mutate(ctx, m)
		})
	}
}

// On executes the given hook only for the given operation.
//
//	hook.On(Log, ent.Delete|ent.Create)
func On(hk ent.Hook, op ent.Op) ent.Hook {
	return If(hk, HasOp(op))
}

// Unless skips the given hook only for the given operation.
//
//	hook.Unless(Log, ent.Update|ent.UpdateOne)
func Unless(hk ent.Hook, op ent.Op) ent.Hook {
	return If(hk, Not(HasOp(op)))
}

// FixedError is a hook returning a fixed error.
func FixedError(err error) ent.Hook {
	return func(ent.Mutator) ent.Mutator {
		return ent.MutateFunc(func(context.Context, ent.Mutation) (ent.Value, error) {
			return nil, err
		})
	}
}

// Reject returns a hook that rejects all operations that match op.
//
//	func (T) Hooks() []ent.Hook {
//		return []ent.Hook{
//			Reject(ent.Delete|ent.Update),
//		}
//	}
func Reject(op ent.Op) ent.Hook {
	hk := FixedError(fmt.Errorf("%s operation is not allowed", op))
	return On(hk, op)
}

// Chain acts as a list of hooks and is effectively immutable.
// Once created, it will always hold the same set of hooks in the same order.
type Chain struct {
	hooks []ent.Hook
}

// NewChain creates a new chain of hooks.
func NewChain(hooks ...ent.Hook) Chain {
	return Chain{append([]ent.Hook(nil), hooks...)}
}

// Hook chains the list of hooks and returns the final hook.
func (c Chain) Hook() ent.Hook {
	return func(mutator ent.Mutator) ent.Mutator {
		for i := len(c.hooks) - 1; i >= 0; i-- {
			mutator = c.hooks[i](mutator)
		}
		return mutator
	}
}

// Append extends a chain, adding the specified hook
// as the last ones in the mutation flow.
func (c Chain) Append(hooks ...ent.Hook) Chain {
	newHooks := make([]ent.Hook, 0, len(c.hooks)+len(hooks))
	newHooks = append(newHooks, c.hooks...)
	newHooks = append(newHooks, hooks...)
	return Chain{newHooks}
}

// Extend extends a chain, adding the specified chain
// as the last ones in the mutation flow.
func (c Chain) Extend(chain Chain) Chain {
	return c.Append(chain.hooks...)
}
