// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"fmt"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/ProtonMail/gluon/internal/db/ent/deletedsubscription"
	"github.com/ProtonMail/gluon/internal/db/ent/predicate"
)

// DeletedSubscriptionDelete is the builder for deleting a DeletedSubscription entity.
type DeletedSubscriptionDelete struct {
	config
	hooks    []Hook
	mutation *DeletedSubscriptionMutation
}

// Where appends a list predicates to the DeletedSubscriptionDelete builder.
func (dsd *DeletedSubscriptionDelete) Where(ps ...predicate.DeletedSubscription) *DeletedSubscriptionDelete {
	dsd.mutation.Where(ps...)
	return dsd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (dsd *DeletedSubscriptionDelete) Exec(ctx context.Context) (int, error) {
	var (
		err      error
		affected int
	)
	if len(dsd.hooks) == 0 {
		affected, err = dsd.sqlExec(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*DeletedSubscriptionMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			dsd.mutation = mutation
			affected, err = dsd.sqlExec(ctx)
			mutation.done = true
			return affected, err
		})
		for i := len(dsd.hooks) - 1; i >= 0; i-- {
			if dsd.hooks[i] == nil {
				return 0, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = dsd.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, dsd.mutation); err != nil {
			return 0, err
		}
	}
	return affected, err
}

// ExecX is like Exec, but panics if an error occurs.
func (dsd *DeletedSubscriptionDelete) ExecX(ctx context.Context) int {
	n, err := dsd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (dsd *DeletedSubscriptionDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := &sqlgraph.DeleteSpec{
		Node: &sqlgraph.NodeSpec{
			Table: deletedsubscription.Table,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: deletedsubscription.FieldID,
			},
		},
	}
	if ps := dsd.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, dsd.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	return affected, err
}

// DeletedSubscriptionDeleteOne is the builder for deleting a single DeletedSubscription entity.
type DeletedSubscriptionDeleteOne struct {
	dsd *DeletedSubscriptionDelete
}

// Exec executes the deletion query.
func (dsdo *DeletedSubscriptionDeleteOne) Exec(ctx context.Context) error {
	n, err := dsdo.dsd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{deletedsubscription.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (dsdo *DeletedSubscriptionDeleteOne) ExecX(ctx context.Context) {
	dsdo.dsd.ExecX(ctx)
}
