// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package fieldtype

import (
	"net"
	"net/http"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/entc/integration/ent/predicate"
	"entgo.io/ent/entc/integration/ent/role"
	"entgo.io/ent/entc/integration/ent/schema"
	"github.com/google/uuid"
)

// ID filters vertices based on their ID field.
func ID(id int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldID), id))
	})
}

// IDEQ applies the EQ predicate on the ID field.
func IDEQ(id int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldID), id))
	})
}

// IDNEQ applies the NEQ predicate on the ID field.
func IDNEQ(id int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldID), id))
	})
}

// IDIn applies the In predicate on the ID field.
func IDIn(ids ...int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		v := make([]interface{}, len(ids))
		for i := range v {
			v[i] = ids[i]
		}
		s.Where(sql.In(s.C(FieldID), v...))
	})
}

// IDNotIn applies the NotIn predicate on the ID field.
func IDNotIn(ids ...int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		v := make([]interface{}, len(ids))
		for i := range v {
			v[i] = ids[i]
		}
		s.Where(sql.NotIn(s.C(FieldID), v...))
	})
}

// IDGT applies the GT predicate on the ID field.
func IDGT(id int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldID), id))
	})
}

// IDGTE applies the GTE predicate on the ID field.
func IDGTE(id int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldID), id))
	})
}

// IDLT applies the LT predicate on the ID field.
func IDLT(id int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldID), id))
	})
}

// IDLTE applies the LTE predicate on the ID field.
func IDLTE(id int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldID), id))
	})
}

// Int applies equality check predicate on the "int" field. It's identical to IntEQ.
func Int(v int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldInt), v))
	})
}

// Int8 applies equality check predicate on the "int8" field. It's identical to Int8EQ.
func Int8(v int8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldInt8), v))
	})
}

// Int16 applies equality check predicate on the "int16" field. It's identical to Int16EQ.
func Int16(v int16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldInt16), v))
	})
}

// Int32 applies equality check predicate on the "int32" field. It's identical to Int32EQ.
func Int32(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldInt32), v))
	})
}

// Int64 applies equality check predicate on the "int64" field. It's identical to Int64EQ.
func Int64(v int64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldInt64), v))
	})
}

// OptionalInt applies equality check predicate on the "optional_int" field. It's identical to OptionalIntEQ.
func OptionalInt(v int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalInt), v))
	})
}

// OptionalInt8 applies equality check predicate on the "optional_int8" field. It's identical to OptionalInt8EQ.
func OptionalInt8(v int8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalInt8), v))
	})
}

// OptionalInt16 applies equality check predicate on the "optional_int16" field. It's identical to OptionalInt16EQ.
func OptionalInt16(v int16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalInt16), v))
	})
}

// OptionalInt32 applies equality check predicate on the "optional_int32" field. It's identical to OptionalInt32EQ.
func OptionalInt32(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalInt32), v))
	})
}

// OptionalInt64 applies equality check predicate on the "optional_int64" field. It's identical to OptionalInt64EQ.
func OptionalInt64(v int64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalInt64), v))
	})
}

// NillableInt applies equality check predicate on the "nillable_int" field. It's identical to NillableIntEQ.
func NillableInt(v int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNillableInt), v))
	})
}

// NillableInt8 applies equality check predicate on the "nillable_int8" field. It's identical to NillableInt8EQ.
func NillableInt8(v int8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNillableInt8), v))
	})
}

// NillableInt16 applies equality check predicate on the "nillable_int16" field. It's identical to NillableInt16EQ.
func NillableInt16(v int16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNillableInt16), v))
	})
}

// NillableInt32 applies equality check predicate on the "nillable_int32" field. It's identical to NillableInt32EQ.
func NillableInt32(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNillableInt32), v))
	})
}

// NillableInt64 applies equality check predicate on the "nillable_int64" field. It's identical to NillableInt64EQ.
func NillableInt64(v int64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNillableInt64), v))
	})
}

// ValidateOptionalInt32 applies equality check predicate on the "validate_optional_int32" field. It's identical to ValidateOptionalInt32EQ.
func ValidateOptionalInt32(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldValidateOptionalInt32), v))
	})
}

// OptionalUint applies equality check predicate on the "optional_uint" field. It's identical to OptionalUintEQ.
func OptionalUint(v uint) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalUint), v))
	})
}

// OptionalUint8 applies equality check predicate on the "optional_uint8" field. It's identical to OptionalUint8EQ.
func OptionalUint8(v uint8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalUint8), v))
	})
}

// OptionalUint16 applies equality check predicate on the "optional_uint16" field. It's identical to OptionalUint16EQ.
func OptionalUint16(v uint16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalUint16), v))
	})
}

// OptionalUint32 applies equality check predicate on the "optional_uint32" field. It's identical to OptionalUint32EQ.
func OptionalUint32(v uint32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalUint32), v))
	})
}

// OptionalUint64 applies equality check predicate on the "optional_uint64" field. It's identical to OptionalUint64EQ.
func OptionalUint64(v uint64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalUint64), v))
	})
}

// OptionalFloat applies equality check predicate on the "optional_float" field. It's identical to OptionalFloatEQ.
func OptionalFloat(v float64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalFloat), v))
	})
}

// OptionalFloat32 applies equality check predicate on the "optional_float32" field. It's identical to OptionalFloat32EQ.
func OptionalFloat32(v float32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalFloat32), v))
	})
}

// Text applies equality check predicate on the "text" field. It's identical to TextEQ.
func Text(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldText), v))
	})
}

// Datetime applies equality check predicate on the "datetime" field. It's identical to DatetimeEQ.
func Datetime(v time.Time) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldDatetime), v))
	})
}

// Decimal applies equality check predicate on the "decimal" field. It's identical to DecimalEQ.
func Decimal(v float64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldDecimal), v))
	})
}

// LinkOther applies equality check predicate on the "link_other" field. It's identical to LinkOtherEQ.
func LinkOther(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldLinkOther), v))
	})
}

// LinkOtherFunc applies equality check predicate on the "link_other_func" field. It's identical to LinkOtherFuncEQ.
func LinkOtherFunc(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldLinkOtherFunc), v))
	})
}

// MAC applies equality check predicate on the "mac" field. It's identical to MACEQ.
func MAC(v schema.MAC) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldMAC), v))
	})
}

// StringArray applies equality check predicate on the "string_array" field. It's identical to StringArrayEQ.
func StringArray(v schema.Strings) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldStringArray), v))
	})
}

// Password applies equality check predicate on the "password" field. It's identical to PasswordEQ.
func Password(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldPassword), v))
	})
}

// StringScanner applies equality check predicate on the "string_scanner" field. It's identical to StringScannerEQ.
func StringScanner(v schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldStringScanner), v))
	})
}

// Duration applies equality check predicate on the "duration" field. It's identical to DurationEQ.
func Duration(v time.Duration) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldDuration), vc))
	})
}

// Dir applies equality check predicate on the "dir" field. It's identical to DirEQ.
func Dir(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldDir), vc))
	})
}

// Ndir applies equality check predicate on the "ndir" field. It's identical to NdirEQ.
func Ndir(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNdir), vc))
	})
}

// Str applies equality check predicate on the "str" field. It's identical to StrEQ.
func Str(v sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldStr), v))
	})
}

// NullStr applies equality check predicate on the "null_str" field. It's identical to NullStrEQ.
func NullStr(v *sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNullStr), v))
	})
}

// Link applies equality check predicate on the "link" field. It's identical to LinkEQ.
func Link(v schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldLink), v))
	})
}

// NullLink applies equality check predicate on the "null_link" field. It's identical to NullLinkEQ.
func NullLink(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNullLink), v))
	})
}

// Active applies equality check predicate on the "active" field. It's identical to ActiveEQ.
func Active(v schema.Status) predicate.FieldType {
	vc := bool(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldActive), vc))
	})
}

// NullActive applies equality check predicate on the "null_active" field. It's identical to NullActiveEQ.
func NullActive(v schema.Status) predicate.FieldType {
	vc := bool(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNullActive), vc))
	})
}

// Deleted applies equality check predicate on the "deleted" field. It's identical to DeletedEQ.
func Deleted(v *sql.NullBool) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldDeleted), v))
	})
}

// DeletedAt applies equality check predicate on the "deleted_at" field. It's identical to DeletedAtEQ.
func DeletedAt(v *sql.NullTime) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldDeletedAt), v))
	})
}

// RawData applies equality check predicate on the "raw_data" field. It's identical to RawDataEQ.
func RawData(v []byte) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldRawData), v))
	})
}

// Sensitive applies equality check predicate on the "sensitive" field. It's identical to SensitiveEQ.
func Sensitive(v []byte) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldSensitive), v))
	})
}

// IP applies equality check predicate on the "ip" field. It's identical to IPEQ.
func IP(v net.IP) predicate.FieldType {
	vc := []byte(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldIP), vc))
	})
}

// NullInt64 applies equality check predicate on the "null_int64" field. It's identical to NullInt64EQ.
func NullInt64(v *sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNullInt64), v))
	})
}

// SchemaInt applies equality check predicate on the "schema_int" field. It's identical to SchemaIntEQ.
func SchemaInt(v schema.Int) predicate.FieldType {
	vc := int(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldSchemaInt), vc))
	})
}

// SchemaInt8 applies equality check predicate on the "schema_int8" field. It's identical to SchemaInt8EQ.
func SchemaInt8(v schema.Int8) predicate.FieldType {
	vc := int8(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldSchemaInt8), vc))
	})
}

// SchemaInt64 applies equality check predicate on the "schema_int64" field. It's identical to SchemaInt64EQ.
func SchemaInt64(v schema.Int64) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldSchemaInt64), vc))
	})
}

// SchemaFloat applies equality check predicate on the "schema_float" field. It's identical to SchemaFloatEQ.
func SchemaFloat(v schema.Float64) predicate.FieldType {
	vc := float64(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldSchemaFloat), vc))
	})
}

// SchemaFloat32 applies equality check predicate on the "schema_float32" field. It's identical to SchemaFloat32EQ.
func SchemaFloat32(v schema.Float32) predicate.FieldType {
	vc := float32(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldSchemaFloat32), vc))
	})
}

// NullFloat applies equality check predicate on the "null_float" field. It's identical to NullFloatEQ.
func NullFloat(v *sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNullFloat), v))
	})
}

// OptionalUUID applies equality check predicate on the "optional_uuid" field. It's identical to OptionalUUIDEQ.
func OptionalUUID(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalUUID), v))
	})
}

// NillableUUID applies equality check predicate on the "nillable_uuid" field. It's identical to NillableUUIDEQ.
func NillableUUID(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNillableUUID), v))
	})
}

// Pair applies equality check predicate on the "pair" field. It's identical to PairEQ.
func Pair(v schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldPair), v))
	})
}

// NilPair applies equality check predicate on the "nil_pair" field. It's identical to NilPairEQ.
func NilPair(v *schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNilPair), v))
	})
}

// Vstring applies equality check predicate on the "vstring" field. It's identical to VstringEQ.
func Vstring(v schema.VString) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldVstring), v))
	})
}

// Triple applies equality check predicate on the "triple" field. It's identical to TripleEQ.
func Triple(v schema.Triple) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldTriple), v))
	})
}

// BigInt applies equality check predicate on the "big_int" field. It's identical to BigIntEQ.
func BigInt(v schema.BigInt) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldBigInt), v))
	})
}

// PasswordOther applies equality check predicate on the "password_other" field. It's identical to PasswordOtherEQ.
func PasswordOther(v schema.Password) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldPasswordOther), v))
	})
}

// IntEQ applies the EQ predicate on the "int" field.
func IntEQ(v int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldInt), v))
	})
}

// IntNEQ applies the NEQ predicate on the "int" field.
func IntNEQ(v int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldInt), v))
	})
}

// IntIn applies the In predicate on the "int" field.
func IntIn(vs ...int) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldInt), v...))
	})
}

// IntNotIn applies the NotIn predicate on the "int" field.
func IntNotIn(vs ...int) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldInt), v...))
	})
}

// IntGT applies the GT predicate on the "int" field.
func IntGT(v int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldInt), v))
	})
}

// IntGTE applies the GTE predicate on the "int" field.
func IntGTE(v int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldInt), v))
	})
}

// IntLT applies the LT predicate on the "int" field.
func IntLT(v int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldInt), v))
	})
}

// IntLTE applies the LTE predicate on the "int" field.
func IntLTE(v int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldInt), v))
	})
}

// Int8EQ applies the EQ predicate on the "int8" field.
func Int8EQ(v int8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldInt8), v))
	})
}

// Int8NEQ applies the NEQ predicate on the "int8" field.
func Int8NEQ(v int8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldInt8), v))
	})
}

// Int8In applies the In predicate on the "int8" field.
func Int8In(vs ...int8) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldInt8), v...))
	})
}

// Int8NotIn applies the NotIn predicate on the "int8" field.
func Int8NotIn(vs ...int8) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldInt8), v...))
	})
}

// Int8GT applies the GT predicate on the "int8" field.
func Int8GT(v int8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldInt8), v))
	})
}

// Int8GTE applies the GTE predicate on the "int8" field.
func Int8GTE(v int8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldInt8), v))
	})
}

// Int8LT applies the LT predicate on the "int8" field.
func Int8LT(v int8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldInt8), v))
	})
}

// Int8LTE applies the LTE predicate on the "int8" field.
func Int8LTE(v int8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldInt8), v))
	})
}

// Int16EQ applies the EQ predicate on the "int16" field.
func Int16EQ(v int16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldInt16), v))
	})
}

// Int16NEQ applies the NEQ predicate on the "int16" field.
func Int16NEQ(v int16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldInt16), v))
	})
}

// Int16In applies the In predicate on the "int16" field.
func Int16In(vs ...int16) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldInt16), v...))
	})
}

// Int16NotIn applies the NotIn predicate on the "int16" field.
func Int16NotIn(vs ...int16) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldInt16), v...))
	})
}

// Int16GT applies the GT predicate on the "int16" field.
func Int16GT(v int16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldInt16), v))
	})
}

// Int16GTE applies the GTE predicate on the "int16" field.
func Int16GTE(v int16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldInt16), v))
	})
}

// Int16LT applies the LT predicate on the "int16" field.
func Int16LT(v int16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldInt16), v))
	})
}

// Int16LTE applies the LTE predicate on the "int16" field.
func Int16LTE(v int16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldInt16), v))
	})
}

// Int32EQ applies the EQ predicate on the "int32" field.
func Int32EQ(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldInt32), v))
	})
}

// Int32NEQ applies the NEQ predicate on the "int32" field.
func Int32NEQ(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldInt32), v))
	})
}

// Int32In applies the In predicate on the "int32" field.
func Int32In(vs ...int32) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldInt32), v...))
	})
}

// Int32NotIn applies the NotIn predicate on the "int32" field.
func Int32NotIn(vs ...int32) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldInt32), v...))
	})
}

// Int32GT applies the GT predicate on the "int32" field.
func Int32GT(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldInt32), v))
	})
}

// Int32GTE applies the GTE predicate on the "int32" field.
func Int32GTE(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldInt32), v))
	})
}

// Int32LT applies the LT predicate on the "int32" field.
func Int32LT(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldInt32), v))
	})
}

// Int32LTE applies the LTE predicate on the "int32" field.
func Int32LTE(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldInt32), v))
	})
}

// Int64EQ applies the EQ predicate on the "int64" field.
func Int64EQ(v int64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldInt64), v))
	})
}

// Int64NEQ applies the NEQ predicate on the "int64" field.
func Int64NEQ(v int64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldInt64), v))
	})
}

// Int64In applies the In predicate on the "int64" field.
func Int64In(vs ...int64) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldInt64), v...))
	})
}

// Int64NotIn applies the NotIn predicate on the "int64" field.
func Int64NotIn(vs ...int64) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldInt64), v...))
	})
}

// Int64GT applies the GT predicate on the "int64" field.
func Int64GT(v int64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldInt64), v))
	})
}

// Int64GTE applies the GTE predicate on the "int64" field.
func Int64GTE(v int64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldInt64), v))
	})
}

// Int64LT applies the LT predicate on the "int64" field.
func Int64LT(v int64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldInt64), v))
	})
}

// Int64LTE applies the LTE predicate on the "int64" field.
func Int64LTE(v int64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldInt64), v))
	})
}

// OptionalIntEQ applies the EQ predicate on the "optional_int" field.
func OptionalIntEQ(v int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalInt), v))
	})
}

// OptionalIntNEQ applies the NEQ predicate on the "optional_int" field.
func OptionalIntNEQ(v int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldOptionalInt), v))
	})
}

// OptionalIntIn applies the In predicate on the "optional_int" field.
func OptionalIntIn(vs ...int) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldOptionalInt), v...))
	})
}

// OptionalIntNotIn applies the NotIn predicate on the "optional_int" field.
func OptionalIntNotIn(vs ...int) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldOptionalInt), v...))
	})
}

// OptionalIntGT applies the GT predicate on the "optional_int" field.
func OptionalIntGT(v int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldOptionalInt), v))
	})
}

// OptionalIntGTE applies the GTE predicate on the "optional_int" field.
func OptionalIntGTE(v int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldOptionalInt), v))
	})
}

// OptionalIntLT applies the LT predicate on the "optional_int" field.
func OptionalIntLT(v int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldOptionalInt), v))
	})
}

// OptionalIntLTE applies the LTE predicate on the "optional_int" field.
func OptionalIntLTE(v int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldOptionalInt), v))
	})
}

// OptionalIntIsNil applies the IsNil predicate on the "optional_int" field.
func OptionalIntIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldOptionalInt)))
	})
}

// OptionalIntNotNil applies the NotNil predicate on the "optional_int" field.
func OptionalIntNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldOptionalInt)))
	})
}

// OptionalInt8EQ applies the EQ predicate on the "optional_int8" field.
func OptionalInt8EQ(v int8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalInt8), v))
	})
}

// OptionalInt8NEQ applies the NEQ predicate on the "optional_int8" field.
func OptionalInt8NEQ(v int8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldOptionalInt8), v))
	})
}

// OptionalInt8In applies the In predicate on the "optional_int8" field.
func OptionalInt8In(vs ...int8) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldOptionalInt8), v...))
	})
}

// OptionalInt8NotIn applies the NotIn predicate on the "optional_int8" field.
func OptionalInt8NotIn(vs ...int8) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldOptionalInt8), v...))
	})
}

// OptionalInt8GT applies the GT predicate on the "optional_int8" field.
func OptionalInt8GT(v int8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldOptionalInt8), v))
	})
}

// OptionalInt8GTE applies the GTE predicate on the "optional_int8" field.
func OptionalInt8GTE(v int8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldOptionalInt8), v))
	})
}

// OptionalInt8LT applies the LT predicate on the "optional_int8" field.
func OptionalInt8LT(v int8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldOptionalInt8), v))
	})
}

// OptionalInt8LTE applies the LTE predicate on the "optional_int8" field.
func OptionalInt8LTE(v int8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldOptionalInt8), v))
	})
}

// OptionalInt8IsNil applies the IsNil predicate on the "optional_int8" field.
func OptionalInt8IsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldOptionalInt8)))
	})
}

// OptionalInt8NotNil applies the NotNil predicate on the "optional_int8" field.
func OptionalInt8NotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldOptionalInt8)))
	})
}

// OptionalInt16EQ applies the EQ predicate on the "optional_int16" field.
func OptionalInt16EQ(v int16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalInt16), v))
	})
}

// OptionalInt16NEQ applies the NEQ predicate on the "optional_int16" field.
func OptionalInt16NEQ(v int16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldOptionalInt16), v))
	})
}

// OptionalInt16In applies the In predicate on the "optional_int16" field.
func OptionalInt16In(vs ...int16) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldOptionalInt16), v...))
	})
}

// OptionalInt16NotIn applies the NotIn predicate on the "optional_int16" field.
func OptionalInt16NotIn(vs ...int16) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldOptionalInt16), v...))
	})
}

// OptionalInt16GT applies the GT predicate on the "optional_int16" field.
func OptionalInt16GT(v int16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldOptionalInt16), v))
	})
}

// OptionalInt16GTE applies the GTE predicate on the "optional_int16" field.
func OptionalInt16GTE(v int16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldOptionalInt16), v))
	})
}

// OptionalInt16LT applies the LT predicate on the "optional_int16" field.
func OptionalInt16LT(v int16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldOptionalInt16), v))
	})
}

// OptionalInt16LTE applies the LTE predicate on the "optional_int16" field.
func OptionalInt16LTE(v int16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldOptionalInt16), v))
	})
}

// OptionalInt16IsNil applies the IsNil predicate on the "optional_int16" field.
func OptionalInt16IsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldOptionalInt16)))
	})
}

// OptionalInt16NotNil applies the NotNil predicate on the "optional_int16" field.
func OptionalInt16NotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldOptionalInt16)))
	})
}

// OptionalInt32EQ applies the EQ predicate on the "optional_int32" field.
func OptionalInt32EQ(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalInt32), v))
	})
}

// OptionalInt32NEQ applies the NEQ predicate on the "optional_int32" field.
func OptionalInt32NEQ(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldOptionalInt32), v))
	})
}

// OptionalInt32In applies the In predicate on the "optional_int32" field.
func OptionalInt32In(vs ...int32) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldOptionalInt32), v...))
	})
}

// OptionalInt32NotIn applies the NotIn predicate on the "optional_int32" field.
func OptionalInt32NotIn(vs ...int32) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldOptionalInt32), v...))
	})
}

// OptionalInt32GT applies the GT predicate on the "optional_int32" field.
func OptionalInt32GT(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldOptionalInt32), v))
	})
}

// OptionalInt32GTE applies the GTE predicate on the "optional_int32" field.
func OptionalInt32GTE(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldOptionalInt32), v))
	})
}

// OptionalInt32LT applies the LT predicate on the "optional_int32" field.
func OptionalInt32LT(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldOptionalInt32), v))
	})
}

// OptionalInt32LTE applies the LTE predicate on the "optional_int32" field.
func OptionalInt32LTE(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldOptionalInt32), v))
	})
}

// OptionalInt32IsNil applies the IsNil predicate on the "optional_int32" field.
func OptionalInt32IsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldOptionalInt32)))
	})
}

// OptionalInt32NotNil applies the NotNil predicate on the "optional_int32" field.
func OptionalInt32NotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldOptionalInt32)))
	})
}

// OptionalInt64EQ applies the EQ predicate on the "optional_int64" field.
func OptionalInt64EQ(v int64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalInt64), v))
	})
}

// OptionalInt64NEQ applies the NEQ predicate on the "optional_int64" field.
func OptionalInt64NEQ(v int64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldOptionalInt64), v))
	})
}

// OptionalInt64In applies the In predicate on the "optional_int64" field.
func OptionalInt64In(vs ...int64) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldOptionalInt64), v...))
	})
}

// OptionalInt64NotIn applies the NotIn predicate on the "optional_int64" field.
func OptionalInt64NotIn(vs ...int64) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldOptionalInt64), v...))
	})
}

// OptionalInt64GT applies the GT predicate on the "optional_int64" field.
func OptionalInt64GT(v int64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldOptionalInt64), v))
	})
}

// OptionalInt64GTE applies the GTE predicate on the "optional_int64" field.
func OptionalInt64GTE(v int64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldOptionalInt64), v))
	})
}

// OptionalInt64LT applies the LT predicate on the "optional_int64" field.
func OptionalInt64LT(v int64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldOptionalInt64), v))
	})
}

// OptionalInt64LTE applies the LTE predicate on the "optional_int64" field.
func OptionalInt64LTE(v int64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldOptionalInt64), v))
	})
}

// OptionalInt64IsNil applies the IsNil predicate on the "optional_int64" field.
func OptionalInt64IsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldOptionalInt64)))
	})
}

// OptionalInt64NotNil applies the NotNil predicate on the "optional_int64" field.
func OptionalInt64NotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldOptionalInt64)))
	})
}

// NillableIntEQ applies the EQ predicate on the "nillable_int" field.
func NillableIntEQ(v int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNillableInt), v))
	})
}

// NillableIntNEQ applies the NEQ predicate on the "nillable_int" field.
func NillableIntNEQ(v int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldNillableInt), v))
	})
}

// NillableIntIn applies the In predicate on the "nillable_int" field.
func NillableIntIn(vs ...int) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldNillableInt), v...))
	})
}

// NillableIntNotIn applies the NotIn predicate on the "nillable_int" field.
func NillableIntNotIn(vs ...int) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldNillableInt), v...))
	})
}

// NillableIntGT applies the GT predicate on the "nillable_int" field.
func NillableIntGT(v int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldNillableInt), v))
	})
}

// NillableIntGTE applies the GTE predicate on the "nillable_int" field.
func NillableIntGTE(v int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldNillableInt), v))
	})
}

// NillableIntLT applies the LT predicate on the "nillable_int" field.
func NillableIntLT(v int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldNillableInt), v))
	})
}

// NillableIntLTE applies the LTE predicate on the "nillable_int" field.
func NillableIntLTE(v int) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldNillableInt), v))
	})
}

// NillableIntIsNil applies the IsNil predicate on the "nillable_int" field.
func NillableIntIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldNillableInt)))
	})
}

// NillableIntNotNil applies the NotNil predicate on the "nillable_int" field.
func NillableIntNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldNillableInt)))
	})
}

// NillableInt8EQ applies the EQ predicate on the "nillable_int8" field.
func NillableInt8EQ(v int8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNillableInt8), v))
	})
}

// NillableInt8NEQ applies the NEQ predicate on the "nillable_int8" field.
func NillableInt8NEQ(v int8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldNillableInt8), v))
	})
}

// NillableInt8In applies the In predicate on the "nillable_int8" field.
func NillableInt8In(vs ...int8) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldNillableInt8), v...))
	})
}

// NillableInt8NotIn applies the NotIn predicate on the "nillable_int8" field.
func NillableInt8NotIn(vs ...int8) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldNillableInt8), v...))
	})
}

// NillableInt8GT applies the GT predicate on the "nillable_int8" field.
func NillableInt8GT(v int8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldNillableInt8), v))
	})
}

// NillableInt8GTE applies the GTE predicate on the "nillable_int8" field.
func NillableInt8GTE(v int8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldNillableInt8), v))
	})
}

// NillableInt8LT applies the LT predicate on the "nillable_int8" field.
func NillableInt8LT(v int8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldNillableInt8), v))
	})
}

// NillableInt8LTE applies the LTE predicate on the "nillable_int8" field.
func NillableInt8LTE(v int8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldNillableInt8), v))
	})
}

// NillableInt8IsNil applies the IsNil predicate on the "nillable_int8" field.
func NillableInt8IsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldNillableInt8)))
	})
}

// NillableInt8NotNil applies the NotNil predicate on the "nillable_int8" field.
func NillableInt8NotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldNillableInt8)))
	})
}

// NillableInt16EQ applies the EQ predicate on the "nillable_int16" field.
func NillableInt16EQ(v int16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNillableInt16), v))
	})
}

// NillableInt16NEQ applies the NEQ predicate on the "nillable_int16" field.
func NillableInt16NEQ(v int16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldNillableInt16), v))
	})
}

// NillableInt16In applies the In predicate on the "nillable_int16" field.
func NillableInt16In(vs ...int16) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldNillableInt16), v...))
	})
}

// NillableInt16NotIn applies the NotIn predicate on the "nillable_int16" field.
func NillableInt16NotIn(vs ...int16) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldNillableInt16), v...))
	})
}

// NillableInt16GT applies the GT predicate on the "nillable_int16" field.
func NillableInt16GT(v int16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldNillableInt16), v))
	})
}

// NillableInt16GTE applies the GTE predicate on the "nillable_int16" field.
func NillableInt16GTE(v int16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldNillableInt16), v))
	})
}

// NillableInt16LT applies the LT predicate on the "nillable_int16" field.
func NillableInt16LT(v int16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldNillableInt16), v))
	})
}

// NillableInt16LTE applies the LTE predicate on the "nillable_int16" field.
func NillableInt16LTE(v int16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldNillableInt16), v))
	})
}

// NillableInt16IsNil applies the IsNil predicate on the "nillable_int16" field.
func NillableInt16IsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldNillableInt16)))
	})
}

// NillableInt16NotNil applies the NotNil predicate on the "nillable_int16" field.
func NillableInt16NotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldNillableInt16)))
	})
}

// NillableInt32EQ applies the EQ predicate on the "nillable_int32" field.
func NillableInt32EQ(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNillableInt32), v))
	})
}

// NillableInt32NEQ applies the NEQ predicate on the "nillable_int32" field.
func NillableInt32NEQ(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldNillableInt32), v))
	})
}

// NillableInt32In applies the In predicate on the "nillable_int32" field.
func NillableInt32In(vs ...int32) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldNillableInt32), v...))
	})
}

// NillableInt32NotIn applies the NotIn predicate on the "nillable_int32" field.
func NillableInt32NotIn(vs ...int32) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldNillableInt32), v...))
	})
}

// NillableInt32GT applies the GT predicate on the "nillable_int32" field.
func NillableInt32GT(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldNillableInt32), v))
	})
}

// NillableInt32GTE applies the GTE predicate on the "nillable_int32" field.
func NillableInt32GTE(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldNillableInt32), v))
	})
}

// NillableInt32LT applies the LT predicate on the "nillable_int32" field.
func NillableInt32LT(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldNillableInt32), v))
	})
}

// NillableInt32LTE applies the LTE predicate on the "nillable_int32" field.
func NillableInt32LTE(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldNillableInt32), v))
	})
}

// NillableInt32IsNil applies the IsNil predicate on the "nillable_int32" field.
func NillableInt32IsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldNillableInt32)))
	})
}

// NillableInt32NotNil applies the NotNil predicate on the "nillable_int32" field.
func NillableInt32NotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldNillableInt32)))
	})
}

// NillableInt64EQ applies the EQ predicate on the "nillable_int64" field.
func NillableInt64EQ(v int64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNillableInt64), v))
	})
}

// NillableInt64NEQ applies the NEQ predicate on the "nillable_int64" field.
func NillableInt64NEQ(v int64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldNillableInt64), v))
	})
}

// NillableInt64In applies the In predicate on the "nillable_int64" field.
func NillableInt64In(vs ...int64) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldNillableInt64), v...))
	})
}

// NillableInt64NotIn applies the NotIn predicate on the "nillable_int64" field.
func NillableInt64NotIn(vs ...int64) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldNillableInt64), v...))
	})
}

// NillableInt64GT applies the GT predicate on the "nillable_int64" field.
func NillableInt64GT(v int64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldNillableInt64), v))
	})
}

// NillableInt64GTE applies the GTE predicate on the "nillable_int64" field.
func NillableInt64GTE(v int64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldNillableInt64), v))
	})
}

// NillableInt64LT applies the LT predicate on the "nillable_int64" field.
func NillableInt64LT(v int64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldNillableInt64), v))
	})
}

// NillableInt64LTE applies the LTE predicate on the "nillable_int64" field.
func NillableInt64LTE(v int64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldNillableInt64), v))
	})
}

// NillableInt64IsNil applies the IsNil predicate on the "nillable_int64" field.
func NillableInt64IsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldNillableInt64)))
	})
}

// NillableInt64NotNil applies the NotNil predicate on the "nillable_int64" field.
func NillableInt64NotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldNillableInt64)))
	})
}

// ValidateOptionalInt32EQ applies the EQ predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32EQ(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldValidateOptionalInt32), v))
	})
}

// ValidateOptionalInt32NEQ applies the NEQ predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32NEQ(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldValidateOptionalInt32), v))
	})
}

// ValidateOptionalInt32In applies the In predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32In(vs ...int32) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldValidateOptionalInt32), v...))
	})
}

// ValidateOptionalInt32NotIn applies the NotIn predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32NotIn(vs ...int32) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldValidateOptionalInt32), v...))
	})
}

// ValidateOptionalInt32GT applies the GT predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32GT(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldValidateOptionalInt32), v))
	})
}

// ValidateOptionalInt32GTE applies the GTE predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32GTE(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldValidateOptionalInt32), v))
	})
}

// ValidateOptionalInt32LT applies the LT predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32LT(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldValidateOptionalInt32), v))
	})
}

// ValidateOptionalInt32LTE applies the LTE predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32LTE(v int32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldValidateOptionalInt32), v))
	})
}

// ValidateOptionalInt32IsNil applies the IsNil predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32IsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldValidateOptionalInt32)))
	})
}

// ValidateOptionalInt32NotNil applies the NotNil predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32NotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldValidateOptionalInt32)))
	})
}

// OptionalUintEQ applies the EQ predicate on the "optional_uint" field.
func OptionalUintEQ(v uint) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalUint), v))
	})
}

// OptionalUintNEQ applies the NEQ predicate on the "optional_uint" field.
func OptionalUintNEQ(v uint) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldOptionalUint), v))
	})
}

// OptionalUintIn applies the In predicate on the "optional_uint" field.
func OptionalUintIn(vs ...uint) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldOptionalUint), v...))
	})
}

// OptionalUintNotIn applies the NotIn predicate on the "optional_uint" field.
func OptionalUintNotIn(vs ...uint) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldOptionalUint), v...))
	})
}

// OptionalUintGT applies the GT predicate on the "optional_uint" field.
func OptionalUintGT(v uint) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldOptionalUint), v))
	})
}

// OptionalUintGTE applies the GTE predicate on the "optional_uint" field.
func OptionalUintGTE(v uint) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldOptionalUint), v))
	})
}

// OptionalUintLT applies the LT predicate on the "optional_uint" field.
func OptionalUintLT(v uint) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldOptionalUint), v))
	})
}

// OptionalUintLTE applies the LTE predicate on the "optional_uint" field.
func OptionalUintLTE(v uint) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldOptionalUint), v))
	})
}

// OptionalUintIsNil applies the IsNil predicate on the "optional_uint" field.
func OptionalUintIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldOptionalUint)))
	})
}

// OptionalUintNotNil applies the NotNil predicate on the "optional_uint" field.
func OptionalUintNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldOptionalUint)))
	})
}

// OptionalUint8EQ applies the EQ predicate on the "optional_uint8" field.
func OptionalUint8EQ(v uint8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalUint8), v))
	})
}

// OptionalUint8NEQ applies the NEQ predicate on the "optional_uint8" field.
func OptionalUint8NEQ(v uint8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldOptionalUint8), v))
	})
}

// OptionalUint8In applies the In predicate on the "optional_uint8" field.
func OptionalUint8In(vs ...uint8) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldOptionalUint8), v...))
	})
}

// OptionalUint8NotIn applies the NotIn predicate on the "optional_uint8" field.
func OptionalUint8NotIn(vs ...uint8) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldOptionalUint8), v...))
	})
}

// OptionalUint8GT applies the GT predicate on the "optional_uint8" field.
func OptionalUint8GT(v uint8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldOptionalUint8), v))
	})
}

// OptionalUint8GTE applies the GTE predicate on the "optional_uint8" field.
func OptionalUint8GTE(v uint8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldOptionalUint8), v))
	})
}

// OptionalUint8LT applies the LT predicate on the "optional_uint8" field.
func OptionalUint8LT(v uint8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldOptionalUint8), v))
	})
}

// OptionalUint8LTE applies the LTE predicate on the "optional_uint8" field.
func OptionalUint8LTE(v uint8) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldOptionalUint8), v))
	})
}

// OptionalUint8IsNil applies the IsNil predicate on the "optional_uint8" field.
func OptionalUint8IsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldOptionalUint8)))
	})
}

// OptionalUint8NotNil applies the NotNil predicate on the "optional_uint8" field.
func OptionalUint8NotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldOptionalUint8)))
	})
}

// OptionalUint16EQ applies the EQ predicate on the "optional_uint16" field.
func OptionalUint16EQ(v uint16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalUint16), v))
	})
}

// OptionalUint16NEQ applies the NEQ predicate on the "optional_uint16" field.
func OptionalUint16NEQ(v uint16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldOptionalUint16), v))
	})
}

// OptionalUint16In applies the In predicate on the "optional_uint16" field.
func OptionalUint16In(vs ...uint16) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldOptionalUint16), v...))
	})
}

// OptionalUint16NotIn applies the NotIn predicate on the "optional_uint16" field.
func OptionalUint16NotIn(vs ...uint16) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldOptionalUint16), v...))
	})
}

// OptionalUint16GT applies the GT predicate on the "optional_uint16" field.
func OptionalUint16GT(v uint16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldOptionalUint16), v))
	})
}

// OptionalUint16GTE applies the GTE predicate on the "optional_uint16" field.
func OptionalUint16GTE(v uint16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldOptionalUint16), v))
	})
}

// OptionalUint16LT applies the LT predicate on the "optional_uint16" field.
func OptionalUint16LT(v uint16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldOptionalUint16), v))
	})
}

// OptionalUint16LTE applies the LTE predicate on the "optional_uint16" field.
func OptionalUint16LTE(v uint16) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldOptionalUint16), v))
	})
}

// OptionalUint16IsNil applies the IsNil predicate on the "optional_uint16" field.
func OptionalUint16IsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldOptionalUint16)))
	})
}

// OptionalUint16NotNil applies the NotNil predicate on the "optional_uint16" field.
func OptionalUint16NotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldOptionalUint16)))
	})
}

// OptionalUint32EQ applies the EQ predicate on the "optional_uint32" field.
func OptionalUint32EQ(v uint32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalUint32), v))
	})
}

// OptionalUint32NEQ applies the NEQ predicate on the "optional_uint32" field.
func OptionalUint32NEQ(v uint32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldOptionalUint32), v))
	})
}

// OptionalUint32In applies the In predicate on the "optional_uint32" field.
func OptionalUint32In(vs ...uint32) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldOptionalUint32), v...))
	})
}

// OptionalUint32NotIn applies the NotIn predicate on the "optional_uint32" field.
func OptionalUint32NotIn(vs ...uint32) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldOptionalUint32), v...))
	})
}

// OptionalUint32GT applies the GT predicate on the "optional_uint32" field.
func OptionalUint32GT(v uint32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldOptionalUint32), v))
	})
}

// OptionalUint32GTE applies the GTE predicate on the "optional_uint32" field.
func OptionalUint32GTE(v uint32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldOptionalUint32), v))
	})
}

// OptionalUint32LT applies the LT predicate on the "optional_uint32" field.
func OptionalUint32LT(v uint32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldOptionalUint32), v))
	})
}

// OptionalUint32LTE applies the LTE predicate on the "optional_uint32" field.
func OptionalUint32LTE(v uint32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldOptionalUint32), v))
	})
}

// OptionalUint32IsNil applies the IsNil predicate on the "optional_uint32" field.
func OptionalUint32IsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldOptionalUint32)))
	})
}

// OptionalUint32NotNil applies the NotNil predicate on the "optional_uint32" field.
func OptionalUint32NotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldOptionalUint32)))
	})
}

// OptionalUint64EQ applies the EQ predicate on the "optional_uint64" field.
func OptionalUint64EQ(v uint64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalUint64), v))
	})
}

// OptionalUint64NEQ applies the NEQ predicate on the "optional_uint64" field.
func OptionalUint64NEQ(v uint64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldOptionalUint64), v))
	})
}

// OptionalUint64In applies the In predicate on the "optional_uint64" field.
func OptionalUint64In(vs ...uint64) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldOptionalUint64), v...))
	})
}

// OptionalUint64NotIn applies the NotIn predicate on the "optional_uint64" field.
func OptionalUint64NotIn(vs ...uint64) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldOptionalUint64), v...))
	})
}

// OptionalUint64GT applies the GT predicate on the "optional_uint64" field.
func OptionalUint64GT(v uint64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldOptionalUint64), v))
	})
}

// OptionalUint64GTE applies the GTE predicate on the "optional_uint64" field.
func OptionalUint64GTE(v uint64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldOptionalUint64), v))
	})
}

// OptionalUint64LT applies the LT predicate on the "optional_uint64" field.
func OptionalUint64LT(v uint64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldOptionalUint64), v))
	})
}

// OptionalUint64LTE applies the LTE predicate on the "optional_uint64" field.
func OptionalUint64LTE(v uint64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldOptionalUint64), v))
	})
}

// OptionalUint64IsNil applies the IsNil predicate on the "optional_uint64" field.
func OptionalUint64IsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldOptionalUint64)))
	})
}

// OptionalUint64NotNil applies the NotNil predicate on the "optional_uint64" field.
func OptionalUint64NotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldOptionalUint64)))
	})
}

// StateEQ applies the EQ predicate on the "state" field.
func StateEQ(v State) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldState), v))
	})
}

// StateNEQ applies the NEQ predicate on the "state" field.
func StateNEQ(v State) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldState), v))
	})
}

// StateIn applies the In predicate on the "state" field.
func StateIn(vs ...State) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldState), v...))
	})
}

// StateNotIn applies the NotIn predicate on the "state" field.
func StateNotIn(vs ...State) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldState), v...))
	})
}

// StateIsNil applies the IsNil predicate on the "state" field.
func StateIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldState)))
	})
}

// StateNotNil applies the NotNil predicate on the "state" field.
func StateNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldState)))
	})
}

// OptionalFloatEQ applies the EQ predicate on the "optional_float" field.
func OptionalFloatEQ(v float64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalFloat), v))
	})
}

// OptionalFloatNEQ applies the NEQ predicate on the "optional_float" field.
func OptionalFloatNEQ(v float64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldOptionalFloat), v))
	})
}

// OptionalFloatIn applies the In predicate on the "optional_float" field.
func OptionalFloatIn(vs ...float64) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldOptionalFloat), v...))
	})
}

// OptionalFloatNotIn applies the NotIn predicate on the "optional_float" field.
func OptionalFloatNotIn(vs ...float64) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldOptionalFloat), v...))
	})
}

// OptionalFloatGT applies the GT predicate on the "optional_float" field.
func OptionalFloatGT(v float64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldOptionalFloat), v))
	})
}

// OptionalFloatGTE applies the GTE predicate on the "optional_float" field.
func OptionalFloatGTE(v float64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldOptionalFloat), v))
	})
}

// OptionalFloatLT applies the LT predicate on the "optional_float" field.
func OptionalFloatLT(v float64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldOptionalFloat), v))
	})
}

// OptionalFloatLTE applies the LTE predicate on the "optional_float" field.
func OptionalFloatLTE(v float64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldOptionalFloat), v))
	})
}

// OptionalFloatIsNil applies the IsNil predicate on the "optional_float" field.
func OptionalFloatIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldOptionalFloat)))
	})
}

// OptionalFloatNotNil applies the NotNil predicate on the "optional_float" field.
func OptionalFloatNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldOptionalFloat)))
	})
}

// OptionalFloat32EQ applies the EQ predicate on the "optional_float32" field.
func OptionalFloat32EQ(v float32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalFloat32), v))
	})
}

// OptionalFloat32NEQ applies the NEQ predicate on the "optional_float32" field.
func OptionalFloat32NEQ(v float32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldOptionalFloat32), v))
	})
}

// OptionalFloat32In applies the In predicate on the "optional_float32" field.
func OptionalFloat32In(vs ...float32) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldOptionalFloat32), v...))
	})
}

// OptionalFloat32NotIn applies the NotIn predicate on the "optional_float32" field.
func OptionalFloat32NotIn(vs ...float32) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldOptionalFloat32), v...))
	})
}

// OptionalFloat32GT applies the GT predicate on the "optional_float32" field.
func OptionalFloat32GT(v float32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldOptionalFloat32), v))
	})
}

// OptionalFloat32GTE applies the GTE predicate on the "optional_float32" field.
func OptionalFloat32GTE(v float32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldOptionalFloat32), v))
	})
}

// OptionalFloat32LT applies the LT predicate on the "optional_float32" field.
func OptionalFloat32LT(v float32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldOptionalFloat32), v))
	})
}

// OptionalFloat32LTE applies the LTE predicate on the "optional_float32" field.
func OptionalFloat32LTE(v float32) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldOptionalFloat32), v))
	})
}

// OptionalFloat32IsNil applies the IsNil predicate on the "optional_float32" field.
func OptionalFloat32IsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldOptionalFloat32)))
	})
}

// OptionalFloat32NotNil applies the NotNil predicate on the "optional_float32" field.
func OptionalFloat32NotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldOptionalFloat32)))
	})
}

// TextEQ applies the EQ predicate on the "text" field.
func TextEQ(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldText), v))
	})
}

// TextNEQ applies the NEQ predicate on the "text" field.
func TextNEQ(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldText), v))
	})
}

// TextIn applies the In predicate on the "text" field.
func TextIn(vs ...string) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldText), v...))
	})
}

// TextNotIn applies the NotIn predicate on the "text" field.
func TextNotIn(vs ...string) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldText), v...))
	})
}

// TextGT applies the GT predicate on the "text" field.
func TextGT(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldText), v))
	})
}

// TextGTE applies the GTE predicate on the "text" field.
func TextGTE(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldText), v))
	})
}

// TextLT applies the LT predicate on the "text" field.
func TextLT(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldText), v))
	})
}

// TextLTE applies the LTE predicate on the "text" field.
func TextLTE(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldText), v))
	})
}

// TextContains applies the Contains predicate on the "text" field.
func TextContains(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldText), v))
	})
}

// TextHasPrefix applies the HasPrefix predicate on the "text" field.
func TextHasPrefix(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldText), v))
	})
}

// TextHasSuffix applies the HasSuffix predicate on the "text" field.
func TextHasSuffix(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldText), v))
	})
}

// TextIsNil applies the IsNil predicate on the "text" field.
func TextIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldText)))
	})
}

// TextNotNil applies the NotNil predicate on the "text" field.
func TextNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldText)))
	})
}

// TextEqualFold applies the EqualFold predicate on the "text" field.
func TextEqualFold(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldText), v))
	})
}

// TextContainsFold applies the ContainsFold predicate on the "text" field.
func TextContainsFold(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldText), v))
	})
}

// DatetimeEQ applies the EQ predicate on the "datetime" field.
func DatetimeEQ(v time.Time) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldDatetime), v))
	})
}

// DatetimeNEQ applies the NEQ predicate on the "datetime" field.
func DatetimeNEQ(v time.Time) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldDatetime), v))
	})
}

// DatetimeIn applies the In predicate on the "datetime" field.
func DatetimeIn(vs ...time.Time) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldDatetime), v...))
	})
}

// DatetimeNotIn applies the NotIn predicate on the "datetime" field.
func DatetimeNotIn(vs ...time.Time) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldDatetime), v...))
	})
}

// DatetimeGT applies the GT predicate on the "datetime" field.
func DatetimeGT(v time.Time) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldDatetime), v))
	})
}

// DatetimeGTE applies the GTE predicate on the "datetime" field.
func DatetimeGTE(v time.Time) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldDatetime), v))
	})
}

// DatetimeLT applies the LT predicate on the "datetime" field.
func DatetimeLT(v time.Time) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldDatetime), v))
	})
}

// DatetimeLTE applies the LTE predicate on the "datetime" field.
func DatetimeLTE(v time.Time) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldDatetime), v))
	})
}

// DatetimeIsNil applies the IsNil predicate on the "datetime" field.
func DatetimeIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldDatetime)))
	})
}

// DatetimeNotNil applies the NotNil predicate on the "datetime" field.
func DatetimeNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldDatetime)))
	})
}

// DecimalEQ applies the EQ predicate on the "decimal" field.
func DecimalEQ(v float64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldDecimal), v))
	})
}

// DecimalNEQ applies the NEQ predicate on the "decimal" field.
func DecimalNEQ(v float64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldDecimal), v))
	})
}

// DecimalIn applies the In predicate on the "decimal" field.
func DecimalIn(vs ...float64) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldDecimal), v...))
	})
}

// DecimalNotIn applies the NotIn predicate on the "decimal" field.
func DecimalNotIn(vs ...float64) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldDecimal), v...))
	})
}

// DecimalGT applies the GT predicate on the "decimal" field.
func DecimalGT(v float64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldDecimal), v))
	})
}

// DecimalGTE applies the GTE predicate on the "decimal" field.
func DecimalGTE(v float64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldDecimal), v))
	})
}

// DecimalLT applies the LT predicate on the "decimal" field.
func DecimalLT(v float64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldDecimal), v))
	})
}

// DecimalLTE applies the LTE predicate on the "decimal" field.
func DecimalLTE(v float64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldDecimal), v))
	})
}

// DecimalIsNil applies the IsNil predicate on the "decimal" field.
func DecimalIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldDecimal)))
	})
}

// DecimalNotNil applies the NotNil predicate on the "decimal" field.
func DecimalNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldDecimal)))
	})
}

// LinkOtherEQ applies the EQ predicate on the "link_other" field.
func LinkOtherEQ(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldLinkOther), v))
	})
}

// LinkOtherNEQ applies the NEQ predicate on the "link_other" field.
func LinkOtherNEQ(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldLinkOther), v))
	})
}

// LinkOtherIn applies the In predicate on the "link_other" field.
func LinkOtherIn(vs ...*schema.Link) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldLinkOther), v...))
	})
}

// LinkOtherNotIn applies the NotIn predicate on the "link_other" field.
func LinkOtherNotIn(vs ...*schema.Link) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldLinkOther), v...))
	})
}

// LinkOtherGT applies the GT predicate on the "link_other" field.
func LinkOtherGT(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldLinkOther), v))
	})
}

// LinkOtherGTE applies the GTE predicate on the "link_other" field.
func LinkOtherGTE(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldLinkOther), v))
	})
}

// LinkOtherLT applies the LT predicate on the "link_other" field.
func LinkOtherLT(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldLinkOther), v))
	})
}

// LinkOtherLTE applies the LTE predicate on the "link_other" field.
func LinkOtherLTE(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldLinkOther), v))
	})
}

// LinkOtherIsNil applies the IsNil predicate on the "link_other" field.
func LinkOtherIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldLinkOther)))
	})
}

// LinkOtherNotNil applies the NotNil predicate on the "link_other" field.
func LinkOtherNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldLinkOther)))
	})
}

// LinkOtherFuncEQ applies the EQ predicate on the "link_other_func" field.
func LinkOtherFuncEQ(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldLinkOtherFunc), v))
	})
}

// LinkOtherFuncNEQ applies the NEQ predicate on the "link_other_func" field.
func LinkOtherFuncNEQ(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldLinkOtherFunc), v))
	})
}

// LinkOtherFuncIn applies the In predicate on the "link_other_func" field.
func LinkOtherFuncIn(vs ...*schema.Link) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldLinkOtherFunc), v...))
	})
}

// LinkOtherFuncNotIn applies the NotIn predicate on the "link_other_func" field.
func LinkOtherFuncNotIn(vs ...*schema.Link) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldLinkOtherFunc), v...))
	})
}

// LinkOtherFuncGT applies the GT predicate on the "link_other_func" field.
func LinkOtherFuncGT(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldLinkOtherFunc), v))
	})
}

// LinkOtherFuncGTE applies the GTE predicate on the "link_other_func" field.
func LinkOtherFuncGTE(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldLinkOtherFunc), v))
	})
}

// LinkOtherFuncLT applies the LT predicate on the "link_other_func" field.
func LinkOtherFuncLT(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldLinkOtherFunc), v))
	})
}

// LinkOtherFuncLTE applies the LTE predicate on the "link_other_func" field.
func LinkOtherFuncLTE(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldLinkOtherFunc), v))
	})
}

// LinkOtherFuncIsNil applies the IsNil predicate on the "link_other_func" field.
func LinkOtherFuncIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldLinkOtherFunc)))
	})
}

// LinkOtherFuncNotNil applies the NotNil predicate on the "link_other_func" field.
func LinkOtherFuncNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldLinkOtherFunc)))
	})
}

// MACEQ applies the EQ predicate on the "mac" field.
func MACEQ(v schema.MAC) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldMAC), v))
	})
}

// MACNEQ applies the NEQ predicate on the "mac" field.
func MACNEQ(v schema.MAC) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldMAC), v))
	})
}

// MACIn applies the In predicate on the "mac" field.
func MACIn(vs ...schema.MAC) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldMAC), v...))
	})
}

// MACNotIn applies the NotIn predicate on the "mac" field.
func MACNotIn(vs ...schema.MAC) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldMAC), v...))
	})
}

// MACGT applies the GT predicate on the "mac" field.
func MACGT(v schema.MAC) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldMAC), v))
	})
}

// MACGTE applies the GTE predicate on the "mac" field.
func MACGTE(v schema.MAC) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldMAC), v))
	})
}

// MACLT applies the LT predicate on the "mac" field.
func MACLT(v schema.MAC) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldMAC), v))
	})
}

// MACLTE applies the LTE predicate on the "mac" field.
func MACLTE(v schema.MAC) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldMAC), v))
	})
}

// MACContains applies the Contains predicate on the "mac" field.
func MACContains(v schema.MAC) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldMAC), vc))
	})
}

// MACHasPrefix applies the HasPrefix predicate on the "mac" field.
func MACHasPrefix(v schema.MAC) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldMAC), vc))
	})
}

// MACHasSuffix applies the HasSuffix predicate on the "mac" field.
func MACHasSuffix(v schema.MAC) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldMAC), vc))
	})
}

// MACIsNil applies the IsNil predicate on the "mac" field.
func MACIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldMAC)))
	})
}

// MACNotNil applies the NotNil predicate on the "mac" field.
func MACNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldMAC)))
	})
}

// MACEqualFold applies the EqualFold predicate on the "mac" field.
func MACEqualFold(v schema.MAC) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldMAC), vc))
	})
}

// MACContainsFold applies the ContainsFold predicate on the "mac" field.
func MACContainsFold(v schema.MAC) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldMAC), vc))
	})
}

// StringArrayEQ applies the EQ predicate on the "string_array" field.
func StringArrayEQ(v schema.Strings) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldStringArray), v))
	})
}

// StringArrayNEQ applies the NEQ predicate on the "string_array" field.
func StringArrayNEQ(v schema.Strings) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldStringArray), v))
	})
}

// StringArrayIn applies the In predicate on the "string_array" field.
func StringArrayIn(vs ...schema.Strings) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldStringArray), v...))
	})
}

// StringArrayNotIn applies the NotIn predicate on the "string_array" field.
func StringArrayNotIn(vs ...schema.Strings) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldStringArray), v...))
	})
}

// StringArrayGT applies the GT predicate on the "string_array" field.
func StringArrayGT(v schema.Strings) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldStringArray), v))
	})
}

// StringArrayGTE applies the GTE predicate on the "string_array" field.
func StringArrayGTE(v schema.Strings) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldStringArray), v))
	})
}

// StringArrayLT applies the LT predicate on the "string_array" field.
func StringArrayLT(v schema.Strings) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldStringArray), v))
	})
}

// StringArrayLTE applies the LTE predicate on the "string_array" field.
func StringArrayLTE(v schema.Strings) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldStringArray), v))
	})
}

// StringArrayIsNil applies the IsNil predicate on the "string_array" field.
func StringArrayIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldStringArray)))
	})
}

// StringArrayNotNil applies the NotNil predicate on the "string_array" field.
func StringArrayNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldStringArray)))
	})
}

// PasswordEQ applies the EQ predicate on the "password" field.
func PasswordEQ(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldPassword), v))
	})
}

// PasswordNEQ applies the NEQ predicate on the "password" field.
func PasswordNEQ(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldPassword), v))
	})
}

// PasswordIn applies the In predicate on the "password" field.
func PasswordIn(vs ...string) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldPassword), v...))
	})
}

// PasswordNotIn applies the NotIn predicate on the "password" field.
func PasswordNotIn(vs ...string) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldPassword), v...))
	})
}

// PasswordGT applies the GT predicate on the "password" field.
func PasswordGT(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldPassword), v))
	})
}

// PasswordGTE applies the GTE predicate on the "password" field.
func PasswordGTE(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldPassword), v))
	})
}

// PasswordLT applies the LT predicate on the "password" field.
func PasswordLT(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldPassword), v))
	})
}

// PasswordLTE applies the LTE predicate on the "password" field.
func PasswordLTE(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldPassword), v))
	})
}

// PasswordContains applies the Contains predicate on the "password" field.
func PasswordContains(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldPassword), v))
	})
}

// PasswordHasPrefix applies the HasPrefix predicate on the "password" field.
func PasswordHasPrefix(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldPassword), v))
	})
}

// PasswordHasSuffix applies the HasSuffix predicate on the "password" field.
func PasswordHasSuffix(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldPassword), v))
	})
}

// PasswordIsNil applies the IsNil predicate on the "password" field.
func PasswordIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldPassword)))
	})
}

// PasswordNotNil applies the NotNil predicate on the "password" field.
func PasswordNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldPassword)))
	})
}

// PasswordEqualFold applies the EqualFold predicate on the "password" field.
func PasswordEqualFold(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldPassword), v))
	})
}

// PasswordContainsFold applies the ContainsFold predicate on the "password" field.
func PasswordContainsFold(v string) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldPassword), v))
	})
}

// StringScannerEQ applies the EQ predicate on the "string_scanner" field.
func StringScannerEQ(v schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldStringScanner), v))
	})
}

// StringScannerNEQ applies the NEQ predicate on the "string_scanner" field.
func StringScannerNEQ(v schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldStringScanner), v))
	})
}

// StringScannerIn applies the In predicate on the "string_scanner" field.
func StringScannerIn(vs ...schema.StringScanner) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldStringScanner), v...))
	})
}

// StringScannerNotIn applies the NotIn predicate on the "string_scanner" field.
func StringScannerNotIn(vs ...schema.StringScanner) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldStringScanner), v...))
	})
}

// StringScannerGT applies the GT predicate on the "string_scanner" field.
func StringScannerGT(v schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldStringScanner), v))
	})
}

// StringScannerGTE applies the GTE predicate on the "string_scanner" field.
func StringScannerGTE(v schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldStringScanner), v))
	})
}

// StringScannerLT applies the LT predicate on the "string_scanner" field.
func StringScannerLT(v schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldStringScanner), v))
	})
}

// StringScannerLTE applies the LTE predicate on the "string_scanner" field.
func StringScannerLTE(v schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldStringScanner), v))
	})
}

// StringScannerContains applies the Contains predicate on the "string_scanner" field.
func StringScannerContains(v schema.StringScanner) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldStringScanner), vc))
	})
}

// StringScannerHasPrefix applies the HasPrefix predicate on the "string_scanner" field.
func StringScannerHasPrefix(v schema.StringScanner) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldStringScanner), vc))
	})
}

// StringScannerHasSuffix applies the HasSuffix predicate on the "string_scanner" field.
func StringScannerHasSuffix(v schema.StringScanner) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldStringScanner), vc))
	})
}

// StringScannerIsNil applies the IsNil predicate on the "string_scanner" field.
func StringScannerIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldStringScanner)))
	})
}

// StringScannerNotNil applies the NotNil predicate on the "string_scanner" field.
func StringScannerNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldStringScanner)))
	})
}

// StringScannerEqualFold applies the EqualFold predicate on the "string_scanner" field.
func StringScannerEqualFold(v schema.StringScanner) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldStringScanner), vc))
	})
}

// StringScannerContainsFold applies the ContainsFold predicate on the "string_scanner" field.
func StringScannerContainsFold(v schema.StringScanner) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldStringScanner), vc))
	})
}

// DurationEQ applies the EQ predicate on the "duration" field.
func DurationEQ(v time.Duration) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldDuration), vc))
	})
}

// DurationNEQ applies the NEQ predicate on the "duration" field.
func DurationNEQ(v time.Duration) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldDuration), vc))
	})
}

// DurationIn applies the In predicate on the "duration" field.
func DurationIn(vs ...time.Duration) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = int64(vs[i])
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldDuration), v...))
	})
}

// DurationNotIn applies the NotIn predicate on the "duration" field.
func DurationNotIn(vs ...time.Duration) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = int64(vs[i])
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldDuration), v...))
	})
}

// DurationGT applies the GT predicate on the "duration" field.
func DurationGT(v time.Duration) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldDuration), vc))
	})
}

// DurationGTE applies the GTE predicate on the "duration" field.
func DurationGTE(v time.Duration) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldDuration), vc))
	})
}

// DurationLT applies the LT predicate on the "duration" field.
func DurationLT(v time.Duration) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldDuration), vc))
	})
}

// DurationLTE applies the LTE predicate on the "duration" field.
func DurationLTE(v time.Duration) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldDuration), vc))
	})
}

// DurationIsNil applies the IsNil predicate on the "duration" field.
func DurationIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldDuration)))
	})
}

// DurationNotNil applies the NotNil predicate on the "duration" field.
func DurationNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldDuration)))
	})
}

// DirEQ applies the EQ predicate on the "dir" field.
func DirEQ(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldDir), vc))
	})
}

// DirNEQ applies the NEQ predicate on the "dir" field.
func DirNEQ(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldDir), vc))
	})
}

// DirIn applies the In predicate on the "dir" field.
func DirIn(vs ...http.Dir) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldDir), v...))
	})
}

// DirNotIn applies the NotIn predicate on the "dir" field.
func DirNotIn(vs ...http.Dir) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldDir), v...))
	})
}

// DirGT applies the GT predicate on the "dir" field.
func DirGT(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldDir), vc))
	})
}

// DirGTE applies the GTE predicate on the "dir" field.
func DirGTE(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldDir), vc))
	})
}

// DirLT applies the LT predicate on the "dir" field.
func DirLT(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldDir), vc))
	})
}

// DirLTE applies the LTE predicate on the "dir" field.
func DirLTE(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldDir), vc))
	})
}

// DirContains applies the Contains predicate on the "dir" field.
func DirContains(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldDir), vc))
	})
}

// DirHasPrefix applies the HasPrefix predicate on the "dir" field.
func DirHasPrefix(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldDir), vc))
	})
}

// DirHasSuffix applies the HasSuffix predicate on the "dir" field.
func DirHasSuffix(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldDir), vc))
	})
}

// DirEqualFold applies the EqualFold predicate on the "dir" field.
func DirEqualFold(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldDir), vc))
	})
}

// DirContainsFold applies the ContainsFold predicate on the "dir" field.
func DirContainsFold(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldDir), vc))
	})
}

// NdirEQ applies the EQ predicate on the "ndir" field.
func NdirEQ(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNdir), vc))
	})
}

// NdirNEQ applies the NEQ predicate on the "ndir" field.
func NdirNEQ(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldNdir), vc))
	})
}

// NdirIn applies the In predicate on the "ndir" field.
func NdirIn(vs ...http.Dir) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldNdir), v...))
	})
}

// NdirNotIn applies the NotIn predicate on the "ndir" field.
func NdirNotIn(vs ...http.Dir) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldNdir), v...))
	})
}

// NdirGT applies the GT predicate on the "ndir" field.
func NdirGT(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldNdir), vc))
	})
}

// NdirGTE applies the GTE predicate on the "ndir" field.
func NdirGTE(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldNdir), vc))
	})
}

// NdirLT applies the LT predicate on the "ndir" field.
func NdirLT(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldNdir), vc))
	})
}

// NdirLTE applies the LTE predicate on the "ndir" field.
func NdirLTE(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldNdir), vc))
	})
}

// NdirContains applies the Contains predicate on the "ndir" field.
func NdirContains(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldNdir), vc))
	})
}

// NdirHasPrefix applies the HasPrefix predicate on the "ndir" field.
func NdirHasPrefix(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldNdir), vc))
	})
}

// NdirHasSuffix applies the HasSuffix predicate on the "ndir" field.
func NdirHasSuffix(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldNdir), vc))
	})
}

// NdirIsNil applies the IsNil predicate on the "ndir" field.
func NdirIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldNdir)))
	})
}

// NdirNotNil applies the NotNil predicate on the "ndir" field.
func NdirNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldNdir)))
	})
}

// NdirEqualFold applies the EqualFold predicate on the "ndir" field.
func NdirEqualFold(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldNdir), vc))
	})
}

// NdirContainsFold applies the ContainsFold predicate on the "ndir" field.
func NdirContainsFold(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldNdir), vc))
	})
}

// StrEQ applies the EQ predicate on the "str" field.
func StrEQ(v sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldStr), v))
	})
}

// StrNEQ applies the NEQ predicate on the "str" field.
func StrNEQ(v sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldStr), v))
	})
}

// StrIn applies the In predicate on the "str" field.
func StrIn(vs ...sql.NullString) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldStr), v...))
	})
}

// StrNotIn applies the NotIn predicate on the "str" field.
func StrNotIn(vs ...sql.NullString) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldStr), v...))
	})
}

// StrGT applies the GT predicate on the "str" field.
func StrGT(v sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldStr), v))
	})
}

// StrGTE applies the GTE predicate on the "str" field.
func StrGTE(v sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldStr), v))
	})
}

// StrLT applies the LT predicate on the "str" field.
func StrLT(v sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldStr), v))
	})
}

// StrLTE applies the LTE predicate on the "str" field.
func StrLTE(v sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldStr), v))
	})
}

// StrContains applies the Contains predicate on the "str" field.
func StrContains(v sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldStr), vc))
	})
}

// StrHasPrefix applies the HasPrefix predicate on the "str" field.
func StrHasPrefix(v sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldStr), vc))
	})
}

// StrHasSuffix applies the HasSuffix predicate on the "str" field.
func StrHasSuffix(v sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldStr), vc))
	})
}

// StrIsNil applies the IsNil predicate on the "str" field.
func StrIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldStr)))
	})
}

// StrNotNil applies the NotNil predicate on the "str" field.
func StrNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldStr)))
	})
}

// StrEqualFold applies the EqualFold predicate on the "str" field.
func StrEqualFold(v sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldStr), vc))
	})
}

// StrContainsFold applies the ContainsFold predicate on the "str" field.
func StrContainsFold(v sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldStr), vc))
	})
}

// NullStrEQ applies the EQ predicate on the "null_str" field.
func NullStrEQ(v *sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNullStr), v))
	})
}

// NullStrNEQ applies the NEQ predicate on the "null_str" field.
func NullStrNEQ(v *sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldNullStr), v))
	})
}

// NullStrIn applies the In predicate on the "null_str" field.
func NullStrIn(vs ...*sql.NullString) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldNullStr), v...))
	})
}

// NullStrNotIn applies the NotIn predicate on the "null_str" field.
func NullStrNotIn(vs ...*sql.NullString) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldNullStr), v...))
	})
}

// NullStrGT applies the GT predicate on the "null_str" field.
func NullStrGT(v *sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldNullStr), v))
	})
}

// NullStrGTE applies the GTE predicate on the "null_str" field.
func NullStrGTE(v *sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldNullStr), v))
	})
}

// NullStrLT applies the LT predicate on the "null_str" field.
func NullStrLT(v *sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldNullStr), v))
	})
}

// NullStrLTE applies the LTE predicate on the "null_str" field.
func NullStrLTE(v *sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldNullStr), v))
	})
}

// NullStrContains applies the Contains predicate on the "null_str" field.
func NullStrContains(v *sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldNullStr), vc))
	})
}

// NullStrHasPrefix applies the HasPrefix predicate on the "null_str" field.
func NullStrHasPrefix(v *sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldNullStr), vc))
	})
}

// NullStrHasSuffix applies the HasSuffix predicate on the "null_str" field.
func NullStrHasSuffix(v *sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldNullStr), vc))
	})
}

// NullStrIsNil applies the IsNil predicate on the "null_str" field.
func NullStrIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldNullStr)))
	})
}

// NullStrNotNil applies the NotNil predicate on the "null_str" field.
func NullStrNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldNullStr)))
	})
}

// NullStrEqualFold applies the EqualFold predicate on the "null_str" field.
func NullStrEqualFold(v *sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldNullStr), vc))
	})
}

// NullStrContainsFold applies the ContainsFold predicate on the "null_str" field.
func NullStrContainsFold(v *sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldNullStr), vc))
	})
}

// LinkEQ applies the EQ predicate on the "link" field.
func LinkEQ(v schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldLink), v))
	})
}

// LinkNEQ applies the NEQ predicate on the "link" field.
func LinkNEQ(v schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldLink), v))
	})
}

// LinkIn applies the In predicate on the "link" field.
func LinkIn(vs ...schema.Link) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldLink), v...))
	})
}

// LinkNotIn applies the NotIn predicate on the "link" field.
func LinkNotIn(vs ...schema.Link) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldLink), v...))
	})
}

// LinkGT applies the GT predicate on the "link" field.
func LinkGT(v schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldLink), v))
	})
}

// LinkGTE applies the GTE predicate on the "link" field.
func LinkGTE(v schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldLink), v))
	})
}

// LinkLT applies the LT predicate on the "link" field.
func LinkLT(v schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldLink), v))
	})
}

// LinkLTE applies the LTE predicate on the "link" field.
func LinkLTE(v schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldLink), v))
	})
}

// LinkContains applies the Contains predicate on the "link" field.
func LinkContains(v schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldLink), vc))
	})
}

// LinkHasPrefix applies the HasPrefix predicate on the "link" field.
func LinkHasPrefix(v schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldLink), vc))
	})
}

// LinkHasSuffix applies the HasSuffix predicate on the "link" field.
func LinkHasSuffix(v schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldLink), vc))
	})
}

// LinkIsNil applies the IsNil predicate on the "link" field.
func LinkIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldLink)))
	})
}

// LinkNotNil applies the NotNil predicate on the "link" field.
func LinkNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldLink)))
	})
}

// LinkEqualFold applies the EqualFold predicate on the "link" field.
func LinkEqualFold(v schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldLink), vc))
	})
}

// LinkContainsFold applies the ContainsFold predicate on the "link" field.
func LinkContainsFold(v schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldLink), vc))
	})
}

// NullLinkEQ applies the EQ predicate on the "null_link" field.
func NullLinkEQ(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNullLink), v))
	})
}

// NullLinkNEQ applies the NEQ predicate on the "null_link" field.
func NullLinkNEQ(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldNullLink), v))
	})
}

// NullLinkIn applies the In predicate on the "null_link" field.
func NullLinkIn(vs ...*schema.Link) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldNullLink), v...))
	})
}

// NullLinkNotIn applies the NotIn predicate on the "null_link" field.
func NullLinkNotIn(vs ...*schema.Link) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldNullLink), v...))
	})
}

// NullLinkGT applies the GT predicate on the "null_link" field.
func NullLinkGT(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldNullLink), v))
	})
}

// NullLinkGTE applies the GTE predicate on the "null_link" field.
func NullLinkGTE(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldNullLink), v))
	})
}

// NullLinkLT applies the LT predicate on the "null_link" field.
func NullLinkLT(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldNullLink), v))
	})
}

// NullLinkLTE applies the LTE predicate on the "null_link" field.
func NullLinkLTE(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldNullLink), v))
	})
}

// NullLinkContains applies the Contains predicate on the "null_link" field.
func NullLinkContains(v *schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldNullLink), vc))
	})
}

// NullLinkHasPrefix applies the HasPrefix predicate on the "null_link" field.
func NullLinkHasPrefix(v *schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldNullLink), vc))
	})
}

// NullLinkHasSuffix applies the HasSuffix predicate on the "null_link" field.
func NullLinkHasSuffix(v *schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldNullLink), vc))
	})
}

// NullLinkIsNil applies the IsNil predicate on the "null_link" field.
func NullLinkIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldNullLink)))
	})
}

// NullLinkNotNil applies the NotNil predicate on the "null_link" field.
func NullLinkNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldNullLink)))
	})
}

// NullLinkEqualFold applies the EqualFold predicate on the "null_link" field.
func NullLinkEqualFold(v *schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldNullLink), vc))
	})
}

// NullLinkContainsFold applies the ContainsFold predicate on the "null_link" field.
func NullLinkContainsFold(v *schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldNullLink), vc))
	})
}

// ActiveEQ applies the EQ predicate on the "active" field.
func ActiveEQ(v schema.Status) predicate.FieldType {
	vc := bool(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldActive), vc))
	})
}

// ActiveNEQ applies the NEQ predicate on the "active" field.
func ActiveNEQ(v schema.Status) predicate.FieldType {
	vc := bool(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldActive), vc))
	})
}

// ActiveIsNil applies the IsNil predicate on the "active" field.
func ActiveIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldActive)))
	})
}

// ActiveNotNil applies the NotNil predicate on the "active" field.
func ActiveNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldActive)))
	})
}

// NullActiveEQ applies the EQ predicate on the "null_active" field.
func NullActiveEQ(v schema.Status) predicate.FieldType {
	vc := bool(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNullActive), vc))
	})
}

// NullActiveNEQ applies the NEQ predicate on the "null_active" field.
func NullActiveNEQ(v schema.Status) predicate.FieldType {
	vc := bool(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldNullActive), vc))
	})
}

// NullActiveIsNil applies the IsNil predicate on the "null_active" field.
func NullActiveIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldNullActive)))
	})
}

// NullActiveNotNil applies the NotNil predicate on the "null_active" field.
func NullActiveNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldNullActive)))
	})
}

// DeletedEQ applies the EQ predicate on the "deleted" field.
func DeletedEQ(v *sql.NullBool) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldDeleted), v))
	})
}

// DeletedNEQ applies the NEQ predicate on the "deleted" field.
func DeletedNEQ(v *sql.NullBool) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldDeleted), v))
	})
}

// DeletedIsNil applies the IsNil predicate on the "deleted" field.
func DeletedIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldDeleted)))
	})
}

// DeletedNotNil applies the NotNil predicate on the "deleted" field.
func DeletedNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldDeleted)))
	})
}

// DeletedAtEQ applies the EQ predicate on the "deleted_at" field.
func DeletedAtEQ(v *sql.NullTime) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldDeletedAt), v))
	})
}

// DeletedAtNEQ applies the NEQ predicate on the "deleted_at" field.
func DeletedAtNEQ(v *sql.NullTime) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldDeletedAt), v))
	})
}

// DeletedAtIn applies the In predicate on the "deleted_at" field.
func DeletedAtIn(vs ...*sql.NullTime) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldDeletedAt), v...))
	})
}

// DeletedAtNotIn applies the NotIn predicate on the "deleted_at" field.
func DeletedAtNotIn(vs ...*sql.NullTime) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldDeletedAt), v...))
	})
}

// DeletedAtGT applies the GT predicate on the "deleted_at" field.
func DeletedAtGT(v *sql.NullTime) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldDeletedAt), v))
	})
}

// DeletedAtGTE applies the GTE predicate on the "deleted_at" field.
func DeletedAtGTE(v *sql.NullTime) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldDeletedAt), v))
	})
}

// DeletedAtLT applies the LT predicate on the "deleted_at" field.
func DeletedAtLT(v *sql.NullTime) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldDeletedAt), v))
	})
}

// DeletedAtLTE applies the LTE predicate on the "deleted_at" field.
func DeletedAtLTE(v *sql.NullTime) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldDeletedAt), v))
	})
}

// DeletedAtIsNil applies the IsNil predicate on the "deleted_at" field.
func DeletedAtIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldDeletedAt)))
	})
}

// DeletedAtNotNil applies the NotNil predicate on the "deleted_at" field.
func DeletedAtNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldDeletedAt)))
	})
}

// RawDataEQ applies the EQ predicate on the "raw_data" field.
func RawDataEQ(v []byte) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldRawData), v))
	})
}

// RawDataNEQ applies the NEQ predicate on the "raw_data" field.
func RawDataNEQ(v []byte) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldRawData), v))
	})
}

// RawDataIn applies the In predicate on the "raw_data" field.
func RawDataIn(vs ...[]byte) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldRawData), v...))
	})
}

// RawDataNotIn applies the NotIn predicate on the "raw_data" field.
func RawDataNotIn(vs ...[]byte) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldRawData), v...))
	})
}

// RawDataGT applies the GT predicate on the "raw_data" field.
func RawDataGT(v []byte) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldRawData), v))
	})
}

// RawDataGTE applies the GTE predicate on the "raw_data" field.
func RawDataGTE(v []byte) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldRawData), v))
	})
}

// RawDataLT applies the LT predicate on the "raw_data" field.
func RawDataLT(v []byte) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldRawData), v))
	})
}

// RawDataLTE applies the LTE predicate on the "raw_data" field.
func RawDataLTE(v []byte) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldRawData), v))
	})
}

// RawDataIsNil applies the IsNil predicate on the "raw_data" field.
func RawDataIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldRawData)))
	})
}

// RawDataNotNil applies the NotNil predicate on the "raw_data" field.
func RawDataNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldRawData)))
	})
}

// SensitiveEQ applies the EQ predicate on the "sensitive" field.
func SensitiveEQ(v []byte) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldSensitive), v))
	})
}

// SensitiveNEQ applies the NEQ predicate on the "sensitive" field.
func SensitiveNEQ(v []byte) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldSensitive), v))
	})
}

// SensitiveIn applies the In predicate on the "sensitive" field.
func SensitiveIn(vs ...[]byte) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldSensitive), v...))
	})
}

// SensitiveNotIn applies the NotIn predicate on the "sensitive" field.
func SensitiveNotIn(vs ...[]byte) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldSensitive), v...))
	})
}

// SensitiveGT applies the GT predicate on the "sensitive" field.
func SensitiveGT(v []byte) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldSensitive), v))
	})
}

// SensitiveGTE applies the GTE predicate on the "sensitive" field.
func SensitiveGTE(v []byte) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldSensitive), v))
	})
}

// SensitiveLT applies the LT predicate on the "sensitive" field.
func SensitiveLT(v []byte) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldSensitive), v))
	})
}

// SensitiveLTE applies the LTE predicate on the "sensitive" field.
func SensitiveLTE(v []byte) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldSensitive), v))
	})
}

// SensitiveIsNil applies the IsNil predicate on the "sensitive" field.
func SensitiveIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldSensitive)))
	})
}

// SensitiveNotNil applies the NotNil predicate on the "sensitive" field.
func SensitiveNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldSensitive)))
	})
}

// IPEQ applies the EQ predicate on the "ip" field.
func IPEQ(v net.IP) predicate.FieldType {
	vc := []byte(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldIP), vc))
	})
}

// IPNEQ applies the NEQ predicate on the "ip" field.
func IPNEQ(v net.IP) predicate.FieldType {
	vc := []byte(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldIP), vc))
	})
}

// IPIn applies the In predicate on the "ip" field.
func IPIn(vs ...net.IP) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = []byte(vs[i])
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldIP), v...))
	})
}

// IPNotIn applies the NotIn predicate on the "ip" field.
func IPNotIn(vs ...net.IP) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = []byte(vs[i])
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldIP), v...))
	})
}

// IPGT applies the GT predicate on the "ip" field.
func IPGT(v net.IP) predicate.FieldType {
	vc := []byte(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldIP), vc))
	})
}

// IPGTE applies the GTE predicate on the "ip" field.
func IPGTE(v net.IP) predicate.FieldType {
	vc := []byte(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldIP), vc))
	})
}

// IPLT applies the LT predicate on the "ip" field.
func IPLT(v net.IP) predicate.FieldType {
	vc := []byte(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldIP), vc))
	})
}

// IPLTE applies the LTE predicate on the "ip" field.
func IPLTE(v net.IP) predicate.FieldType {
	vc := []byte(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldIP), vc))
	})
}

// IPIsNil applies the IsNil predicate on the "ip" field.
func IPIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldIP)))
	})
}

// IPNotNil applies the NotNil predicate on the "ip" field.
func IPNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldIP)))
	})
}

// NullInt64EQ applies the EQ predicate on the "null_int64" field.
func NullInt64EQ(v *sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNullInt64), v))
	})
}

// NullInt64NEQ applies the NEQ predicate on the "null_int64" field.
func NullInt64NEQ(v *sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldNullInt64), v))
	})
}

// NullInt64In applies the In predicate on the "null_int64" field.
func NullInt64In(vs ...*sql.NullInt64) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldNullInt64), v...))
	})
}

// NullInt64NotIn applies the NotIn predicate on the "null_int64" field.
func NullInt64NotIn(vs ...*sql.NullInt64) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldNullInt64), v...))
	})
}

// NullInt64GT applies the GT predicate on the "null_int64" field.
func NullInt64GT(v *sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldNullInt64), v))
	})
}

// NullInt64GTE applies the GTE predicate on the "null_int64" field.
func NullInt64GTE(v *sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldNullInt64), v))
	})
}

// NullInt64LT applies the LT predicate on the "null_int64" field.
func NullInt64LT(v *sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldNullInt64), v))
	})
}

// NullInt64LTE applies the LTE predicate on the "null_int64" field.
func NullInt64LTE(v *sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldNullInt64), v))
	})
}

// NullInt64IsNil applies the IsNil predicate on the "null_int64" field.
func NullInt64IsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldNullInt64)))
	})
}

// NullInt64NotNil applies the NotNil predicate on the "null_int64" field.
func NullInt64NotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldNullInt64)))
	})
}

// SchemaIntEQ applies the EQ predicate on the "schema_int" field.
func SchemaIntEQ(v schema.Int) predicate.FieldType {
	vc := int(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldSchemaInt), vc))
	})
}

// SchemaIntNEQ applies the NEQ predicate on the "schema_int" field.
func SchemaIntNEQ(v schema.Int) predicate.FieldType {
	vc := int(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldSchemaInt), vc))
	})
}

// SchemaIntIn applies the In predicate on the "schema_int" field.
func SchemaIntIn(vs ...schema.Int) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = int(vs[i])
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldSchemaInt), v...))
	})
}

// SchemaIntNotIn applies the NotIn predicate on the "schema_int" field.
func SchemaIntNotIn(vs ...schema.Int) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = int(vs[i])
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldSchemaInt), v...))
	})
}

// SchemaIntGT applies the GT predicate on the "schema_int" field.
func SchemaIntGT(v schema.Int) predicate.FieldType {
	vc := int(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldSchemaInt), vc))
	})
}

// SchemaIntGTE applies the GTE predicate on the "schema_int" field.
func SchemaIntGTE(v schema.Int) predicate.FieldType {
	vc := int(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldSchemaInt), vc))
	})
}

// SchemaIntLT applies the LT predicate on the "schema_int" field.
func SchemaIntLT(v schema.Int) predicate.FieldType {
	vc := int(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldSchemaInt), vc))
	})
}

// SchemaIntLTE applies the LTE predicate on the "schema_int" field.
func SchemaIntLTE(v schema.Int) predicate.FieldType {
	vc := int(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldSchemaInt), vc))
	})
}

// SchemaIntIsNil applies the IsNil predicate on the "schema_int" field.
func SchemaIntIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldSchemaInt)))
	})
}

// SchemaIntNotNil applies the NotNil predicate on the "schema_int" field.
func SchemaIntNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldSchemaInt)))
	})
}

// SchemaInt8EQ applies the EQ predicate on the "schema_int8" field.
func SchemaInt8EQ(v schema.Int8) predicate.FieldType {
	vc := int8(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldSchemaInt8), vc))
	})
}

// SchemaInt8NEQ applies the NEQ predicate on the "schema_int8" field.
func SchemaInt8NEQ(v schema.Int8) predicate.FieldType {
	vc := int8(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldSchemaInt8), vc))
	})
}

// SchemaInt8In applies the In predicate on the "schema_int8" field.
func SchemaInt8In(vs ...schema.Int8) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = int8(vs[i])
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldSchemaInt8), v...))
	})
}

// SchemaInt8NotIn applies the NotIn predicate on the "schema_int8" field.
func SchemaInt8NotIn(vs ...schema.Int8) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = int8(vs[i])
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldSchemaInt8), v...))
	})
}

// SchemaInt8GT applies the GT predicate on the "schema_int8" field.
func SchemaInt8GT(v schema.Int8) predicate.FieldType {
	vc := int8(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldSchemaInt8), vc))
	})
}

// SchemaInt8GTE applies the GTE predicate on the "schema_int8" field.
func SchemaInt8GTE(v schema.Int8) predicate.FieldType {
	vc := int8(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldSchemaInt8), vc))
	})
}

// SchemaInt8LT applies the LT predicate on the "schema_int8" field.
func SchemaInt8LT(v schema.Int8) predicate.FieldType {
	vc := int8(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldSchemaInt8), vc))
	})
}

// SchemaInt8LTE applies the LTE predicate on the "schema_int8" field.
func SchemaInt8LTE(v schema.Int8) predicate.FieldType {
	vc := int8(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldSchemaInt8), vc))
	})
}

// SchemaInt8IsNil applies the IsNil predicate on the "schema_int8" field.
func SchemaInt8IsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldSchemaInt8)))
	})
}

// SchemaInt8NotNil applies the NotNil predicate on the "schema_int8" field.
func SchemaInt8NotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldSchemaInt8)))
	})
}

// SchemaInt64EQ applies the EQ predicate on the "schema_int64" field.
func SchemaInt64EQ(v schema.Int64) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldSchemaInt64), vc))
	})
}

// SchemaInt64NEQ applies the NEQ predicate on the "schema_int64" field.
func SchemaInt64NEQ(v schema.Int64) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldSchemaInt64), vc))
	})
}

// SchemaInt64In applies the In predicate on the "schema_int64" field.
func SchemaInt64In(vs ...schema.Int64) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = int64(vs[i])
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldSchemaInt64), v...))
	})
}

// SchemaInt64NotIn applies the NotIn predicate on the "schema_int64" field.
func SchemaInt64NotIn(vs ...schema.Int64) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = int64(vs[i])
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldSchemaInt64), v...))
	})
}

// SchemaInt64GT applies the GT predicate on the "schema_int64" field.
func SchemaInt64GT(v schema.Int64) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldSchemaInt64), vc))
	})
}

// SchemaInt64GTE applies the GTE predicate on the "schema_int64" field.
func SchemaInt64GTE(v schema.Int64) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldSchemaInt64), vc))
	})
}

// SchemaInt64LT applies the LT predicate on the "schema_int64" field.
func SchemaInt64LT(v schema.Int64) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldSchemaInt64), vc))
	})
}

// SchemaInt64LTE applies the LTE predicate on the "schema_int64" field.
func SchemaInt64LTE(v schema.Int64) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldSchemaInt64), vc))
	})
}

// SchemaInt64IsNil applies the IsNil predicate on the "schema_int64" field.
func SchemaInt64IsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldSchemaInt64)))
	})
}

// SchemaInt64NotNil applies the NotNil predicate on the "schema_int64" field.
func SchemaInt64NotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldSchemaInt64)))
	})
}

// SchemaFloatEQ applies the EQ predicate on the "schema_float" field.
func SchemaFloatEQ(v schema.Float64) predicate.FieldType {
	vc := float64(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldSchemaFloat), vc))
	})
}

// SchemaFloatNEQ applies the NEQ predicate on the "schema_float" field.
func SchemaFloatNEQ(v schema.Float64) predicate.FieldType {
	vc := float64(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldSchemaFloat), vc))
	})
}

// SchemaFloatIn applies the In predicate on the "schema_float" field.
func SchemaFloatIn(vs ...schema.Float64) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = float64(vs[i])
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldSchemaFloat), v...))
	})
}

// SchemaFloatNotIn applies the NotIn predicate on the "schema_float" field.
func SchemaFloatNotIn(vs ...schema.Float64) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = float64(vs[i])
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldSchemaFloat), v...))
	})
}

// SchemaFloatGT applies the GT predicate on the "schema_float" field.
func SchemaFloatGT(v schema.Float64) predicate.FieldType {
	vc := float64(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldSchemaFloat), vc))
	})
}

// SchemaFloatGTE applies the GTE predicate on the "schema_float" field.
func SchemaFloatGTE(v schema.Float64) predicate.FieldType {
	vc := float64(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldSchemaFloat), vc))
	})
}

// SchemaFloatLT applies the LT predicate on the "schema_float" field.
func SchemaFloatLT(v schema.Float64) predicate.FieldType {
	vc := float64(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldSchemaFloat), vc))
	})
}

// SchemaFloatLTE applies the LTE predicate on the "schema_float" field.
func SchemaFloatLTE(v schema.Float64) predicate.FieldType {
	vc := float64(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldSchemaFloat), vc))
	})
}

// SchemaFloatIsNil applies the IsNil predicate on the "schema_float" field.
func SchemaFloatIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldSchemaFloat)))
	})
}

// SchemaFloatNotNil applies the NotNil predicate on the "schema_float" field.
func SchemaFloatNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldSchemaFloat)))
	})
}

// SchemaFloat32EQ applies the EQ predicate on the "schema_float32" field.
func SchemaFloat32EQ(v schema.Float32) predicate.FieldType {
	vc := float32(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldSchemaFloat32), vc))
	})
}

// SchemaFloat32NEQ applies the NEQ predicate on the "schema_float32" field.
func SchemaFloat32NEQ(v schema.Float32) predicate.FieldType {
	vc := float32(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldSchemaFloat32), vc))
	})
}

// SchemaFloat32In applies the In predicate on the "schema_float32" field.
func SchemaFloat32In(vs ...schema.Float32) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = float32(vs[i])
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldSchemaFloat32), v...))
	})
}

// SchemaFloat32NotIn applies the NotIn predicate on the "schema_float32" field.
func SchemaFloat32NotIn(vs ...schema.Float32) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = float32(vs[i])
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldSchemaFloat32), v...))
	})
}

// SchemaFloat32GT applies the GT predicate on the "schema_float32" field.
func SchemaFloat32GT(v schema.Float32) predicate.FieldType {
	vc := float32(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldSchemaFloat32), vc))
	})
}

// SchemaFloat32GTE applies the GTE predicate on the "schema_float32" field.
func SchemaFloat32GTE(v schema.Float32) predicate.FieldType {
	vc := float32(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldSchemaFloat32), vc))
	})
}

// SchemaFloat32LT applies the LT predicate on the "schema_float32" field.
func SchemaFloat32LT(v schema.Float32) predicate.FieldType {
	vc := float32(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldSchemaFloat32), vc))
	})
}

// SchemaFloat32LTE applies the LTE predicate on the "schema_float32" field.
func SchemaFloat32LTE(v schema.Float32) predicate.FieldType {
	vc := float32(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldSchemaFloat32), vc))
	})
}

// SchemaFloat32IsNil applies the IsNil predicate on the "schema_float32" field.
func SchemaFloat32IsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldSchemaFloat32)))
	})
}

// SchemaFloat32NotNil applies the NotNil predicate on the "schema_float32" field.
func SchemaFloat32NotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldSchemaFloat32)))
	})
}

// NullFloatEQ applies the EQ predicate on the "null_float" field.
func NullFloatEQ(v *sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNullFloat), v))
	})
}

// NullFloatNEQ applies the NEQ predicate on the "null_float" field.
func NullFloatNEQ(v *sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldNullFloat), v))
	})
}

// NullFloatIn applies the In predicate on the "null_float" field.
func NullFloatIn(vs ...*sql.NullFloat64) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldNullFloat), v...))
	})
}

// NullFloatNotIn applies the NotIn predicate on the "null_float" field.
func NullFloatNotIn(vs ...*sql.NullFloat64) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldNullFloat), v...))
	})
}

// NullFloatGT applies the GT predicate on the "null_float" field.
func NullFloatGT(v *sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldNullFloat), v))
	})
}

// NullFloatGTE applies the GTE predicate on the "null_float" field.
func NullFloatGTE(v *sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldNullFloat), v))
	})
}

// NullFloatLT applies the LT predicate on the "null_float" field.
func NullFloatLT(v *sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldNullFloat), v))
	})
}

// NullFloatLTE applies the LTE predicate on the "null_float" field.
func NullFloatLTE(v *sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldNullFloat), v))
	})
}

// NullFloatIsNil applies the IsNil predicate on the "null_float" field.
func NullFloatIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldNullFloat)))
	})
}

// NullFloatNotNil applies the NotNil predicate on the "null_float" field.
func NullFloatNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldNullFloat)))
	})
}

// RoleEQ applies the EQ predicate on the "role" field.
func RoleEQ(v role.Role) predicate.FieldType {
	vc := v
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldRole), vc))
	})
}

// RoleNEQ applies the NEQ predicate on the "role" field.
func RoleNEQ(v role.Role) predicate.FieldType {
	vc := v
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldRole), vc))
	})
}

// RoleIn applies the In predicate on the "role" field.
func RoleIn(vs ...role.Role) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldRole), v...))
	})
}

// RoleNotIn applies the NotIn predicate on the "role" field.
func RoleNotIn(vs ...role.Role) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldRole), v...))
	})
}

// PriorityEQ applies the EQ predicate on the "priority" field.
func PriorityEQ(v role.Priority) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldPriority), v))
	})
}

// PriorityNEQ applies the NEQ predicate on the "priority" field.
func PriorityNEQ(v role.Priority) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldPriority), v))
	})
}

// PriorityIn applies the In predicate on the "priority" field.
func PriorityIn(vs ...role.Priority) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldPriority), v...))
	})
}

// PriorityNotIn applies the NotIn predicate on the "priority" field.
func PriorityNotIn(vs ...role.Priority) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldPriority), v...))
	})
}

// PriorityIsNil applies the IsNil predicate on the "priority" field.
func PriorityIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldPriority)))
	})
}

// PriorityNotNil applies the NotNil predicate on the "priority" field.
func PriorityNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldPriority)))
	})
}

// OptionalUUIDEQ applies the EQ predicate on the "optional_uuid" field.
func OptionalUUIDEQ(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOptionalUUID), v))
	})
}

// OptionalUUIDNEQ applies the NEQ predicate on the "optional_uuid" field.
func OptionalUUIDNEQ(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldOptionalUUID), v))
	})
}

// OptionalUUIDIn applies the In predicate on the "optional_uuid" field.
func OptionalUUIDIn(vs ...uuid.UUID) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldOptionalUUID), v...))
	})
}

// OptionalUUIDNotIn applies the NotIn predicate on the "optional_uuid" field.
func OptionalUUIDNotIn(vs ...uuid.UUID) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldOptionalUUID), v...))
	})
}

// OptionalUUIDGT applies the GT predicate on the "optional_uuid" field.
func OptionalUUIDGT(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldOptionalUUID), v))
	})
}

// OptionalUUIDGTE applies the GTE predicate on the "optional_uuid" field.
func OptionalUUIDGTE(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldOptionalUUID), v))
	})
}

// OptionalUUIDLT applies the LT predicate on the "optional_uuid" field.
func OptionalUUIDLT(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldOptionalUUID), v))
	})
}

// OptionalUUIDLTE applies the LTE predicate on the "optional_uuid" field.
func OptionalUUIDLTE(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldOptionalUUID), v))
	})
}

// OptionalUUIDIsNil applies the IsNil predicate on the "optional_uuid" field.
func OptionalUUIDIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldOptionalUUID)))
	})
}

// OptionalUUIDNotNil applies the NotNil predicate on the "optional_uuid" field.
func OptionalUUIDNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldOptionalUUID)))
	})
}

// NillableUUIDEQ applies the EQ predicate on the "nillable_uuid" field.
func NillableUUIDEQ(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNillableUUID), v))
	})
}

// NillableUUIDNEQ applies the NEQ predicate on the "nillable_uuid" field.
func NillableUUIDNEQ(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldNillableUUID), v))
	})
}

// NillableUUIDIn applies the In predicate on the "nillable_uuid" field.
func NillableUUIDIn(vs ...uuid.UUID) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldNillableUUID), v...))
	})
}

// NillableUUIDNotIn applies the NotIn predicate on the "nillable_uuid" field.
func NillableUUIDNotIn(vs ...uuid.UUID) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldNillableUUID), v...))
	})
}

// NillableUUIDGT applies the GT predicate on the "nillable_uuid" field.
func NillableUUIDGT(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldNillableUUID), v))
	})
}

// NillableUUIDGTE applies the GTE predicate on the "nillable_uuid" field.
func NillableUUIDGTE(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldNillableUUID), v))
	})
}

// NillableUUIDLT applies the LT predicate on the "nillable_uuid" field.
func NillableUUIDLT(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldNillableUUID), v))
	})
}

// NillableUUIDLTE applies the LTE predicate on the "nillable_uuid" field.
func NillableUUIDLTE(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldNillableUUID), v))
	})
}

// NillableUUIDIsNil applies the IsNil predicate on the "nillable_uuid" field.
func NillableUUIDIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldNillableUUID)))
	})
}

// NillableUUIDNotNil applies the NotNil predicate on the "nillable_uuid" field.
func NillableUUIDNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldNillableUUID)))
	})
}

// StringsIsNil applies the IsNil predicate on the "strings" field.
func StringsIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldStrings)))
	})
}

// StringsNotNil applies the NotNil predicate on the "strings" field.
func StringsNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldStrings)))
	})
}

// PairEQ applies the EQ predicate on the "pair" field.
func PairEQ(v schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldPair), v))
	})
}

// PairNEQ applies the NEQ predicate on the "pair" field.
func PairNEQ(v schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldPair), v))
	})
}

// PairIn applies the In predicate on the "pair" field.
func PairIn(vs ...schema.Pair) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldPair), v...))
	})
}

// PairNotIn applies the NotIn predicate on the "pair" field.
func PairNotIn(vs ...schema.Pair) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldPair), v...))
	})
}

// PairGT applies the GT predicate on the "pair" field.
func PairGT(v schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldPair), v))
	})
}

// PairGTE applies the GTE predicate on the "pair" field.
func PairGTE(v schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldPair), v))
	})
}

// PairLT applies the LT predicate on the "pair" field.
func PairLT(v schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldPair), v))
	})
}

// PairLTE applies the LTE predicate on the "pair" field.
func PairLTE(v schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldPair), v))
	})
}

// NilPairEQ applies the EQ predicate on the "nil_pair" field.
func NilPairEQ(v *schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNilPair), v))
	})
}

// NilPairNEQ applies the NEQ predicate on the "nil_pair" field.
func NilPairNEQ(v *schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldNilPair), v))
	})
}

// NilPairIn applies the In predicate on the "nil_pair" field.
func NilPairIn(vs ...*schema.Pair) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldNilPair), v...))
	})
}

// NilPairNotIn applies the NotIn predicate on the "nil_pair" field.
func NilPairNotIn(vs ...*schema.Pair) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldNilPair), v...))
	})
}

// NilPairGT applies the GT predicate on the "nil_pair" field.
func NilPairGT(v *schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldNilPair), v))
	})
}

// NilPairGTE applies the GTE predicate on the "nil_pair" field.
func NilPairGTE(v *schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldNilPair), v))
	})
}

// NilPairLT applies the LT predicate on the "nil_pair" field.
func NilPairLT(v *schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldNilPair), v))
	})
}

// NilPairLTE applies the LTE predicate on the "nil_pair" field.
func NilPairLTE(v *schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldNilPair), v))
	})
}

// NilPairIsNil applies the IsNil predicate on the "nil_pair" field.
func NilPairIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldNilPair)))
	})
}

// NilPairNotNil applies the NotNil predicate on the "nil_pair" field.
func NilPairNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldNilPair)))
	})
}

// VstringEQ applies the EQ predicate on the "vstring" field.
func VstringEQ(v schema.VString) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldVstring), v))
	})
}

// VstringNEQ applies the NEQ predicate on the "vstring" field.
func VstringNEQ(v schema.VString) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldVstring), v))
	})
}

// VstringIn applies the In predicate on the "vstring" field.
func VstringIn(vs ...schema.VString) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldVstring), v...))
	})
}

// VstringNotIn applies the NotIn predicate on the "vstring" field.
func VstringNotIn(vs ...schema.VString) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldVstring), v...))
	})
}

// VstringGT applies the GT predicate on the "vstring" field.
func VstringGT(v schema.VString) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldVstring), v))
	})
}

// VstringGTE applies the GTE predicate on the "vstring" field.
func VstringGTE(v schema.VString) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldVstring), v))
	})
}

// VstringLT applies the LT predicate on the "vstring" field.
func VstringLT(v schema.VString) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldVstring), v))
	})
}

// VstringLTE applies the LTE predicate on the "vstring" field.
func VstringLTE(v schema.VString) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldVstring), v))
	})
}

// VstringContains applies the Contains predicate on the "vstring" field.
func VstringContains(v schema.VString) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldVstring), vc))
	})
}

// VstringHasPrefix applies the HasPrefix predicate on the "vstring" field.
func VstringHasPrefix(v schema.VString) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldVstring), vc))
	})
}

// VstringHasSuffix applies the HasSuffix predicate on the "vstring" field.
func VstringHasSuffix(v schema.VString) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldVstring), vc))
	})
}

// VstringEqualFold applies the EqualFold predicate on the "vstring" field.
func VstringEqualFold(v schema.VString) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldVstring), vc))
	})
}

// VstringContainsFold applies the ContainsFold predicate on the "vstring" field.
func VstringContainsFold(v schema.VString) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldVstring), vc))
	})
}

// TripleEQ applies the EQ predicate on the "triple" field.
func TripleEQ(v schema.Triple) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldTriple), v))
	})
}

// TripleNEQ applies the NEQ predicate on the "triple" field.
func TripleNEQ(v schema.Triple) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldTriple), v))
	})
}

// TripleIn applies the In predicate on the "triple" field.
func TripleIn(vs ...schema.Triple) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldTriple), v...))
	})
}

// TripleNotIn applies the NotIn predicate on the "triple" field.
func TripleNotIn(vs ...schema.Triple) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldTriple), v...))
	})
}

// TripleGT applies the GT predicate on the "triple" field.
func TripleGT(v schema.Triple) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldTriple), v))
	})
}

// TripleGTE applies the GTE predicate on the "triple" field.
func TripleGTE(v schema.Triple) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldTriple), v))
	})
}

// TripleLT applies the LT predicate on the "triple" field.
func TripleLT(v schema.Triple) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldTriple), v))
	})
}

// TripleLTE applies the LTE predicate on the "triple" field.
func TripleLTE(v schema.Triple) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldTriple), v))
	})
}

// BigIntEQ applies the EQ predicate on the "big_int" field.
func BigIntEQ(v schema.BigInt) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldBigInt), v))
	})
}

// BigIntNEQ applies the NEQ predicate on the "big_int" field.
func BigIntNEQ(v schema.BigInt) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldBigInt), v))
	})
}

// BigIntIn applies the In predicate on the "big_int" field.
func BigIntIn(vs ...schema.BigInt) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldBigInt), v...))
	})
}

// BigIntNotIn applies the NotIn predicate on the "big_int" field.
func BigIntNotIn(vs ...schema.BigInt) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldBigInt), v...))
	})
}

// BigIntGT applies the GT predicate on the "big_int" field.
func BigIntGT(v schema.BigInt) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldBigInt), v))
	})
}

// BigIntGTE applies the GTE predicate on the "big_int" field.
func BigIntGTE(v schema.BigInt) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldBigInt), v))
	})
}

// BigIntLT applies the LT predicate on the "big_int" field.
func BigIntLT(v schema.BigInt) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldBigInt), v))
	})
}

// BigIntLTE applies the LTE predicate on the "big_int" field.
func BigIntLTE(v schema.BigInt) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldBigInt), v))
	})
}

// BigIntIsNil applies the IsNil predicate on the "big_int" field.
func BigIntIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldBigInt)))
	})
}

// BigIntNotNil applies the NotNil predicate on the "big_int" field.
func BigIntNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldBigInt)))
	})
}

// PasswordOtherEQ applies the EQ predicate on the "password_other" field.
func PasswordOtherEQ(v schema.Password) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldPasswordOther), v))
	})
}

// PasswordOtherNEQ applies the NEQ predicate on the "password_other" field.
func PasswordOtherNEQ(v schema.Password) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldPasswordOther), v))
	})
}

// PasswordOtherIn applies the In predicate on the "password_other" field.
func PasswordOtherIn(vs ...schema.Password) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.In(s.C(FieldPasswordOther), v...))
	})
}

// PasswordOtherNotIn applies the NotIn predicate on the "password_other" field.
func PasswordOtherNotIn(vs ...schema.Password) predicate.FieldType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotIn(s.C(FieldPasswordOther), v...))
	})
}

// PasswordOtherGT applies the GT predicate on the "password_other" field.
func PasswordOtherGT(v schema.Password) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldPasswordOther), v))
	})
}

// PasswordOtherGTE applies the GTE predicate on the "password_other" field.
func PasswordOtherGTE(v schema.Password) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldPasswordOther), v))
	})
}

// PasswordOtherLT applies the LT predicate on the "password_other" field.
func PasswordOtherLT(v schema.Password) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldPasswordOther), v))
	})
}

// PasswordOtherLTE applies the LTE predicate on the "password_other" field.
func PasswordOtherLTE(v schema.Password) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldPasswordOther), v))
	})
}

// PasswordOtherIsNil applies the IsNil predicate on the "password_other" field.
func PasswordOtherIsNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldPasswordOther)))
	})
}

// PasswordOtherNotNil applies the NotNil predicate on the "password_other" field.
func PasswordOtherNotNil() predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldPasswordOther)))
	})
}

// And groups predicates with the AND operator between them.
func And(predicates ...predicate.FieldType) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s1 := s.Clone().SetP(nil)
		for _, p := range predicates {
			p(s1)
		}
		s.Where(s1.P())
	})
}

// Or groups predicates with the OR operator between them.
func Or(predicates ...predicate.FieldType) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		s1 := s.Clone().SetP(nil)
		for i, p := range predicates {
			if i > 0 {
				s1.Or()
			}
			p(s1)
		}
		s.Where(s1.P())
	})
}

// Not applies the not operator on the given predicate.
func Not(p predicate.FieldType) predicate.FieldType {
	return predicate.FieldType(func(s *sql.Selector) {
		p(s.Not())
	})
}
