// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"entgo.io/ent/entc/integration/customid/ent/account"
	"entgo.io/ent/entc/integration/customid/ent/blob"
	"entgo.io/ent/entc/integration/customid/ent/bloblink"
	"entgo.io/ent/entc/integration/customid/ent/car"
	"entgo.io/ent/entc/integration/customid/ent/device"
	"entgo.io/ent/entc/integration/customid/ent/doc"
	"entgo.io/ent/entc/integration/customid/ent/group"
	"entgo.io/ent/entc/integration/customid/ent/intsid"
	"entgo.io/ent/entc/integration/customid/ent/mixinid"
	"entgo.io/ent/entc/integration/customid/ent/note"
	"entgo.io/ent/entc/integration/customid/ent/other"
	"entgo.io/ent/entc/integration/customid/ent/pet"
	"entgo.io/ent/entc/integration/customid/ent/predicate"
	"entgo.io/ent/entc/integration/customid/ent/revision"
	"entgo.io/ent/entc/integration/customid/ent/session"
	"entgo.io/ent/entc/integration/customid/ent/token"
	"entgo.io/ent/entc/integration/customid/ent/user"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entql"
	"entgo.io/ent/schema/field"
)

// schemaGraph holds a representation of ent/schema at runtime.
var schemaGraph = func() *sqlgraph.Schema {
	graph := &sqlgraph.Schema{Nodes: make([]*sqlgraph.Node, 16)}
	graph.Nodes[0] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   account.Table,
			Columns: account.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeOther,
				Column: account.FieldID,
			},
		},
		Type: "Account",
		Fields: map[string]*sqlgraph.FieldSpec{
			account.FieldEmail: {Type: field.TypeString, Column: account.FieldEmail},
		},
	}
	graph.Nodes[1] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   blob.Table,
			Columns: blob.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeUUID,
				Column: blob.FieldID,
			},
		},
		Type: "Blob",
		Fields: map[string]*sqlgraph.FieldSpec{
			blob.FieldUUID:  {Type: field.TypeUUID, Column: blob.FieldUUID},
			blob.FieldCount: {Type: field.TypeInt, Column: blob.FieldCount},
		},
	}
	graph.Nodes[2] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   bloblink.Table,
			Columns: bloblink.Columns,
			CompositeID: []*sqlgraph.FieldSpec{
				{
					Type:   field.TypeUUID,
					Column: bloblink.FieldBlobID,
				},
				{
					Type:   field.TypeUUID,
					Column: bloblink.FieldLinkID,
				},
			},
		},
		Type: "BlobLink",
		Fields: map[string]*sqlgraph.FieldSpec{
			bloblink.FieldCreatedAt: {Type: field.TypeTime, Column: bloblink.FieldCreatedAt},
			bloblink.FieldBlobID:    {Type: field.TypeUUID, Column: bloblink.FieldBlobID},
			bloblink.FieldLinkID:    {Type: field.TypeUUID, Column: bloblink.FieldLinkID},
		},
	}
	graph.Nodes[3] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   car.Table,
			Columns: car.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: car.FieldID,
			},
		},
		Type: "Car",
		Fields: map[string]*sqlgraph.FieldSpec{
			car.FieldBeforeID: {Type: field.TypeFloat64, Column: car.FieldBeforeID},
			car.FieldAfterID:  {Type: field.TypeFloat64, Column: car.FieldAfterID},
			car.FieldModel:    {Type: field.TypeString, Column: car.FieldModel},
		},
	}
	graph.Nodes[4] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   device.Table,
			Columns: device.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeBytes,
				Column: device.FieldID,
			},
		},
		Type:   "Device",
		Fields: map[string]*sqlgraph.FieldSpec{},
	}
	graph.Nodes[5] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   doc.Table,
			Columns: doc.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeString,
				Column: doc.FieldID,
			},
		},
		Type: "Doc",
		Fields: map[string]*sqlgraph.FieldSpec{
			doc.FieldText: {Type: field.TypeString, Column: doc.FieldText},
		},
	}
	graph.Nodes[6] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   group.Table,
			Columns: group.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: group.FieldID,
			},
		},
		Type:   "Group",
		Fields: map[string]*sqlgraph.FieldSpec{},
	}
	graph.Nodes[7] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   intsid.Table,
			Columns: intsid.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt64,
				Column: intsid.FieldID,
			},
		},
		Type:   "IntSID",
		Fields: map[string]*sqlgraph.FieldSpec{},
	}
	graph.Nodes[8] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   mixinid.Table,
			Columns: mixinid.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeUUID,
				Column: mixinid.FieldID,
			},
		},
		Type: "MixinID",
		Fields: map[string]*sqlgraph.FieldSpec{
			mixinid.FieldSomeField:  {Type: field.TypeString, Column: mixinid.FieldSomeField},
			mixinid.FieldMixinField: {Type: field.TypeString, Column: mixinid.FieldMixinField},
		},
	}
	graph.Nodes[9] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   note.Table,
			Columns: note.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeString,
				Column: note.FieldID,
			},
		},
		Type: "Note",
		Fields: map[string]*sqlgraph.FieldSpec{
			note.FieldText: {Type: field.TypeString, Column: note.FieldText},
		},
	}
	graph.Nodes[10] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   other.Table,
			Columns: other.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeOther,
				Column: other.FieldID,
			},
		},
		Type:   "Other",
		Fields: map[string]*sqlgraph.FieldSpec{},
	}
	graph.Nodes[11] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   pet.Table,
			Columns: pet.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeString,
				Column: pet.FieldID,
			},
		},
		Type:   "Pet",
		Fields: map[string]*sqlgraph.FieldSpec{},
	}
	graph.Nodes[12] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   revision.Table,
			Columns: revision.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeString,
				Column: revision.FieldID,
			},
		},
		Type:   "Revision",
		Fields: map[string]*sqlgraph.FieldSpec{},
	}
	graph.Nodes[13] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   session.Table,
			Columns: session.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeBytes,
				Column: session.FieldID,
			},
		},
		Type:   "Session",
		Fields: map[string]*sqlgraph.FieldSpec{},
	}
	graph.Nodes[14] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   token.Table,
			Columns: token.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeOther,
				Column: token.FieldID,
			},
		},
		Type: "Token",
		Fields: map[string]*sqlgraph.FieldSpec{
			token.FieldBody: {Type: field.TypeString, Column: token.FieldBody},
		},
	}
	graph.Nodes[15] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   user.Table,
			Columns: user.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: user.FieldID,
			},
		},
		Type:   "User",
		Fields: map[string]*sqlgraph.FieldSpec{},
	}
	graph.MustAddE(
		"token",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   account.TokenTable,
			Columns: []string{account.TokenColumn},
			Bidi:    false,
		},
		"Account",
		"Token",
	)
	graph.MustAddE(
		"parent",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2O,
			Inverse: false,
			Table:   blob.ParentTable,
			Columns: []string{blob.ParentColumn},
			Bidi:    true,
		},
		"Blob",
		"Blob",
	)
	graph.MustAddE(
		"links",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   blob.LinksTable,
			Columns: blob.LinksPrimaryKey,
			Bidi:    true,
		},
		"Blob",
		"Blob",
	)
	graph.MustAddE(
		"blob_links",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   blob.BlobLinksTable,
			Columns: []string{blob.BlobLinksColumn},
			Bidi:    false,
		},
		"Blob",
		"BlobLink",
	)
	graph.MustAddE(
		"blob",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   bloblink.BlobTable,
			Columns: []string{bloblink.BlobColumn},
			Bidi:    false,
		},
		"BlobLink",
		"Blob",
	)
	graph.MustAddE(
		"link",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   bloblink.LinkTable,
			Columns: []string{bloblink.LinkColumn},
			Bidi:    false,
		},
		"BlobLink",
		"Blob",
	)
	graph.MustAddE(
		"owner",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   car.OwnerTable,
			Columns: []string{car.OwnerColumn},
			Bidi:    false,
		},
		"Car",
		"Pet",
	)
	graph.MustAddE(
		"active_session",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   device.ActiveSessionTable,
			Columns: []string{device.ActiveSessionColumn},
			Bidi:    false,
		},
		"Device",
		"Session",
	)
	graph.MustAddE(
		"sessions",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   device.SessionsTable,
			Columns: []string{device.SessionsColumn},
			Bidi:    false,
		},
		"Device",
		"Session",
	)
	graph.MustAddE(
		"parent",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   doc.ParentTable,
			Columns: []string{doc.ParentColumn},
			Bidi:    false,
		},
		"Doc",
		"Doc",
	)
	graph.MustAddE(
		"children",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   doc.ChildrenTable,
			Columns: []string{doc.ChildrenColumn},
			Bidi:    false,
		},
		"Doc",
		"Doc",
	)
	graph.MustAddE(
		"related",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   doc.RelatedTable,
			Columns: doc.RelatedPrimaryKey,
			Bidi:    true,
		},
		"Doc",
		"Doc",
	)
	graph.MustAddE(
		"users",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   group.UsersTable,
			Columns: group.UsersPrimaryKey,
			Bidi:    false,
		},
		"Group",
		"User",
	)
	graph.MustAddE(
		"parent",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   intsid.ParentTable,
			Columns: []string{intsid.ParentColumn},
			Bidi:    true,
		},
		"IntSID",
		"IntSID",
	)
	graph.MustAddE(
		"children",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   intsid.ChildrenTable,
			Columns: []string{intsid.ChildrenColumn},
			Bidi:    false,
		},
		"IntSID",
		"IntSID",
	)
	graph.MustAddE(
		"parent",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   note.ParentTable,
			Columns: []string{note.ParentColumn},
			Bidi:    false,
		},
		"Note",
		"Note",
	)
	graph.MustAddE(
		"children",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   note.ChildrenTable,
			Columns: []string{note.ChildrenColumn},
			Bidi:    false,
		},
		"Note",
		"Note",
	)
	graph.MustAddE(
		"owner",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   pet.OwnerTable,
			Columns: []string{pet.OwnerColumn},
			Bidi:    false,
		},
		"Pet",
		"User",
	)
	graph.MustAddE(
		"cars",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   pet.CarsTable,
			Columns: []string{pet.CarsColumn},
			Bidi:    false,
		},
		"Pet",
		"Car",
	)
	graph.MustAddE(
		"friends",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   pet.FriendsTable,
			Columns: pet.FriendsPrimaryKey,
			Bidi:    true,
		},
		"Pet",
		"Pet",
	)
	graph.MustAddE(
		"best_friend",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2O,
			Inverse: false,
			Table:   pet.BestFriendTable,
			Columns: []string{pet.BestFriendColumn},
			Bidi:    true,
		},
		"Pet",
		"Pet",
	)
	graph.MustAddE(
		"device",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   session.DeviceTable,
			Columns: []string{session.DeviceColumn},
			Bidi:    false,
		},
		"Session",
		"Device",
	)
	graph.MustAddE(
		"account",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   token.AccountTable,
			Columns: []string{token.AccountColumn},
			Bidi:    false,
		},
		"Token",
		"Account",
	)
	graph.MustAddE(
		"groups",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   user.GroupsTable,
			Columns: user.GroupsPrimaryKey,
			Bidi:    false,
		},
		"User",
		"Group",
	)
	graph.MustAddE(
		"parent",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   user.ParentTable,
			Columns: []string{user.ParentColumn},
			Bidi:    false,
		},
		"User",
		"User",
	)
	graph.MustAddE(
		"children",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   user.ChildrenTable,
			Columns: []string{user.ChildrenColumn},
			Bidi:    false,
		},
		"User",
		"User",
	)
	graph.MustAddE(
		"pets",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   user.PetsTable,
			Columns: []string{user.PetsColumn},
			Bidi:    false,
		},
		"User",
		"Pet",
	)
	return graph
}()

// predicateAdder wraps the addPredicate method.
// All update, update-one and query builders implement this interface.
type predicateAdder interface {
	addPredicate(func(s *sql.Selector))
}

// addPredicate implements the predicateAdder interface.
func (aq *AccountQuery) addPredicate(pred func(s *sql.Selector)) {
	aq.predicates = append(aq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the AccountQuery builder.
func (aq *AccountQuery) Filter() *AccountFilter {
	return &AccountFilter{config: aq.config, predicateAdder: aq}
}

// addPredicate implements the predicateAdder interface.
func (m *AccountMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the AccountMutation builder.
func (m *AccountMutation) Filter() *AccountFilter {
	return &AccountFilter{config: m.config, predicateAdder: m}
}

// AccountFilter provides a generic filtering capability at runtime for AccountQuery.
type AccountFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *AccountFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[0].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql other predicate on the id field.
func (f *AccountFilter) WhereID(p entql.OtherP) {
	f.Where(p.Field(account.FieldID))
}

// WhereEmail applies the entql string predicate on the email field.
func (f *AccountFilter) WhereEmail(p entql.StringP) {
	f.Where(p.Field(account.FieldEmail))
}

// WhereHasToken applies a predicate to check if query has an edge token.
func (f *AccountFilter) WhereHasToken() {
	f.Where(entql.HasEdge("token"))
}

// WhereHasTokenWith applies a predicate to check if query has an edge token with a given conditions (other predicates).
func (f *AccountFilter) WhereHasTokenWith(preds ...predicate.Token) {
	f.Where(entql.HasEdgeWith("token", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (bq *BlobQuery) addPredicate(pred func(s *sql.Selector)) {
	bq.predicates = append(bq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the BlobQuery builder.
func (bq *BlobQuery) Filter() *BlobFilter {
	return &BlobFilter{config: bq.config, predicateAdder: bq}
}

// addPredicate implements the predicateAdder interface.
func (m *BlobMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the BlobMutation builder.
func (m *BlobMutation) Filter() *BlobFilter {
	return &BlobFilter{config: m.config, predicateAdder: m}
}

// BlobFilter provides a generic filtering capability at runtime for BlobQuery.
type BlobFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *BlobFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[1].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql [16]byte predicate on the id field.
func (f *BlobFilter) WhereID(p entql.ValueP) {
	f.Where(p.Field(blob.FieldID))
}

// WhereUUID applies the entql [16]byte predicate on the uuid field.
func (f *BlobFilter) WhereUUID(p entql.ValueP) {
	f.Where(p.Field(blob.FieldUUID))
}

// WhereCount applies the entql int predicate on the count field.
func (f *BlobFilter) WhereCount(p entql.IntP) {
	f.Where(p.Field(blob.FieldCount))
}

// WhereHasParent applies a predicate to check if query has an edge parent.
func (f *BlobFilter) WhereHasParent() {
	f.Where(entql.HasEdge("parent"))
}

// WhereHasParentWith applies a predicate to check if query has an edge parent with a given conditions (other predicates).
func (f *BlobFilter) WhereHasParentWith(preds ...predicate.Blob) {
	f.Where(entql.HasEdgeWith("parent", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasLinks applies a predicate to check if query has an edge links.
func (f *BlobFilter) WhereHasLinks() {
	f.Where(entql.HasEdge("links"))
}

// WhereHasLinksWith applies a predicate to check if query has an edge links with a given conditions (other predicates).
func (f *BlobFilter) WhereHasLinksWith(preds ...predicate.Blob) {
	f.Where(entql.HasEdgeWith("links", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasBlobLinks applies a predicate to check if query has an edge blob_links.
func (f *BlobFilter) WhereHasBlobLinks() {
	f.Where(entql.HasEdge("blob_links"))
}

// WhereHasBlobLinksWith applies a predicate to check if query has an edge blob_links with a given conditions (other predicates).
func (f *BlobFilter) WhereHasBlobLinksWith(preds ...predicate.BlobLink) {
	f.Where(entql.HasEdgeWith("blob_links", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (blq *BlobLinkQuery) addPredicate(pred func(s *sql.Selector)) {
	blq.predicates = append(blq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the BlobLinkQuery builder.
func (blq *BlobLinkQuery) Filter() *BlobLinkFilter {
	return &BlobLinkFilter{config: blq.config, predicateAdder: blq}
}

// addPredicate implements the predicateAdder interface.
func (m *BlobLinkMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the BlobLinkMutation builder.
func (m *BlobLinkMutation) Filter() *BlobLinkFilter {
	return &BlobLinkFilter{config: m.config, predicateAdder: m}
}

// BlobLinkFilter provides a generic filtering capability at runtime for BlobLinkQuery.
type BlobLinkFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *BlobLinkFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[2].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereCreatedAt applies the entql time.Time predicate on the created_at field.
func (f *BlobLinkFilter) WhereCreatedAt(p entql.TimeP) {
	f.Where(p.Field(bloblink.FieldCreatedAt))
}

// WhereBlobID applies the entql [16]byte predicate on the blob_id field.
func (f *BlobLinkFilter) WhereBlobID(p entql.ValueP) {
	f.Where(p.Field(bloblink.FieldBlobID))
}

// WhereLinkID applies the entql [16]byte predicate on the link_id field.
func (f *BlobLinkFilter) WhereLinkID(p entql.ValueP) {
	f.Where(p.Field(bloblink.FieldLinkID))
}

// WhereHasBlob applies a predicate to check if query has an edge blob.
func (f *BlobLinkFilter) WhereHasBlob() {
	f.Where(entql.HasEdge("blob"))
}

// WhereHasBlobWith applies a predicate to check if query has an edge blob with a given conditions (other predicates).
func (f *BlobLinkFilter) WhereHasBlobWith(preds ...predicate.Blob) {
	f.Where(entql.HasEdgeWith("blob", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasLink applies a predicate to check if query has an edge link.
func (f *BlobLinkFilter) WhereHasLink() {
	f.Where(entql.HasEdge("link"))
}

// WhereHasLinkWith applies a predicate to check if query has an edge link with a given conditions (other predicates).
func (f *BlobLinkFilter) WhereHasLinkWith(preds ...predicate.Blob) {
	f.Where(entql.HasEdgeWith("link", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (cq *CarQuery) addPredicate(pred func(s *sql.Selector)) {
	cq.predicates = append(cq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the CarQuery builder.
func (cq *CarQuery) Filter() *CarFilter {
	return &CarFilter{config: cq.config, predicateAdder: cq}
}

// addPredicate implements the predicateAdder interface.
func (m *CarMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the CarMutation builder.
func (m *CarMutation) Filter() *CarFilter {
	return &CarFilter{config: m.config, predicateAdder: m}
}

// CarFilter provides a generic filtering capability at runtime for CarQuery.
type CarFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *CarFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[3].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *CarFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(car.FieldID))
}

// WhereBeforeID applies the entql float64 predicate on the before_id field.
func (f *CarFilter) WhereBeforeID(p entql.Float64P) {
	f.Where(p.Field(car.FieldBeforeID))
}

// WhereAfterID applies the entql float64 predicate on the after_id field.
func (f *CarFilter) WhereAfterID(p entql.Float64P) {
	f.Where(p.Field(car.FieldAfterID))
}

// WhereModel applies the entql string predicate on the model field.
func (f *CarFilter) WhereModel(p entql.StringP) {
	f.Where(p.Field(car.FieldModel))
}

// WhereHasOwner applies a predicate to check if query has an edge owner.
func (f *CarFilter) WhereHasOwner() {
	f.Where(entql.HasEdge("owner"))
}

// WhereHasOwnerWith applies a predicate to check if query has an edge owner with a given conditions (other predicates).
func (f *CarFilter) WhereHasOwnerWith(preds ...predicate.Pet) {
	f.Where(entql.HasEdgeWith("owner", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (dq *DeviceQuery) addPredicate(pred func(s *sql.Selector)) {
	dq.predicates = append(dq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the DeviceQuery builder.
func (dq *DeviceQuery) Filter() *DeviceFilter {
	return &DeviceFilter{config: dq.config, predicateAdder: dq}
}

// addPredicate implements the predicateAdder interface.
func (m *DeviceMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the DeviceMutation builder.
func (m *DeviceMutation) Filter() *DeviceFilter {
	return &DeviceFilter{config: m.config, predicateAdder: m}
}

// DeviceFilter provides a generic filtering capability at runtime for DeviceQuery.
type DeviceFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *DeviceFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[4].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql []byte predicate on the id field.
func (f *DeviceFilter) WhereID(p entql.BytesP) {
	f.Where(p.Field(device.FieldID))
}

// WhereHasActiveSession applies a predicate to check if query has an edge active_session.
func (f *DeviceFilter) WhereHasActiveSession() {
	f.Where(entql.HasEdge("active_session"))
}

// WhereHasActiveSessionWith applies a predicate to check if query has an edge active_session with a given conditions (other predicates).
func (f *DeviceFilter) WhereHasActiveSessionWith(preds ...predicate.Session) {
	f.Where(entql.HasEdgeWith("active_session", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasSessions applies a predicate to check if query has an edge sessions.
func (f *DeviceFilter) WhereHasSessions() {
	f.Where(entql.HasEdge("sessions"))
}

// WhereHasSessionsWith applies a predicate to check if query has an edge sessions with a given conditions (other predicates).
func (f *DeviceFilter) WhereHasSessionsWith(preds ...predicate.Session) {
	f.Where(entql.HasEdgeWith("sessions", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (dq *DocQuery) addPredicate(pred func(s *sql.Selector)) {
	dq.predicates = append(dq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the DocQuery builder.
func (dq *DocQuery) Filter() *DocFilter {
	return &DocFilter{config: dq.config, predicateAdder: dq}
}

// addPredicate implements the predicateAdder interface.
func (m *DocMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the DocMutation builder.
func (m *DocMutation) Filter() *DocFilter {
	return &DocFilter{config: m.config, predicateAdder: m}
}

// DocFilter provides a generic filtering capability at runtime for DocQuery.
type DocFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *DocFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[5].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql string predicate on the id field.
func (f *DocFilter) WhereID(p entql.StringP) {
	f.Where(p.Field(doc.FieldID))
}

// WhereText applies the entql string predicate on the text field.
func (f *DocFilter) WhereText(p entql.StringP) {
	f.Where(p.Field(doc.FieldText))
}

// WhereHasParent applies a predicate to check if query has an edge parent.
func (f *DocFilter) WhereHasParent() {
	f.Where(entql.HasEdge("parent"))
}

// WhereHasParentWith applies a predicate to check if query has an edge parent with a given conditions (other predicates).
func (f *DocFilter) WhereHasParentWith(preds ...predicate.Doc) {
	f.Where(entql.HasEdgeWith("parent", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasChildren applies a predicate to check if query has an edge children.
func (f *DocFilter) WhereHasChildren() {
	f.Where(entql.HasEdge("children"))
}

// WhereHasChildrenWith applies a predicate to check if query has an edge children with a given conditions (other predicates).
func (f *DocFilter) WhereHasChildrenWith(preds ...predicate.Doc) {
	f.Where(entql.HasEdgeWith("children", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasRelated applies a predicate to check if query has an edge related.
func (f *DocFilter) WhereHasRelated() {
	f.Where(entql.HasEdge("related"))
}

// WhereHasRelatedWith applies a predicate to check if query has an edge related with a given conditions (other predicates).
func (f *DocFilter) WhereHasRelatedWith(preds ...predicate.Doc) {
	f.Where(entql.HasEdgeWith("related", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (gq *GroupQuery) addPredicate(pred func(s *sql.Selector)) {
	gq.predicates = append(gq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the GroupQuery builder.
func (gq *GroupQuery) Filter() *GroupFilter {
	return &GroupFilter{config: gq.config, predicateAdder: gq}
}

// addPredicate implements the predicateAdder interface.
func (m *GroupMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the GroupMutation builder.
func (m *GroupMutation) Filter() *GroupFilter {
	return &GroupFilter{config: m.config, predicateAdder: m}
}

// GroupFilter provides a generic filtering capability at runtime for GroupQuery.
type GroupFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *GroupFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[6].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *GroupFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(group.FieldID))
}

// WhereHasUsers applies a predicate to check if query has an edge users.
func (f *GroupFilter) WhereHasUsers() {
	f.Where(entql.HasEdge("users"))
}

// WhereHasUsersWith applies a predicate to check if query has an edge users with a given conditions (other predicates).
func (f *GroupFilter) WhereHasUsersWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("users", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (isq *IntSIDQuery) addPredicate(pred func(s *sql.Selector)) {
	isq.predicates = append(isq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the IntSIDQuery builder.
func (isq *IntSIDQuery) Filter() *IntSIDFilter {
	return &IntSIDFilter{config: isq.config, predicateAdder: isq}
}

// addPredicate implements the predicateAdder interface.
func (m *IntSIDMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the IntSIDMutation builder.
func (m *IntSIDMutation) Filter() *IntSIDFilter {
	return &IntSIDFilter{config: m.config, predicateAdder: m}
}

// IntSIDFilter provides a generic filtering capability at runtime for IntSIDQuery.
type IntSIDFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *IntSIDFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[7].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int64 predicate on the id field.
func (f *IntSIDFilter) WhereID(p entql.Int64P) {
	f.Where(p.Field(intsid.FieldID))
}

// WhereHasParent applies a predicate to check if query has an edge parent.
func (f *IntSIDFilter) WhereHasParent() {
	f.Where(entql.HasEdge("parent"))
}

// WhereHasParentWith applies a predicate to check if query has an edge parent with a given conditions (other predicates).
func (f *IntSIDFilter) WhereHasParentWith(preds ...predicate.IntSID) {
	f.Where(entql.HasEdgeWith("parent", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasChildren applies a predicate to check if query has an edge children.
func (f *IntSIDFilter) WhereHasChildren() {
	f.Where(entql.HasEdge("children"))
}

// WhereHasChildrenWith applies a predicate to check if query has an edge children with a given conditions (other predicates).
func (f *IntSIDFilter) WhereHasChildrenWith(preds ...predicate.IntSID) {
	f.Where(entql.HasEdgeWith("children", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (miq *MixinIDQuery) addPredicate(pred func(s *sql.Selector)) {
	miq.predicates = append(miq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the MixinIDQuery builder.
func (miq *MixinIDQuery) Filter() *MixinIDFilter {
	return &MixinIDFilter{config: miq.config, predicateAdder: miq}
}

// addPredicate implements the predicateAdder interface.
func (m *MixinIDMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the MixinIDMutation builder.
func (m *MixinIDMutation) Filter() *MixinIDFilter {
	return &MixinIDFilter{config: m.config, predicateAdder: m}
}

// MixinIDFilter provides a generic filtering capability at runtime for MixinIDQuery.
type MixinIDFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *MixinIDFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[8].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql [16]byte predicate on the id field.
func (f *MixinIDFilter) WhereID(p entql.ValueP) {
	f.Where(p.Field(mixinid.FieldID))
}

// WhereSomeField applies the entql string predicate on the some_field field.
func (f *MixinIDFilter) WhereSomeField(p entql.StringP) {
	f.Where(p.Field(mixinid.FieldSomeField))
}

// WhereMixinField applies the entql string predicate on the mixin_field field.
func (f *MixinIDFilter) WhereMixinField(p entql.StringP) {
	f.Where(p.Field(mixinid.FieldMixinField))
}

// addPredicate implements the predicateAdder interface.
func (nq *NoteQuery) addPredicate(pred func(s *sql.Selector)) {
	nq.predicates = append(nq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the NoteQuery builder.
func (nq *NoteQuery) Filter() *NoteFilter {
	return &NoteFilter{config: nq.config, predicateAdder: nq}
}

// addPredicate implements the predicateAdder interface.
func (m *NoteMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the NoteMutation builder.
func (m *NoteMutation) Filter() *NoteFilter {
	return &NoteFilter{config: m.config, predicateAdder: m}
}

// NoteFilter provides a generic filtering capability at runtime for NoteQuery.
type NoteFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *NoteFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[9].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql string predicate on the id field.
func (f *NoteFilter) WhereID(p entql.StringP) {
	f.Where(p.Field(note.FieldID))
}

// WhereText applies the entql string predicate on the text field.
func (f *NoteFilter) WhereText(p entql.StringP) {
	f.Where(p.Field(note.FieldText))
}

// WhereHasParent applies a predicate to check if query has an edge parent.
func (f *NoteFilter) WhereHasParent() {
	f.Where(entql.HasEdge("parent"))
}

// WhereHasParentWith applies a predicate to check if query has an edge parent with a given conditions (other predicates).
func (f *NoteFilter) WhereHasParentWith(preds ...predicate.Note) {
	f.Where(entql.HasEdgeWith("parent", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasChildren applies a predicate to check if query has an edge children.
func (f *NoteFilter) WhereHasChildren() {
	f.Where(entql.HasEdge("children"))
}

// WhereHasChildrenWith applies a predicate to check if query has an edge children with a given conditions (other predicates).
func (f *NoteFilter) WhereHasChildrenWith(preds ...predicate.Note) {
	f.Where(entql.HasEdgeWith("children", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (oq *OtherQuery) addPredicate(pred func(s *sql.Selector)) {
	oq.predicates = append(oq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the OtherQuery builder.
func (oq *OtherQuery) Filter() *OtherFilter {
	return &OtherFilter{config: oq.config, predicateAdder: oq}
}

// addPredicate implements the predicateAdder interface.
func (m *OtherMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the OtherMutation builder.
func (m *OtherMutation) Filter() *OtherFilter {
	return &OtherFilter{config: m.config, predicateAdder: m}
}

// OtherFilter provides a generic filtering capability at runtime for OtherQuery.
type OtherFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *OtherFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[10].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql other predicate on the id field.
func (f *OtherFilter) WhereID(p entql.OtherP) {
	f.Where(p.Field(other.FieldID))
}

// addPredicate implements the predicateAdder interface.
func (pq *PetQuery) addPredicate(pred func(s *sql.Selector)) {
	pq.predicates = append(pq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the PetQuery builder.
func (pq *PetQuery) Filter() *PetFilter {
	return &PetFilter{config: pq.config, predicateAdder: pq}
}

// addPredicate implements the predicateAdder interface.
func (m *PetMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the PetMutation builder.
func (m *PetMutation) Filter() *PetFilter {
	return &PetFilter{config: m.config, predicateAdder: m}
}

// PetFilter provides a generic filtering capability at runtime for PetQuery.
type PetFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *PetFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[11].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql string predicate on the id field.
func (f *PetFilter) WhereID(p entql.StringP) {
	f.Where(p.Field(pet.FieldID))
}

// WhereHasOwner applies a predicate to check if query has an edge owner.
func (f *PetFilter) WhereHasOwner() {
	f.Where(entql.HasEdge("owner"))
}

// WhereHasOwnerWith applies a predicate to check if query has an edge owner with a given conditions (other predicates).
func (f *PetFilter) WhereHasOwnerWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("owner", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasCars applies a predicate to check if query has an edge cars.
func (f *PetFilter) WhereHasCars() {
	f.Where(entql.HasEdge("cars"))
}

// WhereHasCarsWith applies a predicate to check if query has an edge cars with a given conditions (other predicates).
func (f *PetFilter) WhereHasCarsWith(preds ...predicate.Car) {
	f.Where(entql.HasEdgeWith("cars", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasFriends applies a predicate to check if query has an edge friends.
func (f *PetFilter) WhereHasFriends() {
	f.Where(entql.HasEdge("friends"))
}

// WhereHasFriendsWith applies a predicate to check if query has an edge friends with a given conditions (other predicates).
func (f *PetFilter) WhereHasFriendsWith(preds ...predicate.Pet) {
	f.Where(entql.HasEdgeWith("friends", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasBestFriend applies a predicate to check if query has an edge best_friend.
func (f *PetFilter) WhereHasBestFriend() {
	f.Where(entql.HasEdge("best_friend"))
}

// WhereHasBestFriendWith applies a predicate to check if query has an edge best_friend with a given conditions (other predicates).
func (f *PetFilter) WhereHasBestFriendWith(preds ...predicate.Pet) {
	f.Where(entql.HasEdgeWith("best_friend", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (rq *RevisionQuery) addPredicate(pred func(s *sql.Selector)) {
	rq.predicates = append(rq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the RevisionQuery builder.
func (rq *RevisionQuery) Filter() *RevisionFilter {
	return &RevisionFilter{config: rq.config, predicateAdder: rq}
}

// addPredicate implements the predicateAdder interface.
func (m *RevisionMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the RevisionMutation builder.
func (m *RevisionMutation) Filter() *RevisionFilter {
	return &RevisionFilter{config: m.config, predicateAdder: m}
}

// RevisionFilter provides a generic filtering capability at runtime for RevisionQuery.
type RevisionFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *RevisionFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[12].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql string predicate on the id field.
func (f *RevisionFilter) WhereID(p entql.StringP) {
	f.Where(p.Field(revision.FieldID))
}

// addPredicate implements the predicateAdder interface.
func (sq *SessionQuery) addPredicate(pred func(s *sql.Selector)) {
	sq.predicates = append(sq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the SessionQuery builder.
func (sq *SessionQuery) Filter() *SessionFilter {
	return &SessionFilter{config: sq.config, predicateAdder: sq}
}

// addPredicate implements the predicateAdder interface.
func (m *SessionMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the SessionMutation builder.
func (m *SessionMutation) Filter() *SessionFilter {
	return &SessionFilter{config: m.config, predicateAdder: m}
}

// SessionFilter provides a generic filtering capability at runtime for SessionQuery.
type SessionFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *SessionFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[13].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql []byte predicate on the id field.
func (f *SessionFilter) WhereID(p entql.BytesP) {
	f.Where(p.Field(session.FieldID))
}

// WhereHasDevice applies a predicate to check if query has an edge device.
func (f *SessionFilter) WhereHasDevice() {
	f.Where(entql.HasEdge("device"))
}

// WhereHasDeviceWith applies a predicate to check if query has an edge device with a given conditions (other predicates).
func (f *SessionFilter) WhereHasDeviceWith(preds ...predicate.Device) {
	f.Where(entql.HasEdgeWith("device", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (tq *TokenQuery) addPredicate(pred func(s *sql.Selector)) {
	tq.predicates = append(tq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the TokenQuery builder.
func (tq *TokenQuery) Filter() *TokenFilter {
	return &TokenFilter{config: tq.config, predicateAdder: tq}
}

// addPredicate implements the predicateAdder interface.
func (m *TokenMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the TokenMutation builder.
func (m *TokenMutation) Filter() *TokenFilter {
	return &TokenFilter{config: m.config, predicateAdder: m}
}

// TokenFilter provides a generic filtering capability at runtime for TokenQuery.
type TokenFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *TokenFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[14].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql other predicate on the id field.
func (f *TokenFilter) WhereID(p entql.OtherP) {
	f.Where(p.Field(token.FieldID))
}

// WhereBody applies the entql string predicate on the body field.
func (f *TokenFilter) WhereBody(p entql.StringP) {
	f.Where(p.Field(token.FieldBody))
}

// WhereHasAccount applies a predicate to check if query has an edge account.
func (f *TokenFilter) WhereHasAccount() {
	f.Where(entql.HasEdge("account"))
}

// WhereHasAccountWith applies a predicate to check if query has an edge account with a given conditions (other predicates).
func (f *TokenFilter) WhereHasAccountWith(preds ...predicate.Account) {
	f.Where(entql.HasEdgeWith("account", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (uq *UserQuery) addPredicate(pred func(s *sql.Selector)) {
	uq.predicates = append(uq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the UserQuery builder.
func (uq *UserQuery) Filter() *UserFilter {
	return &UserFilter{config: uq.config, predicateAdder: uq}
}

// addPredicate implements the predicateAdder interface.
func (m *UserMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the UserMutation builder.
func (m *UserMutation) Filter() *UserFilter {
	return &UserFilter{config: m.config, predicateAdder: m}
}

// UserFilter provides a generic filtering capability at runtime for UserQuery.
type UserFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *UserFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[15].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *UserFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(user.FieldID))
}

// WhereHasGroups applies a predicate to check if query has an edge groups.
func (f *UserFilter) WhereHasGroups() {
	f.Where(entql.HasEdge("groups"))
}

// WhereHasGroupsWith applies a predicate to check if query has an edge groups with a given conditions (other predicates).
func (f *UserFilter) WhereHasGroupsWith(preds ...predicate.Group) {
	f.Where(entql.HasEdgeWith("groups", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasParent applies a predicate to check if query has an edge parent.
func (f *UserFilter) WhereHasParent() {
	f.Where(entql.HasEdge("parent"))
}

// WhereHasParentWith applies a predicate to check if query has an edge parent with a given conditions (other predicates).
func (f *UserFilter) WhereHasParentWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("parent", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasChildren applies a predicate to check if query has an edge children.
func (f *UserFilter) WhereHasChildren() {
	f.Where(entql.HasEdge("children"))
}

// WhereHasChildrenWith applies a predicate to check if query has an edge children with a given conditions (other predicates).
func (f *UserFilter) WhereHasChildrenWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("children", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasPets applies a predicate to check if query has an edge pets.
func (f *UserFilter) WhereHasPets() {
	f.Where(entql.HasEdge("pets"))
}

// WhereHasPetsWith applies a predicate to check if query has an edge pets with a given conditions (other predicates).
func (f *UserFilter) WhereHasPetsWith(preds ...predicate.Pet) {
	f.Where(entql.HasEdgeWith("pets", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}
