<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <xsl:output method="html"/>

  <xsl:template match="prologdoc">
    <html>
      <head>
        <title><xsl:value-of select="file"/></title>
      </head>
      <body bgcolor="white">
        <xsl:apply-templates select="predicate"/>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="predicate">
    <h3 class="pred"><xsl:value-of select="name"/>/<xsl:value-of select="arity"/></h3>
    <h3><xsl:value-of select="@foo"/></h3>
    <xsl:apply-templates select="modes"/>
    <xsl:apply-templates select="arguments"/>
    <xsl:apply-templates select="description"/>
    <p/>
  </xsl:template>

  <xsl:template match="modes">
    <span class="modes">
      <ul>
        <xsl:apply-templates/>
      </ul>
    </span>
  </xsl:template>
  
  <xsl:template match="mode">
    <li>
      <span class="li-head">
        <xsl:value-of select="form"/>
        <xsl:if test="description">: <xsl:apply-templates select="description"/></xsl:if>
      </span>
    </li>
  </xsl:template>

  <xsl:template match="args">
    <span class="args">
      <xsl:apply-templates/>
    </span>
  </xsl:template>

  <xsl:template match="descr">
    <span class="desc">
      <xsl:apply-templates/>
    </span>
  </xsl:template>

  <xsl:template match="paragraph">
    <xsl:apply-templates/>
    <p/>
  </xsl:template>

  <xsl:template match="list">
    <ul>
      <xsl:apply-templates/>
    </ul>
  </xsl:template>

  <xsl:template match="li">
    <li>
      <span class="li-head"><xsl:value-of select="head"/></span>
      <xsl:if test="description">: <xsl:apply-templates select="description"/></xsl:if>
    </li>
  </xsl:template>
</xsl:stylesheet>
