/* -*- Mode: Prolog -*- */
/** @copyright
  
  This file is part of PrologDoc (http://prologdoc.sourceforge.net/).

  Copyright (C) 2004 by Salvador Fandino (sfandino@@yahoo.com)

  PrologDoc is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  PrologDoc is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with PrologDoc; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  
  @/copyright */

:- module(pd, [ tag_class/2,
		tag_inside/2,
		tag_args/2,
		tag_callback/4,
		is_a/2,
		match_tag/2] ).

:- use_module(library('prologdoc/callback')).
:- use_module(library('prologdoc/comments_parser')).

:- multifile
	tag_class/2,
	tag_inside/2,
	tag_callback/4,
	tag_args/2.

/** @pred is_a(?Tag, ?Class)
  @arg Tag: tag name
  @arg Class: class name

  @desc inheritance relationship for tags.
  */

is_a(A, A).
is_a(A, B) :-
	tag_class(A, A1),
	is_a(A1, B).


match_arg_req([], _).
match_arg_req([H|T], A) :-
	la_get(A, H),
	match_arg_req(T, A).

match_child_req([], _).
match_child_req([H|T], C) :-
	(   member(M, C),
	    match_tag(H, M)
	->  match_child_req(T, C) ).

match_tag(t(Type, RA, RC), t(N, A, C)) :-
	is_a(N, Type),
	match_arg_req(RA, A),
	match_child_req(RC, C).
