package Pista::Util;

use strict;
use warnings;
use vars qw(@ISA @EXPORT_OK);
use Exporter ();
@ISA = qw(Exporter);
@EXPORT_OK = qw(dup min max parse_ints swap_history CCtov vtoCC);

use Dumpvalue;
my $dumper = new Dumpvalue;

sub dup {
	my $old = shift;
	return $old unless (my $ref=ref($old));
	my $class;

	if ("$old" =~ /^(.*)=([A-Z]+)\(.*\)/) {
		$class = $1;
		$ref = $2;
	}

	if ($ref eq 'HASH') {
		my $new = { };
		foreach (keys %$old) {
			$new->{$_} = dup($old->{$_});
		}
		bless $new,$class if $class;
		return $new;
	}
	if ($ref eq 'ARRAY') {
		my $new = [ ];
		for (0..$#$old) {
			$new->[$_] = dup($old->[$_]);
		}
		bless $new,$class if $class;
		return $new;
	}
	if ($ref eq 'SCALAR') {
		my $new = \$$old;
		bless $new,$class if $class;
		return $new;
	}
	if ($ref eq 'REF') {
		my $new = \dup($$old);
		bless $new,$class if $class;
		return $new;
	}
	return $old;		# just copy
}

sub min {
	my ($a, $b) = @_;
	return $a unless defined $b;
	return $a unless $a > $b;
	return $b;
}

sub max {
	my ($a, $b) = @_;
	return $a unless defined $b;
	return $a unless $a < $b;
	return $b;
}

sub parse_ints {
	my @in = split(/\s+/,shift);
	my @out = ();
	for (@in) {
		$_ = oct() if /^\s*0/;
		push(@out, $_);
	}
	return (wantarray ? @out : shift(@out));
}

sub swap_history {
	my $term = shift;
	my $features = $term->Features;
	return unless $features->{getHistory} and $features->{setHistory};
	my @oldhistory = $term->GetHistory;
	$term->SetHistory(@_);
	return @oldhistory;
}

# Convert a series of little endian shorts to bytes
sub vtoCC {
	my $wordsref = shift;
	return undef unless ref $wordsref eq 'ARRAY';
	return [ unpack('C*', pack('v*', @$wordsref)) ];
}

# Convert a series of bytes to little endian shorts
sub CCtov {
	my $bytesref = shift;
	return undef unless ref $bytesref eq 'ARRAY';
	return [ unpack('v*', pack('C*', @$bytesref)) ];
}

sub isatree {
	no strict 'refs';
	my $level = shift;
	my @isa = @_;
	for (@isa) {
		print '|  ' x $level, "+--", $_, "\n";
		isatree($level+1, @{"${_}::ISA"});
	}
}

package Pista::Util::ReadLine;

use IO::Handle;
our @ISA = qw(IO::Handle);

sub new {
	my $pkg = shift;
	shift;
	my $inglob = shift;
	my $outglob = shift;
	my $term = IO::Handle->new_from_fd($inglob,"r") or return;
	autoflush $outglob 1;
	bless $term, $pkg;
}

sub readline { shift->getline; }

sub Features { {}; }

1;
