package Pista::Section;

use strict;
use warnings;
use Pista::Util qw(min max);

use Dumpvalue;
my $dumper = new Dumpvalue('arrayDepth' => 10, 'quoteHighBit'=>1);

sub new {
	my $pkg = shift;
	my $self = { };
	$self->{start} = shift;
	$self->{end} = shift;
	$self->{content} = ref $_[0] eq 'ARRAY' ? $_[0] : [ @_ ];
	bless $self, $pkg;
}

sub merge {
	my ($dst, $src) = @_;
	return $dst unless $src;
	my $new = { };
	$new->{start} = min($src->{start}, $dst->{start});
	$new->{end}   = max($src->{end},   $dst->{end});
	my $dstoffset = $dst->{start} - $new->{start};
	my $srcoffset = $src->{start} - $new->{start};
	if (!$dstoffset) {
		# much faster than cell by cell copy
		$new->{content} = $dst->{content};
	}
	else {
		for (my $i=0; $i<=$#{$dst->{content}}; $i++) {
			$new->{content}->[$dstoffset+$i] = $dst->{content}->[$i];
		}
	}
	for (my $i=0; $i<=$#{$src->{content}}; $i++) {
		$new->{content}->[$srcoffset+$i] = $src->{content}->[$i];
	}
	$dst->{start}   = $new->{start};
	$dst->{end}     = $new->{end};
	$dst->{content} = $new->{content};
	return $dst;
}

sub intersect {
	my ($self, $low, $high) = @_;
	return undef if ($high < $self->{start});
	return undef if ($self->{end} < $low);
	if ($high < $self->{end}) {
		splice(@{$self->{content}},
			$self->{start} + $high + 1,
			$self->{end} - $high);
		$self->{end} = $high;
	}
	if ($self->{start} < $low) {
		splice(@{$self->{content}}, 0, $low - $self->{start});
		$self->{start} = $low;
	}
	return $self;
}

# index        0...........f
# address   1200........120f
# range        1203..1207
# range   11f3.......1207
# range        1203.........1123
# range   11f3..............1123
# range 7f..9f              130a..14ff
sub erase {
	my ($self, $low, $high) = @_;
	return $self if $self->{end} < $low;
	return $self if $self->{start} > $high;
	my $start = max($self->{start}, $low);
	my $end   = min($self->{end}, $high);
	my $startidx = $start - $self->{start};
	my $len = $end - $start + 1;
	my @emptylist;
	$#emptylist = $len - 1;
	splice(@{$self->{content}}, $startidx, $len, @emptylist);
	return $self->cleanup;
}

sub cleanup {
	my $self = shift;
	my ($mask, $blank) = @_;
	my $c = $self->{content};
	while ($#$c >= 0) {
		if (defined $c->[$#$c]) {
			last unless defined $blank and
				($c->[$#$c] & $mask) == $blank;
		}
		pop @$c;
		$self->{end}--;
	}
	while ($#$c >= 0) {
		if (defined $c->[0]) {
			last unless defined $blank and
				($c->[0] & $mask) == $blank;
		}
		shift @$c;
		$self->{start}++;
	}
	return undef if $self->{end} < $self->{start};
	return $self;
}

##sub checksum {
##	my $self = shift;
##	my $chksum = 0;
##	foreach (@{$self->{buffer}}) {
##		$chksum += defined $_ ?  $_ : ((1<<(2*$self->{width}))-1);
##	}
##	return $chksum & 0xffff;
##}
#	
##sub set_attribs {
##	my $self = shift;
##	$self->{width} = shift;
##	$self->{addrspace} = shift;
##}
##
##sub get_attribs {
##	my $self = shift;
##	return ($self->{width}, $self->{addrspace});
##}
#

1;
