package Pista::Object::Firmware;

use strict;
use warnings;
our @ISA = qw(Pista::Object);
use Pista::Util qw(dup);

use Dumpvalue;
my $dumper = new Dumpvalue('quoteHighBit'=>1, 'arrayDepth'=>16);

sub new {
	my $pkg = shift;
	my $self = { programmer => shift, device => shift };
	if (!$self->{programmer}) {
		print "420 No programmer selected\n";
		return undef;
	}
	if (!$self->{device}) {
		print "440 No device selected\n";
		return undef;
	}
#$dumper->dumpValue($self);
	bless $self, $pkg;
}

sub write {
#print "->write(@_)\n";
	my $self = shift;
	my $src = shift;
	my %arg = (@_);
	my $force = $arg{force};
	undef %arg;
	my $device = $self->{device};
	my $saved;
#$dumper->dumpValue($src);

	if ($device->{addressing} eq 'byte') {
		# Program and userid sections of 18Fxxx devices can be written
		# in 8 byte chunks only. We have to read a few bytes and to
		# prepend/append to content to write.
		# (18Cxxx devices don't require this preparation but
		# it does not hurt them.)
		$src = dup($src);		# keep orginal object intact
		for my $sect (qw(prog userid)) {
			next unless exists $src->{$sect};
			my $s = $src->{$sect};
#print "elotte:\n";
#$dumper->dumpValue($s);
			my $start = $s->{start};
			if ($start % 8) {
				my $head = $self->_do_read("read_$sect",
					$start&~7, ($start&~1)+1, undef, undef);
				return undef unless $head;
#print "head\n";
#$dumper->dumpValue($head);
				$s = $head->merge($s);
			}
			my $end = $s->{end};
			if (($end+1) % 8) {
				my $tail = $self->_do_read("read_$sect",
					($end+1)&~1, ($end&~7)+7, undef, undef);
				return undef unless $tail;
#print "tail\n";
#$dumper->dumpValue($tail);
				$s = $tail->merge($s);
			}
#print "utana\n";
#$dumper->dumpValue($s);
			$src->{$sect} = $s;
		}
	}

	for my $sect (qw(prog)) {
		next unless exists $src->{$sect};
		next unless exists $device->{$sect};
		my $start = $src->{$sect}->{start};
		my $end = $src->{$sect}->{end};
		my $content = $src->{$sect}->{content};
		if ($saved and exists $saved->{$sect}) {
			$content = dup($content);
			my $mask = $device->{$sect}->{preserve};
			if ($#{$mask} > 0) {
				for my $i (0..$#$content) {
					$content->[$i] &= ~$mask->[$i];
					$content->[$i] |= $saved->{$sect}->{content}->[$i];
				}
			}
			else {
				for my $i (0..$#$content) {
					$content->[$i] &= ~$mask->[0];
					$content->[$i] |= $saved->{$sect}->{content}->[$i];
				}
			}
		}
#$dumper->dumpValue($content);
		printf "121 Downloading firmware 0x%x-0x%x\n", $start, $end;
		$self->_do_write("write_firmware", $start, $end, $content) or
			return undef;
	}
	return $self;
}

sub _do_write {
	my ($self, $method, $start, $end, $content) = @_;
#return $self;
	no strict qw(refs);
	if (!$self->{programmer}->can($method)) {
		print "523 Unimplemented programmer method \"$method\"\n";
		return undef;
	}
	return $self->{programmer}->$method($self->{device},
					$start, $end, $content);
}

#TODO _do_read

1;
